/*
 * Decompiled with CFR 0.152.
 */
package com.aibonware.viewnaver.content.board;

import com.aibonware.nvrlib.model.BaseBoard;
import com.aibonware.nvrlib.model.Poster;
import com.aibonware.viewnaver.ViewNaver;
import com.aibonware.viewnaver.browser.Browser;
import com.aibonware.viewnaver.browser.BrowserListener;
import com.aibonware.viewnaver.command.BoardTitleProvider;
import com.aibonware.viewnaver.command.DefaultPosterSelection;
import com.aibonware.viewnaver.command.OpenURLCommand;
import com.aibonware.viewnaver.command.PosterMenuItems;
import com.aibonware.viewnaver.command.ShowThreadCommand;
import com.aibonware.viewnaver.component.ButtonBar;
import com.aibonware.viewnaver.config.ThreadListConfig;
import com.aibonware.viewnaver.content.TabContent;
import com.aibonware.viewnaver.content.TabContentCategory;
import com.aibonware.viewnaver.content.TabContentView;
import com.aibonware.viewnaver.content.board.BaseBoardContent;
import com.aibonware.viewnaver.format.DefaultFormatter;
import com.aibonware.viewnaver.model.BoardTitle;
import com.aibonware.viewnaver.model.FilterType;
import com.aibonware.viewnaver.model.NThread;
import com.aibonware.viewnaver.task.TaskFlow;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public abstract class BaseBoardView<C extends BaseBoard<NThread>>
extends TabContentView {
    public C board;
    private Browser browser;
    protected JTextField pageText;
    protected JButton closeButton;
    protected ButtonBar toolbar;
    BaseBoardContent<C> content;
    private NThread selectedThread;
    private DefaultPosterSelection posterSelection = new DefaultPosterSelection();
    private PosterMenuItems posterItems;
    JButton nextButton = new JButton("\uff1e");
    JButton prevButton = new JButton("\uff1c");
    private static SimpleDateFormat df = new SimpleDateFormat("yy/MM/dd");

    public BaseBoardView(TabContentCategory category) {
        super(category);
        String initialHtml = "<html><head><meta http-equiv=\"Content-Type\" content=\"text/html\"><style> TABLE  { border-width: 0px 1px 1px 0px ;  border-style: solid; border-color: black;  } TD { font-family: '" + ViewNaver.instance.platform.getDefaultFont() + "'; font-size: 10pt; border-width: 1px 0px 0px 1px; border-style: solid;  border-color: black; } " + "A:link, A:visited, A:active { color: black; border-width: 1px; text-decoration: none; } " + "A:hover { color: gray; border-width: 1px; text-decoration: none; } " + "</style>" + "</head><body></body></html>";
        this.browser = ViewNaver.instance.getBrowserFactory().createBrowser(initialHtml);
        final JPopupMenu popup = new JPopupMenu();
        this.posterItems = new PosterMenuItems(this, this.posterSelection, new BoardTitleProvider(){

            @Override
            public BoardTitle getBoardTitle() {
                return (BoardTitle)ViewNaver.instance.boardTitles.getBoardTitle(((BaseBoard)BaseBoardView.this.board).boardName);
            }
        });
        this.posterItems.addAllto(popup);
        popup.addSeparator();
        popup.add(new JMenuItem(new AbstractAction("Cancel"){

            @Override
            public void actionPerformed(ActionEvent e) {
                popup.setVisible(false);
            }
        }));
        this.browser.addBrowserListener(new BrowserListener(){

            @Override
            public boolean beforeNavigate(final String url) {
                if (url.startsWith("thread:")) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            int nid = Integer.parseInt(url.substring("thread:".length()));
                            NThread threadTitle = (NThread)(this).BaseBoardView.this.board.getThreadByNid(nid);
                            TaskFlow taskFlow = ViewNaver.instance.taskFlowList.getThreadFlow(((BaseBoard)(this).BaseBoardView.this.board).boardName, nid);
                            taskFlow.execute(new ShowThreadCommand(threadTitle, ((BaseBoard)(this).BaseBoardView.this.board).boardName));
                        }
                    });
                } else if (url.startsWith("poster:")) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            int nid = Integer.parseInt(url.substring("poster:".length()));
                            BaseBoardView.this.selectedThread = (NThread)(this).BaseBoardView.this.board.getThreadByNid(nid);
                            Poster poster = new Poster(((BaseBoardView)(this).BaseBoardView.this).selectedThread.poster, ((BaseBoardView)(this).BaseBoardView.this).selectedThread.country);
                            BaseBoardView.this.posterSelection.setCurrentPoster(poster);
                            Point mousePoint = MouseInfo.getPointerInfo().getLocation();
                            Point compPoint = BaseBoardView.this.browser.getComponent().getLocationOnScreen();
                            popup.show(BaseBoardView.this.browser.getComponent(), mousePoint.x - compPoint.x, mousePoint.y - compPoint.y);
                        }
                    });
                } else {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            new OpenURLCommand(BaseBoardView.this, url, false).run();
                        }
                    });
                }
                return false;
            }
        });
        this.closeButton = new JButton("\u9589\u3058\u308b");
        this.pageText = new JTextField("");
        this.pageText.setMaximumSize(new Dimension(30, 30));
        this.prevButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (((BaseBoard)BaseBoardView.this.board).pageNo < 1) {
                    ViewNaver.println("\u7d42\u7aef\u3067\u3059\u3002");
                    return;
                }
                BaseBoardView.this.setSpecifiedPageNo(((BaseBoard)BaseBoardView.this.board).pageNo - 1);
                BaseBoardView.this.loadNewPage(BaseBoardView.this.board, BaseBoardView.this.getSpecifiedPageNo(), false);
            }
        });
        this.nextButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BaseBoardView.this.setSpecifiedPageNo(((BaseBoard)BaseBoardView.this.board).pageNo + 1);
                BaseBoardView.this.loadNewPage(BaseBoardView.this.board, BaseBoardView.this.getSpecifiedPageNo(), false);
            }
        });
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ViewNaver.instance.mainWindow.container.removeContent(BaseBoardView.this.content);
                BaseBoardView.this.posterItems.endListen();
            }
        });
        this.toolbar = new ButtonBar();
        this.toolbar.add(this.closeButton);
        this.toolbar.addSeparator();
        this.toolbar.add(this.prevButton);
        this.toolbar.add(this.pageText);
        this.toolbar.add(this.nextButton);
        this.add((Component)this.toolbar, "North");
        this.add(this.browser.getComponent(), "Center");
    }

    @Override
    public void disposeTab() {
        this.posterItems.endListen();
        super.disposeTab();
    }

    protected void setSpecifiedPageNo(int newPageNo) {
        this.pageText.setText(String.valueOf(newPageNo));
    }

    protected int getSpecifiedPageNo() {
        int newPageNo = -1;
        try {
            newPageNo = Integer.parseInt(this.pageText.getText());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return newPageNo;
    }

    protected abstract void loadNewPage(C var1, int var2, boolean var3);

    private boolean hasImageThread(C c) {
        int i = 0;
        while (i < c.getThreadCount()) {
            if (((NThread)c.getThread((int)i)).smallImageUrl != null) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected abstract ThreadListConfig getConfig();

    @Override
    public void setClientContent(TabContent c) {
        this.content = (BaseBoardContent)c;
        this.board = (BaseBoard)this.content.target;
        if (this.board != null) {
            this.pageText.setText(String.valueOf(((BaseBoard)this.board).pageNo));
        } else {
            this.pageText.setText("");
        }
        StringWriter writer = new StringWriter();
        PrintWriter out = new PrintWriter(writer);
        boolean hasImageThread = this.hasImageThread(this.board);
        ThreadListConfig config = this.getConfig();
        if (config.showTotalPages) {
            out.println("\u7dcf\u30da\u30fc\u30b8\u6570: " + ((BaseBoard)this.board).totalPages + " \u30da\u30fc\u30b8<br>");
        }
        out.println("<table border=1 cellspacing=0><tbody>");
        Vector<String> v = new Vector<String>();
        if (config.showNid) {
            v.addElement("nid");
        }
        if (config.showDispId) {
            v.addElement("id");
        }
        if (config.showImage && hasImageThread) {
            v.addElement("image");
        }
        if (config.showCountry) {
            v.addElement("cn");
        }
        if (config.showPoster) {
            v.addElement("poster");
        }
        if (config.showArticleNum) {
            v.addElement("res");
        }
        v.addElement("new");
        if (config.showViewNum) {
            v.addElement("view");
        }
        if (config.showTitle) {
            v.addElement("title");
        }
        if (config.showDate) {
            v.addElement("date");
        }
        String[] headerNames = new String[v.size()];
        v.toArray(headerNames);
        DefaultFormatter formatter = new DefaultFormatter();
        out.println("<tr>");
        int i = 0;
        while (i < headerNames.length) {
            out.println("<td>" + headerNames[i] + "</td>");
            ++i;
        }
        out.println("</tr");
        i = 0;
        while (i < this.board.getThreadCount()) {
            NThread thread = (NThread)this.board.getThread(i);
            FilterType filterType = ViewNaver.instance.config.getFilterConfig().filters.get(new Poster(thread.poster, thread.country));
            if (filterType == null) {
                filterType = FilterType.NOAction;
            }
            if (filterType.equals((Object)FilterType.Hidden)) {
                this.board.removeThread(i);
                --i;
            } else {
                String baseTitle = thread.title;
                if (baseTitle.trim().length() == 0) {
                    baseTitle = "<i>(\u7a7a\u6b04\u306e\u30bf\u30a4\u30c8\u30eb)</i>";
                }
                String title = "";
                int j = 0;
                while (j < thread.depth) {
                    title = String.valueOf(title) + "\u3000";
                    ++j;
                }
                if (thread.depth > 0) {
                    title = String.valueOf(title) + "\u2514";
                }
                title = String.valueOf(title) + baseTitle;
                if (filterType.equals((Object)FilterType.NOAction)) {
                    String newstr = thread.oldArticleNum == Integer.MIN_VALUE ? "n" : (thread.oldArticleNum == thread.articleNum ? "&nbsp;" : String.valueOf(thread.articleNum - thread.oldArticleNum));
                    String dispIdText = thread.dispId;
                    if (dispIdText.equals("")) {
                        dispIdText = "-";
                    }
                    boolean isFavorite = ViewNaver.instance.config.getFavoritePersonConfig().persons.contains(new Poster(thread.poster, thread.country));
                    out.print("<tr>");
                    if (config.showNid) {
                        out.print("<td>" + thread.nid + "</td>");
                    }
                    if (config.showDispId) {
                        out.print("<td>" + dispIdText + "</td>");
                    }
                    if (config.showImage) {
                        out.print(hasImageThread ? "<td><img src=\"" + thread.smallImageUrl + "\"></td>" : "");
                    }
                    if (config.showCountry) {
                        out.print("<td>" + thread.country.toHtml() + "</td>");
                    }
                    if (config.showPoster) {
                        out.print("<td><a href=\"poster:" + thread.nid + "\">" + formatter.formatPerson(thread.poster, isFavorite) + "</td>");
                    }
                    if (config.showArticleNum) {
                        out.print("<td>" + thread.articleNum + "</td>");
                    }
                    out.print("<td>" + newstr + "</td>");
                    if (config.showViewNum) {
                        out.print("<td>" + thread.viewNum + "</td>");
                    }
                    if (config.showTitle) {
                        out.print("<td><a href=\"thread:" + thread.nid + "\">" + title + "</a></td>");
                    }
                    if (config.showDate) {
                        out.print("<td>" + df.format(thread.createDate) + "</td>");
                    }
                    out.println("</tr>");
                } else {
                    out.println("<tr><td colspan=" + v.size() + ">(\uff8c\uff68\uff99\uff80\u6e08\u307f)</td></tr>");
                }
            }
            ++i;
        }
        out.println("</tbody></table>");
        out.close();
        this.browser.setBodyHtml(writer.toString());
    }

    @Override
    public void refreshContent() {
        this.setClientContent(this.content);
    }
}

