/*
 * Decompiled with CFR 0.152.
 */
package com.aibonware.viewnaver.server.conv;

import com.aibonware.viewnaver.ViewNaver;
import com.aibonware.viewnaver.server.MiniServer;
import com.aibonware.viewnaver.server.UserSession;
import com.aibonware.viewnaver.server.conv.ConverterFilter;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ContentsConverter {
    private Vector<Replacer> replacers;
    public Vector<ConverterFilter> filterPrototypes = new Vector();

    public void init(MiniServer server) {
        this.replacers = new Vector();
        String[] deleteAll = new String[]{"<!\\-\\-.*?\\-\\->", "<noscript.*?>.*?</noscript>", "<script.*?></script>"};
        int i = 0;
        while (i < deleteAll.length) {
            this.replacers.addElement(new Replacer(deleteAll[i], ""));
            ++i;
        }
        String[][] tagOnly = new String[][]{{"<applet.*?>.*?</applet>", "#applet"}, {"<object.*?>.*?</object>", "#object"}, {"<map.*>.*?</map>", "#map"}, {"<embed.*?>", "#embed"}, {"<img.*?>", "#img"}};
        int i2 = 0;
        while (i2 < tagOnly.length) {
            this.replacers.addElement(new Replacer(tagOnly[i2][0], tagOnly[i2][1]));
            ++i2;
        }
        String[][] tagAndText = new String[][]{{"<a\\s+.*?>(.*?)</a>", "#link($1)"}};
        int i3 = 0;
        while (i3 < tagAndText.length) {
            this.replacers.addElement(new Replacer(tagAndText[i3][0], tagAndText[i3][1]));
            ++i3;
        }
        String[] toEnter = new String[]{"tr", "P", "H\\d+", "UL", "OL", "DIR", "MENU", "PRE", "DL", "DIV", "CENTER", "NOSCRIPT", "NOFRAMES", "BLOCKQUOTE", "FORM", "ISINDEX", "HR", "TABLE", "FIELDSET", "ADDRESS", "LTICOL", "O:P"};
        int i4 = 0;
        while (i4 < toEnter.length) {
            this.replacers.addElement(new Replacer("<" + toEnter[i4] + "\\s+.*?>", "<br>"));
            this.replacers.addElement(new Replacer("<" + toEnter[i4] + ">", "<br>"));
            this.replacers.addElement(new Replacer("</" + toEnter[i4] + ">", "<br>"));
            ++i4;
        }
        String[] toSpace = new String[]{"td", "TT", "I", "B", "U", "S", "STRIKE", "BIG", "SMALL", "EM", "STRONG", "DFN", "CODE", "SAMP", "KBD", "VAR", "CITE", "ABBR", "ACRONYM", "A", "IMG", "APPLET", "OBJECT", "FONT", "BASEFONT", "SCRIPT", "MAP", "Q", "SUB", "SUP", "SPAN", "BDO", "IFRAME", "INPUT", "SELECT", "TEXTAREA", "LABEL", "BUTTON", "BLINK", "EMBED", "LAYER", "ILAYER", "NOLAYER", "NOBR", "WBR", "RUBY", "RB", "RP", "RT", "SPACER", "INS", "DEL"};
        int i5 = 0;
        while (i5 < toSpace.length) {
            this.replacers.addElement(new Replacer("<" + toSpace[i5] + "\\s+.*?>", "&nbsp;"));
            this.replacers.addElement(new Replacer("<" + toSpace[i5] + ">", "&nbsp;"));
            this.replacers.addElement(new Replacer("</" + toSpace[i5] + ">", "&nbsp;"));
            ++i5;
        }
        String[] delTag = new String[]{"a", "abbr", "acronym", "address", "applet", "area", "b", "base", "basefont", "bdo", "bgsound", "big", "", "link", "blockquote", "body", "button", "caption", "center", "cite", "code", "col", "colgroup", "comment", "dd", "del", "dfn", "dir", "div", "dl", "dt", "em", "embed", "fieldset", "font", "form", "fram", "", "frameset", "head", "hr", "html", "i", "iframe", "ilayer", "img", "input", "ins", "isindex", "kbd", "", "eygen", "label", "layer", "legend", "li", "link", "listing", "map", "marquee", "menu", "meta", "mult", "col", "nextid", "nobr", "noembed", "noframes", "nolayer", "noscript", "object", "ol", "optgroup", "option", "p", "param", "plaintext", "pre", "q", "rb", "rp", "rt", "ruby", "s", "samp", "script", "select", "server", "small", "spacer", "span", "strike", "strong", "style", "sub", "sup", "table", "tbody", "td", "textarea", "tfoot", "th", "thead", "title", "tr", "tt", "u", "ul", "var", "wbr", "xmp"};
        int i6 = 0;
        while (i6 < delTag.length) {
            this.replacers.addElement(new Replacer("<" + delTag[i6] + "\\s+.*?>", ""));
            this.replacers.addElement(new Replacer("<" + delTag[i6] + ">", ""));
            this.replacers.addElement(new Replacer("</" + delTag[i6] + ">", ""));
            ++i6;
        }
        this.replacers.addElement(new Replacer("[\\r\\n\\t]", " "));
        this.replacers.addElement(new Replacer("<br\\s*/?>", "\n"));
        String[][] markup = new String[][]{{"&", "amp"}, {"\"", "quot"}, {"<", "lt"}, {">", "gt"}, {" ", "nbsp"}};
        int i7 = 0;
        while (i7 < markup.length) {
            this.replacers.addElement(new Replacer("&" + markup[i7][1] + ";", markup[i7][0]));
            ++i7;
        }
        this.replacers.addElement(new Replacer(" ++", " "));
        this.replacers.addElement(new Replacer("\\n[ \\n]*", "\n"));
        i7 = 0;
        while (i7 < markup.length) {
            this.replacers.addElement(new Replacer(markup[i7][0], "&" + markup[i7][1] + ";"));
            ++i7;
        }
        this.replacers.addElement(new Replacer("\\n", "<br>"));
    }

    private String replacePUAChar(String s) {
        StringBuffer buf = new StringBuffer(s);
        int i = 0;
        while (i < buf.length()) {
            if (buf.charAt(i) > '\ue000') {
                buf.setCharAt(i, ' ');
            }
            ++i;
        }
        return buf.toString();
    }

    public String convert(UserSession user, String imageUrl, String s) {
        s = this.replacePUAChar(s);
        Vector<ConverterFilter> filters = new Vector<ConverterFilter>();
        for (ConverterFilter filter : this.filterPrototypes) {
            filters.addElement(filter.newInstance());
        }
        for (ConverterFilter filter : filters) {
            s = filter.preprocess(s);
        }
        int i = 0;
        while (i < this.replacers.size()) {
            Replacer replacer = this.replacers.elementAt(i);
            s = replacer.exec(s);
            ++i;
        }
        for (ConverterFilter filter : filters) {
            s = filter.postprocess(user, s);
        }
        return s;
    }

    public String getFullContents(String contents) {
        return contents;
    }

    public String getShortContents(int desiredLineNum, int desiredCharNum, String contents, String link) {
        if (desiredCharNum > contents.length()) {
            return contents;
        }
        if (ViewNaver.instance.server.useSmallImage) {
            return contents;
        }
        return String.valueOf(contents.substring(0, desiredCharNum)) + "<br>" + link;
    }

    private static class Replacer {
        public Pattern pattern;
        public String replace;

        public Replacer(String pattern, String replace) {
            this.pattern = Pattern.compile(pattern, 2);
            this.replace = replace;
        }

        public String exec(String s) {
            Matcher matcher = this.pattern.matcher(s);
            return matcher.replaceAll(this.replace);
        }
    }
}

