/*
 * Decompiled with CFR 0.152.
 */
package chrriis.dj.nativeswing;

import chrriis.common.ObjectRegistry;
import chrriis.common.Utils;
import chrriis.dj.nativeswing.BackBufferManager;
import chrriis.dj.nativeswing.CommandMessage;
import chrriis.dj.nativeswing.ControlCommandMessage;
import chrriis.dj.nativeswing.LocalMessage;
import chrriis.dj.nativeswing.Message;
import chrriis.dj.nativeswing.NSOption;
import chrriis.dj.nativeswing.NativeComponentProxy;
import chrriis.dj.nativeswing.NativeComponentProxyPanel;
import chrriis.dj.nativeswing.NativeInterface;
import chrriis.dj.nativeswing.NativeInterfaceAdapter;
import chrriis.dj.nativeswing.NativeInterfaceListener;
import chrriis.dj.nativeswing.SWTUtils;
import java.awt.BorderLayout;
import java.awt.Canvas;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.StringReader;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;
import org.eclipse.swt.SWT;
import org.eclipse.swt.awt.SWT_AWT;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseWheelListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class NativeComponent
extends Canvas {
    private static final boolean IS_DEBUGGING_OPTIONS = Boolean.parseBoolean(System.getProperty("nativeswing.components.debug.printoptions"));
    private volatile List<CommandMessage> initializationCommandMessageList = new ArrayList<CommandMessage>();
    private static ObjectRegistry registry = new ObjectRegistry();
    private int componentID;
    private Thread resizeThread;
    private boolean isForcingInitialization;
    private Method getAWTHandleMethod;
    private NativeInterfaceListener nativeInterfaceListener;
    private boolean isNativePeerValid;
    private String invalidNativePeerText;
    private boolean isNativePeerInitialized;
    private boolean isNativePeerDisposed;
    private NativeComponentProxy nativeComponentProxy;
    private boolean isShellEnabled = true;
    private BackBufferManager backBufferManager;
    protected EventListenerList listenerList = new EventListenerList();

    public void runInSequence(Runnable runnable) {
        this.runSync(new CMLocal_runInSequence(), runnable);
    }

    public Object runSync(CommandMessage commandMessage, Object ... args) {
        if (NativeInterface.isAlive()) {
            NativeInterface.checkUIThread();
        }
        if (commandMessage instanceof ControlCommandMessage) {
            ((ControlCommandMessage)commandMessage).setNativeComponent(this);
        }
        if (this.initializationCommandMessageList != null) {
            commandMessage.setArgs(args);
            this.initializationCommandMessageList.add(commandMessage);
            return null;
        }
        if (!this.isNativePeerValid()) {
            commandMessage.setArgs(args);
            this.printFailedInvocation(commandMessage);
            return null;
        }
        return commandMessage.syncExec(args);
    }

    public void runAsync(CommandMessage commandMessage, Object ... args) {
        if (NativeInterface.isAlive()) {
            NativeInterface.checkUIThread();
        }
        if (commandMessage instanceof ControlCommandMessage) {
            ((ControlCommandMessage)commandMessage).setNativeComponent(this);
        }
        if (this.initializationCommandMessageList != null) {
            commandMessage.setArgs(args);
            this.initializationCommandMessageList.add(commandMessage);
        } else if (!this.isNativePeerValid()) {
            commandMessage.setArgs(args);
            this.printFailedInvocation(commandMessage);
        } else {
            commandMessage.asyncExec(args);
        }
    }

    private void printFailedInvocation(Message message) {
        System.err.println("Invalid " + this.getComponentDescription() + ": " + message);
    }

    protected static ObjectRegistry getRegistry() {
        return registry;
    }

    protected int getComponentID() {
        return this.componentID;
    }

    public NativeComponent() {
        this.componentID = registry.add(this);
        this.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                if (NativeComponent.this.isNativePeerValid() && !NativeComponent.this.isNativePeerDisposed()) {
                    NativeComponent.this.runSync(new CMN_transferFocus(), new Object[0]);
                }
            }
        });
        this.setFocusable(true);
        this.addHierarchyListener(new HierarchyListener(){

            public void hierarchyChanged(HierarchyEvent e) {
                Container parent;
                long changeFlags = e.getChangeFlags();
                if ((changeFlags & 1L) != 0L && (parent = NativeComponent.this.getParent()) != null && !(parent instanceof NativeComponentHolder)) {
                    throw new IllegalStateException("The native component cannot be added directly! Use the createEmbeddableComponent() method to get a component that can be added.");
                }
            }
        });
    }

    @Override
    public void reshape(int x, int y, int width, int height) {
        if (this.resizeThread == null && width != this.getWidth() || height != this.getHeight()) {
            this.resizeThread = new Thread("NativeSwing Resize"){

                public void run() {
                    try {
                        3.sleep(50L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            if (NativeComponent.this.isNativePeerValid()) {
                                NativeComponent.this.resizeThread = null;
                                new CMN_reshape().asyncExec(NativeComponent.this, NativeComponent.this.getWidth(), NativeComponent.this.getHeight());
                            }
                        }
                    });
                }
            };
            this.resizeThread.start();
        }
        super.reshape(x, y, width, height);
    }

    private static Object[] getKeyEventArgs(KeyEvent keyEvent, int keyEventType) {
        return new Object[]{keyEventType, keyEvent.stateMask, Character.valueOf(keyEvent.character), keyEvent.keyCode};
    }

    private static Object[] getMouseEventArgs(Control control, org.eclipse.swt.events.MouseEvent e, int mouseEventType) {
        Integer lastEventType;
        org.eclipse.swt.events.MouseEvent lastEvent = (org.eclipse.swt.events.MouseEvent)control.getData("NS_LastMouseEvent");
        if (lastEvent != null && (lastEventType = (Integer)control.getData("NS_LastMouseEventType")) == mouseEventType && lastEvent.x == e.x && lastEvent.y == e.y && lastEvent.button == e.button && lastEvent.count == e.count && lastEvent.stateMask == e.stateMask) {
            return null;
        }
        control.setData("NS_LastMouseEvent", (Object)e);
        control.setData("NS_LastMouseEventType", (Object)mouseEventType);
        lastEvent = e;
        return new Object[]{mouseEventType, e.x, e.y, e.button, e.count, e.stateMask, e.display.getCursorLocation()};
    }

    private static void configureControl(final Control control, int componentID) {
        control.setData("NS_ID", (Object)componentID);
        control.setData("NS_EnabledEventsMask", (Object)0L);
        control.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(org.eclipse.swt.events.MouseEvent e) {
                Object[] mouseEventArgs = NativeComponent.getMouseEventArgs(control, e, 501);
                if (mouseEventArgs != null) {
                    new CMJ_dispatchMouseEvent().asyncExec(control, mouseEventArgs);
                }
            }

            public void mouseUp(org.eclipse.swt.events.MouseEvent e) {
                Object[] mouseEventArgs = NativeComponent.getMouseEventArgs(control, e, 502);
                if (mouseEventArgs != null) {
                    new CMJ_dispatchMouseEvent().asyncExec(control, mouseEventArgs);
                }
            }
        });
        control.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(org.eclipse.swt.events.MouseEvent e) {
                Object[] mouseEventArgs;
                if (((Long)e.widget.getData("NS_EnabledEventsMask") & 0x20L) != 0L && (mouseEventArgs = NativeComponent.getMouseEventArgs(control, e, 503)) != null) {
                    new CMJ_dispatchMouseEvent().asyncExec(control, mouseEventArgs);
                }
            }
        });
        control.addMouseWheelListener(new MouseWheelListener(){

            public void mouseScrolled(org.eclipse.swt.events.MouseEvent e) {
                Object[] mouseEventArgs = NativeComponent.getMouseEventArgs(control, e, 507);
                if (mouseEventArgs != null) {
                    new CMJ_dispatchMouseEvent().asyncExec(control, mouseEventArgs);
                }
            }
        });
        control.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if ((e.stateMask & 0x40000) != 0 && e.keyCode == 9) {
                    e.doit = false;
                }
                new CMJ_dispatchKeyEvent().asyncExec(control, NativeComponent.getKeyEventArgs(e, 401));
            }

            public void keyReleased(KeyEvent e) {
                new CMJ_dispatchKeyEvent().asyncExec(control, NativeComponent.getKeyEventArgs(e, 402));
                new CMJ_dispatchKeyEvent().asyncExec(control, NativeComponent.getKeyEventArgs(e, 400));
            }
        });
    }

    @Override
    public synchronized void addMouseMotionListener(MouseMotionListener listener) {
        if (this.getMouseMotionListeners().length == 0 && listener != null) {
            this.runAsync(new CMN_setEventsEnabled(), 32L, true);
        }
        super.addMouseMotionListener(listener);
    }

    @Override
    public synchronized void removeMouseMotionListener(MouseMotionListener listener) {
        super.removeMouseMotionListener(listener);
        if (this.getMouseMotionListeners().length == 0) {
            this.runAsync(new CMN_setEventsEnabled(), 32L, false);
        }
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (!this.isNativePeerValid()) {
            String text = this.invalidNativePeerText;
            if (text == null) {
                text = "Invalid " + this.getComponentDescription();
            }
            FontMetrics fm = g.getFontMetrics();
            BufferedReader r = new BufferedReader(new StringReader(text));
            int lineHeight = fm.getHeight();
            int ascent = fm.getAscent();
            try {
                String line;
                int i = 0;
                while ((line = r.readLine()) != null) {
                    g.drawString(line, 5, ascent + 5 + lineHeight * i);
                    ++i;
                }
            }
            catch (Exception exception) {}
        } else if (this.backBufferManager != null) {
            this.backBufferManager.paintBackBuffer(g);
        }
    }

    @Override
    public void print(Graphics g) {
        BufferedImage image = new BufferedImage(this.getWidth(), this.getHeight(), 2);
        this.paintComponent(image);
        g.drawImage(image, 0, 0, null);
        g.dispose();
        image.flush();
    }

    private void throwDuplicateCreationException() {
        this.isNativePeerValid = false;
        this.invalidNativePeerText = "Failed to create " + this.getComponentDescription() + "\n\nReason:\nA native component cannot be re-created after having been disposed.";
        this.repaint();
        throw new IllegalStateException("A native component cannot be re-created after having been disposed! To achieve re-parenting or allow re-creation, set the option to defer destruction until finalization (note that re-parenting accross different frames is not supported).");
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (this.isForcingInitialization) {
            return;
        }
        if (this.isNativePeerDisposed) {
            this.throwDuplicateCreationException();
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (NativeComponent.this.isNativePeerDisposed) {
                    NativeComponent.this.throwDuplicateCreationException();
                }
                if (!NativeComponent.this.isNativePeerInitialized) {
                    NativeComponent.this.createNativePeer();
                }
            }
        });
    }

    public void initializeNativePeer() {
        Window windowAncestor;
        if (NativeInterface.isAlive()) {
            NativeInterface.checkUIThread();
        }
        if ((windowAncestor = SwingUtilities.getWindowAncestor(this)) == null) {
            throw new IllegalStateException("This method can only be called when the component has a Window ancestor!");
        }
        if (this.isNativePeerDisposed) {
            this.throwDuplicateCreationException();
        }
        if (!this.isNativePeerInitialized) {
            this.isForcingInitialization = true;
            try {
                windowAncestor.addNotify();
                this.createNativePeer();
            }
            finally {
                this.isForcingInitialization = false;
            }
        }
    }

    private Object getHandle() {
        try {
            if (this.getAWTHandleMethod == null) {
                Method loadLibraryMethod = SWT_AWT.class.getDeclaredMethod("loadLibrary", new Class[0]);
                loadLibraryMethod.setAccessible(true);
                loadLibraryMethod.invoke(null, new Object[0]);
                this.getAWTHandleMethod = SWT_AWT.class.getDeclaredMethod("getAWTHandle", Canvas.class);
                this.getAWTHandleMethod.setAccessible(true);
            }
            return this.getAWTHandleMethod.invoke(null, this);
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    protected Object[] getNativePeerCreationParameters() {
        return null;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private void createNativePeer() {
        isInterfaceAlive = NativeInterface.isAlive();
        if (isInterfaceAlive) {
            NativeInterface.checkUIThread();
        }
        NativeInterface.addCanvas(this);
        if (this.initializationCommandMessageList == null) {
            this.throwDuplicateCreationException();
        }
        initializationCommandMessageList_ = this.initializationCommandMessageList;
        this.initializationCommandMessageList = null;
        this.isNativePeerInitialized = true;
        if (isInterfaceAlive) {
            block9: {
                this.nativeInterfaceListener = new NNativeInterfaceListener(this);
                NativeInterface.addNativeInterfaceListener(this.nativeInterfaceListener);
                this.isNativePeerValid = true;
                try {
                    this.runSync(new CMN_createControl(), new Object[]{this.componentID, this.getClass().getName(), this.getHandle(), this.getNativePeerCreationParameters()});
                    break block9;
                }
                catch (Exception e) {
                    this.isNativePeerValid = false;
                    sb = new StringBuilder();
                    t /* !! */  = e;
                    ** while (t /* !! */  != null)
                }
lbl-1000:
                // 1 sources

                {
                    sb.append("    " + t /* !! */ .toString() + "\n");
                    t /* !! */  = t /* !! */ .getCause();
                    continue;
                }
lbl27:
                // 1 sources

                this.invalidNativePeerText = "Failed to create " + this.getComponentDescription() + "\n\nReason:\n" + sb.toString();
                e.printStackTrace();
            }
            new CMN_reshape().asyncExec(this, new Object[]{this.getWidth(), this.getHeight()});
        } else {
            this.invalidNativePeerText = "Failed to create " + this.getComponentDescription() + "\n\nReason:\nThe native interface is not open!";
        }
        for (CommandMessage initCommandMessage : initializationCommandMessageList_) {
            if (!this.isNativePeerValid()) {
                this.printFailedInvocation(initCommandMessage);
                continue;
            }
            initCommandMessage.asyncSend();
        }
    }

    @Override
    public void removeNotify() {
        this.disposeNativePeer();
        super.removeNotify();
    }

    protected void disposeNativePeer() {
        if (!this.isNativePeerDisposed) {
            this.isNativePeerDisposed = true;
            this.invalidateNativePeer("The native component was disposed.");
            if (this.isNativePeerInitialized) {
                NativeInterface.removeNativeInterfaceListener(this.nativeInterfaceListener);
                NativeInterface.removeCanvas(this);
                if (this.isNativePeerValid()) {
                    this.runSync(new CMN_destroyControl(), new Object[0]);
                }
            }
            registry.remove(this.componentID);
            this.isNativePeerValid = false;
            if (this.nativeComponentProxy != null) {
                this.nativeComponentProxy.dispose();
            }
        }
    }

    public boolean isNativePeerDisposed() {
        return this.isNativePeerDisposed;
    }

    public boolean isNativePeerInitialized() {
        return this.isNativePeerInitialized;
    }

    public boolean isNativePeerValid() {
        return this.isNativePeerValid && NativeInterface.isAlive();
    }

    private void invalidateNativePeer(String invalidNativePeerText) {
        if (this.isNativePeerValid) {
            this.isNativePeerValid = false;
            this.invalidNativePeerText = "Invalid " + this.getComponentDescription() + "\n\nReason:\n" + invalidNativePeerText;
            this.repaint();
        }
    }

    private String getComponentDescription() {
        return String.valueOf(this.getClass().getName()) + "[" + this.getComponentID() + "/" + this.hashCode() + "]";
    }

    void setNativeComponentProxy(NativeComponentProxy nativeComponentProxy) {
        this.nativeComponentProxy = nativeComponentProxy;
    }

    NativeComponentProxy getNativeComponentProxy() {
        return this.nativeComponentProxy;
    }

    private static boolean isJNAPresent() {
        try {
            Class.forName("com.sun.jna.examples.WindowUtils");
            Class.forName("com.sun.jna.Platform");
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected Component createEmbeddableComponent(Map<Object, Object> optionMap) {
        if (IS_DEBUGGING_OPTIONS) {
            StringBuilder sb = new StringBuilder();
            sb.append("NativeComponent ").append(this.getComponentDescription()).append(" options: ");
            boolean isFirst = true;
            for (Object key : optionMap.keySet()) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    sb.append(", ");
                }
                Object value = optionMap.get(key);
                if (value instanceof NSOption) {
                    sb.append(value);
                    continue;
                }
                sb.append(key).append('=').append(value);
            }
            if (isFirst) {
                sb.append("<none>");
            }
            System.err.println(sb);
        }
        Boolean filiationType = optionMap.get("Proxy Component Hierarchy") != null ? Boolean.TRUE : null;
        Boolean destructionTime = optionMap.get("Destroy On Finalization") != null ? Boolean.TRUE : null;
        Boolean visibilityConstraint = optionMap.get("Constrain Visibility") != null ? Boolean.TRUE : null;
        boolean isJNAPresent = NativeComponent.isJNAPresent();
        if (visibilityConstraint == null && isJNAPresent && filiationType != null) {
            visibilityConstraint = true;
        }
        if (visibilityConstraint != null && !isJNAPresent) {
            throw new IllegalStateException("The JNA libraries are required to use the visibility constraints!");
        }
        if (destructionTime != null && filiationType == null) {
            filiationType = true;
        }
        if (filiationType != null) {
            return new NativeComponentProxyPanel(this, Boolean.TRUE.equals(visibilityConstraint), Boolean.TRUE.equals(destructionTime), Boolean.TRUE.equals(filiationType));
        }
        if (visibilityConstraint == null) {
            return new SimpleNativeComponentHolder(this);
        }
        return new NativeComponentProxyPanel(this, Boolean.TRUE.equals(visibilityConstraint), Boolean.TRUE.equals(destructionTime), Boolean.TRUE.equals(filiationType));
    }

    void setShellEnabled(boolean isEnabled) {
        if (isEnabled == this.isShellEnabled) {
            return;
        }
        this.isShellEnabled = isEnabled;
        this.runAsync(new CMN_setShellEnabled(), isEnabled);
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        this.runAsync(new CMN_setEnabled(), isEnabled);
    }

    @Override
    public boolean hasFocus() {
        boolean hasFocus = super.hasFocus();
        if (!hasFocus && this.isNativePeerValid() && !this.isNativePeerDisposed) {
            return Boolean.TRUE.equals(new CMN_hasFocus().syncExec(this, new Object[0]));
        }
        return hasFocus;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension result = null;
        if (this.isNativePeerValid() && !this.isNativePeerDisposed) {
            result = (Dimension)new CMN_getPreferredSize().syncExec(this, new Object[0]);
        }
        if (result == null) {
            result = super.getPreferredSize();
        }
        return result;
    }

    public void paintComponent(BufferedImage image) {
        this.paintComponent(image, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintComponent(BufferedImage image, Rectangle[] rectangles) {
        if (image == null || !this.isNativePeerValid() || this.isNativePeerDisposed) {
            return;
        }
        int width = Math.min(this.getWidth(), image.getWidth());
        int height = Math.min(this.getHeight(), image.getHeight());
        if (width <= 0 || height <= 0) {
            return;
        }
        if (rectangles == null) {
            rectangles = new Rectangle[]{new Rectangle(width, height)};
        }
        Rectangle bounds = new Rectangle(width, height);
        ArrayList<Rectangle> rectangleList = new ArrayList<Rectangle>();
        Rectangle[] rectangleArray = rectangles;
        int n = 0;
        int n2 = rectangleArray.length;
        while (n < n2) {
            Rectangle rectangle = rectangleArray[n];
            if (rectangle.intersects(bounds)) {
                rectangleList.add(rectangle.intersection(bounds));
            }
            ++n;
        }
        if (rectangleList.isEmpty()) {
            return;
        }
        rectangles = rectangleList.toArray(new Rectangle[0]);
        try {
            final ServerSocket serverSocket = new ServerSocket(0);
            NativeInterfaceAdapter nativeInterfaceListener = new NativeInterfaceAdapter(){

                public void nativeInterfaceClosed() {
                    NativeInterface.removeNativeInterfaceListener(this);
                    try {
                        serverSocket.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            };
            CMN_getComponentImage getComponentImage = new CMN_getComponentImage();
            NativeInterface.addNativeInterfaceListener(nativeInterfaceListener);
            getComponentImage.asyncExec(this, serverSocket.getLocalPort(), rectangles);
            Socket socket = serverSocket.accept();
            byte[] bytes = new byte[3072];
            int count = 0;
            int readCount = 0;
            try {
                BufferedInputStream in = new BufferedInputStream(socket.getInputStream());
                BufferedImage bufferedImage = image;
                synchronized (bufferedImage) {
                    Rectangle[] rectangleArray2 = rectangles;
                    int n3 = 0;
                    int n4 = rectangleArray2.length;
                    while (n3 < n4) {
                        Rectangle rectangle = rectangleArray2[n3];
                        int[] pixels = new int[rectangle.width];
                        int y = 0;
                        while (y < rectangle.height && readCount != -1) {
                            int x = 0;
                            while (x < rectangle.width && readCount != -1) {
                                if (readCount == 0 && (readCount = in.read(bytes)) != -1 && readCount % 3 != 0) {
                                    int c = in.read(bytes, readCount, bytes.length - readCount);
                                    readCount = c == -1 ? -1 : (readCount += c);
                                }
                                if (readCount == -1) break;
                                pixels[x] = 0xFF000000 | (0xFF & bytes[count]) << 16 | (0xFF & bytes[count + 1]) << 8 | 0xFF & bytes[count + 2];
                                if ((count += 3) == readCount) {
                                    count = 0;
                                    readCount = 0;
                                }
                                ++x;
                            }
                            if (readCount != -1) {
                                image.setRGB(rectangle.x, rectangle.y + y, rectangle.width, 1, pixels, 0, rectangle.width);
                            }
                            ++y;
                        }
                        if (readCount == -1) break;
                        ++n3;
                    }
                }
                NativeInterface.removeNativeInterfaceListener(nativeInterfaceListener);
                in.close();
                socket.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            serverSocket.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(0, 0);
    }

    private BackBufferManager getBackBufferManager() {
        if (this.nativeComponentProxy != null) {
            return this.nativeComponentProxy.getBackBufferManager();
        }
        if (this.backBufferManager == null) {
            this.backBufferManager = new BackBufferManager(this, this);
        }
        return this.backBufferManager;
    }

    public void createBackBuffer() {
        this.getBackBufferManager().createBackBuffer();
    }

    public void updateBackBufferOnVisibleTranslucentAreas() {
        this.getBackBufferManager().updateBackBufferOnVisibleTranslucentAreas();
    }

    public void updateBackBuffer(Rectangle[] rectangles) {
        this.getBackBufferManager().updateBackBuffer(rectangles);
    }

    public void destroyBackBuffer() {
        this.getBackBufferManager().destroyBackBuffer();
    }

    @Override
    public <T extends EventListener> T[] getListeners(Class<T> listenerType) {
        EventListener[] result = this.listenerList.getListeners(listenerType);
        if (result.length == 0) {
            return super.getListeners(listenerType);
        }
        return result;
    }

    private static class CMJ_dispatchKeyEvent
    extends ControlCommandMessage {
        private CMJ_dispatchKeyEvent() {
        }

        public Object run(Object[] args) {
            int keyCode;
            NativeComponent nativeComponent = this.getNativeComponent();
            if (!nativeComponent.isShowing()) {
                return null;
            }
            int type = (Integer)args[0];
            int e_stateMask = (Integer)args[1];
            char e_character = ((Character)args[2]).charValue();
            int e_keyCode = (Integer)args[3];
            if (e_keyCode == 9) {
                if (type == 401 && (e_stateMask & 0x40000) != 0) {
                    boolean isBackward = (e_stateMask & 0x20000) != 0;
                    Component c = nativeComponent.getNativeComponentProxy();
                    if (c == null) {
                        c = nativeComponent;
                    }
                    if (isBackward) {
                        c.transferFocusBackward();
                    } else {
                        c.transferFocus();
                    }
                }
                return null;
            }
            char character = e_character;
            if (type == 400) {
                if (character == '\u0000') {
                    return null;
                }
                keyCode = 0;
            } else {
                keyCode = SWTUtils.translateSWTKeyCode(e_keyCode);
            }
            java.awt.event.KeyEvent ke = new java.awt.event.KeyEvent(nativeComponent, type, System.currentTimeMillis(), SWTUtils.translateSWTModifiers(e_stateMask), keyCode, character);
            nativeComponent.dispatchEvent(ke);
            return null;
        }
    }

    private static class CMJ_dispatchMouseEvent
    extends ControlCommandMessage {
        private static int buttonPressedCount;

        private CMJ_dispatchMouseEvent() {
        }

        public Object run(Object[] args) {
            NativeComponent nativeComponent = this.getNativeComponent();
            if (!nativeComponent.isShowing()) {
                return null;
            }
            int type = (Integer)args[0];
            int e_x = (Integer)args[1];
            int e_y = (Integer)args[2];
            int e_button = (Integer)args[3];
            int e_count = (Integer)args[4];
            int e_stateMask = (Integer)args[5];
            Point e_cursorLocation = (Point)args[6];
            switch (type) {
                case 501: {
                    ++buttonPressedCount;
                    break;
                }
                case 502: {
                    if (--buttonPressedCount >= 0) break;
                    buttonPressedCount = 0;
                    break;
                }
            }
            int button = SWTUtils.translateSWTMouseButton(e_button);
            if (button == 0) {
                switch (type) {
                    case 500: 
                    case 501: 
                    case 502: {
                        return null;
                    }
                }
            }
            if (buttonPressedCount != 0 && type == 503) {
                type = 506;
            }
            MouseEvent me = Utils.IS_JAVA_6_OR_GREATER ? (type == 507 ? new MouseWheelEvent(nativeComponent, type, System.currentTimeMillis(), SWTUtils.translateSWTModifiers(e_stateMask), e_x, e_y, e_cursorLocation.x, e_cursorLocation.y, 0, false, 0, Math.abs(e_count), e_count < 0 ? 1 : -1) : new MouseEvent(nativeComponent, type, System.currentTimeMillis(), SWTUtils.translateSWTModifiers(e_stateMask), e_x, e_y, e_cursorLocation.x, e_cursorLocation.y, e_count, false, button)) : (type == 507 ? new MouseWheelEvent((Component)nativeComponent, type, System.currentTimeMillis(), SWTUtils.translateSWTModifiers(e_stateMask), e_x, e_y, 0, false, 0, Math.abs(e_count), e_count < 0 ? 1 : -1) : new MouseEvent(nativeComponent, type, System.currentTimeMillis(), SWTUtils.translateSWTModifiers(e_stateMask), e_x, e_y, e_count, false, button));
            nativeComponent.dispatchEvent(me);
            return null;
        }
    }

    private class CMLocal_runInSequence
    extends LocalMessage {
        private CMLocal_runInSequence() {
        }

        public Object run(Object[] args) {
            ((Runnable)args[0]).run();
            return null;
        }
    }

    private static class CMN_createControl
    extends CommandMessage {
        private CMN_createControl() {
        }

        public Shell createShell(Object handle) throws Exception {
            Method shellCreationMethod = null;
            try {
                shellCreationMethod = Shell.class.getMethod(String.valueOf(SWT.getPlatform()) + "_new", Display.class, Integer.TYPE);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (shellCreationMethod != null) {
                return (Shell)shellCreationMethod.invoke(null, NativeInterface.getDisplay(), handle);
            }
            try {
                shellCreationMethod = Shell.class.getMethod(String.valueOf(SWT.getPlatform()) + "_new", Display.class, Long.TYPE);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (shellCreationMethod != null) {
                return (Shell)shellCreationMethod.invoke(null, NativeInterface.getDisplay(), handle);
            }
            Constructor shellConstructor = null;
            try {
                shellConstructor = Shell.class.getConstructor(Display.class, Shell.class, Integer.TYPE, Integer.TYPE);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (shellConstructor != null) {
                shellConstructor.setAccessible(true);
                return (Shell)shellConstructor.newInstance(NativeInterface.getDisplay(), null, 8, handle);
            }
            try {
                shellConstructor = Shell.class.getConstructor(Display.class, Shell.class, Integer.TYPE, Long.TYPE);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (shellConstructor != null) {
                shellConstructor.setAccessible(true);
                return (Shell)shellConstructor.newInstance(NativeInterface.getDisplay(), null, 8, handle);
            }
            throw new IllegalStateException("Failed to create a Shell!");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object run(Object[] args) throws Exception {
            ObjectRegistry objectRegistry = registry;
            synchronized (objectRegistry) {
                Shell shell = this.createShell(args[2]);
                shell.setLayout((Layout)new FillLayout());
                int componentID = (Integer)args[0];
                Method createControlMethod = Class.forName((String)args[1]).getDeclaredMethod("createControl", Shell.class, Object[].class);
                createControlMethod.setAccessible(true);
                Control control = (Control)createControlMethod.invoke(null, shell, args[3]);
                registry.add(control, componentID);
                NativeComponent.configureControl(control, componentID);
                shell.setVisible(true);
            }
            return null;
        }
    }

    private static class CMN_destroyControl
    extends ControlCommandMessage {
        private CMN_destroyControl() {
        }

        public Object run(Object[] args) {
            Control control = this.getControl();
            registry.remove(this.getComponentID());
            if (control != null) {
                Shell shell;
                if (!control.isDisposed() && (shell = control.getShell()) != null) {
                    shell.dispose();
                }
                control.dispose();
            }
            return null;
        }
    }

    private static class CMN_getComponentImage
    extends ControlCommandMessage {
        private CMN_getComponentImage() {
        }

        private void printRemoveClip(Control control, GC gc) {
            Point size = control.getSize();
            Display display = control.getDisplay();
            Shell oldParent = control.getShell();
            Shell tmpHiddenParentShell = new Shell();
            Shell tmpParentShell = new Shell(tmpHiddenParentShell, 786440);
            Point location = display.map(control, null, control.getLocation());
            tmpParentShell.setLocation(location);
            tmpParentShell.setSize(size);
            org.eclipse.swt.widgets.Canvas screenshotCanvas = new org.eclipse.swt.widgets.Canvas((Composite)tmpParentShell, 262144);
            screenshotCanvas.setSize(size);
            GC displayGC = new GC((Drawable)display);
            final Image screenshot = new Image((Device)display, size.x, size.y);
            displayGC.copyArea(screenshot, location.x, location.y);
            displayGC.dispose();
            PaintListener paintListener = new PaintListener(){

                public void paintControl(PaintEvent e) {
                    e.gc.drawImage(screenshot, 0, 0);
                }
            };
            tmpParentShell.addPaintListener(paintListener);
            screenshotCanvas.addPaintListener(paintListener);
            oldParent.addPaintListener(paintListener);
            org.eclipse.swt.widgets.Canvas controlReplacementCanvas = new org.eclipse.swt.widgets.Canvas((Composite)oldParent, 262144);
            controlReplacementCanvas.setSize(size);
            controlReplacementCanvas.addPaintListener(paintListener);
            control.setRedraw(false);
            oldParent.setRedraw(false);
            control.setParent((Composite)tmpParentShell);
            control.moveBelow((Control)screenshotCanvas);
            tmpParentShell.setVisible(true);
            control.print(gc);
            control.setParent((Composite)oldParent);
            control.moveAbove((Control)controlReplacementCanvas);
            controlReplacementCanvas.dispose();
            oldParent.removePaintListener(paintListener);
            tmpParentShell.dispose();
            tmpHiddenParentShell.dispose();
            oldParent.setRedraw(true);
            control.setRedraw(true);
            screenshot.dispose();
        }

        private ImageData getImageData(Control control, Region region) {
            if (control.isDisposed()) {
                return null;
            }
            Point size = control.getSize();
            if (size.x <= 0 || size.y <= 0) {
                return null;
            }
            org.eclipse.swt.graphics.Rectangle bounds = region.getBounds();
            Display display = control.getDisplay();
            Image image = new Image((Device)display, bounds.x + bounds.width, bounds.y + bounds.height);
            GC gc = new GC((Drawable)image);
            gc.setClipping(region);
            if ("win32".equals(SWT.getPlatform()) && control instanceof Browser) {
                this.printRemoveClip(control, gc);
            } else {
                control.print(gc);
            }
            gc.dispose();
            ImageData imageData = image.getImageData();
            image.dispose();
            return imageData;
        }

        public Object run(Object[] args) throws Exception {
            ImageData imageData;
            int port = (Integer)args[0];
            Rectangle[] rectangles = (Rectangle[])args[1];
            final Control control = this.getControl();
            final Region region = new Region();
            Rectangle[] rectangleArray = rectangles;
            int n = 0;
            int n2 = rectangleArray.length;
            while (n < n2) {
                Rectangle rectangle = rectangleArray[n];
                region.add(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                ++n;
            }
            if (!NativeInterface.isUIThread()) {
                final Exception[] eArray = new Exception[1];
                final ImageData[] resultArray = new ImageData[1];
                control.getDisplay().syncExec(new Runnable(){

                    public void run() {
                        try {
                            resultArray[0] = CMN_getComponentImage.this.getImageData(control, region);
                        }
                        catch (Exception e) {
                            eArray[0] = e;
                        }
                    }
                });
                if (eArray[0] != null) {
                    new Socket("127.0.0.1", port).close();
                    throw eArray[0];
                }
                imageData = resultArray[0];
            } else {
                imageData = this.getImageData(control, region);
            }
            region.dispose();
            if (imageData == null) {
                new Socket("127.0.0.1", port).close();
                return null;
            }
            int cursor = 0;
            byte[] bytes = new byte[3072];
            PaletteData palette = imageData.palette;
            if (palette.isDirect) {
                Socket socket = new Socket("127.0.0.1", port);
                BufferedOutputStream out = new BufferedOutputStream(socket.getOutputStream());
                int width = imageData.width;
                int height = imageData.height;
                try {
                    Rectangle[] rectangleArray2 = rectangles;
                    int n3 = 0;
                    int n4 = rectangleArray2.length;
                    while (n3 < n4) {
                        Rectangle rectangle = rectangleArray2[n3];
                        int j = 0;
                        while (j < rectangle.height) {
                            int y = rectangle.y + j;
                            int i = 0;
                            while (i < rectangle.width) {
                                int x = rectangle.x + i;
                                if (x < width && y < height) {
                                    int pixel = imageData.getPixel(x, y);
                                    int red = pixel & palette.redMask;
                                    bytes[cursor++] = (byte)(palette.redShift < 0 ? red >>> -palette.redShift : red << palette.redShift);
                                    int green = pixel & palette.greenMask;
                                    bytes[cursor++] = (byte)(palette.greenShift < 0 ? green >>> -palette.greenShift : green << palette.greenShift);
                                    int blue = pixel & palette.blueMask;
                                    bytes[cursor++] = (byte)(palette.blueShift < 0 ? blue >>> -palette.blueShift : blue << palette.blueShift);
                                } else {
                                    cursor += 3;
                                }
                                if (cursor == bytes.length) {
                                    out.write(bytes);
                                    cursor = 0;
                                }
                                ++i;
                            }
                            ++j;
                        }
                        ++n3;
                    }
                    out.write(bytes, 0, cursor);
                    out.flush();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                out.close();
                socket.close();
                return null;
            }
            throw new IllegalStateException("Not implemented");
        }
    }

    private static class CMN_getPreferredSize
    extends ControlCommandMessage {
        private CMN_getPreferredSize() {
        }

        public Object run(Object[] args) {
            Control control = this.getControl();
            Point cSize = control.computeSize(-1, -1);
            return new Dimension(cSize.x, cSize.y);
        }
    }

    private static class CMN_hasFocus
    extends ControlCommandMessage {
        private CMN_hasFocus() {
        }

        public Object run(Object[] args) {
            return this.getControl().isFocusControl();
        }
    }

    private static class CMN_reshape
    extends ControlCommandMessage {
        private CMN_reshape() {
        }

        public Object run(Object[] args) {
            this.getControl().getShell().setSize(((Integer)args[0]).intValue(), ((Integer)args[1]).intValue());
            return null;
        }
    }

    private static class CMN_setEnabled
    extends ControlCommandMessage {
        private CMN_setEnabled() {
        }

        public Object run(Object[] args) {
            this.getControl().setEnabled(((Boolean)args[0]).booleanValue());
            return null;
        }
    }

    private static class CMN_setEventsEnabled
    extends ControlCommandMessage {
        private CMN_setEventsEnabled() {
        }

        public Object run(Object[] args) {
            long eventMask = (Long)args[0];
            boolean isEnabled = (Boolean)args[1];
            long events = (Long)this.getControl().getData("NS_EnabledEventsMask");
            events = isEnabled ? (events |= eventMask) : (events &= eventMask ^ 0xFFFFFFFFFFFFFFFFL);
            this.getControl().setData("NS_EnabledEventsMask", (Object)events);
            return null;
        }
    }

    private static class CMN_setShellEnabled
    extends ControlCommandMessage {
        private CMN_setShellEnabled() {
        }

        public Object run(Object[] args) {
            this.getControl().getShell().setEnabled(((Boolean)args[0]).booleanValue());
            return null;
        }
    }

    private static class CMN_transferFocus
    extends ControlCommandMessage {
        private CMN_transferFocus() {
        }

        public Object run(Object[] args) {
            this.getControl().traverse(16);
            return null;
        }
    }

    private static class NNativeInterfaceListener
    extends NativeInterfaceAdapter {
        protected Reference<NativeComponent> nativeComponent;

        protected NNativeInterfaceListener(NativeComponent nativeComponent) {
            this.nativeComponent = new WeakReference<NativeComponent>(nativeComponent);
        }

        public void nativeInterfaceClosed() {
            NativeInterface.removeNativeInterfaceListener(this);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    NativeComponent nativeComponent = NNativeInterfaceListener.this.nativeComponent.get();
                    if (nativeComponent == null) {
                        return;
                    }
                    nativeComponent.invalidateNativePeer("The native peer died unexpectedly.");
                    nativeComponent.repaint();
                }
            });
        }
    }

    static interface NativeComponentHolder {
    }

    static class SimpleNativeComponentHolder
    extends JPanel
    implements NativeComponentHolder {
        private NativeComponent nativeComponent;

        public SimpleNativeComponentHolder(NativeComponent nativeComponent) {
            super(new BorderLayout(0, 0));
            this.nativeComponent = nativeComponent;
            this.add(nativeComponent);
        }

        protected void printComponent(Graphics g) {
            this.nativeComponent.print(g);
        }
    }
}

