/*
 * Decompiled with CFR 0.152.
 */
package chrriis.dj.nativeswing;

import chrriis.common.Filter;
import chrriis.common.UIUtils;
import chrriis.dj.nativeswing.BackBufferManager;
import chrriis.dj.nativeswing.NativeComponent;
import chrriis.dj.nativeswing.NativeComponentProxyPanel;
import chrriis.dj.nativeswing.NativeComponentProxyWindow;
import chrriis.dj.nativeswing.NativeInterface;
import java.awt.AWTEvent;
import java.awt.Canvas;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

abstract class NativeComponentProxy
extends JComponent {
    private BackBufferManager backBufferManager;
    protected NativeComponent nativeComponent;
    protected boolean isDestructionOnFinalization;
    protected boolean isVisibilityConstrained;
    private AWTEventListener shapeAdjustmentEventListener;
    private HierarchyListener hierarchyListener;
    private Component peer;

    protected NativeComponentProxy(NativeComponent nativeComponent, boolean isVisibilityConstrained, boolean isDestructionOnFinalization) {
        this.isDestructionOnFinalization = isDestructionOnFinalization;
        this.isVisibilityConstrained = isVisibilityConstrained;
        this.setFocusable(true);
        this.nativeComponent = nativeComponent;
        this.backBufferManager = new BackBufferManager(nativeComponent, this);
        this.hierarchyListener = new HierarchyListener(){

            public void hierarchyChanged(HierarchyEvent e) {
                long changeFlags = e.getChangeFlags();
                if ((changeFlags & 4L) != 0L) {
                    if (NativeComponentProxy.this.isVisibilityConstrained) {
                        NativeComponentProxy.this.adjustPeerShape();
                    } else {
                        NativeComponentProxy.this.adjustPeerBounds();
                    }
                }
            }
        };
        if (isVisibilityConstrained) {
            this.shapeAdjustmentEventListener = new AWTEventListener(){

                public void eventDispatched(AWTEvent e) {
                    boolean isAdjustingShape = false;
                    switch (e.getID()) {
                        case 100: 
                        case 101: 
                        case 300: 
                        case 301: {
                            isAdjustingShape = true;
                            break;
                        }
                        case 102: 
                        case 103: {
                            if (!(e.getSource() instanceof Window)) break;
                            isAdjustingShape = true;
                        }
                    }
                    if (isAdjustingShape && NativeComponentProxy.this.nativeComponent.getNativeComponentProxy() == NativeComponentProxy.this) {
                        NativeComponentProxy.this.adjustPeerShape();
                    }
                }
            };
        }
    }

    public void addNotify() {
        super.addNotify();
        this.nativeComponent.setNativeComponentProxy(this);
        if (this.hierarchyListener != null) {
            this.addHierarchyListener(this.hierarchyListener);
        }
        if (this.shapeAdjustmentEventListener != null) {
            Toolkit.getDefaultToolkit().addAWTEventListener(this.shapeAdjustmentEventListener, 3L);
        }
        if (this.peer != null) {
            this.adjustPeerBounds();
            this.connectPeer();
            return;
        }
        this.peer = this.createPeer();
        this.adjustPeerBounds();
        this.connectPeer();
        this.addPeer();
    }

    protected void connectPeer() {
    }

    protected void disconnectPeer() {
    }

    public void removeNotify() {
        super.removeNotify();
        this.nativeComponent.setNativeComponentProxy(null);
        if (this.hierarchyListener != null) {
            this.removeHierarchyListener(this.hierarchyListener);
        }
        if (this.shapeAdjustmentEventListener != null) {
            Toolkit.getDefaultToolkit().removeAWTEventListener(this.shapeAdjustmentEventListener);
        }
        if (this.isDestructionOnFinalization) {
            this.disconnectPeer();
            if (this.isVisibilityConstrained) {
                this.adjustPeerShape();
            } else {
                this.adjustPeerBounds();
            }
            return;
        }
        this.dispose();
    }

    protected void finalize() throws Throwable {
        super.finalize();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                NativeComponentProxy.this.dispose();
            }
        });
    }

    public void dispose() {
        if (this.peer == null) {
            return;
        }
        this.destroyPeer();
        this.peer = null;
    }

    protected abstract Component createPeer();

    protected abstract void addPeer();

    protected abstract void destroyPeer();

    protected void adjustPeerBounds() {
        boolean isShowing;
        if (this.peer == null) {
            return;
        }
        if (!this.isVisibilityConstrained && (isShowing = this.isShowing()) != this.peer.isVisible()) {
            this.peer.setVisible(isShowing);
        }
        Point location = new Point(0, 0);
        if (this.peer instanceof Window) {
            SwingUtilities.convertPointToScreen(location, this);
        } else {
            location = SwingUtilities.convertPoint(this, location, this.peer.getParent());
        }
        Dimension size = this.getPeerSize();
        Rectangle bounds = new Rectangle(location.x, location.y, size.width, size.height);
        if (!this.peer.getBounds().equals(bounds)) {
            this.peer.setBounds(bounds);
            this.peer.invalidate();
            this.peer.validate();
            this.peer.repaint();
            if (this.isVisibilityConstrained) {
                this.adjustPeerShape();
            }
        }
    }

    protected Dimension getPeerSize() {
        return this.getSize();
    }

    protected abstract void adjustPeerShape();

    public void paint(Graphics g) {
        super.paint(g);
        Canvas[] canvasArray = NativeInterface.getCanvas();
        int n = 0;
        int n2 = canvasArray.length;
        while (n < n2) {
            NativeComponentProxy nativeComponentProxy;
            Canvas canvas = canvasArray[n];
            if (canvas instanceof NativeComponent && (nativeComponentProxy = ((NativeComponent)canvas).getNativeComponentProxy()) != null && nativeComponentProxy.isVisibilityConstrained) {
                nativeComponentProxy.adjustPeerShape();
            }
            ++n;
        }
    }

    public void reshape(int x, int y, int w, int h) {
        if (x == this.getX() && y == this.getY() && w == this.getWidth() && h == this.getHeight()) {
            return;
        }
        super.reshape(x, y, w, h);
        this.adjustPeerBounds();
    }

    protected abstract Rectangle[] getPeerShapeArea();

    protected Rectangle[] computePeerShapeArea() {
        Rectangle[] shape = UIUtils.getComponentVisibleArea(this, new Filter<Component>(){

            @Override
            public boolean accept(Component c) {
                return !(c instanceof NativeComponentProxyPanel.EmbeddedPanel);
            }
        }, false);
        if (shape.length == 0) {
            return shape;
        }
        Window windowAncestor = SwingUtilities.getWindowAncestor(this);
        Rectangle tempRectangle = new Rectangle();
        Window[] windowArray = NativeInterface.getWindows();
        int n = 0;
        int n2 = windowArray.length;
        while (n < n2) {
            Window window = windowArray[n];
            if (!(window instanceof NativeComponentProxyWindow.EmbeddedWindow) && window.isVisible()) {
                Window owner = window;
                while ((owner = owner.getOwner()) != null) {
                    if (owner != windowAncestor) continue;
                    tempRectangle.setBounds(0, 0, window.getWidth(), window.getHeight());
                    shape = UIUtils.subtract(shape, SwingUtilities.convertRectangle(window, tempRectangle, this));
                    break;
                }
            }
            ++n;
        }
        return shape;
    }

    protected void printComponent(Graphics g) {
        this.nativeComponent.print(g);
    }

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.backBufferManager.paintBackBuffer(g);
    }

    public BackBufferManager getBackBufferManager() {
        return this.backBufferManager;
    }
}

