/*
 * Decompiled with CFR 0.152.
 */
package chrriis.dj.nativeswing.components;

import chrriis.common.ObjectRegistry;
import chrriis.common.Utils;
import chrriis.dj.nativeswing.CommandMessage;
import chrriis.dj.nativeswing.ControlCommandMessage;
import chrriis.dj.nativeswing.NSOption;
import chrriis.dj.nativeswing.NativeComponent;
import chrriis.dj.nativeswing.components.JWebBrowser;
import chrriis.dj.nativeswing.components.JWebBrowserWindow;
import chrriis.dj.nativeswing.components.WebBrowserEvent;
import chrriis.dj.nativeswing.components.WebBrowserListener;
import chrriis.dj.nativeswing.components.WebBrowserNavigationEvent;
import chrriis.dj.nativeswing.components.WebBrowserWindowOpeningEvent;
import chrriis.dj.nativeswing.components.WebBrowserWindowWillOpenEvent;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Window;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import javax.swing.SwingUtilities;
import org.eclipse.swt.SWT;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.CloseWindowListener;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.OpenWindowListener;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.browser.StatusTextEvent;
import org.eclipse.swt.browser.StatusTextListener;
import org.eclipse.swt.browser.TitleEvent;
import org.eclipse.swt.browser.TitleListener;
import org.eclipse.swt.browser.VisibilityWindowAdapter;
import org.eclipse.swt.browser.VisibilityWindowListener;
import org.eclipse.swt.browser.WindowEvent;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class NativeWebBrowser
extends NativeComponent {
    private static final String COMMAND_PREFIX = "command://";
    private boolean isXULRunnerEngine;
    private Reference<JWebBrowser> webBrowser;
    private String status;
    private String title;
    private int loadingProgress = 100;

    @Override
    protected Object[] getNativePeerCreationParameters() {
        return new Object[]{this.isXULRunnerEngine};
    }

    protected static Control createControl(Shell shell, Object[] parameters) {
        int style = 0;
        if (((Boolean)parameters[0]).booleanValue()) {
            style |= 0x8000;
        }
        final Browser browser = new Browser((Composite)shell, style);
        browser.addCloseWindowListener(new CloseWindowListener(){

            public void close(WindowEvent event) {
                new CMJ_closeWindow().asyncExec((Control)browser, new Object[0]);
            }
        });
        browser.addOpenWindowListener(new OpenWindowListener(){

            public void open(WindowEvent e) {
                Browser newWebBrowser;
                boolean isDisposed;
                e.required = true;
                final Integer componentID = (Integer)new CMJ_createWindow().syncExec((Control)browser, new Object[0]);
                if (componentID == null) {
                    isDisposed = true;
                    Shell shell = new Shell();
                    newWebBrowser = new Browser((Composite)shell, browser.getStyle());
                } else {
                    isDisposed = false;
                    newWebBrowser = (Browser)NativeWebBrowser.access$3().get(componentID);
                }
                e.browser = newWebBrowser;
                newWebBrowser.addVisibilityWindowListener((VisibilityWindowListener)new VisibilityWindowAdapter(){

                    public void show(WindowEvent e) {
                        Browser browser = (Browser)e.widget;
                        if (isDisposed) {
                            final Shell shell = browser.getShell();
                            e.display.asyncExec(new Runnable(){

                                public void run() {
                                    shell.close();
                                }
                            });
                        } else {
                            browser.removeVisibilityWindowListener((VisibilityWindowListener)this);
                            new CMJ_showWindow().asyncExec((Control)newWebBrowser, new Object[]{componentID, e.menuBar, e.toolBar, e.addressBar, e.statusBar, e.location == null ? null : new Point(e.location.x, e.location.y), e.size == null ? null : new Dimension(e.size.x, e.size.y)});
                        }
                    }
                });
            }
        });
        browser.addLocationListener(new LocationListener(){

            public void changed(LocationEvent e) {
                browser.setData("Browser.loading", (Object)false);
                new CMJ_locationChanged().asyncExec((Control)browser, new Object[]{e.location, e.top});
            }

            public void changing(LocationEvent e) {
                String location = e.location;
                if (location.startsWith(NativeWebBrowser.COMMAND_PREFIX)) {
                    e.doit = false;
                    String query = location.substring(NativeWebBrowser.COMMAND_PREFIX.length());
                    if (query.endsWith("/")) {
                        query = query.substring(0, query.length() - 1);
                    }
                    ArrayList<String> queryElementList = new ArrayList<String>();
                    StringTokenizer st = new StringTokenizer(query, "&", true);
                    String lastToken = null;
                    while (st.hasMoreTokens()) {
                        String token = st.nextToken();
                        if ("&".equals(token)) {
                            if (lastToken == null) {
                                queryElementList.add("");
                            }
                            lastToken = null;
                            continue;
                        }
                        lastToken = token;
                        queryElementList.add(Utils.decodeURL(token));
                    }
                    if (lastToken == null) {
                        queryElementList.add("");
                    }
                    String command = queryElementList.isEmpty() ? "" : (String)queryElementList.remove(0);
                    String[] args = queryElementList.toArray(new String[0]);
                    new CMJ_commandReceived().asyncExec((Control)browser, new Object[]{command, args});
                    return;
                }
                if (location.startsWith("javascript:")) {
                    return;
                }
                browser.setData("CMJ_updateStatus.status", null);
                browser.setData("CMJ_updateProgress.progress", null);
                browser.setData("Browser.loading", (Object)true);
                e.doit = (Boolean)new CMJ_locationChanging().syncExec((Control)browser, new Object[]{location, e.top});
                if (!e.doit) {
                    browser.setData("Browser.loading", (Object)false);
                    new CMJ_locationChangeCanceled().asyncExec((Control)browser, new Object[]{location, e.top});
                }
            }
        });
        browser.addTitleListener(new TitleListener(){

            public void changed(TitleEvent e) {
                new CMJ_updateTitle().asyncExec((Control)browser, new Object[]{e.title});
            }
        });
        browser.addStatusTextListener(new StatusTextListener(){

            public void changed(StatusTextEvent e) {
                String newStatus;
                String oldStatus = (String)browser.getData("CMJ_updateStatus.status");
                if (!Utils.equals(oldStatus, newStatus = e.text)) {
                    browser.setData("CMJ_updateStatus.status", (Object)newStatus);
                    new CMJ_updateStatus().asyncExec((Control)browser, new Object[]{newStatus});
                }
            }
        });
        browser.addProgressListener(new ProgressListener(){

            private void updateProgress(int loadingProgress) {
                Integer oldLoadingProgress = (Integer)browser.getData("CMJ_updateProgress.progress");
                if (!Utils.equals(oldLoadingProgress, loadingProgress)) {
                    browser.setData("CMJ_updateProgress.progress", (Object)loadingProgress);
                    new CMJ_updateLoadingProgress().asyncExec((Control)browser, new Object[]{loadingProgress});
                }
            }

            public void changed(ProgressEvent e) {
                if (e.total <= 0 || e.total < e.current) {
                    return;
                }
                browser.setData("Browser.loading", (Object)true);
                this.updateProgress(e.current == e.total ? 100 : Math.min(e.current * 100 / e.total, 99));
            }

            public void completed(ProgressEvent progressevent) {
                browser.setData("Browser.loading", (Object)false);
                this.updateProgress(100);
            }
        });
        NativeWebBrowser.registerDefaultPopupMenu(browser);
        return browser;
    }

    public NativeWebBrowser(JWebBrowser webBrowser, boolean isXULRunnerEngine) {
        this.webBrowser = new WeakReference<JWebBrowser>(webBrowser);
        this.isXULRunnerEngine = isXULRunnerEngine || "xulrunner".equals(System.getProperty("nativeswing.webbrowser.runtime"));
    }

    public static void clearSessionCookies() {
        new CMN_clearSessionCookies().asyncExec(new Object[0]);
    }

    public String getResourceLocation() {
        return (String)this.runSync(new CMN_getResourceLocation(), new Object[0]);
    }

    public boolean navigate(String resourceLocation) {
        return Boolean.TRUE.equals(this.runSync(new CMN_navigate(), resourceLocation));
    }

    public String getHTMLContent() {
        return (String)this.runSync(new CMN_getHTMLContent(), new Object[0]);
    }

    public boolean setHTMLContent(String html) {
        return Boolean.TRUE.equals(this.runSync(new CMN_setHTMLContent(), html));
    }

    public boolean executeJavascriptAndWait(String script) {
        return Boolean.TRUE.equals(this.runSync(new CMN_executeJavascript(), script));
    }

    public void executeJavascript(String script) {
        this.runAsync(new CMN_executeJavascript(), script);
    }

    public void stopLoading() {
        this.runAsync(new CMN_stopLoading(), new Object[0]);
    }

    public void reloadPage() {
        this.runAsync(new CMN_reloadPage(), new Object[0]);
    }

    public boolean isBackNavigationEnabled() {
        return Boolean.TRUE.equals(this.runSync(new CMN_isBackNavigationEnabled(), new Object[0]));
    }

    public void navigateBack() {
        this.runAsync(new CMN_navigateBack(), new Object[0]);
    }

    public boolean isForwardNavigationEnabled() {
        return Boolean.TRUE.equals(this.runSync(new CMN_isForwardNavigationEnabled(), new Object[0]));
    }

    public void navigateForward() {
        this.runAsync(new CMN_navigateForward(), new Object[0]);
    }

    private static void registerDefaultPopupMenu(final Browser browser) {
        Menu oldMenu = browser.getMenu();
        if (oldMenu != null) {
            oldMenu.dispose();
        }
        if ("win32".equals(SWT.getPlatform()) && (browser.getStyle() & 0x8000) == 0) {
            browser.setMenu(null);
            return;
        }
        Menu menu = new Menu((Decorations)browser.getShell(), 8);
        String className = NativeWebBrowser.class.getName();
        ResourceBundle bundle = ResourceBundle.getBundle(String.valueOf(className.substring(0, className.lastIndexOf(46)).replace('.', '/')) + "/resource/WebBrowser");
        final MenuItem backMenuItem = new MenuItem(menu, 8);
        backMenuItem.setText(bundle.getString("SystemMenuBack"));
        backMenuItem.setImage(new Image((Device)browser.getDisplay(), NativeWebBrowser.class.getResourceAsStream(bundle.getString("SystemMenuBackIcon"))));
        backMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                browser.back();
            }
        });
        final MenuItem forwardMenuItem = new MenuItem(menu, 8);
        forwardMenuItem.setText(bundle.getString("SystemMenuForward"));
        forwardMenuItem.setImage(new Image((Device)browser.getDisplay(), NativeWebBrowser.class.getResourceAsStream(bundle.getString("SystemMenuForwardIcon"))));
        forwardMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                browser.forward();
            }
        });
        MenuItem reloadMenuItem = new MenuItem(menu, 8);
        reloadMenuItem.setText(bundle.getString("SystemMenuReload"));
        reloadMenuItem.setImage(new Image((Device)browser.getDisplay(), NativeWebBrowser.class.getResourceAsStream(bundle.getString("SystemMenuReloadIcon"))));
        reloadMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                browser.refresh();
            }
        });
        final MenuItem stopMenuItem = new MenuItem(menu, 8);
        stopMenuItem.setText(bundle.getString("SystemMenuStop"));
        stopMenuItem.setImage(new Image((Device)browser.getDisplay(), NativeWebBrowser.class.getResourceAsStream(bundle.getString("SystemMenuStopIcon"))));
        stopMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                browser.stop();
            }
        });
        menu.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuShown(MenuEvent e) {
                backMenuItem.setEnabled(browser.isBackEnabled());
                forwardMenuItem.setEnabled(browser.isForwardEnabled());
                stopMenuItem.setEnabled(Boolean.TRUE.equals(browser.getData("Browser.loading")));
            }
        });
        browser.setMenu(menu);
    }

    public void setDefaultPopupMenuRegistered(boolean isDefaultPopupMenuRegistered) {
        this.runAsync(new CMN_setDefaultPopupMenuRegistered(), isDefaultPopupMenuRegistered);
    }

    public String getStatusText() {
        return this.status == null ? "" : this.status;
    }

    public String getPageTitle() {
        return this.title == null ? "" : this.title;
    }

    public int getLoadingProgress() {
        return this.loadingProgress;
    }

    public void addWebBrowserListener(WebBrowserListener listener) {
        this.listenerList.add(WebBrowserListener.class, listener);
    }

    public void removeWebBrowserListener(WebBrowserListener listener) {
        this.listenerList.remove(WebBrowserListener.class, listener);
    }

    public WebBrowserListener[] getWebBrowserListeners() {
        return (WebBrowserListener[])this.listenerList.getListeners(WebBrowserListener.class);
    }

    @Override
    protected Component createEmbeddableComponent(Map<Object, Object> optionMap) {
        return super.createEmbeddableComponent(optionMap);
    }

    @Override
    protected void disposeNativePeer() {
        super.disposeNativePeer();
    }

    static /* synthetic */ ObjectRegistry access$3() {
        return NativeComponent.getRegistry();
    }

    private static class CMJ_closeWindow
    extends ControlCommandMessage {
        private CMJ_closeWindow() {
        }

        public Object run(Object[] args) {
            NativeWebBrowser nativeWebBrowser = (NativeWebBrowser)this.getNativeComponent();
            JWebBrowser webBrowser = (JWebBrowser)nativeWebBrowser.webBrowser.get();
            if (webBrowser == null) {
                return null;
            }
            Object[] listeners = nativeWebBrowser.listenerList.getListenerList();
            WebBrowserEvent e = null;
            int i = listeners.length - 2;
            while (i >= 0) {
                if (listeners[i] == WebBrowserListener.class) {
                    if (e == null) {
                        e = new WebBrowserEvent(webBrowser);
                    }
                    ((WebBrowserListener)listeners[i + 1]).windowClosing(e);
                }
                i -= 2;
            }
            JWebBrowserWindow browserWindow = webBrowser.getWebBrowserWindow();
            if (browserWindow != null) {
                browserWindow.dispose();
            }
            return null;
        }
    }

    private static class CMJ_commandReceived
    extends ControlCommandMessage {
        private CMJ_commandReceived() {
        }

        public Object run(Object[] args) {
            NativeWebBrowser nativeWebBrowser = (NativeWebBrowser)this.getNativeComponent();
            JWebBrowser webBrowser = (JWebBrowser)nativeWebBrowser.webBrowser.get();
            if (webBrowser == null) {
                return null;
            }
            Object[] listeners = nativeWebBrowser.listenerList.getListenerList();
            WebBrowserEvent e = null;
            String command = (String)args[0];
            String[] arguments = (String[])args[1];
            int i = listeners.length - 2;
            while (i >= 0) {
                if (listeners[i] == WebBrowserListener.class) {
                    if (e == null) {
                        e = new WebBrowserEvent(webBrowser);
                    }
                    ((WebBrowserListener)listeners[i + 1]).commandReceived(e, command, arguments);
                }
                i -= 2;
            }
            return null;
        }
    }

    private static class CMJ_createWindow
    extends ControlCommandMessage {
        private CMJ_createWindow() {
        }

        public Object run(Object[] args) {
            NativeWebBrowser nativeWebBrowser = (NativeWebBrowser)this.getNativeComponent();
            JWebBrowser webBrowser = (JWebBrowser)nativeWebBrowser.webBrowser.get();
            if (webBrowser == null) {
                return null;
            }
            JWebBrowser jWebBrowser = new JWebBrowser(new NSOption[0]);
            Object[] listeners = nativeWebBrowser.listenerList.getListenerList();
            WebBrowserWindowWillOpenEvent e = null;
            int i = listeners.length - 2;
            while (i >= 0 && jWebBrowser != null) {
                if (listeners[i] == WebBrowserListener.class) {
                    if (e == null) {
                        e = new WebBrowserWindowWillOpenEvent(webBrowser, jWebBrowser);
                    }
                    ((WebBrowserListener)listeners[i + 1]).windowWillOpen(e);
                    jWebBrowser = e.isConsumed() ? null : e.getNewWebBrowser();
                }
                i -= 2;
            }
            if (jWebBrowser == null) {
                return null;
            }
            if (!jWebBrowser.isNativePeerInitialized()) {
                Window windowAncestor = SwingUtilities.getWindowAncestor(jWebBrowser);
                if (windowAncestor == null) {
                    JWebBrowserWindow webBrowserWindow = new JWebBrowserWindow(jWebBrowser);
                    windowAncestor = webBrowserWindow;
                }
                jWebBrowser.getNativeComponent().initializeNativePeer();
            }
            return ((NativeWebBrowser)jWebBrowser.getNativeComponent()).getComponentID();
        }
    }

    private static class CMJ_locationChangeCanceled
    extends ControlCommandMessage {
        private CMJ_locationChangeCanceled() {
        }

        public Object run(Object[] args) {
            NativeWebBrowser nativeWebBrowser = (NativeWebBrowser)this.getNativeComponent();
            JWebBrowser webBrowser = (JWebBrowser)nativeWebBrowser.webBrowser.get();
            if (webBrowser == null) {
                return null;
            }
            Object[] listeners = nativeWebBrowser.listenerList.getListenerList();
            String location = (String)args[0];
            boolean isTopFrame = (Boolean)args[1];
            WebBrowserNavigationEvent e = null;
            int i = listeners.length - 2;
            while (i >= 0) {
                if (listeners[i] == WebBrowserListener.class) {
                    if (e == null) {
                        e = new WebBrowserNavigationEvent(webBrowser, location, isTopFrame);
                    }
                    ((WebBrowserListener)listeners[i + 1]).locationChangeCanceled(e);
                }
                i -= 2;
            }
            return null;
        }
    }

    private static class CMJ_locationChanged
    extends ControlCommandMessage {
        private CMJ_locationChanged() {
        }

        public Object run(Object[] args) {
            NativeWebBrowser nativeWebBrowser = (NativeWebBrowser)this.getNativeComponent();
            JWebBrowser webBrowser = (JWebBrowser)nativeWebBrowser.webBrowser.get();
            if (webBrowser == null) {
                return null;
            }
            Object[] listeners = nativeWebBrowser.listenerList.getListenerList();
            String location = (String)args[0];
            boolean isTopFrame = (Boolean)args[1];
            WebBrowserNavigationEvent e = null;
            int i = listeners.length - 2;
            while (i >= 0) {
                if (listeners[i] == WebBrowserListener.class) {
                    if (e == null) {
                        e = new WebBrowserNavigationEvent(webBrowser, location, isTopFrame);
                    }
                    ((WebBrowserListener)listeners[i + 1]).locationChanged(e);
                }
                i -= 2;
            }
            return null;
        }
    }

    private static class CMJ_locationChanging
    extends ControlCommandMessage {
        private CMJ_locationChanging() {
        }

        public Object run(Object[] args) {
            NativeWebBrowser nativeWebBrowser = (NativeWebBrowser)this.getNativeComponent();
            JWebBrowser webBrowser = (JWebBrowser)nativeWebBrowser.webBrowser.get();
            if (webBrowser == null) {
                return false;
            }
            Object[] listeners = nativeWebBrowser.listenerList.getListenerList();
            String location = (String)args[0];
            boolean isTopFrame = (Boolean)args[1];
            boolean isNavigating = true;
            WebBrowserNavigationEvent e = null;
            int i = listeners.length - 2;
            while (i >= 0) {
                if (listeners[i] == WebBrowserListener.class) {
                    if (e == null) {
                        e = new WebBrowserNavigationEvent(webBrowser, location, isTopFrame);
                    }
                    ((WebBrowserListener)listeners[i + 1]).locationChanging(e);
                    isNavigating &= !e.isConsumed();
                }
                i -= 2;
            }
            return isNavigating;
        }
    }

    private static class CMJ_showWindow
    extends ControlCommandMessage {
        private CMJ_showWindow() {
        }

        public Object run(Object[] args) {
            NativeWebBrowser nativeWebBrowser = (NativeWebBrowser)this.getNativeComponent();
            JWebBrowser webBrowser = (JWebBrowser)nativeWebBrowser.webBrowser.get();
            if (webBrowser == null) {
                return null;
            }
            int componentID = (Integer)args[0];
            final JWebBrowser newWebBrowser = (JWebBrowser)((NativeWebBrowser)NativeWebBrowser.access$3().get(componentID)).webBrowser.get();
            newWebBrowser.setMenuBarVisible((Boolean)args[1]);
            newWebBrowser.setButtonBarVisible((Boolean)args[2]);
            newWebBrowser.setLocationBarVisible((Boolean)args[3]);
            newWebBrowser.setStatusBarVisible((Boolean)args[4]);
            Point location = (Point)args[5];
            Dimension size = (Dimension)args[6];
            JWebBrowserWindow browserWindow = newWebBrowser.getWebBrowserWindow();
            if (browserWindow != null) {
                if (size != null) {
                    browserWindow.setSize(size);
                }
                if (location != null) {
                    browserWindow.setLocation(location);
                }
            }
            Object[] listeners = nativeWebBrowser.listenerList.getListenerList();
            WebBrowserWindowOpeningEvent e = null;
            int i = listeners.length - 2;
            while (i >= 0 && newWebBrowser != null) {
                if (listeners[i] == WebBrowserListener.class) {
                    if (e == null) {
                        e = new WebBrowserWindowOpeningEvent(webBrowser, newWebBrowser, location, size);
                    }
                    ((WebBrowserListener)listeners[i + 1]).windowOpening(e);
                }
                i -= 2;
            }
            new Thread(){

                public void run() {
                    try {
                        1.sleep(200L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            JWebBrowserWindow browserWindow = newWebBrowser.getWebBrowserWindow();
                            if (browserWindow != null && !newWebBrowser.getNativeComponent().isNativePeerDisposed()) {
                                browserWindow.setVisible(true);
                            }
                        }
                    });
                }
            }.start();
            return null;
        }
    }

    private static class CMJ_updateLoadingProgress
    extends ControlCommandMessage {
        private CMJ_updateLoadingProgress() {
        }

        public Object run(Object[] args) {
            NativeWebBrowser nativeWebBrowser = (NativeWebBrowser)this.getNativeComponent();
            JWebBrowser webBrowser = (JWebBrowser)nativeWebBrowser.webBrowser.get();
            if (webBrowser == null) {
                return null;
            }
            nativeWebBrowser.loadingProgress = (Integer)args[0];
            Object[] listeners = nativeWebBrowser.listenerList.getListenerList();
            WebBrowserEvent e = null;
            int i = listeners.length - 2;
            while (i >= 0) {
                if (listeners[i] == WebBrowserListener.class) {
                    if (e == null) {
                        e = new WebBrowserEvent(webBrowser);
                    }
                    ((WebBrowserListener)listeners[i + 1]).loadingProgressChanged(e);
                }
                i -= 2;
            }
            return null;
        }
    }

    private static class CMJ_updateStatus
    extends ControlCommandMessage {
        private CMJ_updateStatus() {
        }

        public Object run(Object[] args) {
            NativeWebBrowser nativeWebBrowser = (NativeWebBrowser)this.getNativeComponent();
            JWebBrowser webBrowser = (JWebBrowser)nativeWebBrowser.webBrowser.get();
            if (webBrowser == null) {
                return null;
            }
            nativeWebBrowser.status = (String)args[0];
            Object[] listeners = nativeWebBrowser.listenerList.getListenerList();
            WebBrowserEvent e = null;
            int i = listeners.length - 2;
            while (i >= 0) {
                if (listeners[i] == WebBrowserListener.class) {
                    if (e == null) {
                        e = new WebBrowserEvent(webBrowser);
                    }
                    ((WebBrowserListener)listeners[i + 1]).statusChanged(e);
                }
                i -= 2;
            }
            return null;
        }
    }

    private static class CMJ_updateTitle
    extends ControlCommandMessage {
        private CMJ_updateTitle() {
        }

        public Object run(Object[] args) {
            NativeWebBrowser nativeWebBrowser = (NativeWebBrowser)this.getNativeComponent();
            JWebBrowser webBrowser = (JWebBrowser)nativeWebBrowser.webBrowser.get();
            if (webBrowser == null) {
                return null;
            }
            nativeWebBrowser.title = (String)args[0];
            Object[] listeners = nativeWebBrowser.listenerList.getListenerList();
            WebBrowserEvent e = null;
            int i = listeners.length - 2;
            while (i >= 0) {
                if (listeners[i] == WebBrowserListener.class) {
                    if (e == null) {
                        e = new WebBrowserEvent(webBrowser);
                    }
                    ((WebBrowserListener)listeners[i + 1]).titleChanged(e);
                }
                i -= 2;
            }
            return null;
        }
    }

    private static class CMN_clearSessionCookies
    extends CommandMessage {
        private CMN_clearSessionCookies() {
        }

        public Object run(Object[] args) {
            Browser.clearSessions();
            return null;
        }
    }

    private static class CMN_executeJavascript
    extends ControlCommandMessage {
        private static Pattern JAVASCRIPT_LINE_COMMENT_PATTERN = Pattern.compile("^\\s*//.*$", 8);

        private CMN_executeJavascript() {
        }

        public Object run(Object[] args) {
            String script = (String)args[0];
            script = JAVASCRIPT_LINE_COMMENT_PATTERN.matcher(script).replaceAll("");
            return ((Browser)this.getControl()).execute(script);
        }
    }

    private static class CMN_getHTMLContent
    extends ControlCommandMessage {
        private CMN_getHTMLContent() {
        }

        public Object run(Object[] args) {
            return ((Browser)this.getControl()).getText();
        }
    }

    private static class CMN_getResourceLocation
    extends ControlCommandMessage {
        private CMN_getResourceLocation() {
        }

        public Object run(Object[] args) {
            return ((Browser)this.getControl()).getUrl();
        }
    }

    private static class CMN_isBackNavigationEnabled
    extends ControlCommandMessage {
        private CMN_isBackNavigationEnabled() {
        }

        public Object run(Object[] args) {
            return ((Browser)this.getControl()).isBackEnabled();
        }
    }

    private static class CMN_isForwardNavigationEnabled
    extends ControlCommandMessage {
        private CMN_isForwardNavigationEnabled() {
        }

        public Object run(Object[] args) {
            return ((Browser)this.getControl()).isForwardEnabled();
        }
    }

    private static class CMN_navigate
    extends ControlCommandMessage {
        private CMN_navigate() {
        }

        public Object run(Object[] args) {
            return ((Browser)this.getControl()).setUrl((String)args[0]);
        }
    }

    private static class CMN_navigateBack
    extends ControlCommandMessage {
        private CMN_navigateBack() {
        }

        public Object run(Object[] args) {
            return ((Browser)this.getControl()).back();
        }
    }

    private static class CMN_navigateForward
    extends ControlCommandMessage {
        private CMN_navigateForward() {
        }

        public Object run(Object[] args) {
            return ((Browser)this.getControl()).forward();
        }
    }

    private static class CMN_reloadPage
    extends ControlCommandMessage {
        private CMN_reloadPage() {
        }

        public Object run(Object[] args) {
            ((Browser)this.getControl()).refresh();
            return null;
        }
    }

    private static class CMN_setDefaultPopupMenuRegistered
    extends ControlCommandMessage {
        private CMN_setDefaultPopupMenuRegistered() {
        }

        public Object run(Object[] args) {
            Browser browser = (Browser)this.getControl();
            boolean isDefaultPopupMenuRegistered = (Boolean)args[0];
            if (isDefaultPopupMenuRegistered) {
                NativeWebBrowser.registerDefaultPopupMenu(browser);
            } else {
                Menu oldMenu = browser.getMenu();
                if (oldMenu != null) {
                    oldMenu.dispose();
                }
                final Menu menu = new Menu((Decorations)browser.getShell(), 8);
                menu.addMenuListener((MenuListener)new MenuAdapter(){

                    public void menuShown(MenuEvent e) {
                        menu.setVisible(false);
                    }
                });
                browser.setMenu(menu);
            }
            return null;
        }
    }

    private static class CMN_setHTMLContent
    extends ControlCommandMessage {
        private CMN_setHTMLContent() {
        }

        public Object run(Object[] args) {
            return ((Browser)this.getControl()).setText((String)args[0]);
        }
    }

    private static class CMN_stopLoading
    extends ControlCommandMessage {
        private CMN_stopLoading() {
        }

        public Object run(Object[] args) {
            ((Browser)this.getControl()).stop();
            return null;
        }
    }
}

