/*
 * Decompiled with CFR 0.152.
 */
package chrriis.dj.nativeswing.components;

import chrriis.common.Utils;
import chrriis.common.WebServer;
import chrriis.dj.nativeswing.WebBrowserObject;
import chrriis.dj.nativeswing.components.JVLCPlayer;
import java.io.File;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VLCPlaylist {
    private JVLCPlayer vlcPlayer;
    private WebBrowserObject webBrowserObject;

    VLCPlaylist(JVLCPlayer vlcPlayer) {
        this.vlcPlayer = vlcPlayer;
        this.webBrowserObject = vlcPlayer.getWebBrowserObject();
    }

    public int getItemCount() {
        Object value = this.webBrowserObject.getObjectProperty("playlist.items.count");
        return value == null ? -1 : ((Number)value).intValue();
    }

    public boolean isPlaying() {
        return Boolean.TRUE.equals(this.webBrowserObject.getObjectProperty("playlist.isPlaying"));
    }

    public int addItem(Class<?> clazz, String resourcePath) {
        this.vlcPlayer.addReferenceClassLoader(clazz.getClassLoader());
        return this.addItem(WebServer.getDefaultWebServer().getClassPathResourceURL(clazz.getName(), resourcePath));
    }

    public int addItem(String resourcePath) {
        Object value;
        File file;
        if (!this.webBrowserObject.hasContent()) {
            this.vlcPlayer.load();
            this.clear();
        }
        if ((file = Utils.getLocalFile(resourcePath)) != null) {
            resourcePath = this.webBrowserObject.getLocalFileURL(file);
        }
        return (value = this.webBrowserObject.invokeObjectFunctionWithResult("playlist.add", resourcePath)) == null ? -1 : ((Number)value).intValue();
    }

    public void play() {
        this.webBrowserObject.invokeObjectFunction("playlist.play", new Object[0]);
    }

    public void playItem(int itemID) {
        this.webBrowserObject.invokeObjectFunction("playlist.playItem", itemID);
    }

    public void togglePause() {
        this.webBrowserObject.invokeObjectFunction("playlist.togglePause", new Object[0]);
    }

    public void stop() {
        this.webBrowserObject.invokeObjectFunction("playlist.stop", new Object[0]);
    }

    public void goNext() {
        this.webBrowserObject.invokeObjectFunction("playlist.next", new Object[0]);
    }

    public void goPrevious() {
        this.webBrowserObject.invokeObjectFunction("playlist.prev", new Object[0]);
    }

    public void clear() {
        this.webBrowserObject.invokeObjectFunction("playlist.items.clear", new Object[0]);
    }

    public void removeItem(int itemID) {
        this.webBrowserObject.invokeObjectFunction("playlist.items.removeItem", itemID);
    }
}

