/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.theme;

import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.internal.theme.DrawData;
import org.eclipse.swt.internal.theme.Theme;
import org.eclipse.swt.internal.theme.ToolBarDrawData;

public class ToolItemDrawData
extends DrawData {
    public ToolBarDrawData parent;
    static final int ARROW_WIDTH = 8;
    static final int ARROW_HEIGHT = 6;

    public ToolItemDrawData() {
        this.state = new int[2];
    }

    Rectangle computeTrim(Theme theme, GC gC) {
        int n = theme.buttonHandle;
        int n2 = OS.gtk_widget_get_style(n);
        int n3 = theme.getWidgetProperty(n, "focus-line-width");
        int n4 = theme.getWidgetProperty(n, "focus-padding");
        int n5 = OS.gtk_style_get_xthickness(n2);
        int n6 = OS.gtk_style_get_ythickness(n2);
        int n7 = n5 + n3 + n4;
        int n8 = n6 + n3 + n4;
        int n9 = this.clientArea.x - n7;
        int n10 = this.clientArea.y - n8;
        int n11 = this.clientArea.width + 2 * n7;
        int n12 = this.clientArea.height + 2 * n8;
        if ((this.style & 4) != 0) {
            n11 += 8;
        }
        return new Rectangle(n9, n10, n11, n12);
    }

    void draw(Theme theme, GC gC, Rectangle rectangle) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5 = this.state[0];
        int n6 = gC.getGCData().drawable;
        if ((this.style & 2) != 0) {
            int n7 = this.getStateType(0);
            int n8 = theme.separatorHandle;
            byte[] byArray = Converter.wcsToMbcs(null, "vseparator", true);
            int n9 = OS.gtk_widget_get_style(n8);
            theme.transferClipping(gC, n9);
            if ((this.parent.style & 0x200) != 0) {
                OS.gtk_paint_hline(n9, n6, n7, null, n8, byArray, rectangle.x, rectangle.x + rectangle.width, rectangle.y + rectangle.height / 2);
            } else {
                OS.gtk_paint_vline(n9, n6, n7, null, n8, byArray, rectangle.y, rectangle.y + rectangle.height, rectangle.x + rectangle.width / 2);
            }
            return;
        }
        int n10 = theme.buttonHandle;
        int n11 = OS.gtk_widget_get_style(n10);
        theme.transferClipping(gC, n11);
        int n12 = theme.getWidgetProperty(n10, "focus-line-width");
        int n13 = theme.getWidgetProperty(n10, "focus-padding");
        int n14 = OS.gtk_container_get_border_width(n10);
        int n15 = rectangle.x + n14;
        int n16 = rectangle.y + n14;
        int n17 = rectangle.width - n14 * 2;
        int n18 = rectangle.height - n14 * 2;
        byte[] byArray = null;
        if ((this.style & 0xC) != 0) {
            byArray = Converter.wcsToMbcs(null, "button", true);
        } else if ((this.style & 0x30) != 0) {
            byArray = Converter.wcsToMbcs(null, "togglebutton", true);
        }
        int[] nArray = new int[1];
        int n19 = theme.toolbarHandle;
        OS.gtk_widget_style_get(n19, OS.button_relief, nArray, 0);
        int n20 = 2;
        if ((n5 & 0xA) != 0) {
            n20 = 1;
        }
        int n21 = this.getStateType(0);
        if (nArray[0] != 2 || (n5 & 0x4A) != 0) {
            OS.gtk_paint_box(n11, n6, n21, n20, null, n10, byArray, n15, n16, n17, n18);
        }
        if (this.clientArea != null) {
            this.clientArea.x = rectangle.x + n14;
            this.clientArea.y = rectangle.y + n14;
            this.clientArea.width = rectangle.width - 2 * n14;
            this.clientArea.height = rectangle.height - 2 * n14;
        }
        int n22 = OS.gtk_style_get_xthickness(n11);
        int n23 = theme.getWidgetProperty(n10, "interior-focus");
        if ((this.style & 4) != 0) {
            n4 = 8;
            n3 = 6;
            n2 = n15 + n17 - n4 - n22 - n13;
            if (n23 == 0) {
                n2 -= n12;
            }
            n = n16 + (n18 - n3) / 2;
            byte[] byArray2 = Converter.wcsToMbcs(null, "arrow", true);
            OS.gtk_paint_arrow(n11, n6, n21, 0, null, theme.arrowHandle, byArray2, 1, true, n2, n, n4, n3);
            if (this.clientArea != null) {
                this.clientArea.width -= rectangle.x + rectangle.width - n2;
            }
        }
        if ((n5 & 4) != 0) {
            n4 = theme.getWidgetProperty(n10, "child-displacement-y");
            n3 = theme.getWidgetProperty(n10, "child-displacement-x");
            n2 = 0;
            if (OS.GTK_VERSION >= OS.VERSION(2, 6, 0)) {
                n2 = theme.getWidgetProperty(n10, "displace-focus");
            }
            if (n23 != 0) {
                n = OS.gtk_style_get_ythickness(n11);
                n15 += n22 + n13;
                n16 += n + n13;
                n17 -= 2 * (n22 + n13);
                n18 -= 2 * (n + n13);
            } else {
                n15 -= n12 + n13;
                n16 -= n12 + n13;
                n17 += 2 * (n12 + n13);
                n18 += 2 * (n12 + n13);
            }
            if ((n5 & 0xA) != 0 && n2 != 0) {
                n15 += n3;
                n16 += n4;
            }
            OS.gtk_paint_focus(n11, n6, n21, null, n10, byArray, n15, n16, n17, n18);
        }
    }

    int hit(Theme theme, Point point, Rectangle rectangle) {
        if (!rectangle.contains(point)) {
            return -1;
        }
        if ((this.style & 4) != 0) {
            int n = theme.buttonHandle;
            int n2 = OS.gtk_widget_get_style(n);
            int n3 = OS.gtk_style_get_xthickness(n2);
            int n4 = theme.getWidgetProperty(n, "interior-focus");
            int n5 = theme.getWidgetProperty(n, "focus-line-width");
            int n6 = theme.getWidgetProperty(n, "focus-padding");
            int n7 = 8;
            int n8 = rectangle.x + rectangle.width - n7 - n3 - n6;
            if (n4 == 0) {
                n8 -= n5;
            }
            if (n8 <= point.x) {
                return 1;
            }
        }
        return 0;
    }
}

