/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.internal.gtk.PangoAttrColor;
import org.eclipse.swt.internal.gtk.PangoAttrInt;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Widget;

public class IME
extends Widget {
    Canvas parent;
    int caretOffset;
    int startOffset;
    int commitCount;
    String text;
    int[] ranges;
    TextStyle[] styles;
    boolean inComposition;

    IME() {
    }

    public IME(Canvas canvas, int n) {
        super(canvas, n);
        this.parent = canvas;
        this.createWidget();
    }

    void createWidget() {
        this.text = "";
        this.startOffset = -1;
        if (this.parent.getIME() == null) {
            this.parent.setIME(this);
        }
    }

    public int getCaretOffset() {
        this.checkWidget();
        return this.startOffset + this.caretOffset;
    }

    public int getCommitCount() {
        this.checkWidget();
        return this.commitCount;
    }

    public int getCompositionOffset() {
        this.checkWidget();
        return this.startOffset;
    }

    public int[] getRanges() {
        this.checkWidget();
        if (this.ranges == null) {
            return new int[0];
        }
        int[] nArray = new int[this.ranges.length];
        int n = 0;
        while (n < nArray.length) {
            nArray[n] = this.ranges[n] + this.startOffset;
            ++n;
        }
        return nArray;
    }

    public TextStyle[] getStyles() {
        this.checkWidget();
        if (this.styles == null) {
            return new TextStyle[0];
        }
        TextStyle[] textStyleArray = new TextStyle[this.styles.length];
        System.arraycopy(this.styles, 0, textStyleArray, 0, this.styles.length);
        return textStyleArray;
    }

    public String getText() {
        this.checkWidget();
        return this.text;
    }

    public boolean getWideCaret() {
        this.checkWidget();
        return false;
    }

    int gtk_button_press_event(int n, int n2) {
        if (!this.isInlineEnabled()) {
            return 0;
        }
        int n3 = this.imHandle();
        if (n3 != 0) {
            OS.gtk_im_context_reset(n3);
        }
        return 0;
    }

    int gtk_commit(int n, int n2) {
        int n3;
        if (!this.isInlineEnabled()) {
            return 0;
        }
        boolean bl = true;
        this.ranges = null;
        this.styles = null;
        this.commitCount = 0;
        this.caretOffset = 0;
        if (n2 != 0 && this.inComposition && (n3 = OS.strlen(n2)) != 0) {
            byte[] byArray = new byte[n3];
            OS.memmove(byArray, n2, n3);
            char[] cArray = Converter.mbcsToWcs(null, byArray);
            Event event = new Event();
            event.detail = 1;
            event.start = this.startOffset;
            event.end = this.startOffset + this.text.length();
            this.text = cArray != null ? new String(cArray) : "";
            event.text = this.text;
            this.commitCount = this.text.length();
            this.sendEvent(43, event);
            bl = event.doit;
            this.text = "";
            this.startOffset = -1;
            this.commitCount = 0;
        }
        this.inComposition = false;
        return bl ? 0 : 1;
    }

    int gtk_preedit_changed(int n) {
        Object object;
        int n2;
        if (!this.isInlineEnabled()) {
            return 0;
        }
        this.ranges = null;
        this.styles = null;
        this.commitCount = 0;
        int n3 = this.imHandle();
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        int[] nArray3 = new int[1];
        OS.gtk_im_context_get_preedit_string(n3, nArray, nArray2, nArray3);
        this.caretOffset = nArray3[0];
        char[] cArray = null;
        if (nArray[0] != 0) {
            n2 = OS.strlen(nArray[0]);
            object = new byte[n2];
            OS.memmove(object, nArray[0], n2);
            cArray = Converter.mbcsToWcs(null, object);
            if (nArray2[0] != 0) {
                int n4 = 0;
                int n5 = OS.pango_attr_list_get_iterator(nArray2[0]);
                while (OS.pango_attr_iterator_next(n5)) {
                    ++n4;
                }
                OS.pango_attr_iterator_destroy(n5);
                this.ranges = new int[n4 * 2];
                this.styles = new TextStyle[n4];
                n5 = OS.pango_attr_list_get_iterator(nArray2[0]);
                PangoAttrColor pangoAttrColor = new PangoAttrColor();
                PangoAttrInt pangoAttrInt = new PangoAttrInt();
                int[] nArray4 = new int[1];
                int[] nArray5 = new int[1];
                int n6 = 0;
                while (n6 < n4) {
                    GdkColor gdkColor;
                    OS.pango_attr_iterator_range(n5, nArray4, nArray5);
                    this.ranges[n6 * 2] = OS.g_utf8_pointer_to_offset(nArray[0], nArray[0] + nArray4[0]);
                    this.ranges[n6 * 2 + 1] = OS.g_utf8_pointer_to_offset(nArray[0], nArray[0] + nArray5[0]) - 1;
                    this.styles[n6] = new TextStyle(null, null, null);
                    int n7 = OS.pango_attr_iterator_get(n5, 9);
                    if (n7 != 0) {
                        OS.memmove(pangoAttrColor, n7, PangoAttrColor.sizeof);
                        gdkColor = new GdkColor();
                        gdkColor.red = pangoAttrColor.color_red;
                        gdkColor.green = pangoAttrColor.color_green;
                        gdkColor.blue = pangoAttrColor.color_blue;
                        this.styles[n6].foreground = Color.gtk_new(this.display, gdkColor);
                    }
                    if ((n7 = OS.pango_attr_iterator_get(n5, 10)) != 0) {
                        OS.memmove(pangoAttrColor, n7, PangoAttrColor.sizeof);
                        gdkColor = new GdkColor();
                        gdkColor.red = pangoAttrColor.color_red;
                        gdkColor.green = pangoAttrColor.color_green;
                        gdkColor.blue = pangoAttrColor.color_blue;
                        this.styles[n6].background = Color.gtk_new(this.display, gdkColor);
                    }
                    if ((n7 = OS.pango_attr_iterator_get(n5, 11)) != 0) {
                        OS.memmove(pangoAttrInt, n7, PangoAttrInt.sizeof);
                        this.styles[n6].underline = pangoAttrInt.value != 0;
                        this.styles[n6].underlineStyle = 0;
                        switch (pangoAttrInt.value) {
                            case 2: {
                                this.styles[n6].underlineStyle = 1;
                                break;
                            }
                            case 4: {
                                this.styles[n6].underlineStyle = 2;
                            }
                        }
                        if (this.styles[n6].underline && (n7 = OS.pango_attr_iterator_get(n5, 18)) != 0) {
                            OS.memmove(pangoAttrColor, n7, PangoAttrColor.sizeof);
                            gdkColor = new GdkColor();
                            gdkColor.red = pangoAttrColor.color_red;
                            gdkColor.green = pangoAttrColor.color_green;
                            gdkColor.blue = pangoAttrColor.color_blue;
                            this.styles[n6].underlineColor = Color.gtk_new(this.display, gdkColor);
                        }
                    }
                    OS.pango_attr_iterator_next(n5);
                    ++n6;
                }
                OS.pango_attr_iterator_destroy(n5);
                OS.pango_attr_list_unref(nArray2[0]);
            }
            OS.g_free(nArray[0]);
        }
        if (cArray != null) {
            if (this.text.length() == 0) {
                this.startOffset = -1;
            }
            n2 = this.startOffset + this.text.length();
            if (this.startOffset == -1) {
                object = new Event();
                object.detail = 3;
                this.sendEvent(43, (Event)object);
                this.startOffset = object.start;
                n2 = object.end;
            }
            this.inComposition = true;
            object = new Event();
            object.detail = 1;
            object.start = this.startOffset;
            object.end = n2;
            this.text = cArray != null ? new String(cArray) : "";
            object.text = this.text;
            this.sendEvent(43, (Event)object);
        }
        return 1;
    }

    int imHandle() {
        return this.parent.imHandle();
    }

    boolean isInlineEnabled() {
        return this.hooks(43);
    }

    void releaseParent() {
        super.releaseParent();
        if (this == this.parent.getIME()) {
            this.parent.setIME(null);
        }
    }

    void releaseWidget() {
        super.releaseWidget();
        this.parent = null;
        this.text = null;
        this.styles = null;
        this.ranges = null;
    }

    public void setCompositionOffset(int n) {
        this.checkWidget();
        if (n < 0) {
            return;
        }
        if (this.startOffset != -1) {
            this.startOffset = n;
        }
    }
}

