/*
 * Decompiled with CFR 0.152.
 */
package com.aibonware.viewnaver.format;

import com.aibonware.viewnaver.ViewNaver;
import com.aibonware.viewnaver.model.Article;
import com.aibonware.viewnaver.model.ArticleList;
import com.aibonware.viewnaver.model.CompositeThread;
import com.aibonware.viewnaver.model.NThread;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;

public class PublishableThreadFormatter {
    private static SimpleDateFormat df = new SimpleDateFormat("MM/dd HH:mm");
    private String HR;

    public PublishableThreadFormatter() {
        this.HR = ViewNaver.instance.getBrowserFactory().HR;
    }

    public String formatThreadHeader(CompositeThread compositeThread) {
        NThread thread = (NThread)compositeThread.thread;
        String urlString = "http://bbs.enjoykorea.jp/tbbs/read.php?board_id=" + compositeThread.boardName + "&nid=" + thread.nid;
        return String.valueOf(thread.country.toHtml()) + " " + "<b>" + thread.poster + "</b> " + thread.title + " " + df.format(thread.createDate) + " " + "<a href=\"" + urlString + "\">URL</a><br>";
    }

    public String formatThreadContent(CompositeThread compositeThread) {
        return "<html><head><meta http-equiv=\"Content-Type\" content=\"text/html\"></head><body>" + this.formatThreadHeader(compositeThread) + this.HR + "<table><tr><td>" + compositeThread.contents;
    }

    public String formatThreadContentFooter(CompositeThread compositeThread) {
        return "</td></tr></table><font size=-1>";
    }

    public String formatArticleFooter(CompositeThread compositeThread) {
        return "</font></body></html>";
    }

    public String formatArticleList(CompositeThread compositeThread) {
        StringWriter writer = new StringWriter();
        PrintWriter out = new PrintWriter(writer);
        ArticleList articles = (ArticleList)compositeThread.articleList;
        int lastVisibleSno = -1;
        int i = 0;
        while (i < articles.getArticleCount()) {
            Article art = (Article)articles.getArticle(i);
            String articleContent = this.formatArticle(lastVisibleSno, art);
            lastVisibleSno = art.sno;
            out.println(articleContent);
            ++i;
        }
        out.close();
        return writer.toString();
    }

    public String formatInnerArticle(int lastVisibleSno, Article art) {
        StringWriter writer = new StringWriter();
        PrintWriter out = new PrintWriter(writer);
        if (lastVisibleSno != art.sno) {
            out.print(this.HR);
        } else {
            out.print("<br>");
        }
        if (art.isReply) {
            out.print("&nbsp;&nbsp;");
        }
        out.print(String.valueOf(df.format(art.postDate)) + " ");
        out.print(String.valueOf(art.country.toHtml()) + " ");
        String start = "";
        String end = "";
        if (art.isDeleted) {
            start = "<s>";
            end = "</s>";
        }
        start = String.valueOf(start) + "<b>";
        end = "</b>" + end;
        out.print(String.valueOf(start) + art.author + end + "</a> ");
        out.print(ViewNaver.instance.articleDecorator.decorate(art.content));
        out.print("<br>");
        out.close();
        return writer.toString();
    }

    public String formatArticle(int lastVisibleSno, Article art) {
        String artText = this.formatInnerArticle(lastVisibleSno, art);
        return artText;
    }
}

