/*
 * Decompiled with CFR 0.152.
 */
package com.aibonware.viewnaver.server;

import Acme.Serve.Serve;
import com.aibonware.nvrlib.net.HttpCancellerProvider;
import com.aibonware.nvrlib.net.LoginSession;
import com.aibonware.viewnaver.ViewNaver;
import com.aibonware.viewnaver.server.UserSession;
import com.aibonware.viewnaver.server.conv.ContentsConverter;
import com.aibonware.viewnaver.server.image.ImageConverterFilter;
import com.aibonware.viewnaver.server.image.ImageServlet;
import com.aibonware.viewnaver.server.movie.MovieConverterFilter;
import com.aibonware.viewnaver.server.movie.MoviePlayServlet;
import com.aibonware.viewnaver.server.movie.MovieServlet;
import com.aibonware.viewnaver.server.servlet.BaseServlet;
import com.aibonware.viewnaver.server.servlet.BoardServlet;
import com.aibonware.viewnaver.server.servlet.ConfirmDelServlet;
import com.aibonware.viewnaver.server.servlet.DeleteArticleServlet;
import com.aibonware.viewnaver.server.servlet.DeleteThreadServlet;
import com.aibonware.viewnaver.server.servlet.LoginServlet;
import com.aibonware.viewnaver.server.servlet.LogoutServlet;
import com.aibonware.viewnaver.server.servlet.MainServlet;
import com.aibonware.viewnaver.server.servlet.PostArticleServlet;
import com.aibonware.viewnaver.server.servlet.PostNewThreadServlet;
import com.aibonware.viewnaver.server.servlet.PostReplyThreadServlet;
import com.aibonware.viewnaver.server.servlet.ThreadServlet;
import com.aibonware.viewnaver.server.servlet.WriteNewThreadServlet;
import com.aibonware.viewnaver.server.servlet.WriteReplyThreadServlet;
import com.aibonware.viewnaver.task.HttpTaskCancellerProvider;
import java.awt.RenderingHints;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.TreeMap;

public final class MiniServer
extends Thread {
    private Serve serv;
    private String password;
    private final int port;
    public SecureRandom rand;
    public final int articlesPerPage;
    public ContentsConverter conv;
    public final boolean useSmallImage;
    public final int maxImageWidth;
    public final int maxImageHeight;
    public final int maxImageSize;
    public final HashMap<RenderingHints.Key, Object> renderingHints;
    public final String movieShrinkerCommandLine;
    public final String movieContentType;
    public LoginSession outerSession;
    private static final String VALID_SID_CHARS = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789._";
    public TreeMap<String, UserSession> sessions = new TreeMap();
    public static final int MAX_SESSION = 10;

    public MiniServer(int port, String password, int articlesPerPage, boolean useSmallImage, int maxImageWidth, int maxImageHeight, int maxImageSize, HashMap<RenderingHints.Key, Object> renderingHints, String movieShrinkerCommandLine, String movieContentType) throws NoSuchAlgorithmException {
        this.port = port;
        this.password = password;
        this.articlesPerPage = articlesPerPage;
        this.useSmallImage = useSmallImage;
        this.maxImageWidth = maxImageWidth;
        this.maxImageHeight = maxImageHeight;
        this.maxImageSize = maxImageSize;
        this.renderingHints = renderingHints;
        this.movieShrinkerCommandLine = movieShrinkerCommandLine;
        this.movieContentType = movieContentType;
        this.rand = SecureRandom.getInstance("SHA1PRNG");
        this.rand.nextInt();
        this.conv = new ContentsConverter();
        this.conv.init(this);
        if (useSmallImage) {
            this.conv.filterPrototypes.addElement(new ImageConverterFilter());
        }
        this.conv.filterPrototypes.addElement(new MovieConverterFilter());
        this.outerSession = new LoginSession("", ViewNaver.instance.config.getNetworkConfig().getProxyInfo(), (HttpCancellerProvider)new HttpTaskCancellerProvider());
    }

    private void addServlet(BaseServlet servlet) {
        this.serv.addServlet("/" + servlet.getName(), servlet);
        ViewNaver.println("servlet " + servlet.getName() + " added.");
    }

    @Override
    public void run() {
        this.serv = new Serve(this.port);
        this.addServlet(new MainServlet());
        this.addServlet(new LoginServlet());
        this.addServlet(new LogoutServlet());
        this.addServlet(new BoardServlet());
        this.addServlet(new ThreadServlet());
        this.addServlet(new PostArticleServlet());
        this.addServlet(new WriteNewThreadServlet());
        this.addServlet(new PostNewThreadServlet());
        this.addServlet(new WriteReplyThreadServlet());
        this.addServlet(new PostReplyThreadServlet());
        this.addServlet(new ConfirmDelServlet());
        this.addServlet(new DeleteArticleServlet());
        this.addServlet(new DeleteThreadServlet());
        this.addServlet(new ImageServlet());
        this.addServlet(new MovieServlet());
        this.addServlet(new MoviePlayServlet());
        this.serv.serve();
    }

    public boolean isValidSidForm(String sid) {
        if (sid == null || sid.length() != 20) {
            return false;
        }
        int i = 0;
        while (i < sid.length()) {
            if (VALID_SID_CHARS.indexOf(sid.charAt(i)) == -1) {
                return false;
            }
            ++i;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isValidSid(String sid) {
        if (!this.isValidSidForm(sid)) {
            return false;
        }
        TreeMap<String, UserSession> treeMap = this.sessions;
        synchronized (treeMap) {
            return this.sessions.containsKey(sid);
        }
    }

    public synchronized String createSid() {
        StringBuffer sid = new StringBuffer(20);
        int i = 0;
        while (i < 20) {
            int r = Math.abs(this.rand.nextInt()) % VALID_SID_CHARS.length();
            sid.append(VALID_SID_CHARS.charAt(r));
            ++i;
        }
        return sid.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSid(String sid) {
        TreeMap<String, UserSession> treeMap = this.sessions;
        synchronized (treeMap) {
            this.sessions.remove(sid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserSession getSession(String sid) {
        TreeMap<String, UserSession> treeMap = this.sessions;
        synchronized (treeMap) {
            block6: {
                block5: {
                    if (sid != null) break block5;
                    return null;
                }
                if (this.sessions.containsKey(sid)) break block6;
                return null;
            }
            return this.sessions.get(sid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String registerSid(String sid) {
        TreeMap<String, UserSession> treeMap = this.sessions;
        synchronized (treeMap) {
            block7: {
                UserSession oldSession = this.sessions.get(sid);
                if (oldSession != null) {
                    oldSession.warning = "\u4e8c\u91cd\u30ed\u30b0\u30a4\u30f3\u3092\u691c\u51fa\u3057\u307e\u3057\u305f\u3002\u3044\u3063\u305f\u3093\u30ed\u30b0\u30a2\u30a6\u30c8\u3057\u3001\u518d\u5ea6\u30ed\u30b0\u30a4\u30f3\u3057\u3066\u304f\u3060\u3055\u3044\u3002";
                } else {
                    this.sessions.put(sid, new UserSession(sid, this.maxImageWidth, this.maxImageHeight, this.maxImageSize, this.renderingHints));
                }
                if (this.sessions.size() <= 10) break block7;
                BaseServlet.mustReject = true;
                return "\u30bb\u30c3\u30b7\u30e7\u30f3\u6570\u304c10\u500b\u3092\u8d85\u3048\u307e\u3057\u305f\u3002\u5916\u90e8\u304b\u3089\u306e\u30a2\u30af\u30bb\u30b9\u3092\u7dca\u6025\u906e\u65ad\u3057\u307e\u3059";
            }
            if (this.sessions.size() > 1) {
                return "\u73fe\u5728\u306e\u30bb\u30c3\u30b7\u30e7\u30f3\u6570\u306f" + this.sessions.size() + "\u500b\u3067\u3059\u3002<br>" + "\u4f7f\u7528\u3092\u7d42\u4e86\u3057\u305f\u969b\u306b\u306f\u5fc5\u305a\u30ed\u30b0\u30a2\u30a6\u30c8\u3092\u884c\u3063\u3066\u304f\u3060\u3055\u3044<br>" + "\u8eab\u306b\u899a\u3048\u304c\u7121\u3044\u5834\u5408\u3001\u4e0d\u6b63\u306a\u30a2\u30af\u30bb\u30b9\u304c\u767a\u751f\u3057\u305f\u53ef\u80fd\u6027\u304c\u3042\u308a\u307e\u3059\u3002<br>" + "\u76f4\u3061\u306b\u5916\u90e8\u304b\u3089\u306e\u30a2\u30af\u30bb\u30b9\u3092\u7dca\u6025\u906e\u65ad\u3057\u3066\u304f\u3060\u3055\u3044";
            }
            return null;
        }
    }

    public boolean isValidPassword(String password) {
        return this.password.equals(password);
    }
}

