/*
 * Decompiled with CFR 0.152.
 */
package com.aibonware.viewnaver.window;

import com.aibonware.nvrlib.net.NetException;
import com.aibonware.viewnaver.ViewNaver;
import com.aibonware.viewnaver.model.NThread;
import com.aibonware.viewnaver.task.ButtonBarStatus;
import com.aibonware.viewnaver.task.TaskFlow;
import com.aibonware.viewnaver.task.WorkerTask;
import com.aibonware.viewnaver.view.ThreadContentsEditorView;
import com.aibonware.viewnaver.window.ChildWindow;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;

public class ReplyThreadWindow
extends JDialog
implements ChildWindow {
    private ThreadContentsEditorView contentsEditorView;
    private final String boardName;
    private final int sno;
    private final NThread srcThread;
    JButton okButton = new JButton();
    JButton cancelButton = new JButton("Cancel");
    private ButtonBarStatus buttonStatus;
    AbstractAction okAction = new AbstractAction("OK"){

        @Override
        public void actionPerformed(ActionEvent e) {
            final String threadTitle = ReplyThreadWindow.this.contentsEditorView.getThreadTitle();
            final String htmlContent = ReplyThreadWindow.this.contentsEditorView.getHtmlContent();
            if (threadTitle == null || threadTitle.trim().equals("")) {
                ViewNaver.println("\u30bf\u30a4\u30c8\u30eb\u304c\u7a7a\u3067\u3059\u3002");
                return;
            }
            if (htmlContent == null || htmlContent.trim().equals("")) {
                ViewNaver.println("\u5185\u5bb9\u304c\u7a7a\u3067\u3059\u3002");
                return;
            }
            TaskFlow taskFlow = ViewNaver.instance.taskFlowList.createNewFlow();
            ReplyThreadWindow.this.buttonStatus.beginTask(ReplyThreadWindow.this.okButton, taskFlow, new JButton[]{ReplyThreadWindow.this.cancelButton});
            taskFlow.execute(new WorkerTask(ViewNaver.instance.appTools){

                @Override
                public void exec() {
                    try {
                        ViewNaver.println("\u30b9\u30ec\u30c3\u30c9\u8fd4\u4fe1\u958b\u59cb..");
                        ViewNaver.instance.multiSession.replyThread(ReplyThreadWindow.this.boardName, threadTitle, htmlContent, ((ReplyThreadWindow)(this).ReplyThreadWindow.this).srcThread.nid, ReplyThreadWindow.this.sno);
                        ViewNaver.println("\u30b9\u30ec\u30c3\u30c9\u8fd4\u4fe1\u7d42\u4e86\u3002");
                        ReplyThreadWindow.this.dispose();
                    }
                    catch (NetException e) {
                        ViewNaver.err((Exception)((Object)e));
                    }
                }
            });
        }
    };

    public ReplyThreadWindow(JFrame parent, String boardName, NThread srcThread, String htmlContents) {
        super(parent);
        this.srcThread = srcThread;
        this.setDefaultCloseOperation(2);
        this.boardName = boardName;
        this.setTitle(String.valueOf(srcThread.poster) + ": " + srcThread.title + " \u3078\u306e\u8fd4\u4fe1\u30b9\u30ec\u30c3\u30c9\u6295\u7a3f");
        this.contentsEditorView = new ThreadContentsEditorView();
        this.contentsEditorView.threadTitleText.setText("[Re] " + srcThread.title);
        this.contentsEditorView.setHtmlContents(htmlContents);
        Box buttonBox = new Box(2);
        buttonBox.add(Box.createGlue());
        buttonBox.add(this.okButton);
        buttonBox.add(this.cancelButton);
        this.add((Component)this.contentsEditorView, "Center");
        this.add((Component)buttonBox, "South");
        this.setBounds(200, 200, 500, 400);
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReplyThreadWindow.this.dispose();
            }
        });
        this.okButton.setAction(this.okAction);
        this.sno = this.createSno(srcThread.dispId);
        if (this.sno == -1) {
            ViewNaver.println("'" + srcThread.dispId + "': \u4e0d\u6b63\u306aID\u3067\u3059\u3002");
            this.okButton.setEnabled(false);
        }
        ViewNaver.instance.childWindowActivator.addChildWindow(this);
        this.buttonStatus = new ButtonBarStatus(new JButton[]{this.okButton}, new JButton[]{this.cancelButton}){

            @Override
            public boolean isEnabledButton(JButton button) {
                if (button != ReplyThreadWindow.this.okButton) {
                    return true;
                }
                return ReplyThreadWindow.this.sno != -1;
            }
        };
    }

    private int createSno(String dispId) {
        if (dispId == null) {
            return -1;
        }
        int delim = dispId.indexOf(45);
        if (delim >= 0) {
            dispId = dispId.substring(0, delim);
        }
        if ((dispId = dispId.trim()).equals("")) {
            return -1;
        }
        try {
            return Integer.parseInt(dispId);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }
}

