/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.libraries;

import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jruby.Ruby;
import org.jruby.RubyHash;
import org.jruby.RubyModule;
import org.jruby.anno.JRubyModule;
import org.jruby.ext.posix.util.Platform;
import org.jruby.runtime.Constants;
import org.jruby.runtime.load.Library;
import org.jruby.util.NormalizedFile;

@JRubyModule(name={"Config"})
public class RbConfigLibrary
implements Library {
    private static final String RUBY_DARWIN = "darwin";
    private static final String RUBY_LINUX = "linux";
    private static final String RUBY_WIN32 = "mswin32";
    private static final String RUBY_SOLARIS = "solaris";
    private static final String RUBY_FREEBSD = "freebsd";
    private static final String RUBY_AIX = "aix";
    public static final Map<String, String> RUBY_OS_NAMES = new HashMap<String, String>();

    public static String getOSName() {
        String OSName = Platform.getOSName();
        String theOSName = RUBY_OS_NAMES.get(OSName);
        return theOSName == null ? OSName : theOSName;
    }

    public void load(Ruby runtime, boolean wrap) {
        RubyModule configModule = runtime.defineModule("Config");
        configModule.defineAnnotatedMethods(RbConfigLibrary.class);
        RubyHash configHash = RubyHash.newHash(runtime);
        configModule.defineConstant("CONFIG", configHash);
        runtime.getObject().defineConstant("RbConfig", configModule);
        String[] versionParts = Constants.RUBY_VERSION.split("\\.");
        RbConfigLibrary.setConfig(configHash, "MAJOR", versionParts[0]);
        RbConfigLibrary.setConfig(configHash, "MINOR", versionParts[1]);
        RbConfigLibrary.setConfig(configHash, "TEENY", versionParts[2]);
        RbConfigLibrary.setConfig(configHash, "ruby_version", versionParts[0] + '.' + versionParts[1]);
        RbConfigLibrary.setConfig(configHash, "arch", "universal-java" + System.getProperty("java.specification.version"));
        String normalizedHome = Ruby.isSecurityRestricted() ? "SECURITY RESTRICTED" : runtime.getJRubyHome();
        RbConfigLibrary.setConfig(configHash, "bindir", new NormalizedFile(normalizedHome, "bin").getPath());
        RbConfigLibrary.setConfig(configHash, "RUBY_INSTALL_NAME", RbConfigLibrary.jrubyScript());
        RbConfigLibrary.setConfig(configHash, "ruby_install_name", RbConfigLibrary.jrubyScript());
        RbConfigLibrary.setConfig(configHash, "SHELL", RbConfigLibrary.jrubyShell());
        RbConfigLibrary.setConfig(configHash, "prefix", normalizedHome);
        RbConfigLibrary.setConfig(configHash, "exec_prefix", normalizedHome);
        RbConfigLibrary.setConfig(configHash, "host_os", RbConfigLibrary.getOSName());
        RbConfigLibrary.setConfig(configHash, "host_vendor", System.getProperty("java.vendor"));
        RbConfigLibrary.setConfig(configHash, "host_cpu", Platform.ARCH);
        RbConfigLibrary.setConfig(configHash, "target_os", RbConfigLibrary.getOSName());
        RbConfigLibrary.setConfig(configHash, "target_cpu", Platform.ARCH);
        String jrubyJarFile = "jruby.jar";
        URL jrubyPropertiesUrl = Ruby.getClassLoader().getResource("/org/jruby/jruby.properties");
        if (jrubyPropertiesUrl != null) {
            Pattern jarFile = Pattern.compile("jar:file:.*?([a-zA-Z0-9.\\-]+\\.jar)!/org/jruby/jruby.properties");
            Matcher jarMatcher = jarFile.matcher(jrubyPropertiesUrl.toString());
            jarMatcher.find();
            if (jarMatcher.matches()) {
                jrubyJarFile = jarMatcher.group(1);
            }
        }
        RbConfigLibrary.setConfig(configHash, "LIBRUBY", jrubyJarFile);
        RbConfigLibrary.setConfig(configHash, "LIBRUBY_SO", jrubyJarFile);
        RbConfigLibrary.setConfig(configHash, "build", Constants.BUILD);
        RbConfigLibrary.setConfig(configHash, "target", Constants.TARGET);
        String libdir = System.getProperty("jruby.lib");
        if (libdir == null) {
            libdir = new NormalizedFile(normalizedHome, "lib").getPath();
        } else {
            try {
                libdir = new NormalizedFile(libdir).getCanonicalPath();
            }
            catch (IOException e) {
                libdir = new NormalizedFile(libdir).getAbsolutePath();
            }
        }
        RbConfigLibrary.setConfig(configHash, "libdir", libdir);
        RbConfigLibrary.setConfig(configHash, "rubylibdir", new NormalizedFile(libdir, "ruby/1.8").getPath());
        RbConfigLibrary.setConfig(configHash, "sitedir", new NormalizedFile(libdir, "ruby/site_ruby").getPath());
        RbConfigLibrary.setConfig(configHash, "sitelibdir", new NormalizedFile(libdir, "ruby/site_ruby/1.8").getPath());
        RbConfigLibrary.setConfig(configHash, "sitearchdir", new NormalizedFile(libdir, "ruby/site_ruby/1.8/java").getPath());
        RbConfigLibrary.setConfig(configHash, "archdir", new NormalizedFile(libdir, "ruby/site_ruby/1.8/java").getPath());
        RbConfigLibrary.setConfig(configHash, "configure_args", "");
        RbConfigLibrary.setConfig(configHash, "datadir", new NormalizedFile(normalizedHome, "share").getPath());
        RbConfigLibrary.setConfig(configHash, "mandir", new NormalizedFile(normalizedHome, "man").getPath());
        RbConfigLibrary.setConfig(configHash, "sysconfdir", new NormalizedFile(normalizedHome, "etc").getPath());
        RbConfigLibrary.setConfig(configHash, "localstatedir", new NormalizedFile(normalizedHome, "var").getPath());
        RbConfigLibrary.setConfig(configHash, "DLEXT", "jar");
        if (Platform.IS_WINDOWS) {
            RbConfigLibrary.setConfig(configHash, "EXEEXT", ".exe");
        } else {
            RbConfigLibrary.setConfig(configHash, "EXEEXT", "");
        }
        RubyHash mkmfHash = RubyHash.newHash(runtime);
        RbConfigLibrary.setConfig(mkmfHash, "libdir", libdir);
        RbConfigLibrary.setConfig(mkmfHash, "arch", "universal-java" + System.getProperty("java.specification.version"));
        RbConfigLibrary.setConfig(mkmfHash, "rubylibdir", "$(libdir)/ruby/$(ruby_version)");
        RbConfigLibrary.setConfig(mkmfHash, "sitedir", "$(libdir)/ruby/site_ruby");
        RbConfigLibrary.setConfig(mkmfHash, "sitelibdir", "$(sitedir)/1.8");
        RbConfigLibrary.setConfig(mkmfHash, "sitearch", "java");
        RbConfigLibrary.setConfig(mkmfHash, "sitearchdir", "$(sitelibdir)/$(sitearch)");
        RbConfigLibrary.setConfig(mkmfHash, "archdir", "$(rubylibdir)/$(arch)");
        RbConfigLibrary.setConfig(mkmfHash, "configure_args", "");
        RbConfigLibrary.setConfig(mkmfHash, "datadir", new NormalizedFile(normalizedHome, "share").getPath());
        RbConfigLibrary.setConfig(mkmfHash, "mandir", new NormalizedFile(normalizedHome, "man").getPath());
        RbConfigLibrary.setConfig(mkmfHash, "sysconfdir", new NormalizedFile(normalizedHome, "etc").getPath());
        RbConfigLibrary.setConfig(mkmfHash, "localstatedir", new NormalizedFile(normalizedHome, "var").getPath());
        RbConfigLibrary.setupMakefileConfig(configModule, mkmfHash);
    }

    private static void setupMakefileConfig(RubyModule configModule, RubyHash mkmfHash) {
        String soflags;
        Ruby ruby = configModule.getRuntime();
        String jflags = " -fno-omit-frame-pointer -fno-strict-aliasing -DNDEBUG ";
        String oflags = " -O2 " + jflags;
        String wflags = " -W -Werror -Wall -Wno-unused -Wno-parentheses ";
        String picflags = "";
        String iflags = " -I\"$(JDK_HOME)/include\" -I\"$(JDK_HOME)/include/$(OS)\" -I\"$(BUILD_DIR)\" ";
        String cflags = "";
        String ldflags = soflags = "";
        String archflags = " -arch i386 -arch ppc -arch x86_64 ";
        cflags = cflags + archflags;
        cflags = cflags + " -isysroot /Developer/SDKs/MacOSX10.4u.sdk -DTARGET_RT_MAC_CFM=0 ";
        cflags = cflags + " -arch i386 -arch ppc -arch x86_64 ";
        ldflags = ldflags + " -arch i386 -arch ppc -arch x86_64 -bundle -framework JavaVM -Wl,-syslibroot,$(SDKROOT) -mmacosx-version-min=10.4 -undefined dynamic_lookup ";
        String libext = "a";
        String objext = "o";
        RbConfigLibrary.setConfig(mkmfHash, "configure_args", "");
        RbConfigLibrary.setConfig(mkmfHash, "CFLAGS", cflags);
        RbConfigLibrary.setConfig(mkmfHash, "CPPFLAGS", "");
        RbConfigLibrary.setConfig(mkmfHash, "ARCH_FLAG", "");
        RbConfigLibrary.setConfig(mkmfHash, "LDFLAGS", ldflags);
        RbConfigLibrary.setConfig(mkmfHash, "DLDFLAGS", "");
        RbConfigLibrary.setConfig(mkmfHash, "LIBEXT", libext);
        RbConfigLibrary.setConfig(mkmfHash, "OBJEXT", objext);
        RbConfigLibrary.setConfig(mkmfHash, "LIBRUBYARG_STATIC", "");
        RbConfigLibrary.setConfig(mkmfHash, "LIBRUBYARG_SHARED", "");
        RbConfigLibrary.setConfig(mkmfHash, "LIBS", "");
        RbConfigLibrary.setConfig(mkmfHash, "DLDLIBS", "");
        RbConfigLibrary.setConfig(mkmfHash, "ENABLED_SHARED", "");
        RbConfigLibrary.setConfig(mkmfHash, "LIBRUBY", "");
        RbConfigLibrary.setConfig(mkmfHash, "LIBRUBY_A", "");
        RbConfigLibrary.setConfig(mkmfHash, "LIBRUBYARG", "");
        RbConfigLibrary.setConfig(mkmfHash, "prefix", "");
        RbConfigLibrary.setConfig(mkmfHash, "ruby_install_name", RbConfigLibrary.jrubyScript());
        RbConfigLibrary.setConfig(mkmfHash, "DLEXT", "bundle");
        RbConfigLibrary.setConfig(mkmfHash, "CC", "cc ");
        RbConfigLibrary.setConfig(mkmfHash, "LDSHARED", "cc ");
        RbConfigLibrary.setConfig(mkmfHash, "OUTFLAG", "-o ");
        RbConfigLibrary.setConfig(mkmfHash, "PATH_SEPARATOR", ":");
        RbConfigLibrary.setConfig(mkmfHash, "INSTALL", "install -c ");
        RbConfigLibrary.setConfig(mkmfHash, "RM", "rm -f");
        RbConfigLibrary.setConfig(mkmfHash, "CP", "cp ");
        RbConfigLibrary.setConfig(mkmfHash, "MAKEDIRS", "mkdir -p ");
        ruby.getObject().defineConstant("CROSS_COMPILING", ruby.getNil());
        configModule.defineConstant("MAKEFILE_CONFIG", mkmfHash);
    }

    private static void setConfig(RubyHash mkmfHash, String key, String value) {
        Ruby runtime = mkmfHash.getRuntime();
        mkmfHash.op_aset(runtime.getCurrentContext(), runtime.newString(key), runtime.newString(value));
    }

    public static String jrubyScript() {
        return System.getProperty("jruby.script", Platform.IS_WINDOWS ? "jruby.bat" : "jruby").replace('\\', '/');
    }

    public static String jrubyShell() {
        return System.getProperty("jruby.shell", Platform.IS_WINDOWS ? "cmd.exe" : "/bin/sh").replace('\\', '/');
    }

    static {
        RUBY_OS_NAMES.put("Mac OS X", RUBY_DARWIN);
        RUBY_OS_NAMES.put("Darwin", RUBY_DARWIN);
        RUBY_OS_NAMES.put("Linux", RUBY_LINUX);
        RUBY_OS_NAMES.put("Windows 95", RUBY_WIN32);
        RUBY_OS_NAMES.put("Windows 98", RUBY_WIN32);
        RUBY_OS_NAMES.put("Windows Me", RUBY_WIN32);
        RUBY_OS_NAMES.put("Windows NT", RUBY_WIN32);
        RUBY_OS_NAMES.put("Windows NT (unknown)", RUBY_WIN32);
        RUBY_OS_NAMES.put("Windows XP", RUBY_WIN32);
        RUBY_OS_NAMES.put("Windows 2003", RUBY_WIN32);
        RUBY_OS_NAMES.put("Windows Vista", RUBY_WIN32);
        RUBY_OS_NAMES.put("Solaris", RUBY_SOLARIS);
        RUBY_OS_NAMES.put("FreeBSD", RUBY_FREEBSD);
        RUBY_OS_NAMES.put("AIX", RUBY_AIX);
    }
}

