/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.libraries;

import java.io.IOException;
import java.util.LinkedList;
import org.jruby.Ruby;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyThread;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.RaiseException;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.load.Library;

public class ThreadLibrary
implements Library {
    public void load(Ruby runtime, boolean wrap) throws IOException {
        Mutex.setup(runtime);
        ConditionVariable.setup(runtime);
        Queue.setup(runtime);
        SizedQueue.setup(runtime);
    }

    static boolean wait_timeout(IRubyObject o, Double timeout) throws InterruptedException {
        if (timeout != null) {
            long end_ns;
            long delay_ns = (long)(timeout * 1.0E9);
            long start_ns = System.nanoTime();
            if (delay_ns > 0L) {
                long delay_ms = delay_ns / 1000000L;
                int delay_ns_remainder = (int)(delay_ns % 1000000L);
                o.wait(delay_ms, delay_ns_remainder);
            }
            return (end_ns = System.nanoTime()) - start_ns <= delay_ns;
        }
        o.wait();
        return true;
    }

    @JRubyClass(name={"SizedQueue"}, parent="Queue")
    public static class SizedQueue
    extends Queue {
        private int capacity = 1;

        @JRubyMethod(name={"new"}, rest=true, frame=true, meta=true)
        public static IRubyObject newInstance(IRubyObject recv, IRubyObject[] args, Block block) {
            SizedQueue result = new SizedQueue(recv.getRuntime(), (RubyClass)recv);
            result.callInit(args, block);
            return result;
        }

        public SizedQueue(Ruby runtime, RubyClass type) {
            super(runtime, type);
        }

        public static void setup(Ruby runtime) {
            RubyClass cSizedQueue = runtime.defineClass("SizedQueue", runtime.fastGetClass("Queue"), new ObjectAllocator(){

                public IRubyObject allocate(Ruby runtime, RubyClass klass) {
                    return new SizedQueue(runtime, klass);
                }
            });
            cSizedQueue.defineAnnotatedMethods(SizedQueue.class);
        }

        @JRubyMethod
        public synchronized IRubyObject clear() {
            super.clear();
            this.notifyAll();
            return this.getRuntime().getNil();
        }

        @JRubyMethod
        public synchronized RubyNumeric max() {
            return RubyNumeric.int2fix(this.getRuntime(), this.capacity);
        }

        @JRubyMethod(name={"max=", "initialize"})
        public synchronized IRubyObject max_set(IRubyObject arg) {
            int new_capacity = RubyNumeric.fix2int(arg);
            if (new_capacity <= 0) {
                this.getRuntime().newArgumentError("queue size must be positive");
            }
            int difference = new_capacity > this.capacity ? new_capacity - this.capacity : 0;
            this.capacity = new_capacity;
            if (difference > 0) {
                this.notifyAll();
            }
            return this.getRuntime().getNil();
        }

        @JRubyMethod(name={"pop", "deq", "shift"}, optional=1)
        public synchronized IRubyObject pop(IRubyObject[] args) {
            IRubyObject result = super.pop(args);
            this.notifyAll();
            return result;
        }

        @JRubyMethod(name={"push", "<<"})
        public synchronized IRubyObject push(IRubyObject value) {
            while (RubyNumeric.fix2int(this.length()) >= this.capacity) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            super.push(value);
            this.notifyAll();
            return this.getRuntime().getNil();
        }
    }

    @JRubyClass(name={"Queue"})
    public static class Queue
    extends RubyObject {
        private LinkedList entries = new LinkedList();

        @JRubyMethod(name={"new"}, rest=true, frame=true, meta=true)
        public static IRubyObject newInstance(IRubyObject recv, IRubyObject[] args, Block block) {
            Queue result = new Queue(recv.getRuntime(), (RubyClass)recv);
            result.callInit(args, block);
            return result;
        }

        public Queue(Ruby runtime, RubyClass type) {
            super(runtime, type);
        }

        public static void setup(Ruby runtime) {
            RubyClass cQueue = runtime.defineClass("Queue", runtime.getObject(), new ObjectAllocator(){

                public IRubyObject allocate(Ruby runtime, RubyClass klass) {
                    return new Queue(runtime, klass);
                }
            });
            cQueue.defineAnnotatedMethods(Queue.class);
        }

        @JRubyMethod
        public synchronized IRubyObject clear() {
            this.entries.clear();
            return this.getRuntime().getNil();
        }

        @JRubyMethod(name={"empty?"})
        public synchronized RubyBoolean empty_p() {
            return this.entries.size() == 0 ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
        }

        @JRubyMethod(name={"length", "size"})
        public synchronized RubyNumeric length() {
            return RubyNumeric.int2fix(this.getRuntime(), this.entries.size());
        }

        @JRubyMethod
        public RubyNumeric num_waiting() {
            return this.getRuntime().newFixnum(0);
        }

        @JRubyMethod(name={"pop", "deq", "shift"}, optional=1)
        public synchronized IRubyObject pop(IRubyObject[] args) {
            boolean should_block = true;
            if (Arity.checkArgumentCount(this.getRuntime(), args, 0, 1) == 1) {
                boolean bl = should_block = !args[0].isTrue();
            }
            if (!should_block && this.entries.size() == 0) {
                throw new RaiseException(this.getRuntime(), this.getRuntime().getThreadError(), "queue empty", false);
            }
            while (this.entries.size() == 0) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            return (IRubyObject)this.entries.removeFirst();
        }

        @JRubyMethod(name={"push", "<<", "enq"})
        public synchronized IRubyObject push(IRubyObject value) {
            this.entries.addLast(value);
            this.notify();
            return this.getRuntime().getNil();
        }
    }

    @JRubyClass(name={"ConditionVariable"})
    public static class ConditionVariable
    extends RubyObject {
        @JRubyMethod(name={"new"}, rest=true, frame=true, meta=true)
        public static ConditionVariable newInstance(IRubyObject recv, IRubyObject[] args, Block block) {
            ConditionVariable result = new ConditionVariable(recv.getRuntime(), (RubyClass)recv);
            result.callInit(args, block);
            return result;
        }

        public ConditionVariable(Ruby runtime, RubyClass type) {
            super(runtime, type);
        }

        public static void setup(Ruby runtime) {
            RubyClass cConditionVariable = runtime.defineClass("ConditionVariable", runtime.getObject(), new ObjectAllocator(){

                public IRubyObject allocate(Ruby runtime, RubyClass klass) {
                    return new ConditionVariable(runtime, klass);
                }
            });
            cConditionVariable.defineAnnotatedMethods(ConditionVariable.class);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JRubyMethod(name={"wait"}, required=1, optional=1)
        public IRubyObject wait_ruby(IRubyObject[] args) throws InterruptedException {
            if (args.length < 1) {
                throw this.getRuntime().newArgumentError(args.length, 1);
            }
            if (args.length > 2) {
                throw this.getRuntime().newArgumentError(args.length, 2);
            }
            if (!(args[0] instanceof Mutex)) {
                throw this.getRuntime().newTypeError(args[0], this.getRuntime().fastGetClass("Mutex"));
            }
            Mutex mutex = (Mutex)args[0];
            Double timeout = null;
            if (args.length > 1 && !args[1].isNil()) {
                timeout = args[1].convertToFloat().getDoubleValue();
            }
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            boolean success = false;
            try {
                ConditionVariable conditionVariable = this;
                synchronized (conditionVariable) {
                    mutex.unlock();
                    try {
                        success = ThreadLibrary.wait_timeout(this, timeout);
                    }
                    finally {
                        if (!success) {
                            this.notify();
                        }
                    }
                }
            }
            finally {
                mutex.lock();
            }
            if (timeout != null) {
                return this.getRuntime().newBoolean(success);
            }
            return this.getRuntime().getNil();
        }

        @JRubyMethod
        public synchronized IRubyObject broadcast() {
            this.notifyAll();
            return this.getRuntime().getNil();
        }

        @JRubyMethod
        public synchronized IRubyObject signal() {
            this.notify();
            return this.getRuntime().getNil();
        }
    }

    @JRubyClass(name={"Mutex"})
    public static class Mutex
    extends RubyObject {
        private RubyThread owner = null;

        @JRubyMethod(name={"new"}, rest=true, meta=true)
        public static Mutex newInstance(IRubyObject recv, IRubyObject[] args, Block block) {
            Mutex result = new Mutex(recv.getRuntime(), (RubyClass)recv);
            result.callInit(args, block);
            return result;
        }

        public Mutex(Ruby runtime, RubyClass type) {
            super(runtime, type);
        }

        public static void setup(Ruby runtime) {
            RubyClass cMutex = runtime.defineClass("Mutex", runtime.getObject(), new ObjectAllocator(){

                public IRubyObject allocate(Ruby runtime, RubyClass klass) {
                    return new Mutex(runtime, klass);
                }
            });
            cMutex.defineAnnotatedMethods(Mutex.class);
        }

        @JRubyMethod(name={"locked?"})
        public synchronized RubyBoolean locked_p() {
            return this.owner != null ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JRubyMethod
        public RubyBoolean try_lock() throws InterruptedException {
            Mutex mutex = this;
            synchronized (mutex) {
                if (this.owner != null) {
                    return this.getRuntime().getFalse();
                }
                this.lock();
            }
            return this.getRuntime().getTrue();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JRubyMethod
        public IRubyObject lock() throws InterruptedException {
            Mutex mutex = this;
            synchronized (mutex) {
                try {
                    while (this.owner != null) {
                        this.wait();
                    }
                    this.owner = this.getRuntime().getCurrentContext().getThread();
                }
                catch (InterruptedException ex) {
                    if (this.owner == null) {
                        this.notify();
                    }
                    throw ex;
                }
            }
            return this;
        }

        @JRubyMethod
        public synchronized RubyBoolean unlock() {
            if (this.owner != null) {
                this.owner = null;
                this.notify();
                return this.getRuntime().getTrue();
            }
            return this.getRuntime().getFalse();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JRubyMethod
        public IRubyObject synchronize(Block block) throws InterruptedException {
            try {
                this.lock();
                IRubyObject iRubyObject = block.yield(this.getRuntime().getCurrentContext(), null);
                return iRubyObject;
            }
            finally {
                this.unlock();
            }
        }
    }
}

