import com.aibonware.viewnaver.ViewNaver
import com.aibonware.viewnaver.Cache
import com.aibonware.viewnaver.xml.ArticleReader
import com.aibonware.viewnaver.xml.ArticleSerializer
import com.aibonware.viewnaver.xml.BaseXMLReader
import com.aibonware.viewnaver.xml.BaseXMLSerializer
import com.aibonware.viewnaver.xml.CompositeThreadReader
import com.aibonware.viewnaver.xml.CompositeThreadSerializer
import com.aibonware.viewnaver.xml.MessageReader
import com.aibonware.viewnaver.xml.MessageSerializer
import com.aibonware.viewnaver.view.LocalSearchType
import com.aibonware.viewnaver.storage.MessageStorage
import com.aibonware.viewnaver.storage.ThreadStorage
import com.aibonware.viewnaver.storage.ThreadStorageWalker
import com.aibonware.viewnaver.parser.BoardParser
import com.aibonware.viewnaver.parser.GoyakuJitenParser
import com.aibonware.viewnaver.parser.IDJitenParser
import com.aibonware.viewnaver.parser.ThreadParser
import com.aibonware.viewnaver.net.MultiSession
import com.aibonware.viewnaver.net.RemoteSite
import com.aibonware.viewnaver.model.Article
import com.aibonware.viewnaver.model.ArticleList
import com.aibonware.viewnaver.model.Board
import com.aibonware.viewnaver.model.BoardTitle
import com.aibonware.viewnaver.model.BoardTitles
import com.aibonware.viewnaver.model.BoardTitlesGroup
import com.aibonware.viewnaver.model.CompositeThread
import com.aibonware.viewnaver.model.FavoriteThread
import com.aibonware.viewnaver.model.FavoriteThreads
import com.aibonware.viewnaver.model.FilterType
import com.aibonware.viewnaver.model.FoundThreads
import com.aibonware.viewnaver.model.Goyaku
import com.aibonware.viewnaver.model.GoyakuJiten
import com.aibonware.viewnaver.model.IDJitenList
import com.aibonware.viewnaver.model.ModelProvider
import com.aibonware.viewnaver.model.NThread
import com.aibonware.viewnaver.model.SessionType
import com.aibonware.viewnaver.format.DefaultFormatter
import com.aibonware.viewnaver.format.PublishableThreadFormatter
import com.aibonware.viewnaver.format.ThreadFormatter
import com.aibonware.viewnaver.decorator.ContentsDecorator
import com.aibonware.viewnaver.decorator.DecoratorChain
import com.aibonware.viewnaver.decorator.EmbeddedMovieDecorator
import com.aibonware.viewnaver.decorator.GoyakuDecorator
import com.aibonware.viewnaver.decorator.LinkGenerator
import com.aibonware.nvrlib.model.BoardType
import com.aibonware.nvrlib.model.Country
import com.aibonware.nvrlib.model.DenyEntry
import com.aibonware.nvrlib.model.Message
import com.aibonware.nvrlib.model.MessageTitle
import com.aibonware.nvrlib.model.MessageTitleList
import com.aibonware.nvrlib.model.Poster
import com.aibonware.nvrlib.model.SearchType
import com.aibonware.nvrlib.net.AnonymousSession
import com.aibonware.nvrlib.net.DenySession
import com.aibonware.nvrlib.net.HttpCancellerProvider
import com.aibonware.nvrlib.net.LoginSession
import com.aibonware.nvrlib.net.NaverSession
import com.aibonware.nvrlib.net.ProxyInfo
import com.aibonware.nvrlib.net.SimpleHttpCancellerProvider
import com.aibonware.nvrlib.net.VariableSession
import com.aibonware.nvrlib.task.TaskCanceller
import com.aibonware.nvrlib.parser.DenyListParser
import com.aibonware.nvrlib.parser.MessageListParser
import com.aibonware.nvrlib.parser.ParsingContext
import com.aibonware.nvrlib.parser.ReplyMessageParser

require 'iconv'

$to_sjis = Iconv.new('Shift_JIS', 'UTF-8')

def to_sjis(s)
  Iconv.conv('Shift_JIS', 'UTF-8', s)
end

def to_utf(s)
  Iconv.conv('UTF-8', 'Shift_JIS', s)
end

$app = ViewNaver.instance
$site = $app.web
$boardTitles = $app.boardTitles

class BoardTitle
  def queryCompositeThread(param)
    if param.class == NThread
      thread = param
      return $site.queryWebThreadContents $app.multiSession, boardName, thread.nid, thread, $app.modelProvider, true
    else
      nid = param
      return $site.queryWebThreadContents $app.multiSession, boardName, nid.to_int, nil, $app.modelProvider, true
    end
  end

  def queryBoard(pageNo)
    parser = BoardParser.new $app.modelProvider
    board = parser.parse($app.multiSession ,$app.web.getBoardPageUrl(boardName, pageNo), boardName, dispName, boardType, pageNo);

    return board;
  end

  def searchPoster(keyword, pageNo)
    foundThreads = SearchType::SearchByPoster.execSearch(
      $app.modelProvider,
      $app.appTools,
      $app.multiSession,
      boardName,
      dispName,
      boardType,
      keyword,
      pageNo)

    return foundThreads
  end
  
  def searchTitle(keyword, pageNo)
    foundThreads = SearchType::SearchByTitle.execSearch(
      $app.modelProvider,
      $app.appTools,
      $app.multiSession,
      boardName,
      dispName,
      boardType,
      keyword,
      pageNo)

    return foundThreads
  end

  def searchThreadNo(dispId, pageNo)
     foundThreads = SearchType::SearchByNo.execSearch(
      $app.modelProvider,
      $app.appTools,
      $app.multiSession,
      boardName,
      dispName,
      boardType,
      keyword,
      pageNo)

    return foundThreads
  end
end

