/*
 * Copyright (c) 2006, team-naver.com
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.aibonware.viewnaver.config;

import java.awt.event.*;
import javax.swing.*;
import org.w3c.dom.*;

@SuppressWarnings("serial")
public class NetworkConfig extends ConfigItem {
	public boolean useProxy = false;
	public String proxyHost = "127.0.0.1";
	public int proxyPort = 8080;

	public NetworkConfig() {
		super("Proxy");
		loadConfig(null);
	}

	@Override public void loadConfig(Element elem) {
		useProxy = Config.getBooleanConfig(elem, "UseProxy", false);
		proxyHost = Config.getStringConfig(elem, "ProxyHost", "127.0.0.1");
		proxyPort = Config.getIntConfig(elem, "ProxyPort", 8080);
	}

	@Override public void saveConfig(Element elem) {
		Config.setBooleanConfig(elem, "UseProxy", useProxy);
		Config.setStringConfig(elem, "ProxyHost", proxyHost);
		Config.setIntConfig(elem, "ProxyPort", proxyPort);
	}

	@Override public String getDispPath() {
		return "lbg[N.ڑ";
	}

	private static class NetworkConfigView extends ConfigItemView {
		JTextField proxyHostText;
		JTextField proxyPortText;
		JCheckBox useProxyCheck;
		private NetworkConfig networkConfig;

		private void changeEnable() {
			setLineEnabled(useProxyCheck.isSelected(), proxyHostText);
			setLineEnabled(useProxyCheck.isSelected(), proxyPortText);
		}
		
		public NetworkConfigView() {
			proxyHostText = new JTextField();
			proxyPortText = new JTextField();
			useProxyCheck = new JCheckBox("vLVgp");

			addLine(useProxyCheck);
			addLine("   vLVT[oAhXF\t", glue(proxyHostText));
			addLine("   vLV|[gԍF\t", glue(proxyPortText));
			
			useProxyCheck.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					changeEnable();
				}
			});
		}

		public void setConfig(ConfigItem config) {
			networkConfig = (NetworkConfig)config;
			useProxyCheck.setSelected(networkConfig.useProxy);
			proxyHostText.setText(networkConfig.proxyHost);
			proxyPortText.setText(String.valueOf(networkConfig.proxyPort));

			changeEnable();
		}

		public void applyConfig() throws ConfigException {
			try {
				networkConfig.useProxy = useProxyCheck.isSelected();
				networkConfig.proxyHost = proxyHostText.getText();
				networkConfig.proxyPort = Integer.parseInt(proxyPortText.getText());
			} catch(NumberFormatException e) {
				if(useProxyCheck.isSelected()) {
					throw new ConfigException("|[gԍɂ͐lw肵ĂB");
				}
			}
		}
	}

	@Override public ConfigItemView getView() {
		return new NetworkConfigView();
	}

}
