/*
 * Copyright (c) 2006, team-naver.com
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.aibonware.viewnaver.content.localsearch;

import com.aibonware.viewnaver.*;
import com.aibonware.viewnaver.content.*;
import com.aibonware.viewnaver.view.*;

public class LocalFoundContent implements TabContent {
	public final LocalFoundContentCategory category;
	
	public LocalFoundContent(LocalFoundContentCategory category) {
		this.category = category;
	}

	public static class LocalFoundContentCategory implements TabContentCategory {
		public final LocalSearchType localSearchType;
		public final String poster;
		public final String keyword;

		public LocalFoundContentCategory(
				LocalSearchType localSearchType,
				String poster,
				String keyword) {
			this.localSearchType = localSearchType;
			this.poster = poster;
			this.keyword = keyword;
		}

		@Override public boolean equals(Object o) {
			boolean e;
			
			if(o == null) return false;
			if(!(o instanceof LocalFoundContentCategory)) return false;

			LocalFoundContentCategory dest = (LocalFoundContentCategory)o;

			if(localSearchType.equals(dest.localSearchType)) return false;
			if(poster == null) {
				if(dest.poster != null) return false;
			} else {
				if(!poster.equals(dest.poster)) return false;
			}
			if(keyword == null) {
				if(dest.keyword != null) return false;
			} else {
				if(keyword.equals(dest.keyword)) return false;
			}

			return true;
		}

		public void createInitialContent(final TabContainer container, final TabContainerView containerView, TabContentView initialView) {
			final LocalFoundContent content = new LocalFoundContent(this);

			container.addContent(content);
			containerView.activate(content.getCategory());
		}

		public String getCategoryName() {
			return "O";
		}

		@Override public int hashCode() {
			int hash = localSearchType.hashCode();
			if(poster != null) hash += poster.hashCode();
			if(keyword != null) hash += keyword.hashCode();

			return hash;
		}

		public Class getContentClass() {
			return LocalFoundContent.class;
		}
	};

	public String getContentTitle() {
		return "O";
	}

	public TabContentCategory getCategory() {
		return category;
	}

	public static TabContentCategory getConstantCategory(
			LocalSearchType localSearchType,
			String poster,
			String keyword) {
		return new LocalFoundContentCategory(localSearchType, poster, keyword);
	}
	
	public void replaceUpdatedContent(final TabContainer container, final TabContainerView containerView, TabContentView contentView) {
		ViewNaver.println("now printing");
	}
}
