/*
 * Copyright (c) 2006, team-naver.com
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.aibonware.viewnaver.model;

public class BoardTitle {
	public final String boardName; // ̓
	public final String dispName; // ̕\
    public final BoardType boardType;

    public BoardTitle(String boardName, String dispName) {
    	this.boardName = boardName;
    	this.dispName = dispName;
    	
    	if(boardName.startsWith("p")) boardType = BoardType.Image;
    	else boardType = BoardType.Text;
    }
    
  	public BoardTitle(String boardName, String dispName, BoardType boardType) {
		this.boardName = boardName;
		this.dispName = dispName;
        this.boardType = boardType;
	}

  	public String toString() {
  		return dispName;
  	}
  	
  	public boolean equals(Object o) {
  		if(o == null) return false;
  		if(!(o instanceof BoardTitle)) return false;
  		
  		BoardTitle dest = (BoardTitle)o;
  		
  		if(!boardType.equals(dest.boardType)) {
  			return false;
  		}

  		if(boardType == BoardType.SearchResult) {
  			return super.equals(dest);
  		}

  		return boardName.equals(dest.boardName) && boardType.equals(dest.boardType);
  	}
}
