/*
 * Copyright (c) 2006, team-naver.com
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.aibonware.viewnaver.parser;

import java.io.*;
import java.util.*;
import java.text.*;

import com.aibonware.viewnaver.*;
import com.aibonware.viewnaver.model.*;
import com.aibonware.viewnaver.net.*;

public class MessageParser  {
	private final String urlString;
	private final MessageTitle messageTitle;

	public MessageParser(MessageTitle messageTitle, String urlString) {
		this.messageTitle = messageTitle;
		this.urlString = urlString;
	}

	private static SimpleDateFormat df = new SimpleDateFormat("yy-MM-dd HH:mm:ss");

	public Message parse() throws NetException, ParsingException {
		BufferedReader reader = ViewNaver.instance.naverSession.open(urlString, "UTF8");

		Message result = parse(reader);
		
		try {
			reader.close();
		} catch(IOException e) {
			throw new RuntimeException("URLN[Ys", e);
		}
		
		return result;
	}
	
	private String removeBlank(String src) {
		StringBuffer buf = new StringBuffer(src);

		while(buf.charAt(0) == '\t' || buf.charAt(0) == ' ') {
			buf.deleteCharAt(0);
		}
		
		while(buf.charAt(buf.length()-1) == '\t' || buf.charAt(buf.length()-1) == ' ') {
			buf.deleteCharAt(buf.length()-1);
		}

		return buf.toString();
	}

	public Message parse(BufferedReader reader) throws ParsingException, NetException  {
		ParsingContext ct = new ParsingContext(reader);

		try {
			ct.seek("<form");
			ct.seek("bZ[W");
			ct.seek("<span class");

			String dateText = ct.cut(">", "</span></td></tr>").trim();

			String countryText = ct.cut("http://static.naver.com/enjoyjapan/tbbs/img_09/ico_", ".gif").trim();

			String poster = ct.cut(">", "</b></td>").trim();

			ct.seek("<table");
			ct.seek("<table");
			ct.seek("ln15");

			String messageText = removeBlank(ct.cut(">", "</td>").trim());
			messageText = messageText.replace("<br />", "<br>");

			Date date = df.parse(dateText);

			Country country;
			
			if(countryText.equals("jpn")) {
				country = Country.JAPAN;
			} else if(countryText.equals("kor")) {
				country = Country.KOREA;
			} else {
				country = Country.UNKNOWN;
			}

			return new Message(
					messageTitle.messageId, 
					poster, 
					country, 
					date, 
					messageText, 
					messageTitle.title);
		} catch(ParseException e) {
			throw new ParsingException(e, ct.text.toString());
		}
	}
}
