/*
 * Copyright (c) 2006, team-naver.com
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.aibonware.viewnaver.parser;

import java.text.*;
import java.io.*;
import java.util.*;
import java.util.regex.*;

import com.aibonware.viewnaver.*;
import com.aibonware.viewnaver.model.*;
import com.aibonware.viewnaver.net.*;

/**
 * ̐ꂽRg̑}ev[gύX邽
 * EBhE > ݒ > Java > R[h > R[hƃRg
 */
public class ThreadParser {
	public ArticleList resultArticleList = null;
	public String resultRawContents = null;
	public NThread resultThread = null;

	private NThread templateThread = null;
	private BufferedReader reader;

	private static SimpleDateFormat articleDateFormat = new SimpleDateFormat("MM-dd HH:mm");
	private static SimpleDateFormat threadDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

	private static Pattern guard1 = Pattern.compile("<span\\s*id\\s*=\\s*[\"'](comment:|thread:|poster:)[\\-\\dA-Za-z\\._]*[\"']>", Pattern.CASE_INSENSITIVE);
	private static Pattern guard2 = Pattern.compile("href\\s*=\\s*[\"'](comment:|thread:|poster:)[\\-\\dA-Za-z\\._]*[\"']",  Pattern.CASE_INSENSITIVE);
	
	public ThreadParser(BufferedReader reader, NThread templateThread) {
		this.reader = reader;
		this.templateThread = templateThread;
	}

	public void parse() throws NetException, ParsingException {
		ParsingContext ct = new ParsingContext(reader);

		parseThreadHeaderAndContents(ct, templateThread);

		resultArticleList = new ArticleList();
		parseAricleList(resultThread.createDate, resultArticleList, ct);
	}

	private void parseThreadHeaderAndContents(ParsingContext ct, NThread templateThread) throws ParsingException {
		try {
			int nid = Integer.parseInt(ct.cut("name=nid value='", "'"));
			ct.seek("tab_bbs01_on.gif");
			
			ct.seek("class='nboard_tb'");

			// ʂ߂
			String countryText = ct.cut("alt='", "'");
			Country country;
			
			if(countryText.contains("KOREA")) {
				country = Country.KOREA;
			} else if(countryText.contains("JAPAN")) {
				country = Country.JAPAN;
			} else {
				country = Country.UNKNOWN;
			}

			// ^Cg߂
			ct.seek("<span");
			String title = ct.cut(">", "</span>");

			// V[PXԍ߂
			String dispId = ct.cut("gray04'>No.", "&nbsp;").trim();

			// e҂߂
			String poster = ct.cut("e:", "&nbsp;&nbsp;&nbsp;").trim();
			
			if(poster.contains("javascript:ui")) {
				int start = poster.indexOf("')\">") + 4;
				int end = poster.indexOf("</a>");
				poster = poster.substring(start, end);
			} else {
				if(poster.equals("^c")) poster = "enjoymaster";
			}
			
			// 쐬߂
			String dateText = ct.cut("쐬:", "</td>").trim();
			Date createDate = threadDateFormat.parse(dateText);

			// {߂
			int viewNum = Integer.parseInt(ct.cut("{:", "&nbsp;").trim());

			// AP[g߂
			// o[Wł́APtableɕϊĖ{ƌ邾B
			String enqueteText = ct.cut(null, "<div style='overflow-x:auto");
			StringBuffer enqueteHtml = new StringBuffer();
			
			if(enqueteText.indexOf("<span id='poll'>") >= 0) {
				ParsingContext enqct = new ParsingContext(enqueteText);
				enqct.seek("<tr class='PollTitle'>");
				enqct.seek("<table");
				
				enqueteHtml.append("#AP[g<table>");
				
				while(enqct.seek("class=c>", "</table>")) {
					// ږ
					String name = enqct.cut(null, "</td>");

					// [
					String value = enqct.cut("class=c>", "</td>");

					enqueteHtml.append("<tr><td>");
					enqueteHtml.append(name);
					enqueteHtml.append("</td><td>");
					enqueteHtml.append(value);
					enqueteHtml.append("</td></tr>");
					
					enqct.seek("<tr><td height=10 colspan=3></td></tr>");
				}
				
				enqueteHtml.append("</table>");
			}

			// {߂
			String contentsText = ct.cut(">", "<script for=window event=onload>");
			int end = contentsText.lastIndexOf("</div>");
			
			// LŎ擾</div>̈ʒuIP\</div>Ȃ̂ŁAXɂ̂ЂƂODIVT
			end = contentsText.lastIndexOf("</div>", end-1);

			resultRawContents = enqueteHtml + contentsText.substring(0, end);

			// viewNVR̃RecړeĂ܂ꍇɔāAHTML̐R[h
			Pattern guard1 = Pattern.compile("<span\\s*id\\s*=\\s*[\"'](comment:|thread:|poster:)[\\-\\dA-Za-z\\._]*[\"']>", Pattern.CASE_INSENSITIVE);
			Pattern guard2 = Pattern.compile("href\\s*=\\s*[\"'](comment:|thread:|poster:)[\\-\\dA-Za-z\\._]*[\"']",  Pattern.CASE_INSENSITIVE);

			resultRawContents = guard1.matcher(resultRawContents).replaceAll("<span>");
			resultRawContents = guard2.matcher(resultRawContents).replaceAll("href=\"\"");

			if(templateThread != null) {
				resultThread = new NThread(
					templateThread.depth,
					dispId,
					templateThread.isAdminThread,
					templateThread.nid,
					templateThread.country,
					title,
					templateThread.articleNum,
					poster,
					createDate,
					createDate,
					viewNum,
					templateThread.mail,
					new Date(),
	                templateThread.isHot,
	                null);
			} else {
				resultThread = new NThread(
						0,
						dispId,
						false,
						nid,
						country,
						title,
						-1,
						poster,
						createDate,
						createDate,
						viewNum,
						null,
						new Date(),
		                false,
		                null);
			}

		} catch(ParseException e) {
			throw new ParsingException(e, ct.text.toString());
		}
	}

	public void parseAricleList(Date startDate, ArticleList articleList, ParsingContext ct) throws ParsingException {
		try {
			for(;;) {
				ct.seek("<td height='11'></td>");
				
				if(!ct.seek("<td align='left' nowrap>", "ment_writer")) break;
				
				// ԐMʂ߂
				String replyText = ct.cut(null, "<img src=");
				boolean isReply;
				
				if(replyText.indexOf('') >= 0) {
					isReply = true;
				} else {
					isReply = false;
				}
								
				// ʂ߂
				String countryText = ct.cut("http://static.naver.com/enjoyjapan/tbbs/img_09/", ">");
				Country country;

				if(countryText.contains("ico_kor")) {
					country = Country.KOREA;
				} else if(countryText.contains("ico_jpn")) {
					country = Country.JAPAN;
				} else {
					country = Country.UNKNOWN;
				}

				// e҂߂
//				String author = ct.cut("')\">", "</a>");
				String author = ct.cut(null, "<span class='small00'>");

				if(author.contains("^c")) {
					author = "enjoymaster";
				} else {
					int start = author.indexOf("')\">") + "')\">".length();
					int end = author.indexOf("</a>", start);
					author = author.substring(start, end);
				}
				
				// et߂
				String dateText = ct.cut(null, "</span>");
				Date postDate = articleDateFormat.parse(dateText);
				
				// ee߂
				String contents = ct.cut("<td class='ln13'>&nbsp;&nbsp;", " </td>");
				contents = contents.replace("\r\n", "<br>");
				
				int delPos = contents.indexOf(" <a href='javascript:delete_ment(");
				if(delPos != -1) contents = contents.substring(0, delPos);
				
				if(isReply) {
					if(contents.startsWith("&nbsp;&nbsp;&nbsp;&nbsp;")) {
						contents = contents.substring("&nbsp;&nbsp;&nbsp;&nbsp;".length());
					}
				}

				// Xԍ߂
				int articleId = Integer.parseInt(ct.cut("<div id='repl_", "'"));

				// sno߂
				int sno = Integer.parseInt(ct.cut("return add_reply(\"", "\""));

				// eX߂
//				int parentArticleId;
	
				articleList.addArticle(new Article(
					author,
					country,
					contents,
					articleId,
					postDate,
					isReply,
					sno));
			}

			GregorianCalendar carendar = new GregorianCalendar();

			carendar.setTime(startDate);
			carendar.add(Calendar.MINUTE, -1); // ڽ͕b0ɂȂĂ̂
			startDate = carendar.getTime();
			int year = carendar.get(Calendar.YEAR);
			
//			Date prevDate = startDate;
			
			// t1970NɂȂĂ̂ŏC
			for(int i=0; i<articleList.getArticleCount(); i++) {
				Article art = articleList.getArticle(i);
	
				carendar.setTime(art.postDate);
				carendar.add(Calendar.YEAR, year-1970);
				Date newPostDate = carendar.getTime();
/*				
				/*while*if(prevDate.compareTo(newPostDate) > 0) {
					year++;
	
					carendar.setTime(art.postDate);
					carendar.add(Calendar.YEAR, year-1970);
					newPostDate = carendar.getTime();
				}
*/				
				art.postDate = newPostDate;
//				prevDate = newPostDate;
			}
		} catch(ParseException e) {
			throw new ParsingException(e, ct.text.toString());
		}
	}

	public NThread getResultThread() {
		return resultThread;
	}

	public String getResultRawContents() {
		return resultRawContents;
	}

	public ArticleList getResultArticleList() {
		return resultArticleList;
	}
}
