/*
 * Copyright (c) 2007, team-naver.com
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.aibonware.viewnaver.server.movie;

import java.util.*;
import com.aibonware.viewnaver.server.*;

public class MovieCache {
	public MovieCache() {}
	
	private Vector<Movie> movies = new Vector<Movie>();
	private HashMap<String /*url*/, Movie> urlMapping = new HashMap<String, Movie>();

	public Movie putMovieUrl(UserSession user, String url) {
		Movie movie = urlMapping.get(url);

		if(movie == null) {
			movie = new Movie(user, movies.size(), url);
			movies.addElement(movie);
			urlMapping.put(url, movie);
		}

		return movie;
	}
	
	public Movie get(String url) {
		if(urlMapping.containsKey(url)) {
			return null;
		} else {
			return urlMapping.get(url);
		}
	}
	
	public Movie get(int movieNo) {
		if(movieNo < 0 || movieNo >= movies.size()) {
			return null;
		} else {
			return movies.elementAt(movieNo);
		}
	}
}
