/*
 * Copyright (c) 2007, team-naver.com
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.aibonware.viewnaver.server.servlet;

import Acme.Serve.servlet.*;
import Acme.Serve.servlet.http.*;
import com.aibonware.viewnaver.*;
import com.aibonware.viewnaver.model.*;
import com.aibonware.viewnaver.server.MiniServer;
import com.aibonware.viewnaver.server.UserSession;

public class MainServlet extends BaseServlet {
	public MainServlet() {}

	@Override public String getName() {
		return "main";
	}

	@Override public void dispContents(MiniServer server, UserSession user, HttpServletRequest request, HttpServletResponse response, ServletOutputStream out) throws Exception {
//		out.println("үށF<br>");
//		out.println("<a href=\"/recvmsg?sid=" + user.sid + "\">M</a><br>");
//		out.println("<a href=\"/sentmsg?sid=" + user.sid + "\">M</a><br>");
//		out.println("<br>");

		BoardTitles boards;

		out.println("÷āF<br>");
		boards = ViewNaver.instance.boardTitles.getBoardTitles(BoardType.Text);

		for(int i=0; i<boards.getBoardCount(); i++) {
			BoardTitle board = boards.getBoardTitle(i);
			out.println("<a href=\"" + BoardServlet.createUrl(user, board.boardName, 1) + "\">" +  board.dispName + "</a><br>");
		}

		out.println("<br>");
		
		out.println("̫āF<br>");
		boards = ViewNaver.instance.boardTitles.getBoardTitles(BoardType.Image);
		
		for(int i=0; i<boards.getBoardCount(); i++) {
			BoardTitle board = boards.getBoardTitle(i);
			out.println("<a href=\"" + BoardServlet.createUrl(user, board.boardName, 1) + "\">" +  board.dispName + "</a><br>");
		}

		out.println("<br>");

		out.println("<a href=\"logout?sid=" + user.sid + "\">۸ޱ</a>");
	}
}
