/*
 * Copyright (c) 2006, team-naver.com
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.aibonware.viewnaver.task;

import java.util.*;

import com.aibonware.viewnaver.model.*;
import com.aibonware.viewnaver.view.*;

public class TaskFlowList {
	private HashMap<Object, TaskFlow> children = new HashMap<Object, TaskFlow>();

	public TaskFlowList() {
	}

	public TaskFlow createNewFlow() {
		return getFlow(new Object());
	}

	private synchronized TaskFlow getFlow(Object tag) {
		TaskFlow taskFlow = children.get(tag);
		
		if(taskFlow == null) {
			taskFlow = new TaskFlowImpl(tag);
			children.put(tag, taskFlow);
		}

		return taskFlow;
	}
	
	void removeFlow(TaskFlow taskFlow) {
		children.remove(taskFlow.getTag());
	}

	public TaskFlow getThreadFlow(String boardName, int nid) {
		return getFlow("read thread " + boardName + " nid=" + nid);
	}

	public TaskFlow getBoardFlow(String boardName, int pageNo) {
		return getFlow("read board " + boardName + " pageNo=" + pageNo);
	}

	public TaskFlow getSearchRemoteThreadFlow(String boardName, SearchType searchType, String keyword) {
		return getFlow("search remote thread " + boardName + ", " + searchType + ", " + keyword);
	}

	public TaskFlow getSearchLocalThreadFlow(LocalSearchType localSearchType, String poster, String keyword) {
		return getFlow("search local thread " + localSearchType + ", " + poster + ", " + keyword);
	}

	public TaskFlow getDenyListFlow() {
		return getFlow("read deny list");
	}

	public TaskFlow getMessageListFlow() {
		return getFlow("read message list");
	}

	public TaskFlow getMessageFlow(int msgno) {
		return getFlow("read message " + msgno);
	}

	public TaskFlow getArticleFlow(String boardName, int nid, int articleId) {
		return getFlow("read article " + boardName + " nid=" + nid + " aid=" + articleId);
	}

	public TaskFlow getLoginFlow() {
		return getFlow("login");
	}
}
