/*
 * Copyright (c) 2006, team-naver.com
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.aibonware.viewnaver.window;

import java.awt.*;
import java.awt.event.*;

import javax.swing.*;

import com.aibonware.viewnaver.*;
import com.aibonware.viewnaver.net.*;
import com.aibonware.viewnaver.task.DefaultTaskStatusReceiver;
import com.aibonware.viewnaver.task.TaskFlow;
import com.aibonware.viewnaver.task.WorkerTask;
import com.aibonware.viewnaver.view.*;
import com.aibonware.viewnaver.model.*;

@SuppressWarnings("serial")
public class ModifyThreadWindow extends JDialog implements ChildWindow {
	private ThreadContentsEditorView modifyWindow;
	private final String boardName;
	private final int sno;
	private final NThread srcThread;

	JButton okButton = new JButton();
	JButton cancelButton = new JButton("Cancel");

	AbstractAction okAction = new AbstractAction("OK") {
		public void actionPerformed(ActionEvent e) {
			final String threadTitle = modifyWindow.getThreadTitle();
			final String htmlContent = modifyWindow.getHtmlContent();

			if(threadTitle == null || threadTitle.trim().equals("")) { 
				ViewNaver.println("^CgłB");
				return;
			}
			
			if(htmlContent == null || htmlContent.trim().equals("")) {
				ViewNaver.println("ełB");
				return;
			}

			TaskFlow taskFlow = ViewNaver.instance.taskFlowList.getThreadFlow(ModifyThreadWindow.this.boardName, srcThread.nid);

			taskFlow.addStatusReceiver(new DefaultTaskStatusReceiver(taskFlow, okButton, okAction, cancelButton));

			taskFlow.execute(new WorkerTask() {
				public void exec() {
					try {
						ViewNaver.println("XbhCJn..");

						ViewNaver.instance.naverSession.modifyThread(
								ModifyThreadWindow.this.boardName,  
								threadTitle, 
								htmlContent,
								srcThread.nid);

						ViewNaver.println("XbhCIB");

						ModifyThreadWindow.this.dispose();

					} catch(NetException e) {
						ViewNaver.err(e);
					}
				}
			});
		}
	};

	public ModifyThreadWindow(JFrame parent, String boardName, NThread srcThread, String htmlContents) {
		super(parent);
		
		this.srcThread = srcThread;
		
		setDefaultCloseOperation(DISPOSE_ON_CLOSE);

		this.boardName = boardName;

		this.setTitle(srcThread.poster + ": " + srcThread.title + " ̃XbhC");

		modifyWindow = new ThreadContentsEditorView();
		modifyWindow.threadTitleText.setText(srcThread.title);
		modifyWindow.setHtmlContents(htmlContents);

		Box buttonBox = new Box(BoxLayout.LINE_AXIS);

		buttonBox.add(Box.createGlue());
		buttonBox.add(okButton);
		buttonBox.add(cancelButton);

		add(modifyWindow, BorderLayout.CENTER);
		add(buttonBox, BorderLayout.SOUTH);

		setBounds(200, 200, 500, 400);

		cancelButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				ModifyThreadWindow.this.dispose();
			}
		});

		okButton.setAction(okAction);
		
		sno = createSno(srcThread.dispId);
		if(sno == -1) {
			ViewNaver.println("'" + srcThread.dispId + "': sIDłB");
			okButton.setEnabled(false);
		}
		
		ViewNaver.instance.childWindowActivator.addChildWindow(this);
	}

	private int createSno(String dispId) {
		if(dispId == null) return -1;
		
		int delim = dispId.indexOf('-');
		if(delim >= 0) dispId = dispId.substring(0, delim);
		dispId = dispId.trim();
		
		if(dispId.equals("")) return -1;
		
		try {
			return Integer.parseInt(dispId);
		} catch(NumberFormatException e) {
			return -1;
		}
	}
}
