package com.aibonware.viewnaver.window;


import java.awt.*;
import java.awt.event.*;

import javax.swing.*;

import com.aibonware.viewnaver.*;
import com.aibonware.viewnaver.view.*;
import com.aibonware.viewnaver.model.*;

@SuppressWarnings("serial")
public class PublishableThreadWindow extends JDialog implements ChildWindow {
	private PublishableThreadView publishableThreadView;

	public PublishableThreadWindow(JFrame parent, CompositeThread compositeThread) {
		super(parent);
		setDefaultCloseOperation(DISPOSE_ON_CLOSE);

		addWindowFocusListener(new WindowAdapter() {
			@Override public void windowLostFocus(WindowEvent e) {
				dispose();
			}
		});
		
		this.setTitle("JpXbhRec̕\");
		
		publishableThreadView = new PublishableThreadView(compositeThread);

		add(publishableThreadView, BorderLayout.CENTER);

		setBounds(200, 200, 500, 400);

		ViewNaver.instance.childWindowActivator.addChildWindow(this);
	}
}
