/*
 * Copyright (c) 2006, team-naver.com
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.aibonware.viewnaver.xml;

import org.w3c.dom.*;

import com.aibonware.viewnaver.model.*;

public class CompositeThreadSerializer extends BaseXMLSerializer {
	public CompositeThreadSerializer(Document doc) {
		super(doc);
	}
 
	public Element serialize(CompositeThread composite) {
		NThread thread = composite.thread;
		ArticleList articles = composite.articleList;
		
		Element threadElem = doc.createElement("CompositeThread");

		threadElem.setAttribute("BoardName", composite.boardName);
		threadElem.setAttribute("NID", String.valueOf(thread.nid));
        
		threadElem.appendChild(createAttrElem("Writer", thread.poster));
		threadElem.appendChild(createAttrElem("Title", thread.title));
		threadElem.appendChild(createAttrElem("CreateDate", thread.createDate));
		threadElem.appendChild(createAttrElem("ModifiedDate", thread.modifiedDate));
		threadElem.appendChild(createAttrElem("Depth", thread.depth));
		threadElem.appendChild(createAttrElem("DispID", thread.dispId));
		threadElem.appendChild(createAttrElem("IsAdminThread", thread.isAdminThread));
		threadElem.appendChild(createAttrElem("Country", thread.country));
		threadElem.appendChild(createAttrElem("CommentNum", thread.articleNum));
		threadElem.appendChild(createAttrElem("ViewNum", thread.viewNum));
		threadElem.appendChild(createAttrElem("IsHot", thread.isHot));
		threadElem.appendChild(createAttrElem("Contents", composite.contents));

        Element articlesElem = doc.createElement("CommentList");
        ArticleSerializer articleSerializer = new ArticleSerializer(doc);

        for(int i=0; i<articles.getArticleCount(); i++) {
        	articlesElem.appendChild(articleSerializer.serialize(articles.getArticle(i)));
        }

        threadElem.appendChild(articlesElem);
        
		return threadElem;
	}
}
