/*
 * Copyright (c) 2006, team-naver.com
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
#pragma once

extern "C" {
	
#define MSG_EXEC_COMMAND 0x7ff0
#define CMD_EXIT_LOOP 0

JNIEXPORT void JNICALL Java_com_aibonware_viewnaver_browser_win32_Win32BrowserThread_messageLoop
  (JNIEnv *, jclass);

JNIEXPORT void JNICALL Java_com_aibonware_viewnaver_browser_win32_Win32BrowserThread_postMessage
  (JNIEnv *, jclass, jint, jint, jint);

JNIEXPORT jint JNICALL Java_com_aibonware_viewnaver_browser_win32_Win32BrowserThread_createBrowser
  (JNIEnv *env, jclass clazz, jobject canvas, jintArray jpolicies);

JNIEXPORT void JNICALL Java_com_aibonware_viewnaver_browser_win32_Win32BrowserThread_writeDocHtml
  (JNIEnv *env, jclass clazz, jint hBrowser, jstring jhtml);

JNIEXPORT void JNICALL Java_com_aibonware_viewnaver_browser_win32_Win32BrowserThread_closeDocHtml
  (JNIEnv *env, jclass clazz, jint hBrowser);

JNIEXPORT void JNICALL Java_com_aibonware_viewnaver_browser_win32_Win32BrowserThread_clearDocHtml
  (JNIEnv *env, jclass clazz, jint hBrowser);

JNIEXPORT void JNICALL Java_com_aibonware_viewnaver_browser_win32_Win32BrowserThread_destroyBrowser
  (JNIEnv *env, jclass clazz, jint);

JNIEXPORT void JNICALL Java_com_aibonware_viewnaver_browser_win32_Win32BrowserThread_resizeBrowser
  (JNIEnv *, jclass, jint, jint, jint);

JNIEXPORT void JNICALL Java_com_aibonware_viewnaver_browser_win32_Win32BrowserThread_setBodyHtml
  (JNIEnv *, jclass, jint, jstring);

JNIEXPORT void JNICALL Java_com_aibonware_viewnaver_browser_win32_Win32BrowserThread_insertBodyHtml
  (JNIEnv *, jclass, jint, jstring, jstring);

JNIEXPORT void JNICALL Java_com_aibonware_viewnaver_browser_win32_Win32BrowserThread_replaceBodyHtml
  (JNIEnv *, jclass, jint, jstring, jstring);

JNIEXPORT jstring JNICALL Java_com_aibonware_viewnaver_browser_win32_Win32BrowserThread_getBodyHtml
  (JNIEnv *, jclass, jint);

JNIEXPORT void JNICALL Java_com_aibonware_viewnaver_browser_win32_Win32BrowserThread_setEditable
  (JNIEnv *, jclass, jint, jboolean);

JNIEXPORT void JNICALL Java_com_aibonware_viewnaver_browser_win32_Win32BrowserThread_toggleBold
  (JNIEnv *, jclass, jint);

JNIEXPORT void JNICALL Java_com_aibonware_viewnaver_browser_win32_Win32BrowserThread_setColor
  (JNIEnv *, jclass, jint, jstring);

JNIEXPORT void JNICALL Java_com_aibonware_viewnaver_browser_win32_Win32BrowserThread_insertHR
  (JNIEnv *, jclass, jint);

JNIEXPORT void JNICALL Java_com_aibonware_viewnaver_browser_win32_Win32BrowserThread_toggleItalic
  (JNIEnv *, jclass, jint);

JNIEXPORT void JNICALL Java_com_aibonware_viewnaver_browser_win32_Win32BrowserThread_toggleUnderLine
  (JNIEnv *, jclass, jint);

JNIEXPORT void JNICALL Java_com_aibonware_viewnaver_browser_win32_Win32BrowserThread_setFontName
  (JNIEnv *, jclass, jint, jstring);

JNIEXPORT void JNICALL Java_com_aibonware_viewnaver_browser_win32_Win32BrowserThread_setFontSize
  (JNIEnv *, jclass, jint, jstring);

JNIEXPORT void JNICALL Java_com_aibonware_viewnaver_browser_win32_Win32BrowserThread_scrollTop
  (JNIEnv *, jclass, jint, jstring);

JNIEXPORT void JNICALL Java_com_aibonware_viewnaver_browser_win32_Win32BrowserThread_refreshBrowser
  (JNIEnv *, jclass, jint);

JNIEXPORT void JNICALL Java_com_aibonware_viewnaver_browser_win32_Win32BrowserThread_resetBrowser
  (JNIEnv *, jclass, jint);
}
