#!/usr/bin/perl

#
# dhcpadmin
#
# Copyright (C) 2008 DesigNET, INC.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
#

##########################################################
#
# 饤ȰϿ
#
# $RCSfile: upload.cgi,v $
# $Revision: 1.18 $
# $Date: 2009/01/04 23:57:51 $
#
##########################################################

# 饤֥ɲ
use lib "../lib";

use strict;
use File::Copy;
use CGI;
use Jcode;
use Net::IPv4Addr;

# 饤֥ɤ߹
require "libcommon.pl";
require "libdhcpconfig.pl";
require "libpage.pl";
require "libpost.pl";
require "libhost.pl";
require "librange.pl";
require "upload.pl";

##########################################################
# ڡѥå
##########################################################
package mypage;

my $body;

use vars qw(@ISA);

#
# pageλҥ饹
#
@ISA = qw(page);
sub new
{
    bless {};
}

#
# ɽ
#
sub display_body
{
    print $body;
}

##########################################################
# ᥤѥå
##########################################################
package main;

##########################################################
# 
##########################################################

my $q = new CGI;
my $ret;
my %conf;
my $msg;
my @errmsg;
my $linkflag = 1;
my $ref = $q->param('REF');
my $SEARCHSTR = "search";         # searchʸ
my $DESTFILE = "host_search.cgi"; # ѥե̾

# 
if (dhcp_init(\%conf, $linkflag, $ref, \@errmsg) != 0) {
    syserr($errmsg[$main::L_DISP]);
    errlog($errmsg[$main::L_LOG], $conf{'facility'});
    exit 1;
}


##########################################################
# ᥤ
##########################################################

my %chgdata;
my @errmsg;
my $csvfile  = $q->param('csvfile');
my $csvdata;
my $csvnum = 0;
my @tmpsubnet;
my $postdata = "REF=" . $ENV{SCRIPT_NAME};  # ե顼ǡǼ
my %decryptdata;

# å
$errmsg[$main::L_DISP] = $main::LANG{$ENV{$main::DISPLANG}}{'INFO_HOSTUP'};

# ѥǡǼ
$decryptdata{'search'} = $q->param('searchflag');
$decryptdata{'searchsubnet'} = $q->param('searchsubnet');
$decryptdata{'searchhost'} = $q->param('searchhost');
$decryptdata{'searchmacaddr'} = $q->param('searchmacaddr');
$decryptdata{'searchipaddr'} = $q->param('searchipaddr');
$decryptdata{'searchipselect'} = $q->param('searchipselect');

# ʣ粽μ¹
if (hidden_decrypt(\%decryptdata, \%conf, \@errmsg) != 0) {
    # ǧ۾
    syserr($errmsg[$main::L_DISP]);
    errlog($errmsg[$main::L_LOG], $conf{'facility'});
    exit 1;
}

# ǽνɽǡ
if (defined($q->param('csvupload')) == 0 && defined($q->param('back')) == 0) {

    @tmpsubnet = $q->param('subnet');
    foreach (@tmpsubnet) {
        $decryptdata{'searchsubnet'} .= $_ . ",";
    }
    $decryptdata{'searchhost'} = $q->param('host');
    $decryptdata{'searchmacaddr'} = $q->param('macaddr');
    $decryptdata{'searchipaddr'} = $q->param('ipaddr');
    $decryptdata{'searchipselect'} = $q->param('ipselect');

}

# åץɽ
if (defined($q->param('csvupload')) == 1) {

    # å
    undef(@errmsg);
   
    # CSVǡϿ
    $ret = regist_cvs2host($csvfile, \$csvnum, \@errmsg);

    # 
    if ($ret == 0) {
        $errmsg[$main::L_DISP] = $main::LANG{$ENV{$main::DISPLANG}}{'INFO_CSV_UPLOAD1'};
        $errmsg[$main::L_DISP] .= "(" . $csvnum . " ";
        $errmsg[$main::L_DISP] .= $main::LANG{$ENV{$main::DISPLANG}}{'INFO_CSV_UPLOAD2'} . ")";
    }

    # ۾ƥ२顼
    if ($ret == -1) {
        syserr($errmsg[$main::L_DISP]);
        errlog($errmsg[$main::L_LOG], $conf{'facility'});
        exit 1;
    }
}

if (defined($q->param('back')) == 1) {
    # POSTǡκ
    $postdata .= "&searchsubnet=" .  $decryptdata{'searchsubnet'} . "&" .
                 "host=" . $decryptdata{'searchhost'} . "&" .
                 "macaddr=" . $decryptdata{'searchmacaddr'} . "&" .
                 "ipaddr=" . $decryptdata{'searchipaddr'} . "&" .
                 "ipselect=" . $decryptdata{'searchipselect'};

    # ܥ󤬲Ƥ
    if ($decryptdata{'search'} eq $SEARCHSTR) {
        $postdata .= "&search=" .  $decryptdata{'search'};
    }

    # ̤ɽ
    if (location_display($DESTFILE, $postdata, \@errmsg) == -1) {
        syserr($errmsg[$main::L_DISP]);
        errlog($errmsg[$main::L_LOG], $conf{'facility'});
        exit 1;
    }
}

##########################################################
# ƥץ졼֤
##########################################################

my $id = "upload";		# ɽѥڡID

# Ź沽ǡǼ
my %cryptdata = ("SEARCH" => $decryptdata{'search'},
                 "SEARCHSUBNETDATA" => $decryptdata{'searchsubnet'},
                 "SEARCHHOSTDATA" => $decryptdata{'searchhost'},
                 "SEARCHMACADDR" => $decryptdata{'searchmacaddr'},
                 "SEARCHIPADDR" => $decryptdata{'searchipaddr'},
                 "SEARCHSELECT" => $decryptdata{'searchipselect'});

# ǡŹ沽
if (hidden_crypt(\%cryptdata, \%conf, \@errmsg) == -1) {
    # ǧ۾
    syserr($errmsg[$main::L_DISP]);
    errlog($errmsg[$main::L_LOG], $conf{'facility'});
    exit 1;
}

# ִǡγǼ
%chgdata = ("SEARCH" => $q->escapeHTML($cryptdata{'SEARCH'}),
            "SEARCHSUBNETDATA" => $q->escapeHTML($cryptdata{'SEARCHSUBNETDATA'}),
            "SEARCHHOSTDATA" => $q->escapeHTML($cryptdata{'SEARCHHOSTDATA'}),
            "SEARCHMACADDR" => $q->escapeHTML($cryptdata{'SEARCHMACADDR'}),
            "SEARCHIPADDR" => $q->escapeHTML($cryptdata{'SEARCHIPADDR'}),
            "SEARCHSELECT" => $q->escapeHTML($cryptdata{'SEARCHSELECT'}));

# ץ졼
if (page::replace_template($id, \$body, \%chgdata, \@errmsg) == -1) {
    syserr($errmsg[$main::L_DISP]);
    errlog($errmsg[$main::L_LOG], $conf{'facility'});
    exit 1;
}

##########################################################
# ڡɽ
##########################################################

my $tabId = "cli";
my $obj;
my $sys_err;

# ɽʸ<br>ؤѴ
main::conv_br(\$errmsg[$main::L_DISP]);

$obj = new mypage;
if ($obj->display($id, \$sys_err, $tabId, \@errmsg) == -1) {
    syserr($errmsg[$main::L_DISP]);
    errlog($errmsg[$main::L_LOG], $conf{'facility'});
    exit 1;
}

exit 0;
