#!/usr/bin/perl

#
# dhcpadmin
#
# Copyright (C) 2008 DesigNET, INC.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
#

##########################################################
#
# 桼
#
# $RCSfile: usermod.cgi,v $
# $Revision: 1.19 $
# $Date: 2008/12/21 05:00:19 $
#
##########################################################

# 饤֥ɲ
use lib "../lib";

use strict;
use CGI;

# 饤֥ɤ߹
require "libcommon.pl";
require "libpage.pl";
require "libpost.pl";
require "libuser.pl";
require "usermod.pl";

##########################################################
# ڡѥå
##########################################################
package mypage;

my $body;

use vars qw(@ISA);

#
# pageλҥ饹
#
@ISA = qw(page);
sub new
{
    bless {};
}

#
# 
#
sub display_logout
{
}

#
# ɽ
#
sub display_body
{
    print $body;
}

#
# 
#
sub display_tab
{
}

##########################################################
# ᥤѥå
##########################################################
package main;

##########################################################
# 
##########################################################

my $q = new CGI;
my %conf;
my $msg;
my @errmsg;
my $linkflag = 1;
my $ref = $q->param('REF');
my $LOCATIONDEST = "userlist.cgi";
my $MYPAGE = "usermod.cgi";
my $postdata = "REF=usermod.cgi";  # ե顼ǡǼ
my $postset = $q->param('postset');
my $MSGOK = "RET:OK";

# 
if (dhcp_init_nosession(\%conf, $linkflag, $ref, \@errmsg) == -1) {
    syserr($errmsg[$main::L_DISP]);
    postend($postset, $errmsg[$main::L_DISP]);
    errlog($errmsg[$main::L_LOG], $conf{'facility'});
    exit 1;
}

##########################################################
# ᥤ
##########################################################

my %chgdata;
my $ret;
my $listhtml;
my $syserr;
my %serverlist;
my $mainflg;
my $message;
my @postserverlist;
my $user = $q->param('user');
my $pass = $q->param('passwd');
my $vpass = $q->param('vpasswd');
my %decryptdata;

# ʣ粽Ϣ˳Ǽ
if (defined($q->param('mod')) == 1) {
    $decryptdata{'USER'} = $user;

    # ʣ粽μ¹
    if (hidden_decrypt(\%decryptdata, \%conf, \@errmsg) != 0) {
        errlog($errmsg[$main::L_LOG], $conf{'facility'});
	postend($postset, $errmsg[$main::L_DISP]);
        syserr($errmsg[$main::L_DISP]);
        exit 1;
    }
    $user = $decryptdata{'USER'};
}

# 
if (defined($q->param('back')) == 1) {

    # ڡɽ
    if (location_display($LOCATIONDEST, $postdata, \@errmsg) == -1) {
        syserr($errmsg[$main::L_DISP]);
        errlog($errmsg[$main::L_LOG], $conf{'facility'});
        exit 1;
    }
}

# ѹܥ󲡲
if (defined($q->param('mod')) == 1) {

    # а
    if (read_serverlist(\%serverlist, \$mainflg, \@errmsg) == -1) {
        errlog($errmsg[$main::L_LOG], $conf{'facility'});
	postend($postset, $errmsg[$main::L_DISP]);
        syserr($errmsg[$main::L_DISP]);
        exit 1;
    }

    # 桼ѹ
    $ret = mod_user($user, $pass, $vpass, \@errmsg);

    # ƥ२顼
    if ($ret == -1) {
	errlog($errmsg[$main::L_LOG], $conf{'facility'});
	postend($postset, $errmsg[$main::L_DISP]);
	syserr($errmsg[$main::L_DISP]);
	exit 1;
    }

    # ѹ
    if ($ret == 1) {

	# POSTǤΤϽλ
	postend($postset, $errmsg[$main::L_DISP]);
    }

    # ѹ
    if ($ret == 0) {

	# POSTǤΤϽλ
	postend($postset, $MSGOK);

	# ѹå
	$message = $main::LANG{$ENV{$main::DISPLANG}}{'INFO_USER_MESSAGE3'} . "(" .
		   $q->escape($q->escapeHTML($user)) . ")\n";;

        # POST(ФޥФλ)
        if ($mainflg == 1) {

            # POSTоݥФ
            make_serverlist(\%serverlist, \@postserverlist, $MYPAGE);

            # POSTоݥФ
            if (@postserverlist > 0) {

		# 
                $postdata .= "&mod=1&user=" . $q->escape($q->param('user')) .
			     "&passwd=" . $q->escape($pass) .
			     "&vpasswd=" . $q->escape($vpass);

                # POST
	        $ret = send_allpost(\@postserverlist, $postdata, \@errmsg);
                if ($ret == -1) {
		    errlog($errmsg[$main::L_LOG], $conf{'facility'});
                    syserr($errmsg[$main::L_DISP]);
                    exit 1;
                }
                if ($ret == 1) {
                    $message = $errmsg[$main::L_DISP];
                }
	    }
        }

        # 
        $postdata .= "&dispmsg=" . $message;

        # 
        $ret = location_post_method(\%serverlist, $LOCATIONDEST, $postdata, \@errmsg);
        if ($ret < 0) {
            syserr($errmsg[$main::L_DISP]);
            errlog($errmsg[$main::L_LOG], $conf{'facility'});
            exit 1;
        }
    }
}

# POSTǤΤϽλ
postend($postset, $main::LANG{$ENV{$main::DISPLANG}}{'ERR_USER_MOD'});

##########################################################
# ƥץ졼֤
##########################################################

my $id = "usermod";		# ɽѥڡID
my %cryptdata;

# Ź沽ǡǼ
$cryptdata{'USER'} = $user;

# ǡŹ沽
if (hidden_crypt(\%cryptdata, \%conf, \@errmsg) == -1) {
    # ǧ۾
    syserr($errmsg[$main::L_DISP]);
    errlog($errmsg[$main::L_LOG], $conf{'facility'});
    exit 1;
}

# ɽѤִǡ
$chgdata{'USER'} = $q->escapeHTML($user);

# Ѥִǡ
$chgdata{'HIDDENUSER'} = $q->escapeHTML($cryptdata{'USER'});

# ץ졼
$ret = page::replace_template($id, \$body, \%chgdata, \@errmsg);
if ($ret != 0) {
    syserr($errmsg[$main::L_DISP]);
    errlog($errmsg[$main::L_LOG], $conf{'facility'});
    exit 1;
}

##########################################################
# ڡɽ
##########################################################

my $tabId = "usermod";
my $obj;

# ɽʸ<br>ؤѴ
main::conv_br(\$errmsg[$main::L_DISP]);

$obj = new mypage;
$ret = $obj->display($id, \$syserr, $tabId, \@errmsg);
if ($ret != 0) {
    syserr($errmsg[$main::L_DISP]);
    errlog($errmsg[$main::L_LOG], $conf{'facility'});
    exit 1;
}

exit 0;
