#
# dhcpadmin
#
# Copyright (C) 2008 DesigNET, INC.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
#

##########################################################
#
# host_add.cgi
#
# $RCSfile: host_add.pl,v $
# $Revision: 1.11 $
# $Date: 2009/01/05 07:43:59 $
#
##########################################################

use strict;
use Jcode;

# ؿ⥰Хѿ

my $HOSTNAME = 0;
my $MACADDRESS = 1;
my $IPADDR = 2;
my $BOOTING_FLAG = 3;

my $DELSUBNRT = 0;
my $DELMACADDRESS = 1;
my $DELHOSTNAME = 2;

# IP߽
my $ALLOW_DENY_BOOTING = "noselect";
my $ALLOW_STR = "allow";
my $DENY_STR = "deny";
my $ALLOW_JP_STR = "";
my $DENY_JP_STR = "";

# ֤ʸκ
my $REPLACESTR = $WORKDIR . "\/";

#
# hostοϿ
#
# 
#	arg0	Ͽ륵֥ͥåȥǥ쥯ȥ̾
#	arg1	Ͽۥ̾
#	arg2	ϿMACɥ쥹
#	arg3	ϿIPɥ쥹
#	arg4	ϿIP߽
#	arg5	顼å
#
# ֤
#	0	   
#	-1	  顼
#

sub add_host
{
    my ($subnetpath, $hostdata, $convmacdata, $ipaddr, $ipflag, $errmsg) = @_;
    my $addline;
    my $filepath;

    # ɲäʸκ
    $addline = sprintf("%s,%s,%s,%s\n", $hostdata, $convmacdata ,$ipaddr, $ipflag);

    # ե̾κ
    $subnetpath =~ s/\//-/g;
    $filepath = $WORKDIR . "/" . $subnetpath . "/host";

    # ɵ
    if (append_file($filepath, $addline, $errmsg) < 0) {
        return -1;
    }

    return 0;
}

#
# hostι
#
# 
#	arg0	Ͽ륵֥ͥåȥǥ쥯ȥ̾
#	arg1	Ͽۥ̾
#	arg2	ϿMACɥ쥹
#	arg3	ϿIP߽
#	arg4	륵֥ͥå̾
#	arg5	ۥ̾
#	arg6	MACɥ쥹
#	arg7	ѴMACɥ쥹
#	arg8	顼å
#
# ֤
#	0	
#	-1	顼
#

sub mod_host
{
    my ($subnet, $host, $macaddr, $ipaddr, $ipselect, $modsubnet, $modhost,
        $modmacaddr, $modipaddr, $convmac, $errmsg) = @_;

    my $addline;
    my $newfilepath;
    my $oldhostpath;
    my $tmphostpath;
    my $newfilename;
    my $filename;
    my $line;
    my @value;
    my $writeline;

    # ɲäʸκ
    $addline = sprintf("%s,%s,%s,%s\n", $host, $convmac, $ipaddr, $ipselect);

    # ¸Υե̾κ
    $filename = $modsubnet;
    $filename =~ s/\//-/g;
    $oldhostpath =$WORKDIR . "/" . $filename . "/host";

    # ե̾κ
    $tmphostpath = $WORKDIR . "/" . $filename . "/host.tmp";

    # եΥץ
    if (open(IN, $oldhostpath) == 0) {
        $$errmsg[$L_DISP] = $LANG{$ENV{$DISPLANG}}{'ERR_TMP_FILE1'} . "(" 
                           . $oldhostpath .  ")";
        $$errmsg[$L_LOG] = $LANG{$LOGLANG}{'ERR_TMP_FILE1'} . "(" . 
                           $oldhostpath . ")";
    }

    while (<IN>) {

        # ʸѴ
        $line = $_;

        # ʬ
        @value = split(/,/, $line);

        # оݤΰԤ
        if (lc($value[$MACADDRESS]) eq lc($modmacaddr) &&
            ($value[$IPADDR] eq $modipaddr)) {

            # subnetƱ
            if ($subnet ne $modsubnet) {

                # subnet̤ξ
                next;
            }

            # Ԥ
            $line = $addline;
        }

        # 񤭹ʸɵ
        $writeline .= $line;
    }

    # 
    close(IN);

    # եؽ񤭹
    if (write_file($tmphostpath, $writeline, $errmsg) < 0) {
        return -1;
    }

    # եΥ͡
    if (rename($tmphostpath, $oldhostpath) == 0) {
        $$errmsg[$L_DISP] = $LANG{$ENV{$DISPLANG}}{'ERR_RENAME_FILE'} . "(" 
                            . $tmphostpath . "<br>->" . $oldhostpath .  ")";
        $$errmsg[$L_LOG] = $LANG{$LOGLANG}{'ERR_RENAME_FILE'} . "(" . 
                           $tmphostpath . "->" . $oldhostpath . ")";
        return -1;
    }

    # ֥ͥåȤѹʤä硢λ
    if ($subnet eq $modsubnet) {
        return 0;
    }

    # ɲäե̾κ
    $newfilename = $subnet;
    $newfilename =~ s/\//-/g;
    $newfilepath = $WORKDIR . "/" . $newfilename . "/host";

    # ɵ
    if (append_file($newfilepath, $addline, $errmsg) < 0) {
        return -1;
    }

    return 0;
}

#
# ɲɬܹܤΥå
#
# 
#	arg0	Ϥ줿(Ϥ)
#	arg1	ѴMACɥ쥹(Ϥ)
#	arg2	顼å
#
# ֤
#	0	
#	1	顼
#

sub check_additem
{
    my ($subnet, $host, $macaddr, $convmac, $ipaddr, $errmsg) = @_;
    my $ret = 0;

    # subnetɬܥå
    if ($subnet eq "") {
        $$errmsg[$L_DISP] = $LANG{$ENV{$DISPLANG}}{'ERR_SUBNET_DATA8'};
        return 1;
    }

    # hostɬܥå
    if ($host eq "") {
        $$errmsg[$L_DISP] = $LANG{$ENV{$DISPLANG}}{'ERR_HOST_DATA'};
        return 1;
    }

    # MACɥ쥹ɬܥå
    if ($macaddr eq "") {
        $$errmsg[$L_DISP] = $LANG{$ENV{$DISPLANG}}{'ERR_MACADDR_DATA'} ;
        return 1;
    }

    # ֥ͥåȤΥå & ۥ̾,MACɥ쥹ηå
    if (check_subnet($subnet, $ipaddr, $errmsg) > 0 || 
        check_client($host, $macaddr, $convmac, $ipaddr, $errmsg) > 0) {
        return 1;
    }

    return 0;
}

#
# hostνʣå()
#
# 
#	arg0	åۥ̾
#	arg1	ۥȾ
#	arg2	顼å
#
# ֤
#	0	
#	1	ʣ顼
#

sub check_dup_host
{
    my ($checkhostname, $allhostlist, $errmsg) = @_;
    my $subnet;
    my $macaddr;
    my @hostname;

    foreach $subnet (keys %$allhostlist) {

        foreach $macaddr (keys %{$$allhostlist{$subnet}}) {

            # ۥ̾νʣå
            @hostname = keys %{$$allhostlist{$subnet}{$macaddr}};

            if ($checkhostname eq $hostname[0]) {
                $$errmsg[$L_DISP] = $LANG{$ENV{$DISPLANG}}{'ERR_DUPULICATE_HOST'}
                                    . "(" . $checkhostname . ")";
                $$errmsg[$L_LOG] = $LANG{$LOGLANG}{'ERR_DUPULICATE_HOST'} . "("
                                    . $checkhostname . ")";
                return 1;
            }
        }
    }

    return 0;
}

#
# IPɥ쥹νʣå
#
# 
#       arg0    IPɥ쥹ΰ
#       arg1    åIPɥ쥹
#       arg2    ۥȾ
#       arg3    ֥ͥå
#       arg4    顼å
#
# ֤
#       0       
#       1       ʣ顼
#

sub check_dup_ipaddr
{
    my ($alliplist, $checkipaddr, $subnet, $errmsg) = @_;
    my $ret;
    my $addmsg = "(" . $checkipaddr . ")";

    # ʤåʤ
    if ($checkipaddr eq "") {
        return 0;
    }

    # ϥեѴ
    $subnet =~ s/\//\-/;

    # IPɥ쥹νʣå
    if (defined($$alliplist{$subnet}{$checkipaddr}) == 1) {
        $$errmsg[$L_DISP] = $LANG{$ENV{$DISPLANG}}{'ERR_DUPULICATE_IP'};
        $$errmsg[$L_DISP] .= $addmsg;
        return 1;
    }

    $ret = check_ipformat($subnet, $checkipaddr, $addmsg, $errmsg);

    return $ret;
}

#
# MACɥ쥹νʣå()
#
# 
#	arg0	åMACɥ쥹
#	arg1	ۥȾ
#	arg2	֥ͥå
#	arg3	顼å
#
# ֤
#	0	
#	1	ʣ顼
#

sub check_dup_macaddr
{
    my ($checkmacaddr, $allhostlist, $subnet, $errmsg) = @_;
    my $convmacaddr;

    # ʸѴ
    $convmacaddr = lc($checkmacaddr);

    # ϥեѴ
    $subnet =~ s/\//\-/;

    # MACɥ쥹νʣå
    if (defined($$allhostlist{$subnet}{$convmacaddr})) {
        $$errmsg[$L_DISP] = $LANG{$ENV{$DISPLANG}}{'ERR_DUPULICATE_MAC'} .
                            "(" . $checkmacaddr . ")";
        $$errmsg[$L_LOG] = $LANG{$LOGLANG}{'ERR_DUPULICATE_MAC'} . "("
                            . $checkmacaddr . ")";
        return 1;
    }

   return 0;
}

#
# ɲûνʣå
#
# 
#	arg0	ޤޤsubnet̾
#	arg1	åۥ̾
#	arg2	åMACɥ쥹
#	arg3	åIPɥ쥹
#	arg4	顼å
#
# ֤
#	0	
#	1	ʣ顼
#	-1	ƥ२顼
#

sub check_dup_add
{
    my ($subnet, $checkhostname, $checkmacaddr, $checkipaddr, $errmsg) = @_;
    my $ret;
    my %allhostlist;
    my %alliplist;

    # ۥȾɤ߽Ф
    if (read_allhost(\%allhostlist, \%alliplist, $errmsg) == -1) {
        return -1;
    }

    # subnetΥۥ̾Υå
    if (check_dup_host($checkhostname, \%allhostlist, $errmsg) == 1) {
        return 1;
    }

    # MACɥ쥹Υå
    if (check_dup_macaddr($checkmacaddr, \%allhostlist, $subnet, $errmsg) == 1) {
        return 1;
    }

    # IPɥ쥹Υå
    if (check_dup_ipaddr(\%alliplist, $checkipaddr, $subnet, $errmsg) == 1) {
        return 1;
    }

    return 0;
}

#
# νʣå
#
# 
#	arg0	Ϥ줿
#	arg1	顼å
#
# ֤
#	0	
#	1	ʣ顼
#	-1	ƥ२顼
#

sub check_dup_mod
{
    my ($subnet, $host, $macaddr, $convmacaddr, $ipaddr, $modsubnet,
        $modhost, $modmacaddr, $modipaddr, $errmsg) = @_;
    my %allhostlist;
    my %alliplist;
 
    # ۥȾɤ߽Ф
    if (read_allhost(\%allhostlist, \%alliplist, $errmsg) == -1) {
        return -1;
    }

    # MACɥ쥹ѹƤ
    if (lc($convmacaddr) ne lc($modmacaddr) || ($subnet ne $modsubnet)) {
        if (check_dup_macaddr($convmacaddr, \%allhostlist, $subnet, $errmsg) == 1) {
            return 1;
        }
    }

    # IPɥ쥹ѹƤ
    if (($ipaddr ne $modipaddr) || ($subnet ne $modsubnet)) {
        if (check_dup_ipaddr(\%alliplist, $ipaddr, $subnet, $errmsg) == 1) {
            return 1;
        }
    }

    # subnetѹʤhostѹξ硢hostå
    if ($host ne $modhost) {
        if (check_dup_host($host, \%allhostlist, $errmsg) == 1) {
            return 1;
        }
    }

    return 0;
}

#
# å&ɲ
#
# 
#	arg0	֥ͥå
#	arg1	ۥ
#	arg2	MACɥ쥹
#	arg3	IPɥ쥹
#	arg4	߽е
#	arg5	顼å
#
# ֤
#	0	
#	1	ʣ顼
#	-1	ƥ२顼
#

sub check_add_host
{
    my ($subnet, $host, $macaddr, $ipaddr, $ipselect, $errmsg) = @_;
    my $ret;
    my $convmac;

    # å
    if (check_additem($subnet, $host, $macaddr, \$convmac, $ipaddr, $errmsg) == 1) {
        return 1;
    }

    # ʣå
    $ret = check_dup_add($subnet, $host, $convmac, $ipaddr, $errmsg);
    if ($ret != 0) {
        return $ret;
    }

    # ɲ
    if (add_host($subnet, $host, $convmac, $ipaddr, $ipselect, $errmsg) == -1) {
        return -1;
    }

    return 0;

}

#
# å&
#
# 
#	arg0	֥ͥå
#	arg1	ۥ
#	arg2    MACɥ쥹
#	arg3    ipɥ쥹
#	arg4    ݵ
#	arg5    ѹ֥ͥå
#	arg6    ѹۥ
#	arg7    ѹMAC
#	arg8    顼å
#
# ֤
#	0	
#	1	ʣ顼
#	-1	ƥ२顼
#

sub check_mod_host
{
    my ($subnet, $host, $macaddr, $ipaddr, $ipselect, $modsubnet, $modhost, $modmacaddr,
        $modipaddr, $errmsg) = @_;
    my $ret;
    my $convmac;

    # å
    if (check_additem($subnet, $host, $macaddr, \$convmac, $ipaddr, $errmsg) == 1) {
        return 1;
    }

    # ʣå
    $ret = check_dup_mod($subnet, $host, $macaddr, $convmac, $ipaddr, $modsubnet, 
                         $modhost, $modmacaddr, $modipaddr, $errmsg);
    if ($ret != 0) { 
        return $ret;
    }

    # 
    if (mod_host($subnet, $host, $macaddr, $ipaddr, $ipselect, $modsubnet, $modhost,
                    $modmacaddr, $modipaddr, $convmac, $errmsg) == -1) {
        return -1;
    }

    return 0;
}

1;
