#
# dhcpadmin
#
# Copyright (C) 2008 DesigNET, INC.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
#

##########################################################
#
# lease_search.cgi
#
# $RCSfile: lease_search.pl,v $
# $Revision: 1.31 $
# $Date: 2009/01/20 03:17:57 $
#
##########################################################

use Time::Local;

# ؿ⥰Хѿ

my $JSTFLAG = 0;
my $GMTFLAG = 1;
my $GMTTIME = 32400;

#
# 
#
# []
#       arg0    ߽ϳǯ
#       arg1    ߽ϳϷ
#       arg2	߽ϳ
#       arg3	߽Ͻλǯ
#       arg4	߽Ͻλ
#       arg5	߽Ͻλ
#       arg6	߽д¡ϳǯ
#       arg7	߽д¡ϳϷ
#       arg8	߽д¡ϳ
#       arg9	߽д¡Ͻλǯ
#       arg10	߽д¡Ͻλ
#	arg11	߽д¡Ͻλ
#	arg12	
#	arg13	
#	arg14	ִϢ
#	arg15	顼å
#
# [֤]
#       0       OK
#      -1       ƥ२顼
#

sub search_info
{
    my ($ssyear, $ssmon, $ssday,
	$seyear, $semon, $seday,
	$esyear, $esmon, $esday,
	$eeyear, $eemon, $eeday,
	$word, $conf, $chgdata, $errmsg) = @_;
    my $searchword;
    my $sstart;
    my $send;
    my $estart;
    my $eend;
    my @dummy;

    $searchword = $word;

    # ͭ(ͥå)
    if ($word ne "") {

	# ϥå(IPɥ쥹)
	if (check_ipaddr($word, \@dummy) != 0) {

	    # ϥå(MACɥ쥹)
	    if (check_macaddr($word, \$searchword, \@dummy) != 0) {
		$$errmsg[$L_DISP] = $LANG{$ENV{$DISPLANG}}{'ERR_SEARCH_INPUT1'};
		return 1;
	    }
	}
    }

    # ߽å
    if (check_date($ssyear, $ssmon, $ssday, $seyear, $semon, $seday, \$sstart,
		   \$send, $errmsg) == 1) {
	$$errmsg[$L_DISP] = $LANG{$ENV{$DISPLANG}}{'ERR_LENT_START'} . $$errmsg[$L_DISP];
	return $ret;
    }

    # ߽д¥å
    if (check_date($esyear, $esmon, $esday, $eeyear, $eemon, $eeday, \$estart,
		   \$eend, $errmsg) == 1) {
	$$errmsg[$L_DISP] = $LANG{$ENV{$DISPLANG}}{'ERR_LENT_END'} . $$errmsg[$L_DISP];
	return $ret;
    }

    # 
    $ret = get_lease_data($$conf{'leaseslistnum'}, $$conf{'tac'}, $$conf{'dhcplease'},
			  $searchword, $sstart, $send, $estart, $eend, $chgdata, $errmsg);
    if ($ret != 0) {
	return $ret;
    }

    return 0;
}

#
# lease
#
# []
#       arg0    ɽ
#       arg1    tacޥɤΥѥ
#       arg2    ߽оե
#       arg3    ʸ
#	arg4	߽γ
#	arg5	߽νλ
#	arg6	߽д¤γ
#	arg7	߽д¤γ
#       arg8    ִϢ(Ϥ)
#       arg9    顼å
#
# [֤]
#       0       OK
#       1       ߽о̵
#      -1       ƥ२顼
#

sub get_lease_data
{
    my ($maxcount, $taccom, $leasesfile, $searchword, $sstart, $send, $estart, $eend,
	$chgdata, $errmsg) = @_;
    my $matchflg = 0;
    my $count = 0;
    my @line = ();
    my $tmpdisphtml = "";
    my $disphtml = "";

    # leaseեå
    if (!-e $leasesfile) {
        $$errmsg[$main::L_DISP] = $main::LANG{$ENV{$main::DISPLANG}}{'ERR_LEASE_FILE'} .
                                  "(" . $leasesfile . ")";
        $$errmsg[$main::L_LOG] = $main::LANG{$main::LOGLANG}{'ERR_LEASE_FILE'} .
                                  "(" . $leasesfile . ")";
        return -1;
    }
    if (!-r $leasesfile) {
        $$errmsg[$main::L_DISP] = $main::LANG{$ENV{$main::DISPLANG}}{'ERR_LEASE_FILE'} .
                                  "(" . $leasesfile . ")";
        $$errmsg[$main::L_LOG] = $main::LANG{$main::LOGLANG}{'ERR_LEASE_FILE'} .
                                  "(" . $leasesfile . ")";
        return -1;
    }

    # leaseեɹ
    if (open(IN, "$taccom $leasesfile |") == 0) {
        $$errmsg[$main::L_DISP] = $main::LANG{$ENV{$main::DISPLANG}}{'ERR_LEASE_FILE'} .
                                  "(" . $leasesfile . ")";
        $$errmsg[$main::L_LOG] = $main::LANG{$main::LOGLANG}{'ERR_LEASE_FILE'} .
                                  "(" . $leasesfile . ")";
        return -1;
    }

    while(<IN>) {

	# ȡԤ̵
        if (($_ =~ /^#/) || ($_=~ /^$/)) {
            next;
        }

	# ɽȿã齪λ
	if ($count == $maxcount) {
	    last;
	}

	# Ԥ
 	chomp($_);

	# leaseǡ
    	if ($_ =~ /^lease .* {$/) {
    	    push(@lines, $_);
	    # ꡼ե륿(ץǡͭ)
	    if (read2convline(\@lines, \$tmpdisphtml, $sstart, $send, $estart, $eend,
			      $searchword) == 1) {

		# ɽ
		$count++;

		# html
		$disphtml .= $tmpdisphtml;

		# 1ǡhtml
		$tmpdisphtml = "";
	    }

	    # 1ǡ
	    @lines = ();

	    next;
        }

	# Ƭζ򡦥֤ɲ
	$_ =~ s/^\s+//;
	push(@lines, $_);

    }

    # 1߽о󤬤ʤ
    if ($count == 0) {
	$$errmsg[$main::L_DISP] = $main::LANG{$ENV{$main::DISPLANG}}{'ERR_LEASE_NOMATCH'};
    }

    # 
    close(IN);

    # Ǽ
    $$chgdata{'LEASEINFO'} = $disphtml;

    return 0;
}


#
# unixtimeؤѴ
#
# []
#       arg0    Ѵ
#       arg1    Ѵλ(Ϥ)
#       arg2    GMTɤ(0:ܻ,1:GMT)
#
# [֤]
#       0       OK
#

sub conv_unixtime
{
    my ($srctime, $convtime, $gtimeflag) = @_;
    my $date; 
    my $time; 
    my $year; 
    my $month; 
    my $day; 
    my $hour;
    my $min;
    my $sec;

    # ʬ
    ($date ,$time) = split(/ /, $srctime);

    # /ʬ
    ($year, $month, $day) = split(/\//, $date);

    # :ʬ
    ($hour, $min, $sec) = split(/:/, $time);

    # unixtimeѴ
    $$convtime = timelocal($sec, $min, $hour, $day, $month - 1, $year);

    # GMTξ
    if ($gtimeflag == $GMTFLAG) {

        # 9ָ
        $$convtime += $GMTTIME;
    }

    return 0;
}

#
# unixtimeؤѴ(GMT)
#
# []
#       arg0    Ѵ
#       arg1    Ѵλ(Ϥ)
#
# [֤]
#       0       OK
#

sub conv_unixtime_gmt
{
    my ($srctime, $convtime) = @_;

    # GMTѷѴ
    conv_unixtime($srctime, $convtime, $GMTFLAG);

    return 0;
}

#
# unixtimeؤѴ(GMT)
#
# []
#       arg0    Ѵ
#       arg1    Ѵλ(Ϥ)
#
# [֤]
#       0       OK
#

sub conv_unixtime_jst
{
    my ($srctime, $convtime) = @_;

    # GMTѷѴ
    conv_unixtime($srctime, $convtime, $JSTFLAG);

    return 0;
}

#
# ˰פǡ򸡺
#
# []
#       arg0    åǡ
#       arg1    
#
# [֤]
#       0       ǡ԰
#       1       ǡ
#

sub check_search {

    my ($cdata, $search) = @_;

    if ($search eq "") {
        return 1;
    }

    if ($cdata eq $search ) {
        return 1;
    }

    return 0;
}

#
# ֤Υå
#
# []
#       arg0    å
#       arg1    ֤γ
#       arg2    ֤νλ
#
# [֤]
#       0       
#       1       ֳ
#

sub check_time
{
    my ($ctime, $start, $end) = @_;
    my $utime;

    # θ
    if (($start eq "") && ($end eq "")) {
        return 1;
    }

    # UNIXѴ
    conv_unixtime_gmt($ctime, \$utime);

    # ֤
    if (($start <= $utime) && ($utime <= $end)) {
        # 
        return 1;
    }

    return 0;
}

#
# ˰פǡ򸡺
#
# []
#       arg0    ꡼ǡ
#       arg1    HTMLγǼΰ
#       arg2    ߽γ
#       arg3    ߽νλ
#       arg4    ߽д¤γ
#       arg5    ߽д¤νλ
#       arg6    
#
# [֤]
#       0       ǡ԰
#       1       ǡ
#

sub read2convline
{
    my ($data, $htmlline, $lstart, $lend, $estart, $eend, $search) = @_;

    my $starts;
    my $ends;
    my @errmsg;
    my $ipormac;
    my $start = "starts";
    my $line;
    my $startutime;
    my $endutime;

    # dataιɽ
    my $ipline = 8;
    my $macline = 1;
    my $startline = 7;
    my $endline = 6;

    my @sdata;
    my $ip = 0;
    my $mac = 1;

    # MACɥ쥹ΥեޥåȺ
    my $mip = "[0-9a-fA-F][0-9a-fA-F]";
    my $macp = sprintf("(%s:%s:%s:%s:%s:%s)", $mip, $mip, $mip,
                                                    $mip, $mip, $mip);
    # դΥեޥåȺ
    my $tip = "[0-9][0-9]";
    my $starthead = "starts [0-6] ";
    my $stimep = sprintf("(%s%s%s/%s/%s %s:%s:%s)", $starthead, $tip, $tip,
                                                 $tip, $tip, $tip, $tip, $tip);
    my $endhead = "ends [0-6] ";
    my $etimep = sprintf("(%s%s%s/%s/%s %s:%s:%s)", $endhead, $tip, $tip,
                                                 $tip, $tip, $tip, $tip, $tip);
    # IPɥ쥹ΥեޥåȺ
    my $iip = "[0-9]+";
    my $ipp = sprintf("(%s.%s.%s.%s)", $iip, $iip, $iip, $iip);

    # ǡ鸡
    foreach $line (@$data) {

        # ߽θ
        if ($line =~ /$stimep/) {
            $starts = $1;
            $starts =~ s/$starthead//;
            next;
        }

        # λ߽θ
        if ($line =~ /$etimep/) {
            $ends = $1;
            $ends =~ s/$endhead//;
            next;
        }

        # MACɥ쥹θ
        if ($line =~ /$macp/) {
            $sdata[$mac] = $1;
            next;
        }

        # IPɥ쥹θ
        if ($line =~ /$ipp/) {
            $sdata[$ip] = $1;
            next;
        }
    }

    # IPɥ쥹MACɥ쥹Ƚ
    $ipormac = check_ipaddr($search, \@errmsg);

    # UNIXTIMEѴ
    conv_unixtime_gmt($starts, \$startutime);
    conv_unixtime_gmt($ends, \$endutime);

    # HTML
    $$htmlline = "<tr><td class=\"value\">" . unixtime2date($startutime) . "</td>";
    $$htmlline .= "<td class=\"value\">" . $sdata[$mac] . "</td>";
    $$htmlline .= "<td class=\"value\">" . $sdata[$ip] . "</td>";
    $$htmlline .= "<td class=\"value\">" . unixtime2date($endutime) . "</td></tr>\n";

    return check_time($starts, $lstart, $lend) & 
           check_time($ends, $estart, $eend) & 
           check_search($sdata[$ipormac], $search);
}

#
# դΥեޥå
#
# []
#       arg0    UNIXTIME
#
# [֤]
#       ʤ
#

sub unixtime2date
{

    my ($unixtime) = @_;

    my ($sec, $min, $hour, $mday, $mon, $year, $wday, $yday, $isdst) = localtime($unixtime);

    return sprintf("%04d/%02d/%02d %02d:%02d:%02d", 1900 + $year, $mon + 1, $mday, $hour, $min, $sec);

}

#
# դηå
#
# []
#       arg0    ǯ
#       arg1    Ϸ
#       arg2    
#       arg3    λǯ
#       arg4    λ
#       arg5    λ
#       arg6    UNIXॹ(Ϥ)
#       arg7    λUNIXॹ(Ϥ)
#       arg8    顼å
#
# [֤]
#       0       OK
#       1       顼
#

sub check_date
{
    my ($styear, $stmonth, $stday, $endyear, $endmonth, $endday, $startdate, 
        $enddate, $errmsg) = @_;
    my $sret;
    my $eret;
    my $start;
    my $end;
    my $tmpstart;
    my $tmpend;

    $tmpstart = $styear . $stmonth .$stday;
    $tmpstart = $endyear, $endmonth, $endday;


    # ǯå
    $sret = check_startdate($styear, $stmonth, $stday, $startdate, $errmsg);

    # ϥǡ
    if ($sret == 1) {
        return 1;
    }

    # λǯå
    $eret = check_enddate($endyear, $endmonth, $endday, $enddate, $errmsg);

    # ϥǡ
    if ($eret == 1) {
        return 1;
    }

    # ǡϤϤȽλξʤˤϽƽλ
    if (($sret == 2) & ($eret == 2)) {
        $$startdate = "";
        $$enddate = "";
        return 0;
    }

    # ϰϤΥå
    if (check_dateform($startdate, $enddate, $errmsg)) {
        return 1;
    }

    return 0;

}

#
# դηå
#
# []
#       arg0    ǯ
#       arg1    
#       arg2    
#       arg3    顼å
#
# [֤]
#       0       OK
#       1       顼
#

sub is_date {
    my($year, $month, $day, $errmsg) = @_;
    my(@monthlast) = (31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31);

    if ($month < 1 || 12 < $month) {
        $$errmsg[$L_DISP] = $LANG{$ENV{$DISPLANG}}{'ERR_DATE_FORMAT'};
        return 1;
    }

    if ($month == 2) {
        if ( (($year % 4 == 0) && ($year % 100 != 0)) || ($year % 400 == 0) ) {
                $monthlast[1]++;
        }
    }

    if ($day < 1 || $monthlast[$month -1] < $day) {
        $$errmsg[$L_DISP] = $LANG{$ENV{$DISPLANG}}{'ERR_DATE_FORMAT'};
        return 1;
    }

    return 0;
}

#
# դγϡλå
#
# []
#       arg0    
#       arg5    λ
#       arg6    顼å
#
# [֤]
#       0       OK
#       1       顼
#

sub check_dateform
{
    my ($startdate, $enddate, $errmsg) = @_;

    # ϤΤۤ礭ϥ顼
    if ($$startdate > $$enddate) {
        $$errmsg[$L_DISP] = $LANG{$ENV{$DISPLANG}}{'ERR_DATE_RANGE'};
        return 1;
    }

    return 0;
}

#
# å
#
# []
#       arg0    ǯ
#       arg1    
#       arg2    
#       arg3    ॹ(Ϥ) 
#       arg4    顼å
#
# [֤]
#       0       OK
#       1       顼
#       2       ǡ
#

sub check_startdate
{
    my ($year, $month, $day, $date, $errmsg) = @_;
    my $start;

    # å(ƶξ0) 
    if ($year eq "" && $month eq "" && $day eq "") {
        $$date = 0;
        return 2;
    }

    # ͥå
    if (check_date_num($year, $month, $day, $errmsg) != 0) {
        $$errmsg[$L_DISP] = $LANG{$ENV{$DISPLANG}}{'ERR_START'} .
                            $$errmsg[$L_DISP];
        return 1;
    }

    # ¸ߤդå
    if (is_date($year, $month, $day, $errmsg) != 0) {
        $$errmsg[$L_DISP] = $LANG{$ENV{$DISPLANG}}{'ERR_START'} .
                            $$errmsg[$L_DISP];
        return 1;
    }

    # UNIXॹפѴ
    $start = sprintf("%04d/%02d/%02d", $year, $month, $day);
    $start .= " 00:00:00";

    conv_unixtime_jst($start, $date);

    return 0;

}

#
# λå
#
# []
#       arg0    ǯ
#       arg1    
#       arg2    
#       arg3    ॹ(Ϥ) 
#       arg4    顼å
#
# [֤]
#       0       OK
#       1       顼
#       2       ǡ
#

sub check_enddate
{
    my ($year, $month, $day, $date, $errmsg) = @_;
    my $end;
    my ($sec, $min, $hour, $mday, $mon, $yyear, $wday, $yday, $isdst);

    # å(ƶξ0) 
    if ($year eq "" && $month eq "" && $day eq "") {
        ($sec, $min, $hour, $mday, $mon, $yyear,
                                     $wday, $yday, $isdst) = localtime(time());
        $end = sprintf("%04d/%02d/%02d 23:59:59", 1900 + $yyear, $mon + 1, $mday);
        conv_unixtime_jst($end, $date);
        return 2;
    }

    # ͥå
    if (check_date_num($year, $month, $day, $errmsg) != 0) {
        $$errmsg[$L_DISP] = $LANG{$ENV{$DISPLANG}}{'ERR_END'} .
                            $$errmsg[$L_DISP];
        return 1;
    }

    # ¸ߤդå
    if (is_date($year, $month, $day, $errmsg) != 0) {
        $$errmsg[$L_DISP] = $LANG{$ENV{$DISPLANG}}{'ERR_END'} .
                            $$errmsg[$L_DISP];
        return 1;
    }

    # UNIXॹפѴ
    $end = sprintf("%04d/%02d/%02d", $year, $month, $day);
    $end .= " 23:59:59";

    conv_unixtime_jst($end, $date);

    return 0;

}

#
# դοͥå
#
# []
#       arg0    ǯ
#       arg1    
#       arg2    
#       arg3    顼å
#
# [֤]
#       0       OK
#       1       顼
#

sub check_date_num
{
    my ($year, $month, $day, $errmsg) = @_;

    # ǯå
    return check_day($day, $errmsg) |
           check_month($month, $errmsg) |
           check_year($year, $errmsg);
}

#
# å
#
# []
#       arg0    
#       arg1    顼å
#
# [֤]
#       0       OK
#       1       顼
#

sub check_day
{
    my ($day, $errmsg) = @_;

    # å
    if ($day eq "") {
       $$errmsg[$L_DISP] = $LANG{$ENV{$DISPLANG}}{'ERR_DAY_INPUT'};
       return 1;
    }

    # å
    if (length($day) > 2) {
        $$errmsg[$L_DISP] = $LANG{$ENV{$DISPLANG}}{'ERR_DAY_FORMAT'};
        return 1;
    }

    # å
    if (check_num($day) != 0) {
        $$errmsg[$L_DISP] = $LANG{$ENV{$DISPLANG}}{'ERR_DAY_FORMAT'};
        return 1;
    }
    return 0;
}

#
# å
#
# []
#       arg0    
#       arg1    顼å
#
# [֤]
#       0       OK
#       1       顼
#

sub check_month
{
    my ($month, $errmsg) = @_;

    # å
    if ($month eq "") {
       $$errmsg[$L_DISP] = $LANG{$ENV{$DISPLANG}}{'ERR_MONTH_INPUT'};
       return 1;
    }

    # å
    if (length($month) > 2) {
        $$errmsg[$L_DISP] = $LANG{$ENV{$DISPLANG}}{'ERR_MONTH_FORMAT'};
        return 1;
    }

    # å
    if (check_num($month) != 0) {
        $$errmsg[$L_DISP] = $LANG{$ENV{$DISPLANG}}{'ERR_MONTH_FORMAT'};
        return 1;
    }

    return 0;
}

#
# ǯå
#
# []
#       arg0    ǯ
#       arg1    顼å
#
# [֤]
#       0       OK
#       1       顼
#

sub check_year
{
    my ($year, $errmsg) = @_;

    # å
    if ($year eq "") {
       $$errmsg[$L_DISP] = $LANG{$ENV{$DISPLANG}}{'ERR_YEAR_INPUT'};
       return 1;
    }

    # å
    if (length($year) > 4) {
        $$errmsg[$L_DISP] = $LANG{$ENV{$DISPLANG}}{'ERR_YEAR_FORMAT'};
       return 1;
    }

    # å
    if (check_num($year) != 0) {
        $$errmsg[$L_DISP] = $LANG{$ENV{$DISPLANG}}{'ERR_YEAR_FORMAT'};
       return 1;
    }

    # 1970ǯʲǤХ顼
    if ($year < 1970) {
        $$errmsg[$L_DISP] = $LANG{$ENV{$DISPLANG}}{'ERR_YEAR_FORMAT'};
        return 1;
    }

    # 2037ǯ򤳤Ƥ饨顼
    if ($year > 2037) {
        $$errmsg[$L_DISP] = $LANG{$ENV{$DISPLANG}}{'ERR_YEAR_FORMAT'};
        return 1;
    }

    return 0;
}

1;
