#
# dhcpadmin
#
# Copyright (C) 2008 DesigNET, INC.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
#

##########################################################
#
# dhcpե饤֥
#
# $RCSfile: libdhcpconfig.pl,v $
# $Revision: 1.38 $
# $Date: 2009/01/04 23:57:51 $
#
##########################################################

use strict;
use IO::File;

##################饤֥ꥰХ##################
my @subnetitem = (
    "option routers",
    "option subnet-mask",
    "option domain-name-servers",
    "default-lease-time",
    "max-lease-time",
    "option domain-name",
    "range"
);

my %subnetinfo = (
    "option routers" => \&check_datanum3,
    "option subnet-mask" => \&check_datanum3,
    "option domain-name-servers" => \&check_datanum3,
    "default-lease-time" => \&check_datanum2,
    "max-lease-time" => \&check_datanum2,
    "option domain-name" => \&check_datanum3,
    "range" => \&check_datanum3_4
);

my @hostitem = (
    "hardware ethernet",
    "option host-name",
    "booting",
    "fixed-address"
);

my %hostinfo = (
    "hardware ethernet" => \&check_datanum3,
    "option host-name" => \&check_datanum3,
    "booting"=> \&check_datanum2,
    "fixed-address"=> \&check_datanum2
);

# SubnetΥץ

my $OPTION_ROUTERS 	       = 0;
my $OPTION_SUBNET_MASK         = 1;
my $OPTION_DOMAIN_NAME_SERVERS = 2;
my $DEFAULT_LEASE_TIME         = 3;
my $MAX_LEASE_TIME   	       = 4;
my $OPTION_DOMAIN_NAME         = 5;
my $RANGE                      = 6;

# HostΥץ

my $OPTION_HARDWARE_ETHERNET   = 0;
my $OPTION_HOST_NAME           = 1;
my $OPTION_BOOTING             = 2;
my $FIX_IPADDR                 = 3;

# Rangeξ
my $DYNAMIC_BOOTP = "dynamic-bootp";

my $STR_SUBNET = "subnet";
my $STR_HOST = "host";
my $STR_RANGE = "range";
my $STR_END = "}";

# åʸ(booting)
my $STR_ALLOW_BOOTING = "allow";
my $STR_DENY_BOOTING = "deny";

#
# κ
#
# []
#	arg0	(Ϥ)
#	arg1	顼å
#
# [֤]
#	0	OK
#	-1	NG
#
#

sub make_common
{
    my ($common, $errmsg) = @_;
    my $common_file = $WORKDIR . "/common";	# ̥ե

    # եɹ
    if (open(IN, $common_file) == 0) {
	$$errmsg[$L_DISP] = $LANG{$ENV{$DISPLANG}}{'ERR_TMP_FILE1'} . "(" . $common_file .
			    ")";
	$$errmsg[$L_LOG] = $LANG{$LOGLANG}{'ERR_TMP_FILE1'} . "(" . $common_file . ")";
	return -1;
    }

    while (<IN>) {
	$$common .= $_;
    }
    close(IN);

    return 0;
}

#
# ֥ͥåκ
#
# []
#	arg0	
#	arg1	եϥɥ
#	arg2	顼å
#
# [֤]
#	0	OK
#	-1	NG
#
#

sub make_subnet
{
    my ($conf, $fh, $errmsg) = @_;
    my $subnet;
    my $option;
    my $range;
    my $enhance;
    my $host;
    my @dirs;
    my $dir;
    my @list;
    my $ret;

    # workǥ쥯ȥΥǥ쥯ȥ
    if (opendir(DIR, $WORKDIR) != 1) {
	$$errmsg[$L_DISP] = $LANG{$ENV{$DISPLANG}}{'ERR_TMP_DIR1'} . "(" . $WORKDIR . ")";
	$$errmsg[$L_LOG] = $LANG{$LOGLANG}{'ERR_TMP_DIR1'} . "(" . $WORKDIR . ")";
	return -1;
    }
    @dirs = sort grep { -d "$WORKDIR/$_"} readdir(DIR);
    closedir(DIR);

    foreach $dir(@dirs) {

	# 
	$subnet = "";
	$option = "";
	$host = "";
	$range = "";
	$enhance = "";

	# ".",".."ϡ
	if ($dir == "." || $dir == "..") {
	    next;
	}

	# ֥ͥåȡޥμ
	@list = split(/-/, $dir);
	$subnet .= $STR_SUBNET  . " " . $list[0] . " netmask " . $list[1] . " {\n";

	# ץκ
	$ret = make_option($dir, \$option, $errmsg);
	if ($ret < 0) {
	    return -1;
	}
	$subnet .= $option;

	# ϰϾκ
	$ret = make_range($dir, \$range, $errmsg);
	if ($ret < 0) {
	    return -1;
	}
	$subnet .= $range;

	# ĥκ
	$ret = make_ennanceoption($conf, $dir, \$enhance, $errmsg);
	if ($ret < 0) {
	    return -1;
	}

	# ʤä񤭹
	if ($enhance ne "") {
	    $subnet .= $enhance;
	}

	# Ԥ򣱹ɲ
	$subnet .= "\n";

	# ۥȾκ
	$ret = make_host($dir, \$host, $errmsg);
	if ($ret < 0) {
	    return -1;
	}
	$subnet .= $host;

	$subnet .= "}\n";
	print $fh $subnet;

    }

    return 0;
}

#
# ץκ
#
# []
#	arg0	֥ͥåȥǥ쥯ȥ̾
#	arg1	֥ͥåȾ(Ϥ)
#	arg2	顼å
#
# [֤]
#	0	OK
#	-1	NG
#
#

sub make_option
{
    my ($dir, $option, $errmsg) = @_;
    my $option_file = $WORKDIR . "/" . $dir . "/subnet" ;	# ֥ͥåȥե
    my $n = 0;

    # ץեɹ
    if (open(IN, $option_file) == 0) {
	$$errmsg[$L_DISP] = $LANG{$ENV{$DISPLANG}}{'ERR_TMP_FILE1'} . "(" . $option_file .
			    ")";
	$$errmsg[$L_LOG] = $LANG{$LOGLANG}{'ERR_TMP_FILE1'} . "(" . $option_file . ")";
	return -1;
    }

    while (<IN>) {

	chomp($_);

	# ͤȤ
	if ($_ ne "") {

	    # "դʤ
	    if ($n == $OPTION_ROUTERS || $n == $OPTION_SUBNET_MASK ||
	        $n == $OPTION_DOMAIN_NAME_SERVERS || $n == $DEFAULT_LEASE_TIME ||
	        $n == $MAX_LEASE_TIME) {
	        $$option .= "\t" . $subnetitem[$n] . "\t" . $_ . ";\n";

	    # "դ(domain-name)
	    } else {
	        $$option .= "\t" . $subnetitem[$n] . "\t\"" . $_ . "\";\n";
	    }
	}

	$n++;
    }
    close(IN);

    return 0;
}

#
# ϰϾκ
#
# []
#	arg0	֥ͥåȥǥ쥯ȥ̾
#	arg1	ϰ(Ϥ)
#	arg2	顼å
#
# [֤]
#	0	OK
#	-1	NG
#
#

sub make_range
{
    my ($dir, $range, $errmsg) = @_;
    my $range_file = $WORKDIR . "/" . $dir . "/range" ;	# 󥸥ե
    my @list;

    # rangeե뤬¸ߤɤ߹
    if (!-e $range_file ) {
        return 0;
    }

    # ϰϾեɹ
    if (open(IN, $range_file) == 0) {
	$$errmsg[$L_DISP] = $LANG{$ENV{$DISPLANG}}{'ERR_TMP_FILE1'} . "(" . $range_file .
			    ")";
	$$errmsg[$L_LOG] = $LANG{$LOGLANG}{'ERR_TMP_FILE1'} . "(" . $range_file . ")";
	return -1;
    }

    while (<IN>) {

	chomp($_);

	@list = split(/,/, $_);

        # dynamic-bootpե饰Ǥ(ͤȤ)
        if ($list[2] ne "") {
	    $$range .= "\t" . $STR_RANGE . " " . $list[2] . "\t" . $list[0] . " " .
		       $list[1] . ";\n";
	} else {
	    $$range .= "\t" . $STR_RANGE . "\t" . $list[0] . " " . $list[1] . ";\n";
	}

    }
    close(IN);

    return 0;
}

#
# ĥץκ
#
# []
#	arg0	
#	arg1	֥ͥåȥǥ쥯ȥ̾
#	arg2	ĥץ(Ϥ)
#	arg3	顼å
#
# [֤]
#	0	OK
#	-1	NG
#
#

sub make_ennanceoption
{
    my ($conf, $dir, $ennanceoption, $errmsg) = @_;
    my $ennance_file = $WORKDIR . "/" . $dir . "/option" ;	# ĥץե
    my @list;
    my $option;

    if (defined($$conf{'optionname'}) == 0) {
        return 0;
    }

    # ĥץե뤬λϲ⤷ʤ
    if (!-e $ennance_file || -z $ennance_file) {
	return 0;
    }

    # ĥץեɹ
    if (open(IN, $ennance_file) == 0) {
	$$errmsg[$L_DISP] = $LANG{$ENV{$DISPLANG}}{'ERR_TMP_FILE1'} . "(" .
			    $ennance_file . ")";
	$$errmsg[$L_LOG]  = $LANG{$LOGLANG}{'ERR_TMP_FILE1'} . "(" . $ennance_file . ")";
	return -1;
    }

    # 1ԤΤ߼
    $option = <IN>;
    chomp($option);
    $$ennanceoption .= "\t" . $$conf{'optionname'} . " " . $option . ";\n";

    close(IN);

    return 0;
}

#
# ۥȾκ
#
# []
#	arg0	֥ͥåȥǥ쥯ȥ̾
#	arg1	ۥȾ(Ϥ)
#
# [֤]
#	0	OK
#

sub make_host
{
    my ($dir, $host, $errmsg) = @_;
    my $host_file = $WORKDIR . "/" . $dir . "/host" ;	# 󥸥ե
    my @list;

    # ۥȾɹ
    if (open(IN, $host_file) == 0) {

	# ƥ२顼ʥե뤬¸ߤ
	if (-f $host_file) {
	    $$errmsg[$L_DISP] = $LANG{$ENV{$DISPLANG}}{'ERR_TMP_FILE1'} . "(" . $host_file .
			        ")";
	    $$errmsg[$L_LOG] = $LANG{$LOGLANG}{'ERR_TMP_FILE1'} . "(" . $host_file . ")";
	    return -1;
	}
    }

    while (<IN>) {

	chomp($_);

	@list = split(/,/, $_);
	$$host .= "\t" . $STR_HOST . " " . $list[0] . " {\n";
	$$host .= "\t\t" . $hostitem[$OPTION_HARDWARE_ETHERNET] . " " . $list[1] . ";\n";
	$$host .= "\t\t" . $hostitem[$OPTION_HOST_NAME] . " \"" . $list[0] . "\";\n";

        # fixed-address
        if ($list[2] ne "") {
	    $$host .= "\t\t" . $hostitem[$FIX_IPADDR] . " " . $list[2] . ";\n";
        }

	$$host .= "\t\t" . $list[3] . " " . $hostitem[$OPTION_BOOTING] . ";\n";
	$$host .= "\t}\n";

    }
    close(IN);

    return 0;
}

#
# dhcpd.confեκ
#
# []
#	arg1	
#	arg0	顼å
#
# [֤]
#	0	OK
#	-1	NG
#
#

sub make_conf
{
    my ($conf, $errmsg) = @_;
    my $ret;
    my $common;
    my $subnet;
    my $fh;

    # dhcpd.confեΥץ
    if (open($fh, ">$DHCPDCONFTMP") == 0) {
	$$errmsg[$L_DISP] = $LANG{$ENV{$DISPLANG}}{'ERR_TMP_FILE1'} . 
                            "(" . $DHCPDCONFTMP .  ")";
	$$errmsg[$L_LOG] = $LANG{$LOGLANG}{'ERR_TMP_FILE1'} . 
                           "(" . $DHCPDCONFTMP . ")";
	return -1;
    }

    # κ
    $ret = make_common(\$common, $errmsg);
    if ($ret != 0) {
        close($fh);
	return -1;
    }

    # 񤭽Ф
    print $fh $common;

    # ֥ͥåκ
    $ret = make_subnet($conf, $fh, $errmsg);
    if ($ret != 0) {
        close($fh);
	return -1;
    }

    close($fh);

    return 0;
}

#
# dhcpd.confեβ
#
# 
#	arg0	եξ(Ϥ)
#	arg1	顼å
#
# ֤
#	0	
#	1	subnet,host顼
#	-1	ץ顼
#

sub analyze_dhcpd_conf 
{
    my ($conf, $errmsg) = @_;
    my $linenum;
    my $commonline;
    my $line;
    my $checkflag = 0;
    my $fd;
    my $subnetline;
    my $optionname = "";

    # 켡եκ
    if (del_tmpfile($errmsg) < 0 ) { 
        return -1;
    }

    # dhcpd.confɤ߹
    if (open($fd, $DHCPDCONF) == 0) {
        $$errmsg[$L_DISP] = $LANG{$ENV{$DISPLANG}}{'ERR_DHCPD_FILE1'} . "(" 
                            . $DHCPDCONF . ")";
        $$errmsg[$L_LOG] = $LANG{$LOGLANG}{'ERR_DHCPD_FILE1'} . "(" 
                           . $DHCPDCONF . ")";
        return -1;
    }

    # κ
    if (read_common($fd, \$linenum, \$subnetline, $errmsg) < 0) {
        return -1;
    }

    # ĥץ󤬤硢˳Ǽ
    if (defined($$conf{'optionname'}) == 1) {
        $optionname = $$conf{'optionname'};
    }

    # subnetǡ
    if (eof($fd) != 1) {

        # subnetǥ쥯ȥ
        read_subnet($fd, \$linenum, \$subnetline, \$checkflag, $optionname, 
                    $errmsg);
    } 

    close(IN);
    
    return $checkflag;
}

#
# ɤ߹
#
# 
#	arg0	եΥǥץ
#	arg1	ԿʻϤ
#	arg2	subnetΰܡʻϤ
#	arg3	顼åʻϤ
#
# ֤
#	0	
#	-1	ƥ२顼
#

sub read_common 
{
    my ($fd, $linenum, $subnetline, $errmsg) = @_;
    my $line;
    my $commonline;
    my $commonfile;
    my $subnetstr;  # åʸ

    # åʸκ
    $subnetstr = '^' . $STR_SUBNET . '\s+.*{$';

    # 
    $commonline = "";

    for (;($line !~ /$subnetstr/) && (eof($fd) != 1); $line = <$fd>) {
        $$linenum++;

        # ɵ
        $commonline .= $line;
    }

    # subnet饤Ǽ
    if ($line !~ /$subnetstr/) {
        $commonline .= $line;
    } else {
        $$subnetline = $line;
    }

    # 켡ե()
    $commonfile = $WORKDIR . "/common";
    if (write_file($commonfile, $commonline, $errmsg)) {
        return -1;
    }

    return 0;
}

#
# subnetɤ߹
#
# 
#	arg0	եΥǥץ
#	arg1	ԿʻϤ
#	arg2	subnetΰܡʻϤ
#	arg3	顼ѥե饰(:0,顼:1)
#	arg4	ĥץ
#	arg5	顼å
#
# ֤
#	   0	
#

sub read_subnet 
{
    my ($fd, $linenum, $firstsubnetline, $checkflag, $optionname, $errmsg) = @_;
    my $line;
    my $sknum = 1;            # Ϥޤγ̤ο subnetϤޤäƤ
    my $eknum = 0;            # γ̤ο
    my @subnetline;
    my $slinenum = $$linenum; # subnetκǽιԿǼ
    my $ret;
    my $subnetdirname;
    my $subnetstr;            # åʸ
    my $hoststr; 

    # åʸκ
    $subnetstr = '^' . $STR_SUBNET . '\s+.*{$';
    $hoststr = '^' . $STR_HOST . '\s+.*{$';

    # subnet ..{ ޤǤޤ魯
    for (;($line !~ /$subnetstr/) && (eof($fd) != 1);) {

        # 1ɤ߹
        $line = <$fd>;

        # Կ
        $$linenum++;

        # Ƭζ򡢥֤
        $line =~ s/^\s+//g;

        # Ժ
        chomp($line);

        # host start å
        if ($line =~ /$hoststr/) {
            $sknum++;
        }

        # subnet host end å
        if ($line =~ /^}$/) {
            $eknum++;
        }

        # subnetι԰ʳ
        if ($line !~ /$subnetstr/) {
            push(@subnetline, $line);
        }
    }

    # subnetå(1)
    if (check_subnet_init($$firstsubnetline, $slinenum, $sknum, $eknum, 
                          \$subnetdirname, $errmsg) > 0) {

        # ̵subnetξ
        $$checkflag = 1;
    } else {

        # subnet,hostΰ켡ե
        $ret = make_subnet_host_data($slinenum, $subnetdirname, 
                                     \@subnetline, $optionname, $errmsg);
        # 顼ä
        if ($ret != 0) {
            $$checkflag = 1;
        }
    }

    # subnet
    if ($line =~ /$subnetstr/) {
        $$firstsubnetline = $line;
        # subnetɤ 
        read_subnet($fd, $linenum, $firstsubnetline, $checkflag, $optionname, 
                    $errmsg);
    }

    return 0;
}

#
# 켡եκ
#
# 
#	arg0	顼å
#
# ֤
#	   0	
#	  -1	顼
#

sub del_tmpfile 
{
    my ($errmsg) = @_;
    my @filelist;
    my @tmpfilelist;
    my $delfilename;
    my $filepath;
    my $filename;
    my $derrmsg;

    # 켡եɤ߹
    if (read_dir($WORKDIR, \@filelist, $errmsg) < 0 ) {
        $$errmsg[$L_DISP] = $LANG{$ENV{$DISPLANG}}{'ERR_TMP_DIR2'} . "(" 
                            . $WORKDIR . ")";
        $$errmsg[$L_LOG] = $LANG{$LOGLANG}{'ERR_TMP_DIR2'} . "(" 
                           . $WORKDIR . ")";
        return -1;
    }

    # 켡եκ(.lockʳΥե)
    foreach $filepath (@filelist) {
        if ($filepath =~ /\/.lock$/) {
            next;
        }

        # commonեξ
        if (($filepath =~ /\/common$/) && (-f $filepath)) {
            unlink($filepath);
            next;
        }

        # ǥ쥯ȥξ
        if ( -d $filepath) {

            # ǥ쥯ȥ
            if (del_dir($filepath, $errmsg) < 0) {
                return -1;
            }
        }
    }

    return 0;
}

#
# 켡ǥ쥯ȥꡢեκ
#
# 
#	arg0	subnetκǽιԿ
#	arg1	ǥ쥯ȥ̾
#	arg2	subnetιԥǡ()
#	arg3	ĥץ
#	arg4	顼å
#
# ֤
#	 0	
#	 1	顼
#	 2	顼(subnet̵)
#	-1	ƥ२顼
#

sub make_subnet_host_data 
{
    my ($linenum, $subnetdirname, $subnetline, $optionname, $errmsg) = @_;
    my %subnetdata;
    my %hostdata;
    my @allhostdata;
    my $flag = 0;     # returnѥե饰
    my $ret;
    my $subnetdirpath;
    my $inputhostline;

    # subnet,hostǡ
    $ret = get_subnet_host_data($linenum, \%subnetdata, \@allhostdata, 
                                $subnetline, $optionname, $errmsg); 

    # subnet̵ͤʾ
    if ($ret == 2) {
        return 2;
    }

    # subnetԤ
    if ($ret == 1) {
        $flag = 1;
    }

    # subnetǥ쥯ȥ̾κ
    $subnetdirpath = $WORKDIR . "/" . $subnetdirname;
    
    # ɬܥå(subnet)
    if (check_subnetitem(\%subnetdata, $subnetdirname, $errmsg) > 0) {
        return 2;
    }

    # ǥ쥯ȥ
    if (make_dir($subnetdirpath, $errmsg) < 0) {
        return -1;
    }

    # 켡ե(subnet, range)
    if (write_subnetitem($subnetdirname, \%subnetdata, $optionname, $errmsg) 
        < 0 ) {
        return -1;
    }

    # hostǡθĿ
    if (check_hostitem(\@allhostdata, \$inputhostline, $subnetdirname, 
                       $errmsg) > 0 ) {
        # 1ĤǤ顼ä
        $flag = 1;
    }

    # 켡ե(host)
    if (write_hostitem($subnetdirname, $inputhostline, $errmsg) < 0 ) {
        return -1;
    }

    return $flag;
}

#
# subnet,hostΥǡΥåȳǼ
#
# 
#	arg0	subnetκǽιԿ
#	arg1	subnetΥǡ(Ϣ)
#	arg2	subnethostǡ()
#	arg3	subnetιԥǡ()
#	arg4	ĥץ
#	arg5	顼å
#
# ֤
#	0	
#	1	subnet顼orhost̵orhost顼
#	2	顼(subnet̵)
#

sub get_subnet_host_data 
{
    my ($linenum, $subnetdata, $allhostdata, $subnetalldata, $optionname,
        $errmsg) = @_;
    my $status = 1;  #ơ        0: subnet
                     #                  1: subnet
                     #                  2: host
    my @hostline;
    my %hostdata;
    my $checkline;
    my $slinenum = $linenum;
    my $hnum = 0;
    my $ret;
    my $starthostline;
    my $checkflag = 0;    # ֤ѥե饰
    my $hflag = 0;        # hostѤΥե饰
    my $hnum = 0;         # hostθĿ
    my $starthoststr;     # åʸ
    my $endhoststr;       # åʸ

    # åʸκ
    $starthoststr = '^' . $STR_HOST . '\s+.*{$';
    $endhoststr =  '^' . $STR_END . '$';

    foreach $checkline (@$subnetalldata) {

        # Կ
        $slinenum++;

        # host {
        if ($checkline =~ /$starthoststr/i) {
            # ǽγ̤ξ
            if ($status == 1) {
                # hostϤޤԿ
                $starthostline = $slinenum;
            }
            $status++;
        }

        # }
        if ($checkline =~ /}$/i) {
            # ơ򸺤餹
            $status--;

            # host}ɤ
            if ($status == 1) {
                $hflag = 1;
            } else {
                next;
            }
        }

        # host, hostlineɵ
        if ($status >= 2) {
            push(@hostline, $checkline);
            next;
        }

        # hostä
        if ($hflag == 1) {

            # hostǡγǼ
            if (get_all_host_data($starthostline, $allhostdata, 
                                  \@hostline, \$hnum, $errmsg) > 0) {
                $checkflag = 1;
            }

            # 
            undef(@hostline);
            $hflag = 0;
            next;
        }

        # subnet
        if ($status == 1) {
            # ,Ȥξ
            if ($checkline =~ /^$/ || $checkline =~ /^#/) {
                next;
            }

            # ĥץΥåǼ
            if ($optionname ne "") {
                $ret = check_subnetline_ext($checkline, $slinenum, $subnetdata
                                            , $optionname, $errmsg);
                # ʣ顼ξ
                if($ret == 2) {
                    return 2;
                 }

                # ĥץ󤬤
                if ($ret == 0) {
                    next;
                }
            }

            # subnetԥå,Ǽ
            $ret = check_subnetline($checkline, $slinenum, $subnetdata, 
                                    $errmsg);
            # ʣ顼ξ
            if($ret == 2) {
                return 2;

            # 顼ξ
            } elsif ($ret == 1) {
                $checkflag = 1;
            }
            next;
        }

        # subnetν
        if ($status == 0) {

            # ,Ȥξ
            if ($checkline =~ /^$/ || $checkline =~ /^#/) {
                next;
            }

            # Ԥξ
            $$errmsg[$L_DISP] .= $LANG{$ENV{$DISPLANG}}{'ERR_DHCPD_CONF_FORM'} 
                                . "(" . $LANG{$ENV{$DISPLANG}}{'ERR_LINE_STR'}
                                . $slinenum . ")\n";
            $$errmsg[$L_LOG] .= $LANG{$LOGLANG}{'ERR_DHCPD_CONF_FORM'} 
                               . "(" . $LANG{$LOGLANG}{'ERR_LINE_STR'} 
                               . $slinenum . ")\n";
            $checkflag = 1;
        }
    }

    return $checkflag;
}

#
# subnetƤhostФ,Ǽ
#
# 
#	arg0	subnetκǽι
#	arg1	subnetκǽιԿ
#	arg2	̤ο
#	arg3	֥ͥåȥǥ쥯ȥ̾ʻϤ
#	arg4	hostοʻϤ
#	arg5	顼åʻϤ
#
# ֤
#	 0	
#	 1	host顼
#

sub get_all_host_data 
{
    my ($starthostline, $allhostdata, $hostline, $hnum, $errmsg) = @_;
    my %hostdata;
    my $key;
    my $value;
    my $ret;
    my $flag = 0;  # åѥե饰

    # hostǡμФ
    $ret = get_host_data($starthostline, \%hostdata, $hostline, $errmsg);
    if ( $ret <= 1) {

        # host̵Ǥʤ硢hostǡɵ
        while (($key, $value) = each(%hostdata)) {
            $$allhostdata[$$hnum]{$key} = $value;
        }
        $$hnum++;
    }

    # 顼ä
    if ($ret != 0) {
        $flag = 1;
    }

    return $flag;
}

#
# subnetνå
#
# 
#	arg0	subnetκǽι
#	arg1	subnetκǽιԿ
#	arg2	Ϥޤγ̤ο
#	arg3	̤ο
#	arg4	֥ͥåȥǥ쥯ȥ̾ʻϤ
#	arg5	顼åʻϤ
#
# ֤
#	 0	
#	 1	顼(subnet̵)
#

sub check_subnet_init 
{
    my ($firstline, $linenum, $sknum, $eknum, $subnetdirname, $errmsg) = @_;
    my @subnet;

    # subnet̾å
    @subnet = split(/\s+/, $firstline);
    if ($#subnet != 4) {
        $$errmsg[$L_DISP] .= $LANG{$ENV{$DISPLANG}}{'ERR_SUBNET_DATA2'}
                             . "(" . $LANG{$ENV{$DISPLANG}}{'ERR_LINE_STR'} 
                             . $linenum . ")\n";
        $$errmsg[$L_LOG] .= $LANG{$ENV{$DISPLANG}}{'ERR_SUBNET_DATA2'}
                            . "(" . $LANG{$LOGLANG}{'ERR_LINE_STR'} 
                            . $linenum . ")\n";
        return 1;
    }

    # subnetǥ쥯ȥ̾κ
    $$subnetdirname = sprintf("%s-%s", $subnet[1], $subnet[3]);

    # ̤бå
    if ($sknum != $eknum) {
        $$errmsg[$L_DISP] .= $LANG{$ENV{$DISPLANG}}{'ERR_SUBNET_DATA2'}
                            . "(" . $$subnetdirname . ")\n";
        $$errmsg[$L_LOG] .= $LANG{$LOGLANG}{'ERR_SUBNET_DATA2'}
                           . "(" . $$subnetdirname . ")\n";
        return 1;
    }

    return 0;
}

#
# subnetǡγǼ(ĥץ)
#
# 
#	arg0	åsubnetι
#	arg1	subnetιԿ

#	arg2	ǼsubnetǡϢ
#	arg3	ĥץ
#	arg4	顼å(Ϥ)
#
# ֤
#	0	
#	1	Ĥʤä
#	2	ʣ顼(subnet̵)
#

sub check_subnetline_ext
{
    my ($subnetline, $linenum, $subnetdata, $optionname, $errmsg) = @_;
    my $checkstr;

    # åʸκ
    $checkstr = '^' . $optionname . '.*;$';

    # ĥץξ
    if ($subnetline =~ $checkstr) {

        # ʣå
        if (defined($$subnetdata{$optionname})) {
            $$errmsg[$L_DISP] .= $LANG{$ENV{$DISPLANG}}{'ERR_DHCPD_LINE2'}
                                 . "(" . $LANG{$ENV{$DISPLANG}}{'ERR_LINE_STR'}
                                 . $linenum . ")\n";
            $$errmsg[$L_LOG] .= $LANG{$LOGLANG}{'ERR_DHCPD_LINE2'}
                                . "(" . $LANG{$LOGLANG}{'ERR_LINE_STR'}
                                . $linenum . ")\n";
            return 2;
        }

        # ;
        chop($subnetline);

        # ʬִ
        $$subnetdata{$optionname} = $subnetline . "\n";
        $$subnetdata{$optionname} =~ s/$optionname //g;

        return 0;
    }

    # Ĥʤä
    return 1;

}

#
# subnetǡγǼ
#
# 
#	arg0	åsubnetι
#	arg1	subnetιԿ
#	arg2	ǼsubnetǡϢ
#	arg3	顼å(Ϥ)
#
# ֤
#	0	
#	1	顼
#	2	ʣ顼(subnet̵)
#
sub check_subnetline
{
    my ($subnetline, $linenum, $subnetdata, $errmsg) = @_;
    my $checkflag = 0;
    my $sitem;
    my @value;
    my $checkstr;

    foreach $sitem (@subnetitem) {

        # åʸκ
        $checkstr = '^' . $sitem . '\s+.*;$';

        # פʤä
        if ($subnetline !~ /$checkstr/i) {
            next;
        }

        # ʣå
        if (defined($$subnetdata{$sitem}) && $sitem ne $subnetitem[$RANGE]) {
            $$errmsg[$L_DISP] .= $LANG{$ENV{$DISPLANG}}{'ERR_DHCPD_LINE2'}
                                 . "(" . $LANG{$ENV{$DISPLANG}}{'ERR_LINE_STR'}
                                 . $linenum . ")\n";
            $$errmsg[$L_LOG] .= $LANG{$LOGLANG}{'ERR_DHCPD_LINE2'}
                                . "(" . $LANG{$LOGLANG}{'ERR_LINE_STR'}
                                . $linenum . ")\n";
            return 2;
        }

        # ;
        chop($subnetline);

        # ڤ
        @value = split(/\s+/, $subnetline);

        # 顼ξ
        if ($subnetinfo{$sitem}(@value) > 0) {
            last;
        }

        $checkflag = 1;

        # rangeξ
        if ($sitem eq $subnetitem[$RANGE]) {

            # dynamic-bootpʤ
            if ($#value == 2 && $value[1] ne $DYNAMIC_BOOTP) {

                # ϢǼ
                $$subnetdata{$sitem} .= sprintf("%s,%s\n", 
                                                 $value[1],
                                                 $value[2]);
            # dynamic-bootp
            } elsif ($#value == 3 && $value[1] eq $DYNAMIC_BOOTP) {

                # ϢǼ
                $$subnetdata{$sitem} .= sprintf("%s,%s,%s\n", 
                                                 $value[2],
                                                 $value[3], 
                                                 $value[1]);
            } else {
                # rangeη
                $checkflag = 0;
                last;
            }
        } else {

            # ϢǼ
            $$subnetdata{$sitem} = pop(@value);

            # option domain-nameξ硢"
            if ($sitem eq $subnetitem[$OPTION_DOMAIN_NAME]) {
                $$subnetdata{$sitem} =~ s/"//g;
            }
        }
    }

    # ܤξ
    if ($checkflag == 0) {
        $$errmsg[$L_DISP] .= $LANG{$ENV{$DISPLANG}}{'ERR_DHCPD_CONF_FORM'} 
                             . "(" . $LANG{$ENV{$DISPLANG}}{'ERR_LINE_STR'} 
                             . $linenum . ")\n";
        $$errmsg[$L_LOG] .= $LANG{$LOGLANG}{'ERR_DHCPD_CONF_FORM'} 
                            . "(" . $LANG{$LOGLANG}{'ERR_LINE_STR'}
                            . $linenum . ")\n";
        return 1;
    }

    return 0;
}

#
# hostΥǡΥåȳǼ
#
# 
#	arg0	hostκǽιԿ
#	arg1	hostΥǡ()
#	arg2	hostι(
#	arg3	顼å
#
# ֤
#	0	
#	1	host顼Ԥ
#	2	host̵
#

sub get_host_data 
{
    my ($linenum, $hostdata, $hostalldata, $errmsg) = @_;

    my $hlinenum = $linenum - 1;  # hostϤޤԿ
    my $status = 0;               # ơ  1: host
                                  #             2: 2Ĥhost
    my $checkline;
    my $checkflag;
    my $hitem;
    my $flag = 0;
    my $ret;
    my $hoststr;                   # åʸ

    # åʸκ
    $hoststr = '^' . $STR_HOST . '\s+.*{$';


    foreach $checkline (@$hostalldata) {

        # Կ
        $hlinenum++;

        # ܥåѥե饰
        $checkflag = 0;

        # ,Ȥξ
        if ($checkline =~ /^$/ || $checkline =~ /^#/) {
            next;
        }

        # host {
        if ($checkline =~ /$hoststr/i) {
            $status++;
            # 2Ĥhost {
            if ($status > 1) {
                $$errmsg[$L_DISP] .= $LANG{$ENV{$DISPLANG}}{'ERR_HOST_DATA1'}
                                     . "(" . $LANG{$ENV{$DISPLANG}}{'ERR_LINE_STR'}
                                     . $linenum . ")\n";
                $$errmsg[$L_LOG] .= $LANG{$LOGLANG}{'ERR_HOST_DATA1'}
                                    . "(" . $LANG{$LOGLANG}{'ERR_LINE_STR'}
                                    . $linenum . ")\n";
                return 2;
            }
            next;
        }

        # hostܥå,Ǽ
        $ret = check_hostline($checkline, $hlinenum, $hostdata, $errmsg);
        if ($ret == 2) {

            # host̵
            return 2;
        } elsif ($ret == 1) {

            # Ԥ
            $flag = 1;
        }
    }

    return $flag;
}

#
# hostǡγǼ
#
# 
#	arg0	åhostι
#	arg1	hostιԿ
#	arg2	hostǡϢ
#	arg3	顼å
#
# ֤
#	0	
#	1	顼
#	2	ʣ顼
#

sub check_hostline 
{
    my ($hostline, $linenum, $hostdata, $errmsg) = @_;
    my @value;
    my $checkstr;
    my $hitem;
    my $checkflag = 0;

    foreach $hitem (@hostitem) {

        # ʸ
        if ($hitem eq $hostitem[$OPTION_BOOTING]) {
            $checkstr = '^(' . $STR_ALLOW_BOOTING .  '||' . $STR_DENY_BOOTING 
                         . ')\s+' . $hostitem[$OPTION_BOOTING] . ';$';
        } else {
            $checkstr = '^' . $hitem .  '\s+.*;$';
        }

        # ܥ顼å
        if ($hostline !~ /$checkstr/i) {
            next;
        }

        # ʣå
        if (defined($$hostdata{$hitem})) {
            $$errmsg[$L_DISP] .= $LANG{$ENV{$DISPLANG}}{'ERR_DHCPD_LINE2'}
                                 . "(" . $LANG{$ENV{$DISPLANG}}{'ERR_LINE_STR'}
                                 . $linenum . ")\n";
            $$errmsg[$L_LOG] .= $LANG{$LOGLANG}{'ERR_DHCPD_LINE2'}
                                . "(" . $LANG{$LOGLANG}{'ERR_LINE_STR'} 
                                . $linenum . ")\n";
            return 2;
        }

        # ;
        chop($hostline);
        @value = split(/\s+/, $hostline);

        # å
        if ($hostinfo{$hitem}(@value) > 0) {
            last;
        }

        # פ礬롣
        $checkflag = 1;

        # bootingξ
        if ($hitem eq $hostitem[$OPTION_BOOTING]) {
            # Ǽ
            $$hostdata{$hitem} = shift(@value);
        } else {

            # Ǽ
            $$hostdata{$hitem} = pop(@value);

            # hostnameξ,""
            if ($hitem eq $hostitem[$OPTION_HOST_NAME]) {
                $$hostdata{$hitem} =~ s/"//g;
            }

        }
    }

    if ($checkflag == 0) {

        # ʹܤξ
        $$errmsg[$L_DISP] .= $LANG{$ENV{$DISPLANG}}{'ERR_DHCPD_CONF_FORM'} 
                             . "(" . $LANG{$ENV{$DISPLANG}}{'ERR_LINE_STR'}
                             . $linenum . ")\n";
        $$errmsg[$L_LOG] .= $LANG{$LOGLANG}{'ERR_DHCPD_CONF_FORM'} 
                            . "(" . $LANG{$LOGLANG}{'ERR_LINE_STR'}
                            . $linenum . ")\n";
        return 1;
    }

    return 0;
}

#
# hostǡɬܥå
#
# 
#	arg0	åhostΥǡ()
#	arg1	񤭹hostǡ
#	arg2    åhostޤsubnet̾
#	arg3	顼å
#
# ֤
#	0	
#	1	hostɬܥ顼
#

sub check_hostitem 
{
    my ($allhostdata, $inputhostdata, $subnetdirname, $errmsg) = @_;
    my $flag = 0;
    my $item;
    my $checkflag;
    my $count;
    my $i;

    # 
    $$inputhostdata = "";

    # hostθĿ
    $count = $#$allhostdata;

    for ($i = 0; $i <= $count; $i++) {

        # 
        $checkflag = 0;

        # ɬܥå(host)
        foreach $item (@hostitem) {
            if (!defined($$allhostdata[$i]{$item}) && 
                 $item ne $hostitem[$FIX_IPADDR]) {
                $$errmsg[$L_DISP] .= $LANG{$ENV{$DISPLANG}}{'ERR_HOST_DATA2'}
                                   . "(" . $item . ":" . $subnetdirname .")\n";
                $$errmsg[$L_LOG] .= $LANG{$LOGLANG}{'ERR_HOST_DATA2'}
                                   . "(" . $item . ":" . $subnetdirname .")\n";
                $checkflag = -1;
            }
        }

        # ɬܤȴƤ
        if ($checkflag < 0) {
            $flag = 1;
            next;
        }

        # 񤭹ʸ(host)
        $$inputhostdata .= sprintf("%s,%s,%s,%s\n", 
                       $$allhostdata[$i]{$hostitem[$OPTION_HOST_NAME]},
                       $$allhostdata[$i]{$hostitem[$OPTION_HARDWARE_ETHERNET]},
                       $$allhostdata[$i]{$hostitem[$FIX_IPADDR]},
                       $$allhostdata[$i]{$hostitem[$OPTION_BOOTING]});
    }

    return $flag;
}

#
# subnetΥǡͤɬܥå
#
# 
#	arg0	åsubnetΥǡ
#	arg1	åsubnet̾
#	arg2	顼å
#
# ֤
#	0	
#	1	顼
#

sub check_subnetitem 
{
    my ($subnetdata, $subnetdirname, $errmsg) = @_;
    my $checkflag = 0;
    my $item;

    # ƹܤɬܥå
    foreach $item (@subnetitem) {

       # rangeɬܥåʤ
       if ($item eq $STR_RANGE) {
           next;
       }

        # ¸ߤʤä
        if (!defined($$subnetdata{$item}) &&
            $item ne $subnetitem[$OPTION_DOMAIN_NAME]) {
            $$errmsg[$L_DISP] .= $LANG{$ENV{$DISPLANG}}{'ERR_SUBNET_DATA3'}
                                . "(" . $item . ":" . $subnetdirname . ")\n";
            $$errmsg[$L_LOG] .= $LANG{$LOGLANG}{'ERR_SUBNET_DATA3'}
                                . "(" . $item . ":" . $subnetdirname . ")\n";
            $checkflag = 1;
        }
    }

    return $checkflag;
}

#
# subnetǡν񤭹
#
# 
#	arg0	񤭹ǥ쥯ȥ̾
#	arg1	񤭹ǡ(subnet)
#	arg2	ĥץ
#	arg3	顼å
#
# ֤
#	0	
#	-1	顼
#

sub write_subnetitem 
{
    my ($subnetdirname, $subnetdata, $optionname, $errmsg) = @_;
    my $subnetfile;
    my $subnetline;
    my $rangefile;
    my $optionfile;

    # ĥץꤵƤ
    if ($$subnetdata{$optionname} ne "") {

        # 켡ե̾κ(subnet)
        $optionfile =  $WORKDIR . "/" . $subnetdirname . "/option";

        #optionե
        if (write_file($optionfile, $$subnetdata{$optionname}, $errmsg) == -1)
{
            return -1;
        }
    }

    # 񤭹ʸ(subnet)
    if ($$subnetdata{$subnetitem[$OPTION_DOMAIN_NAME]} eq "") {
        $subnetline = sprintf("%s\n%s\n%s\n%s\n%s\n", 
                           $$subnetdata{$subnetitem[$OPTION_ROUTERS]},
                           $$subnetdata{$subnetitem[$OPTION_SUBNET_MASK]},
                           $$subnetdata{$subnetitem[$OPTION_DOMAIN_NAME_SERVERS]},
                           $$subnetdata{$subnetitem[$DEFAULT_LEASE_TIME]},
                           $$subnetdata{$subnetitem[$MAX_LEASE_TIME]});
    } else {
        $subnetline = sprintf("%s\n%s\n%s\n%s\n%s\n%s\n", 
                           $$subnetdata{$subnetitem[$OPTION_ROUTERS]},
                           $$subnetdata{$subnetitem[$OPTION_SUBNET_MASK]},
                           $$subnetdata{$subnetitem[$OPTION_DOMAIN_NAME_SERVERS]},
                           $$subnetdata{$subnetitem[$DEFAULT_LEASE_TIME]},
                           $$subnetdata{$subnetitem[$MAX_LEASE_TIME]},
                           $$subnetdata{$subnetitem[$OPTION_DOMAIN_NAME]});
    }

    # 켡ե̾κ(subnet)
    $subnetfile =  $WORKDIR . "/" . $subnetdirname . "/subnet";

    # 켡եκ(subnet)
    if (write_file($subnetfile, $subnetline, $errmsg) < 0 ) {
        return -1;
    }

    # 켡ե̾κ(range)
    $rangefile =  $WORKDIR . "/" . $subnetdirname . "/range";

    # 켡եκ(range)
    if (write_file($rangefile, $$subnetdata{"range"}, $errmsg) < 0 ) {
        return -1;
    }

    return 0;
}

#
# hostǡν񤭹
#
# 
#	arg0	񤭹ǥ쥯ȥ̾
#	arg1	񤭹ǡ(host)
#	arg2	顼å
#
# ֤
#	0	
#	-1	顼
#

sub write_hostitem 
{
    my ($subnetdirname, $hostline, $errmsg) = @_;
    my $hostfile;

    # 켡ե̾κ(host)
    $hostfile =  $WORKDIR . "/" . $subnetdirname . "/host";

    # 켡եκ(host)
    if (write_file($hostfile, $hostline, $errmsg) < 0 ) {
        return -1;
    }

    return 0;
}

#
# ǡθĿå(2)
#
# 
#	arg0	åǡ
#
# ֤
#	0	
#	1	顼
#

sub check_datanum2 
{
    my (@data) = @_;

    if ($#data != 1) {
        return 1;
    }

    return 0;
}

#
# ǡθĿå(3)
#
# 
#	arg0	åǡ
#
# ֤
#	0	
#	1	顼
#

sub check_datanum3
{
    my (@data) = @_;

    if ($#data != 2) {
        return 1;
    }

    return 0;
}

#
# ǡθĿå(4)
#
# 
#	arg0	åǡ
#
# ֤
#	0	
#	1	顼
#

sub check_datanum4
{
    my (@data) = @_;

    if ($#data != 3) {
        return 1;
    }

    return 0;
}

#
# ǡθĿå(3 or 4)
#
# 
#	arg0	åǡ
#
# ֤
#	0	
#	1	顼
#

sub check_datanum3_4
{
    my (@data) = @_;

    if ($#data != 2 && $#data != 3) {
        return 1;
    }

    return 0;
}
1;
