#
# dhcpadmin
#
# Copyright (C) 2008 DesigNET, INC.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
#

##########################################################
#
# upload.cgiѥ饤֥
#
# $RCSfile: upload.pl,v $
# $Revision: 1.10 $
# $Date: 2009/01/05 07:09:03 $
#
##########################################################

my $csvsubnet = 0;
my $csvhost = 1;
my $csvmac = 2;
my $csvip = 3;
my $csvboot = 4;

my $csvallow = "";
my $registallow = "allow";
my $csvdeny = "";
my $registdeny = "deny";

#
# CSVեɹ
#
# 
#       arg0    CSVե
#       arg1    ɤ߹߷
#       arg2    顼å
#
# ֤
#       0          
#       1          顼
#

sub read_csvfile
{
    my ($csvfile, $csvdata, $errmsg) = @_;
    my $BUFSZ = 2048;
    my $buffer;
    my $bytesread;
    my $data;

    # CSVå
    if ($csvfile eq "") {
        $$errmsg[$L_DISP] = $LANG{$ENV{$DISPLANG}}{'INFO_CSV_NOTSEL'};
        return 1;
    }

    # CSVɤ߹
    while($bytesread = read($csvfile, $buffer, $BUFSZ)){
        $data .= $buffer;
    }

    # ɤ߹ߥǡΥå
    if ($data eq "") {
        $$errmsg[$L_DISP] = $LANG{$ENV{$DISPLANG}}{'ERR_CSV_DATA1'};
        return 1;
    } 

    # Ԥִ
    $data =~ s/\r\n/\n/g;

    # ƳǼ
    $$csvdata = $data;

    return 0;
}

#
# CSVեϿѥå
#
# 
#       arg0    CSVե
#       arg1    Կ
#       arg2    顼å
#
# ֤
#       0          
#       1          顼
#      -1          ƥ२顼
#

sub regist_cvs2host
{
    my ($csvfile, $csvnum, $errmsg) = @_;
    my $csvdata;
    my %data;
    my %allmacdata;
    my %allhostdata;
    my %allipdata;
    my $ret;

    # CSVեɹ
    if (read_csvfile($csvfile, \$csvdata, $errmsg) == 1) {
        return 1;
    }

    # CSVեνʣå
    $ret = csvdata2checkdata($csvdata, \%data, \%allmacdata,
                                    \%allhostdata, \%allipdata, $errmsg);

    # 顼
    if ($ret != 0) {
        return $ret;
    }

    # CSVեϿǡνʣå
    $ret = make_rangedata(\%data, \%allmacdata, \%allhostdata,
                                                \%allipdata, $csvnum, $errmsg);
    return $ret;
}

#
# CSVեΥåѴ
#
# 
#       arg0    CSVեΰ
#       arg1    ֥ͥå
#       arg2    ۥ
#       arg3    MACɥ쥹
#       arg4    IPɥ쥹
#       arg5    ֡Ȥε
#       arg6    Կ
#       arg7    顼å
#
# ֤
#       0          
#       1          顼
#

sub conv2checkdata
{
    my ($csvline, $subnet, $host, $mac, $ip, $boot, $cn, $errmsg) = @_;
    my @tmp;
    my @errmsg;
    my $ret;
    my $addmsg;

    # Ժ
    chomp($csvline);    

    # ǡʬ
    @tmp = split(/,/, $csvline);

    # Υå
    if (@tmp != 5) {
        $$errmsg[$L_DISP] .= $LANG{$ENV{$DISPLANG}}{'ERR_CSV_INV'};
        $$errmsg[$L_DISP] .= $LANG{$ENV{$DISPLANG}}{'ERR_CSV_NUM'};
        $$errmsg[$L_DISP] .= "(" . $LANG{$ENV{$DISPLANG}}{'ERR_LINE_STR'} . $cn . ")";
        return 1;
    }

    foreach (@tmp) {

        # ֥륯ơ
        $_ =~ s/^"//;
        $_ =~ s/"$//;

        # 
        $_ =~ s/^\s+//;
        $_ =~ s/\s+$//;

    }

    # ֥ͥåȥå
    if (check_subnetdir($tmp[$csvsubnet]) == 1) {
        $$errmsg[$L_DISP] .= $LANG{$ENV{$DISPLANG}}{'ERR_CSV_INV'};
        $$errmsg[$L_DISP] .= $LANG{$ENV{$DISPLANG}}{'ERR_SUBNET_NOFOUND'};
        $$errmsg[$L_DISP] .= "(" . $LANG{$ENV{$DISPLANG}}{'ERR_LINE_STR'} . $cn . ")";
        return 1;
    }

    # ֥ͥåȤγǼ
    $$subnet = $tmp[$csvsubnet];

    # ۥȤγǼå
    if ($tmp[$csvhost] eq "") {
        $$errmsg[$L_DISP] .= $LANG{$ENV{$DISPLANG}}{'ERR_CSV_INV'};
        $$errmsg[$L_DISP] .= $LANG{$ENV{$DISPLANG}}{'ERR_HOST_FORMAT'};
        $$errmsg[$L_DISP] .= "(" . $LANG{$ENV{$DISPLANG}}{'ERR_LINE_STR'} . $cn . ")";
        return 1;
    }

    # ۥȤΥå
    if (check_hostname($tmp[$csvhost]) == 1) {
        $$errmsg[$L_DISP] .= $LANG{$ENV{$DISPLANG}}{'ERR_CSV_INV'};
        $$errmsg[$L_DISP] .= $LANG{$ENV{$DISPLANG}}{'ERR_HOST_FORMAT'};
        $$errmsg[$L_DISP] .= "(" . $LANG{$ENV{$DISPLANG}}{'ERR_LINE_STR'} . $cn . ")";
        return 1;
    }

    # ۥȤγǼ
    $$host = $tmp[$csvhost];

    # MACɥ쥹γǼå
    if ($tmp[$csvmac] eq "") {
        $$errmsg[$L_DISP] .= $LANG{$ENV{$DISPLANG}}{'ERR_CSV_INV'};
        $$errmsg[$L_DISP] .= $LANG{$ENV{$DISPLANG}}{'ERR_MACADDR_FORMAT'};
        $$errmsg[$L_DISP] .= "(" . $LANG{$ENV{$DISPLANG}}{'ERR_LINE_STR'} . $cn . ")";
        return 1;
    }

    # MACɥ쥹Υå
    if (check_macaddr($tmp[$csvmac], $mac) == 1) {
        $$errmsg[$L_DISP] .= $LANG{$ENV{$DISPLANG}}{'ERR_CSV_INV'};
        $$errmsg[$L_DISP] .= $LANG{$ENV{$DISPLANG}}{'ERR_MACADDR_FORMAT'};
        $$errmsg[$L_DISP] .= "(" . $LANG{$ENV{$DISPLANG}}{'ERR_LINE_STR'} . $cn . ")";
        return 1;
    }

    # ɲååȤΩ
    $addmsg = "(" . $LANG{$ENV{$DISPLANG}}{'ERR_LINE_STR'} . $cn . ")";

    # IPɥ쥹ϤƤХå
    if ($tmp[$csvip] ne "") {
        # IPɥ쥹Υå
        if (check_ipaddr($tmp[$csvip], \@errmsg) == 1) {
            $$errmsg[$L_DISP] .= $LANG{$ENV{$DISPLANG}}{'ERR_CSV_INV'};
            $$errmsg[$L_DISP] .= $LANG{$ENV{$DISPLANG}}{'ERR_IP_FORMAT'};
            $$errmsg[$L_DISP] .= $addmsg;
            return 1;
        }

        # ϰϤȥȥȥå
        $ret = check_ipformat($tmp[$csvsubnet], $tmp[$csvip],
                                                $addmsg, $errmsg);

        # ƥ२顼
        if ($ret == -1) {
            return -1;
        }

        # 顼
        if ($ret == 1) {
            $$errmsg[$L_DISP] = $LANG{$ENV{$DISPLANG}}{'ERR_CSV_INV'} . $$errmsg[$L_DISP];
            return 1;
        }

        # ۥȤγǼ
        $$ip = $tmp[$csvip];
    }

    # ĤΥå
    if (check_boot($tmp[$csvboot], $boot) == 1) {
        $$errmsg[$L_DISP] .= $LANG{$ENV{$DISPLANG}}{'ERR_CSV_INV'};
        $$errmsg[$L_DISP] .= $LANG{$ENV{$DISPLANG}}{'ERR_BOOT_FORMAT'};
        $$errmsg[$L_DISP] .= "(" . $LANG{$ENV{$DISPLANG}}{'ERR_LINE_STR'} . $cn . ")";
        return 1;
    }

    return 0;
}

#
# ߽еĥå
#
# 
#       arg0    ߽е
#       arg1    Ѵ߽е狼
#
# ֤
#       0          
#       1          顼
#

sub check_boot
{
    my ($orgboot, $boot) = @_;

    Jcode::convert(\$orgboot, 'euc');

    if ($orgboot eq $csvallow) {
        $$boot = $registallow;
        return 0;
    }

    if ($orgboot eq $csvdeny) {
        $$boot = $registdeny;
        return 0;
    }

    return 1;

}

#
# ֥ͥåȥǥ쥯ȥΥå
#
# 
#       arg0    ֥ͥåȥǥ쥯ȥ
#
# ֤
#       0          ¸ߤ
#       1          ¸ߤʤ
#

sub check_subnetdir {
    my ($subnet) = @_;
    my $subnetdirpath;

    $subnet =~ s/\//-/g;
    $subnetdirpath = $WORKDIR . "/" . $subnet;

    # ʤ۾
    if ($subnet eq "") {
        return 1;
    }

    # ¸ߥå
    if (!-d $subnetdirpath) {
        return 1;
    }

    return 0;
}

#
# CSVǡåѤΥǡѴ
#
# 
#       arg0    CSVǡ
#       arg1    Ѵ̳Ǽ
#       arg2    ٤ƤMACɥ쥹
#       arg3    ٤ƤIPɥ쥹
#       arg4    顼å
#
# ֤
#       0          
#       1          顼
#

sub csvdata2checkdata
{
    my ($csvdata, $data, $allmacdata,
                  $allhostdata, $allipdata, $errmsg) = @_;
    my $cn = 0;
    my $ret;
    my $convmac;
    my $convboot;
    my $subnet;
    my $host;
    my $mac;
    my $ip;
    my $boot;
    my $errflg = 0;

    # ɤ߹
    foreach (split(/\n/, $csvdata)) {

        # 
        $subnet = "";
        $host = "";
        $mac = "";
        $ip = "";
        $boot = "";

        # ԿΥ
        $cn++;

        # Ͻʤ
        if ($_ eq "") {
            next;
        }

        # ԤͿ
        if (defined($$errmsg[$L_DISP]) == 1) {
            $$errmsg[$L_DISP] .= "\n";
        } 

        # CSVǡηѴȥå
        $ret = conv2checkdata($_, \$subnet, \$host, \$mac, \$ip, \$boot, $cn, $errmsg);

        # ƥ२顼
        if ($ret == -1) {
            return -1;
        }

        # 顼
        if ($ret == 1) {
            $errflg = 1;
            next;
        }

        # ۥȤνʣå
        if (defined($$data{$subnet}{$host})  == 1) {
            $$errmsg[$L_DISP] .= $LANG{$ENV{$DISPLANG}}{'ERR_CSV_INV'};
            $$errmsg[$L_DISP] .= $LANG{$ENV{$DISPLANG}}{'ERR_CSV_ERR1'};
            $$errmsg[$L_DISP] .= "(" . $LANG{$ENV{$DISPLANG}}{'ERR_LINE_STR'} . $cn . ")";
            $errflg = 1;
            next;
        }

        # MACνʣå
        if (defined($$allmacdata{"$subnet,$mac"}) == 1 ) {
            $$errmsg[$L_DISP] .= $LANG{$ENV{$DISPLANG}}{'ERR_CSV_INV'};
            $$errmsg[$L_DISP] .= $LANG{$ENV{$DISPLANG}}{'ERR_CSV_ERR2'};
            $$errmsg[$L_DISP] .= "(" . $LANG{$ENV{$DISPLANG}}{'ERR_LINE_STR'} . $cn . ")";
            $errflg = 1;
            next;
        }

        if ((defined($$allipdata{$ip}) == 1) && ($ip ne "")) {
            $$errmsg[$L_DISP] .= $LANG{$ENV{$DISPLANG}}{'ERR_CSV_INV'};
            $$errmsg[$L_DISP] .= $LANG{$ENV{$DISPLANG}}{'ERR_CSV_ERR7'};
            $$errmsg[$L_DISP] .= "(" . $LANG{$ENV{$DISPLANG}}{'ERR_LINE_STR'} . $cn . ")";
            $errflg = 1;
            next;
        }

        # ǡǼ
        $$data{$subnet}{$host} = sprintf("%s,%s,%s,%s", $host, $mac, $ip, $boot);

        # MACɥ쥹ȹԿǼ
        $$allmacdata{"$subnet,$mac"} = $cn;

        # ۥ̾ȹԿǼ
        $$allhostdata{$host} = $cn;

        # IPɥ쥹ȹԿǼ
        $$allipdata{$ip} = $cn;
    }

    if ($errflg == 1) {
        return 1;
    }

    return 0;
}

#
# CSVեɹ
#
# 
#       arg0    CSVե
#       arg1    MACɥ쥹
#       arg2    ۥȥǡ
#       arg3    IPǡ
#       arg4    Կ
#       arg5    顼å
#
# ֤
#       0          
#      -1          ƥ२顼
#       1          顼
#

sub make_rangedata
{
    my ($csvdata, $allmacdata, $allhostdata, $allipdata, $csvnum, $errmsg) = @_;
    my $subnetdir;
    my %hostlist;
    my %fixiplist;
    my $subnet;
    my $hostkey;

    # ۥȾɤ߽Ф
    if (read_allhost(\%hostlist, \%fixiplist, $errmsg) == -1) {
        return -1;
    }

    # CSVΥǡ򸡺
    foreach $subnet (keys %$csvdata) {

        # ǥ쥯ȥִ̾
        $subnetdir = $subnet;
        $subnetdir =~ s/\//\-/;

        # ʣå
        if (is_duplicate(\%hostlist, \%fixiplist, $csvdata, $allmacdata,
                                     $allhostdata, $allipdata, $subnetdir, $errmsg) == 1) {
            return 1;
        }

        # ֥ͥå˥ե˽
        if (write_subnet_host($subnetdir, $subnet, $csvdata, $csvnum, $errmsg) == -1 ) {
            return 1;
        }
    }

    # ˽Ԥʤ줿ȽǤե͡
    foreach $subnet (keys %$csvdata) {
        # ǥ쥯ȥִ̾
        $subnetdir = $subnet;
        $subnetdir =~ s/\//\-/;

        if (rename_subnet_host($subnetdir) == -1) {
            return -1;
        }
    }

    return 0;
}

#
# ֥ͥåȥեΥ͡
#
# 
#       arg0    ֥ͥåȥǥ쥯ȥ
#
# ֤
#       0          
#      -1          ͡༺
#

sub rename_subnet_host
{
    my ($subnetdir) = @_;
    my $host;
    my $hosttmp;

    # ۥȥեΥѥ̾
    $host = $WORKDIR . "/" . $subnetdir . "/host";
    $hosttmp = $WORKDIR . "/" . $subnetdir . "/host.tmp";

    if (rename($hosttmp, $host) == 0) {
        return -1;
    }

    return 0;
}

#
# ֥ͥå˥ۥȾ񤭹
#
# 
#       arg0    ֥ͥåȥǥ쥯ȥ
#       arg1    ֥ͥå
#       arg2    CSVѴѤߥǡ
#       arg3    Կ
#       arg4    顼å
#
# ֤
#       0          
#      -1          ƥ२顼
#       1          顼
#

sub write_subnet_host
{
    my ($subnetdir, $subnet, $csvdata, $csvnum, $errmsg) = @_;
    my $data = "";
    my $host;
    my $hosttmp;
    my $ret;

    # ۥȥեΥѥ̾
    $host = $WORKDIR . "/" . $subnetdir . "/host";
    $hosttmp = $WORKDIR . "/" . $subnetdir . "/host.tmp";

    # ǡ
    foreach (sort keys %{$$csvdata{$subnet}}) {
        $$csvnum++;
        $data .= $$csvdata{$subnet}{$_} . "\n";
    }

    # hostե뤬¸ߤʣ
    if ( -e $host ) {
        $ret = copy $host, $hosttmp;
        if ($ret == 0) {
            $$errmsg[$L_DISP] .= $LANG{$ENV{$DISPLANG}}{'ERR_TMP_FILE2'} . "("
                                . $hosttmp . ")";
            $$errmsg[$L_LOG] .= $LANG{$LOGLANG}{'ERR_TMP_FILE2'} . "("
                                . $hosttmp . ")";
            return -1;
        }
    }

    # ǡ
    if (append_file($hosttmp, $data, $errmsg) == -1 ) {
        return -1;
    }

    return 0;
}

#
# ʣå
#
# 
#       arg0    ۥȤΰ
#       arg0    FIXIPΰ
#       arg1    CSVǡ
#       arg2    MACɥ쥹
#       arg3    ֥ͥå
#       arg4    顼å
#
# ֤
#       0          
#       1          ʣ顼
#

sub is_duplicate
{
    my ($hostlist, $fixiplist, $csvdata, $allmacdata,
                   $allhostdata, $allipdata, $subnet, $errmsg) = @_;
    my @hostname;
    my $registmac;
    my $registsubnet;
    my $csvmac;
    my $csvip;
    my $csvhost;
    my $host = 0;
    my $mac = 1;
    my $num;
    my @tmp;

    # MACɥ쥹å
    foreach $csvmac (sort {$$allmacdata{$a} <=> $$allmacdata{$b}} keys %$allmacdata){
        @tmp = split(/,/, $csvmac);

        if (defined($$hostlist{$subnet}{$tmp[$mac]}) == 1) {
            $$errmsg[$L_DISP] = $LANG{$ENV{$DISPLANG}}{'ERR_CSV_INV'};
            $$errmsg[$L_DISP] .= $LANG{$ENV{$DISPLANG}}{'ERR_CSV_ERR2'};
            $$errmsg[$L_DISP] .= "(" . $LANG{$ENV{$DISPLANG}}{'ERR_LINE_STR'};
            $$errmsg[$L_DISP] .= $$allmacdata{$csvmac} . ")";
            return 1;
        }
    }

    # ۥ̾å
    foreach $csvhost (sort {$$allhostdata{$a} <=> $$allhostdata{$b}} keys %$allhostdata) {
        # ϿѤߥۥȤΰCSV˽ʣʤ
        foreach $registsubnet (keys %$hostlist) {
            foreach $registmac (keys %{$$hostlist{$registsubnet}}) {
                @hostname = keys %{$$hostlist{$registsubnet}{$registmac}};

                if ($csvhost eq $hostname[$host]) {
                    $$errmsg[$L_DISP] = $LANG{$ENV{$DISPLANG}}{'ERR_CSV_INV'};
                    $$errmsg[$L_DISP] .= $LANG{$ENV{$DISPLANG}}{'ERR_CSV_ERR1'};
                    $$errmsg[$L_DISP] .= "(" . $LANG{$ENV{$DISPLANG}}{'ERR_LINE_STR'};
                    $$errmsg[$L_DISP] .= $$allhostdata{$hostname[$host]} . ")";
                    return 1;
                }
            }
        }
    }

    # IPɥ쥹å
    foreach $csvip (sort {$$allipdata{$a} <=> $$allipdata{$b}} keys %$allipdata){
        if (defined($$fixiplist{$subnet}{$csvip}) == 1) {
            $$errmsg[$L_DISP] = $LANG{$ENV{$DISPLANG}}{'ERR_CSV_INV'};
            $$errmsg[$L_DISP] .= $LANG{$ENV{$DISPLANG}}{'ERR_CSV_ERR7'};
            $$errmsg[$L_DISP] .= "(" . $LANG{$ENV{$DISPLANG}}{'ERR_LINE_STR'};
            $$errmsg[$L_DISP] .= $$allipdata{$csvip} . ")";
            return 1;
        }
    }

    return 0;
}

1;
