#!/usr/bin/perl

#
# dhcpadmin
#
# Copyright (C) 2008 DesigNET, INC.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
#

##########################################################
#
# 饤Ͽ
#
# $RCSfile: host_add.cgi,v $
# $Revision: 1.24 $
# $Date: 2013/01/18 08:18:10 $
#
##########################################################

# 饤֥ɲ
use lib "../lib";

use strict;
use CGI;
use Net::IPv4Addr;

# 饤֥ɤ߹
require "libcommon.pl";
require "librange.pl";
require "libpage.pl";
require "libhost.pl";
require "libpost.pl";
require "host_add.pl";

##########################################################
# ڡѥå
##########################################################
package mypage;

my $body;

use vars qw(@ISA);

#
# pageλҥ饹
#
@ISA = qw(page);
sub new
{
    bless {};
}

#
# ɽ
#
sub display_body
{
    print $body;
}

##########################################################
# ᥤѥå
##########################################################
package main;

##########################################################
# 
##########################################################

my $q = new CGI;
my $ret;
my %conf;
my @errmsg;
my $linkflag = 1;
my $ref = $q->param('REF');

# ͺƸѥե饰
my $CHECKSTR = "checked";
my $DENYSTR = "deny";

# 쥯ѥե饰
my $SELECTONE = 1;

# searchʸ
my $SEARCHSTR = "search";

# ѥե̾
my $DESTFILE = "host_search.cgi";

# 
if (dhcp_init(\%conf, $linkflag, $ref, \@errmsg) == -1) {
    syserr($errmsg[$main::L_DISP]);
    errlog($errmsg[$main::L_LOG], $conf{'facility'});
    exit 1;
}

##########################################################
# ᥤ
##########################################################

my $convmac = "";
my $id;

my @subnetlist; # 
my $subnetdata;
my $subnethtml;
my $hostdata;
my $macdata;
my $ipdata;
my $ipflag;
my $hostflag;
my $macflag;
my $checkdeny;
my $checkallow;
my @tmpsubnet;

my $modsubnetdata; # 
my $modhostdata;
my $modmacdata;
my $modipdata;
my $modipflag;

my $searchflag;    # Ƥݻѿ

my %chgdata;       # Ѵѿ

my $postdata;
my %decryptdata;
my $convhost = "";

# or Ĥ
$checkallow = $CHECKSTR;

# ǡ
$subnetdata = $q->param('subnet');
$hostdata = $q->param('host');
$macdata = $q->param('macaddr');
$ipdata = $q->param('ipaddr');
$ipflag = $q->param('ipselect');
$hostflag = $q->param('hostsearch');
$macflag = $q->param('macsearch');

# å
$errmsg[$main::L_DISP] = $main::LANG{$ENV{$main::DISPLANG}}{'INFO_HOSTMOD'};

# ɲäξǡõ
if ((defined($q->param('mode')) == 1) && ($q->param('mode') == 0)) {
    $subnetdata = "";
    $hostdata = "";
    $macdata = "";
    $ipdata = "";
    $ipflag = "";
}

# ξǡ
if ($q->param('mode') == 1) {
    $subnetdata = $q->param('modsubnet');
    $hostdata = $q->param('modhost');
    $macdata = $q->param('modmacaddr');
    $ipdata = $q->param('modipaddr');
    $ipflag = $q->param('modipselect');
}

# ѥǡǼ
$decryptdata{'searchflag'} = $q->param('searchflag');
$decryptdata{'searchsubnet'} = $q->param('searchsubnet');
$decryptdata{'searchhost'} = $q->param('searchhost');
$decryptdata{'searchhostflag'} = $q->param('searchhostflag');
$decryptdata{'searchmacaddr'} = $q->param('searchmacaddr');
$decryptdata{'searchmacflag'} = $q->param('searchmacflag');
$decryptdata{'searchipaddr'} = $q->param('searchipaddr');
$decryptdata{'searchipselect'} = $q->param('searchipselect');

# ⡼ɤƤʤˤϥǡʤ
if (defined($q->param('mode')) == 0) {
    $decryptdata{'modsubnetdata'} = $q->param('modsubnet');
    $decryptdata{'modhostdata'} = $q->param('modhost');
    $decryptdata{'modmacdata'} = $q->param('modmacaddr');
    $decryptdata{'modipdata'} = $q->param('modipaddr');
    $decryptdata{'modipflag'} = $q->param('modipselect');
}

# 沽μ¹
if (hidden_decrypt(\%decryptdata, \%conf, \@errmsg) != 0) {
    # ǧ۾
    syserr($errmsg[$main::L_DISP]);
    errlog($errmsg[$main::L_LOG], $conf{'facility'});
    exit 1;
}

#
# Ʋ̤ɽˤsubnet󤫤ɤäȶڤѴ
# ̤ǡѤ
#
if (defined($q->param('mode')) == 1) {

    # ̤ǡѤ
    $decryptdata{'searchhost'} = $q->param('host');
    $decryptdata{'searchhostflag'} = $q->param('hostsearch');
    $decryptdata{'searchmacaddr'} = $q->param('macaddr');
    $decryptdata{'searchmacflag'} = $q->param('macsearch');
    $decryptdata{'searchipaddr'} = $q->param('ipaddr');
    $decryptdata{'searchipselect'} = $q->param('ipselect');
    @tmpsubnet = $q->param('subnet');

    foreach (@tmpsubnet) {
        $decryptdata{'searchsubnet'} .= $_ . ",";
    }

    # Ǹ,
    chop($decryptdata{'$searchsubnet'});

    # ǡм
    $decryptdata{'modsubnetdata'} = $q->param('modsubnet');
    $decryptdata{'modhostdata'} = $q->param('modhost');
    $decryptdata{'modmacdata'} = $q->param('modmacaddr');
    $decryptdata{'modipdata'} = $q->param('modipaddr');
    $decryptdata{'modipflag'} = $q->param('modipselect');
}

# 饤Ͽܥ󤫤餭Ȥƥץ졼Ȥѹ
if ((defined($q->param('mode')) == 1) && ($q->param('mode') == 0) ||
                                         (defined($q->param('add')) == 1)) {
    $id = "cli_add";         # ɽѥڡID
}

# 饤ȹΥ󥯤褿Ȥƥץ졼Ȥѹ
if ((defined($q->param('mode')) == 1) && ($q->param('mode') == 1) ||
                                         (defined($q->param('mod')) == 1)) {
    $id = "cli_mod";         # ɽѥڡID

}

# Ͽܥ󤬲줿Ȥ
if (defined($q->param('add')) == 1) {
    # å
    $errmsg[$main::L_DISP] = "";

    # Ĺۥ̾
    conv_host_br($hostdata, \$convhost);

    # å&ɲ
    $ret = main::check_add_host($subnetdata, $hostdata, $macdata, $ipdata, $ipflag,
                            \@errmsg);
    if ($ret == 0 ) {
        # åǼ
        $errmsg[$main::L_DISP] = $main::LANG{$ENV{$main::DISPLANG}}{'INFO_ADD_HOST'} .
                                        "(" .  $convhost . ")";
    }
}

# 饤ȹ
if (defined($q->param('mod')) == 1) {

    # å
    $errmsg[$main::L_DISP] = "";

    # å&
    $ret = main::check_mod_host($subnetdata, $hostdata, $macdata, $ipdata,
                 $ipflag, $decryptdata{'modsubnetdata'}, $decryptdata{'modhostdata'},
                          $decryptdata{'modmacdata'}, $decryptdata{'modipdata'}, \@errmsg);

    if ($ret == 0 ) {
        # ۥ̾Ѵ
        conv_host_br($hostdata, \$convhost);

        # åǼ
        $errmsg[$main::L_DISP] = $main::LANG{$ENV{$main::DISPLANG}}{'INFO_MOD_HOST'} .
                        "(" .  $convhost . ")";

        # ͤݻ
        $decryptdata{'modsubnetdata'} = $q->param('subnet');
        $decryptdata{'modhostdata'} = $q->param('host');

        # ڤѴ
        check_conv_macaddr($q->param('macaddr'), \$convmac);
        $decryptdata{'modmacdata'} = $convmac;
        $decryptdata{'modipdata'} = $q->param('ipaddr');
        $decryptdata{'modipflag'} = $q->param('ipselect');
    }
}

# ƥ२顼
if ($ret == -1) {
    syserr($errmsg[$main::L_DISP]);
    errlog($errmsg[$main::L_LOG], $conf{'facility'});
    exit 1;
}

# ܥ󤬲줿
if (defined($q->param('searchback')) == 1) {

    # POSTǡκ
    $postdata = "searchsubnet=" .  $decryptdata{'searchsubnet'} . "&" .
                "host=" . $decryptdata{'searchhost'} . "&" .
                "hostsearch=" . $decryptdata{'searchhostflag'} . "&" .
                "macaddr=" . $decryptdata{'searchmacaddr'} . "&" .
                "macsearch=" . $decryptdata{'searchmacflag'} . "&" .
                "ipaddr=" . $decryptdata{'searchipaddr'} . "&" .
                "ipselect=" . $decryptdata{'searchipselect'} . "&" .
                "REF=" . $ENV{SCRIPT_NAME};

    # ܥ󤬲Ƥ
    if ($decryptdata{'searchflag'} eq $SEARCHSTR) {
        $postdata .= "&search=" .  $decryptdata{'searchflag'};
    }

    # ɽ
    if (location_display($DESTFILE, $postdata, \@errmsg) == -1) {
        syserr($errmsg[$main::L_DISP]);
        errlog($errmsg[$main::L_LOG], $conf{'facility'});
        exit 1;
    }
}

#IP߽ͤκƸ
if ($ipflag eq $DENYSTR) {

    # ݤ
    $checkdeny = $CHECKSTR;
}

# 򤵤Ƥ륵֥ͥåȳǼ
push(@subnetlist, $subnetdata);

# ֥ͥåʸ
if (main::make_subnethtml(\$subnethtml, \@subnetlist, $SELECTONE, \@errmsg) 
     < 0 ) {
    syserr($errmsg[$main::L_DISP]);
    errlog($errmsg[$main::L_LOG], $conf{'facility'});
    exit 1;
}

##########################################################
# ƥץ졼֤
##########################################################
my %cryptdata;

$cryptdata{'SEARCHSUBNETDATA'} = $decryptdata{'searchsubnet'};
$cryptdata{'SEARCHHOSTDATA'} = $decryptdata{'searchhost'};
$cryptdata{'SEARCHHOSTFLAG'} = $decryptdata{'searchhostflag'};
$cryptdata{'SEARCHMACADDR'} = $decryptdata{'searchmacaddr'};
$cryptdata{'SEARCHMACFLAG'} = $decryptdata{'searchmacflag'};
$cryptdata{'SEARCHIPADDR'} = $decryptdata{'searchipaddr'};
$cryptdata{'SEARCHSELECT'} = $decryptdata{'searchipselect'};
$cryptdata{'MODSUBNETDATA'} = $decryptdata{'modsubnetdata'};
$cryptdata{'MODHOSTDATA'} = $decryptdata{'modhostdata'};
$cryptdata{'MODMACADDR'} = $decryptdata{'modmacdata'};
$cryptdata{'MODIPADDR'} = $decryptdata{'modipdata'};
$cryptdata{'MODSELECT'} = $decryptdata{'modipflag'};
$cryptdata{'SEARCHFLAG'} = $decryptdata{'searchflag'};

# ǡŹ沽
if (hidden_crypt(\%cryptdata, \%conf, \@errmsg) == -1) {
    # ǧ۾
    syserr($errmsg[$main::L_DISP]);
    errlog($errmsg[$main::L_LOG], $conf{'facility'});
    exit 1;
}

# Ѵѿ
%chgdata = ("SUBNETDATA" => $subnethtml,
            "HOSTDATA" => $q->escapeHTML($hostdata),
            "MACDATA" => $q->escapeHTML($macdata),
            "IPDATA" => $q->escapeHTML($ipdata),
            "CHECKALLOW" => $checkallow,
            "CHECKDENY" => $checkdeny,
            "SEARCH" => $q->escapeHTML($cryptdata{'SEARCHFLAG'}),
            "SEARCHSUBNETDATA" => $q->escapeHTML($cryptdata{'SEARCHSUBNETDATA'}),
            "SEARCHHOSTDATA" => $q->escapeHTML($cryptdata{'SEARCHHOSTDATA'}),
            "SEARCHHOSTFLAG" => $q->escapeHTML($cryptdata{'SEARCHHOSTFLAG'}),
            "SEARCHMACADDR" => $q->escapeHTML($cryptdata{'SEARCHMACADDR'}),
            "SEARCHMACFLAG" => $q->escapeHTML($cryptdata{'SEARCHMACFLAG'}),
            "SEARCHIPADDR" => $q->escapeHTML($cryptdata{'SEARCHIPADDR'}),
            "SEARCHSELECT" => $q->escapeHTML($cryptdata{'SEARCHSELECT'}));

# åǡݴ
$chgdata{"MODSUBNETDATA"} = $q->escapeHTML($cryptdata{'MODSUBNETDATA'});
$chgdata{"MODHOSTDATA"} = $q->escapeHTML($cryptdata{'MODHOSTDATA'});
$chgdata{"MODMACADDR"} = $q->escapeHTML($cryptdata{'MODMACADDR'});
$chgdata{"MODIPADDR"} = $q->escapeHTML($cryptdata{'MODIPADDR'});
$chgdata{"MODSELECT"} = $q->escapeHTML($cryptdata{'MODSELECT'});

# ץ졼
if (page::replace_template($id, \$body, \%chgdata, \@errmsg) == -1) {
    syserr($errmsg[$main::L_DISP]);
    errlog($errmsg[$main::L_LOG], $conf{'facility'});
    exit 1;
}

##########################################################
# ڡɽ
##########################################################

my $tabId = "cli";
my $obj;
my $syserr = 0;

$obj = new mypage;

# ɽʸ<br>ؤѴ
main::conv_br(\$errmsg[$main::L_DISP]);

# ɽ
if ($obj->display($id, \$syserr, $tabId, \@errmsg) == -1) {
    syserr($errmsg[$main::L_DISP]);
    errlog($errmsg[$main::L_LOG], $conf{'facility'});
    exit 1;
}

exit 0;
