#!/usr/bin/perl

#
# dhcpadmin
#
# Copyright (C) 2008 DesigNET, INC.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
#

##########################################################
#
# 饤ȸ
#
# $RCSfile: host_search.cgi,v $
# $Revision: 1.30 $
# $Date: 2013/01/18 09:50:05 $
#
##########################################################

# 饤֥ɲ
use lib "../lib";

use strict;
use CGI;
use Jcode;

# 饤֥ɤ߹
require "libcommon.pl";
require "libpage.pl";
require "libhost.pl";
require "librange.pl";
require "host_search.pl";

# IP߽ѥե饰
my $ALLOW_STR = "allow";
my $DENY_STR = "deny";
my $CHECKSTR = "checked";

# status
my $SEARCHSTR = "search";

# ѥե饰
my $WEBFLAG = 0;
my $CSVFLAG = 1;
my $OUTPUTFLAG;

# ˡե饰
my $ALLSEARCHFLAG  = "allmatch";
my $PARTSEARCHFLAG = "partmatch";
my $HOSTSEARCHFLAG;
my $MACSEARCHFLAG;

# ѿ
my $firsttempdata;
my $lattertempdata;

my %conf;

my @subnetdata;   # 
my $hostdata;
my $macdata;
my $ipdata;
my $check;
my $ipflag;
my $delcheck;
my @delhost;
my $convmacdata;
my @errmsg;
my $searchflag;        # ɤݻ
my $hostsearchflag;
my $macsearchflag;

##########################################################
# 
##########################################################

# ѥå
package mypage;

use vars qw(@ISA);

#
# pageλҥ饹
#
@ISA = qw(page);
sub new
{
    bless {};
}

#
# ɽ
#

# Ѵؿ

sub display_download
{
    my $sub = shift;

    $sub->output_csv_header();
    if (main::search_client(\@subnetdata, $hostdata, $convmacdata, $ipdata,
                           $ipflag, $OUTPUTFLAG, $HOSTSEARCHFLAG,
                           $MACSEARCHFLAG, \@delhost, \@errmsg) == -1) {
        main::errlog($errmsg[$main::L_LOG], $conf{'facility'});
        print Jcode->new($errmsg[$main::L_DISP], "euc")->sjis . "\r\n";
    }

    exit 0;
}

#
# HTTPإå(csv)
#
# []
#       ʤ
#
# [֤]
#       ʤ
#

sub output_csv_header
{
    print <<EOD;
Content-Disposition: attachment; filename=search.csv
Content-type: application/octet-stream

EOD
}

sub display_body
{
    my $data;

    # (Ⱦ)
    print $firsttempdata;

    # 
    if ($searchflag eq $SEARCHSTR) {
        if (main::search_client(\@subnetdata, $hostdata, $convmacdata, $ipdata,
                        $ipflag, $OUTPUTFLAG, \@delhost, $HOSTSEARCHFLAG,
                        $MACSEARCHFLAG, \@errmsg) < 0) {

            # 
            main::errlog($errmsg[$main::L_LOG], $conf{'facility'});

            # javascprit
            print <<EOD;
            <input type=hidden name=dispmsg value="$errmsg[$main::L_DISP]">
          </table>
        </td>
      </tr>
    </table>
          </td>
        </tr>
      </table>
      </td>
    </tr>
  </table>
</form>
<script type="text/javascript">
<!--
function myTimer() {
    clearInterval(TimeID);
    document.common.submit();
}
TimeID = setInterval('new myTimer()', 1);
// -->
</script>
EOD
            exit 0;
        }
    }
    # (Ⱦ)
    print $lattertempdata;
}

##########################################################
# 
##########################################################
package main;

my $q = new CGI;
my $ret;
my $msg;
my $linkflag = 1;
my $ref = $q->param('REF');

# 
if (dhcp_init(\%conf, $linkflag, $ref, \@errmsg) != 0) {
    syserr($errmsg[$main::L_DISP]);
    errlog($errmsg[$main::L_LOG], $conf{'facility'});
    exit 1;
}

##########################################################
# ᥤ
##########################################################

# ɽѥڡID
my $firstid = "cli_search";
my $latterid = "cli_search_latter";
my $tabId = "cli";
my $obj;
my %cryptdata;

my $checkallow = "";   # 
my $checkdeny = ""; 
my $checknoselect = ""; 
my $subnethtml;
my $hostsearchhtml;
my $macsearchhtml;
my $formatcheck;

my $infomsg = "";      # åѿ

my %decryptdata;       # ǥѿ

$obj = new mypage;

# ͤκƸ
@subnetdata = $q->param('subnet');
$hostdata = $q->param('host');
$macdata = $q->param('macaddr');
$ipdata = $q->param('ipaddr');
$delcheck = $q->param('alldel');
$ipflag = $q->param('ipselect');
$searchflag = $q->param('searchflag');
$hostsearchflag = $q->param('hostsearch');
$macsearchflag = $q->param('macsearch');
@delhost = $q->param('deldata');

# ۥ̾פʬפå
# 
if ($hostsearchflag eq $ALLSEARCHFLAG) {
    $HOSTSEARCHFLAG = 0;
# ʬ
} elsif ($hostsearchflag eq $PARTSEARCHFLAG) {
    $HOSTSEARCHFLAG = 1;
}

# MACɥ쥹פʬפå
# 
if ($macsearchflag eq $ALLSEARCHFLAG) {
    $MACSEARCHFLAG = 0;
# ʬ
} elsif ($macsearchflag eq $PARTSEARCHFLAG) {
    $MACSEARCHFLAG = 1;
}

# å
$errmsg[$main::L_DISP] = $main::LANG{$ENV{$main::DISPLANG}}{'INFO_HOSTSEARCH'};

# ǥ顼ξ
if (defined($q->param('dispmsg')) == 1) {
    $errmsg[$main::L_DISP] = $q->param('dispmsg');
    syserr($errmsg[$main::L_DISP]);
    exit 1;
}

# ܥäƤȤ
if (defined($q->param('searchsubnet')) == 1) {
    # ͤκƳǼ
    @subnetdata = split(/,/, $q->param('searchsubnet')); 
}

# ̥ɤξ
if (defined($q->param('search')) || defined($q->param('download'))) {

    # å
    # פä
    if ($MACSEARCHFLAG == 0) {
        $formatcheck = main::check_client($hostdata, $macdata, \$convmacdata, 
                                          $ipdata, \@errmsg);
    # ʬפä
    } else {
        $formatcheck = main::check_client_part($hostdata, $macdata, \$convmacdata,
                                          $ipdata, \@errmsg);
    }

    if ($formatcheck == 0) {
        # ̥ɤξ
        if (defined($q->param('download'))) {

            # Ϸ
            $OUTPUTFLAG = $CSVFLAG;
            $obj->display_download();

        # ξ
        } else {

            $cryptdata{'searchflag'} = $SEARCHSTR;

            # ǡŹ沽
            if (hidden_crypt(\%cryptdata, \%conf, \@errmsg) == -1) {
                # ǧ۾
                syserr($errmsg[$main::L_DISP]);
                errlog($errmsg[$main::L_LOG], $conf{'facility'});
                exit 1;
            }

            # ե饰(줿)
            $searchflag = $cryptdata{'searchflag'};
        }

    # ʤ
    } else {
         if (defined($q->param('search'))) {
            $searchflag = "";
        }
    }
} 


# 
if ($q->param('mode') == 2) {

    # Ϸ
    $OUTPUTFLAG = $WEBFLAG;

    # 򤵤Ƥʤ
    if ($#delhost == -1) {
       $errmsg[$main::L_DISP] = 
               $main::LANG{$ENV{$main::DISPLANG}}{'INFO_DEL_SELECT'};
    } else {

        # ѥå
        $infomsg = "";
        $errmsg[$main::L_DISP] = "";

        # ۥȤκ
        $ret = del_host(\@delhost, \$infomsg, \@errmsg); 

        if ($ret == -1) {
            # ˼
            syserr($errmsg[$main::L_DISP]);
            errlog($errmsg[$main::L_LOG], $conf{'facility'});
            exit 1;
        }

        # åγǼ
        $errmsg[$main::L_DISP] = $infomsg;
    }
}

#IP߽ͤκƸ
if ($ipflag eq $ALLOW_STR) {
    # Ĥ
    $checkallow = $CHECKSTR;
} elsif ($ipflag eq $DENY_STR) {
    # ݤ
    $checkdeny = $CHECKSTR;
} else {
    # or ̤
    $checknoselect = $CHECKSTR;
}

# ֥ͥåʸ
if (main::make_subnethtml(\$subnethtml, \@subnetdata, \@errmsg) == -1) {
    syserr($errmsg[$main::L_DISP]);
    errlog($errmsg[$main::L_LOG], $conf{'facility'});
    exit 1;
}
# ۥ̾html
if (main::make_hostsearchhtml(\$hostsearchhtml, $HOSTSEARCHFLAG, \@errmsg) == -1) {
    syserr($errmsg[$main::L_DISP]);
    errlog($errmsg[$main::L_LOG], $conf{'facility'});
    exit 1;
}

# MACɥ쥹html
if (main::make_macsearchhtml(\$macsearchhtml, $MACSEARCHFLAG, \@errmsg) == -1) {
    syserr($errmsg[$main::L_DISP]);
    errlog($errmsg[$main::L_LOG], $conf{'facility'});
    exit 1;
}
# Ⱦʸ
my %chgdata = ("SUBNETDATA" => $subnethtml,
               "HOSTDATA" => $q->escapeHTML($hostdata),
               "MACDATA" => $q->escapeHTML($macdata),
               "IPDATA" => $q->escapeHTML($ipdata),
               "HOSTSEARCHDATA" => $hostsearchhtml,
               "MACSEARCHDATA" => $macsearchhtml,
               "CHECKALLOW" => $checkallow,
               "CHECKDENY" => $checkdeny,
               "CHECKNOSELECT" => $checknoselect,
               "DELLCHECK" => $delcheck,
               "SEARCH" => $q->escapeHTML($searchflag));

# Ⱦʸ
my %emptychgdata = ();

# ֤(Ⱦ)
if (page::replace_template($firstid, \$firsttempdata, \%chgdata, \@errmsg) == -1) {
    syserr($errmsg[$main::L_DISP]);
    errlog($errmsg[$main::L_LOG], $conf{'facility'});
    exit 1;
}

# ֤(Ⱦ)
if (page::replace_template($latterid, \$lattertempdata, \%emptychgdata, \@errmsg) == -1) {
    syserr($errmsg[$main::L_DISP]);
    errlog($errmsg[$main::L_LOG], $conf{'facility'});
    exit 1;
}

##########################################################
# ڡɽ
##########################################################
my $sys_err;

# ɽʸ<br>ؤѴ
main::conv_br(\$errmsg[$main::L_DISP]);

# ե饰Υǥ
$decryptdata{'search'} = $searchflag;
if (hidden_decrypt(\%decryptdata, \%conf, \@errmsg) != 0) {
    # ǧ۾
    syserr($errmsg[$main::L_DISP]);
    errlog($errmsg[$main::L_LOG], $conf{'facility'});
    exit 1;
}
$searchflag = $decryptdata{'search'};

if ($obj->display($firstid, \$sys_err, $tabId, \@errmsg) != 0) {
    syserr($errmsg[$main::L_DISP]);
    errlog($errmsg[$main::L_LOG], $conf{'facility'});
    exit 1;
}

exit 0;
