#!/usr/bin/perl

#
# dhcpadmin
#
# Copyright (C) 2008 DesigNET, INC.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
#

##########################################################
#
# ϰϿ
#
# $RCSfile: rangemod.cgi,v $
# $Revision: 1.25 $
# $Date: 2013/01/16 23:44:40 $
#
##########################################################

# 饤֥ɲ
use lib "../lib";

use strict;
use CGI;
use Net::IPv4Addr;
use Net::IP;

# 饤֥ɤ߹
require "libcommon.pl";
require "libpage.pl";
require "libpost.pl";
require "librange.pl";
require "libhost.pl";
require "rangemod.pl";

##########################################################
# ڡѥå
##########################################################
package mypage;

my $body;
my $subnetlist;

use vars qw(@ISA);

#
# pageλҥ饹
#
@ISA = qw(page);
sub new
{
    bless {};
}

#
# ɽ
#
sub display_body
{
    print $body;
}

#
# ȥԥåꥹɽ
#
# []
#       arg0    ȥԥåꥹ
#
# [֤]
#       ʤ
#

sub display_topic
{
    shift;
    my ($topic_list) = @_;
    my $num = @$topic_list;
    my $i;
    my $name;
    my $url;

    print <<EOD;
<table class="head">
  <tr>
    <td class="topic" align="left">
EOD

    if ($num < 0) {
        print "&nbsp;";
    } else {
        for ($i = 0; $i < $num; $i++) {
            $name = $$topic_list[$i]->{"name"};
            $url = $$topic_list[$i]->{"url"};
            chomp($url);
            if ($url =~ /<<URLSELSUBNET>>/) {
                $url =~ s/<<URLSELSUBNET>>/$subnetlist/;
            }

            # ǽΥȥԥåʳϱɽ
            if ($i > 0) {
                print "&nbsp;" . ">" . "&nbsp;";
            }

            # ǸΥȥԥåϥ󥯤ˤʤ
            if ($i < $num -1) {
                print "<a href=$url>$name</a>";
            } else {
                print $name;
            }
        }
    }

    print<<EOD;
    </td>
  </tr>
</table>
EOD

}

##########################################################
# ᥤѥå
##########################################################
package main;

##########################################################
# 
##########################################################

my $q = new CGI;
my $ret;
my %conf;
my $msg;
my @errmsg;
my $subnetdir;
my $selrange = $q->param('range');
my @disprang = split(/,/, $selrange);
my $startrange = $q->param('startrange');
my $endrange = $q->param('endrange');
my $postdata = "REF=rangemod.cgi";  # ե顼ǡǼ
my $postrange;
my $DESTFILE = "range.cgi";
my $linkflag = 1;
my $ref = $q->param('REF');

# 
if (dhcp_init(\%conf, $linkflag, $ref, \@errmsg) != 0) {
    syserr($errmsg[$main::L_DISP]);
    errlog($errmsg[$main::L_LOG], $conf{'facility'});
    exit 1;
}

##########################################################
# ᥤ
##########################################################

my %chgdata;

my $url;
my $html;
my %serverlist;
my $mainflg;
my %decryptdata;
my $orgrange = "";
my $modrange;
my @value;
my $shared;
my $tmpsubnetdir;

# å
$errmsg[$main::L_DISP] = $main::LANG{$ENV{$main::DISPLANG}}{'INFO_RANGMOD'};

# ϰ̤򤷤֥ͥåȤ
$decryptdata{'selsubnetlist'} = $q->param('selsubnetlist');
$decryptdata{'shared'} = $q->param('shared');
$decryptdata{'runmode'} = $q->param('runmode');

# ݴѤϰϤˤɲ
if ($q->param('orgrange') ne "") {
    $decryptdata{'orgrange'} = $q->param('orgrange');
}

# ʣ粽μ¹
if (hidden_decrypt(\%decryptdata, \%conf, \@errmsg) != 0) {
    # ǧ۾
    syserr($errmsg[$main::L_DISP]);
    errlog($errmsg[$main::L_LOG], $conf{'facility'});
    exit 1;
}

# ʣǡ
@value = split(/\//, $decryptdata{'selsubnetlist'});
$subnetdir = $value[1] . "/" . $value[2];
$decryptdata{'selsubnetlist'} = $subnetdir;
$shared = $decryptdata{'shared'};

# ϰ̤ܤξˤϰϤݴ
if (defined($q->param('range')) == 1) { 
    $decryptdata{'orgrange'} = $selrange;
    $decryptdata{'runmode'} = $q->param('mode');
}

# 
if (defined($q->param('back')) == 1) {

    $postrange = $decryptdata{'orgrange'};

    if ($decryptdata{'runmode'} eq "mod" ) {
        $postrange = $startrange . "," . $endrange;
    }

    # Ϥǡ
    $postdata .= "&subnetlist=" . $shared . "/" . $subnetdir;
    $postdata .= "&range=" . $postrange;

    # ڡɽ
    if (location_display($DESTFILE, $postdata, \@errmsg) == -1) {
        syserr($errmsg[$main::L_DISP]);
        errlog($errmsg[$main::L_LOG], $conf{'facility'});
        exit 1;
    }
}

# Ͽ
if (defined($q->param('rangeamod')) == 1) {

    # ǥ쥯ȥ̾ѹ
    $tmpsubnetdir = $subnetdir;
    $tmpsubnetdir =~ s/\//-/;

    # ϰϤΥå
    if (check_range_ipaddr($tmpsubnetdir, $startrange, $endrange, $shared, \@errmsg) == 0) {

        if ($decryptdata{'runmode'} eq "mod" ) {
            $modrange = $decryptdata{'orgrange'}
        }

        # ϰϤ¸
        $ret = save_range($tmpsubnetdir, $startrange, $endrange, $modrange, $shared, \@errmsg);

        if ($ret == -1) {
            # ƥ२顼
            syserr($errmsg[$main::L_DISP]);
            errlog($errmsg[$main::L_LOG], $conf{'facility'});
            exit 1;
        }

        if ($ret == 0) {
            # ϤǡȤΩ
            $postdata .= "&dispmsg=" . $main::LANG{$ENV{$main::DISPLANG}}{'INFO_RANGE_DATA7'};
            $postdata .= "(" . $startrange . "-" . $endrange  .")";
            $postdata .= "&subnetlist=" . $shared . "/" . $subnetdir;

            # ڡɽ
            if (location_display($DESTFILE, $postdata, \@errmsg) == -1) {
                syserr($errmsg[$main::L_DISP]);
                errlog($errmsg[$main::L_LOG], $conf{'facility'});
                exit 1;
            }
        }
    }
}

##########################################################
# ƥץ졼֤
##########################################################

my $id = "rangemod";		# ɽѥڡID
my $start = 0;
my $end = 1;
my %cryptdata;
my $orgrange = "";
my $urlsubnet;

# Ź沽ǡǼ
$cryptdata{'SELSUBNETLIST'} = $shared . "/" . $subnetdir;
$cryptdata{'ORGRANGE'} = $decryptdata{'orgrange'};
$cryptdata{'MODE'} = $decryptdata{'runmode'};
$cryptdata{'shared'} = $decryptdata{'shared'};
$urlsubnet = $decryptdata{'selsubnetlist'};
$urlsubnet =~ s/-/\//; 
$cryptdata{'URLSELSUBNET'} = $shared . "/" . $urlsubnet;

# ǡŹ沽
if (hidden_crypt(\%cryptdata, \%conf, \@errmsg) == -1) {
    # ǧ۾
    syserr($errmsg[$main::L_DISP]);
    errlog($errmsg[$main::L_LOG], $conf{'facility'});
    exit 1;
}

# ɽѤִǡ
$chgdata{'SUBNETLIST'} = $decryptdata{'selsubnetlist'};
$chgdata{'DISPSUBNETLIST'} = $decryptdata{'selsubnetlist'};
$chgdata{'DISPSUBNETLIST'} =~ s/-/\//; 

# Ѥִǡ
$chgdata{'SELSUBNETLIST'} = $q->escapeHTML($cryptdata{'SELSUBNETLIST'});
$chgdata{'ORGRANGE'} = $q->escapeHTML($cryptdata{'ORGRANGE'});
$chgdata{'MODE'} = $q->escapeHTML($cryptdata{'MODE'});
$subnetlist = $q->escape($cryptdata{'URLSELSUBNET'});
$chgdata{'SHARED'} = $cryptdata{'shared'};

# ͶϿ
$chgdata{'STARTRANGE'} = $q->escapeHTML($startrange);
$chgdata{'ENDRANGE'} = $q->escapeHTML($endrange);

# ǡƸǡǥǡ¸
if (($decryptdata{'runmode'} eq "mod" ) && (defined($q->param('rangeamod')) == 0)) {
    $chgdata{'STARTRANGE'} = $q->escapeHTML($disprang[$start]);
    $chgdata{'ENDRANGE'} = $q->escapeHTML($disprang[$end]);
} 

# ץ졼
if (page::replace_template($id, \$body, \%chgdata, \@errmsg) == -1) {
    syserr($errmsg[$main::L_DISP]);
    errlog($errmsg[$main::L_LOG], $conf{'facility'});
    exit 1;
}

##########################################################
# ڡɽ
##########################################################

my $tabId = "nw";
my $obj;
my $sys_err;

# ɽʸ<br>ؤѴ
main::conv_br(\$errmsg[$main::L_DISP]);

$obj = new mypage;
if ($obj->display($id, \$sys_err, $tabId, \@errmsg) == -1) {
    syserr($errmsg[$main::L_DISP]);
    errlog($errmsg[$main::L_LOG], $conf{'facility'});
    exit 1;
}

exit 0;
