#!/usr/bin/perl

#
# dhcpadmin
#
# Copyright (C) 2008 DesigNET, INC.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
#

##########################################################
#
# Shared-network 
#
# $RCSfile: sharedlist.cgi,v $
# $Revision: 1.5 $
# $Date: 2013/01/13 01:45:15 $
#
##########################################################

# 饤֥ɲ
use lib "../lib";

use strict;
use File::Copy;
use CGI;

# 饤֥ɤ߹
require "libcommon.pl";
require "libpage.pl";
require "libpost.pl";
require "libsharedlist.pl";

my %conf;

# ѿ
my $firsttempdata;
my $lattertempdata;

my @errmsg;

my $obj;
$obj = new mypage;

##########################################################
# ڡѥå
##########################################################
package mypage;

my $body;

use vars qw(@ISA);

#
# pageλҥ饹
#
@ISA = qw(page);
sub new
{
    bless {};
}

#
# ɽ
#
sub display_body
{
    # Ⱦ
    print $firsttempdata;

    # ɽ
    if (main::make_sharedhtml(\@errmsg) != 0) {
        main::syserr($errmsg[$main::L_DISP]);
        main::errlog($errmsg[$main::L_LOG], $conf{'facility'});
        exit 0;
    }
    
    # Ⱦ
    print $lattertempdata;

}

##########################################################
# ᥤѥå
##########################################################
package main;

##########################################################
# 
##########################################################

my $q = new CGI;
my $ret;
my %conf;
my $msg;
my $linkflag = 1;
my $ref = $q->param('REF');
my $postdata;

# 
if (dhcp_init(\%conf, $linkflag, $ref, \@errmsg) == -1) {
    syserr($errmsg[$main::L_DISP]);
    errlog($errmsg[$main::L_LOG], $conf{'facility'});
    exit 1;
}

##########################################################
# ᥤ
##########################################################

my %chgdata;
my @tmpdirlist;
my $sharedname;
my $makedirname;
my $ret;

# ͤκƸ
$sharedname = $q->param('sharedname');

## ɲåܥ󤬲줿 ##
if (defined($q->param('add')) == 1) {
    # POST줿ͤå롣
    $ret = main::check_sharedname($sharedname, \@errmsg);
    
    # 顼ξ
    if ($ret == 1) {
        errlog($errmsg[$main::L_LOG], $conf{'facility'});
        $chgdata{'SHNAME'} = $q->escapeHTML($sharedname);

    # ͤä
    } else {

        # ǥ쥯ȥ롣
        $makedirname = $main::WORKDIR . "/" . $sharedname;
        
        # ˥ǥ쥯ȥޤϥե뤬ä饨顼
        if (-d $makedirname || -f $makedirname) {
            $errmsg[$main::L_DISP] =
                $main::LANG{$ENV{$main::DISPLANG}}{'ERR_SHNAME_EXIST'} . 
                "(" . $makedirname . ")";
            $errmsg[$main::L_LOG] = 
                $main::LANG{$main::LOGLANG}{'ERR_SHNAME_EXIST'} .
                "(" . $makedirname . ")";
            errlog($errmsg[$main::L_LOG], $conf{'facility'});
            $chgdata{'SHNAME'} = $q->escapeHTML($sharedname);

        # ǥ쥯ȥեʤХǥ쥯ȥ
        } else {
            $ret = main::make_dir($makedirname, \@errmsg);
            
            if ($ret == -1) {
                errlog($errmsg[$main::L_LOG], $conf{'facility'});
            } else {

                # Υå
                $errmsg[$main::L_DISP] =
                    $main::LANG{$ENV{$main::DISPLANG}}{'INFO_ADD_SHARED'} . 
                    "(" . $sharedname . ")";
                $errmsg[$main::L_LOG] = 
                    $main::LANG{$main::LOGLANG}{'INFO_ADD_SHARED'} .
                    "(" . $sharedname . ")";
                errlog($errmsg[$main::L_LOG], $conf{'facility'});
            }
            $chgdata{'SHNAME'} = "";
        }
    }
    ## ɽξ ##
} else {

    # å򥻥å
    $errmsg[$main::L_DISP] = 
        $main::LANG{$ENV{$main::DISPLANG}}{'INFO_SHAREDLIST'};
    if (defined($q->param('dispmsg')) == 1) {
        $errmsg[$main::L_DISP] = $q->param('dispmsg');
    }
    $chgdata{'SHNAME'} = "";
}

##########################################################
# ƥץ졼֤
##########################################################

my $firstid = "sharedlist";	              # ɽѥڡID
my $latterid = "sharedlist_latter";   # ɽѥڡID

# ֤Ⱦ
if (page::replace_template($firstid, \$firsttempdata, \%chgdata, \@errmsg) == -1) {
    syserr($errmsg[$main::L_DISP]);
    errlog($errmsg[$main::L_LOG], $conf{'facility'});
    exit 1;
}


# ֤ʸȾ
if (page::replace_template($latterid, \$lattertempdata, \%chgdata, \@errmsg) == -1) {
    syserr($errmsg[$main::L_DISP]);
    errlog($errmsg[$main::L_LOG], $conf{'facility'});
    exit 1;
}
##########################################################
# ڡɽ
##########################################################

my $tabId = "nw";
my $syserr = 0;

# ɽʸ<br>ؤѴ
main::conv_br(\$errmsg[$main::L_DISP]);

if ($obj->display($firstid, \$syserr, $tabId, \@errmsg) == -1) {
    syserr($errmsg[$main::L_DISP]);
    errlog($errmsg[$main::L_LOG], $conf{'facility'});
    exit 1;
}

exit 0;
