#!/usr/bin/perl

#
# dhcpadmin
#
# Copyright (C) 2008 DesigNET, INC.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
#

##########################################################
#
# Shared-networkԽ
#
# $RCSfile: sharedmod.cgi,v $
# $Revision: 1.8 $
# $Date: 2013/01/17 05:23:06 $
#
##########################################################

# 饤֥ɲ
use lib "../lib";

use strict;
use CGI;
use File::Basename;

# 饤֥ɤ߹
require "libcommon.pl";
require "libpage.pl";
require "libpost.pl";
require "libhost.pl";
require "libsharedlist.pl";
require "libsharedmod.pl";

##########################################################
# ڡѥå
##########################################################
package mypage;

my $bodyhtml;

use vars qw(@ISA);

#
# pageλҥ饹
#
@ISA = qw(page);
sub new
{
    bless {};
}

#
# ɽ
#
sub display_body
{
    print $bodyhtml;
}

##########################################################
# ᥤѥå
##########################################################
package main;

##########################################################
# 
##########################################################

my $q = new CGI;
my %conf;
my @errmsg;
my %inputdata;
my $linkflag = 1;
my $ref = $q->param('REF');
my $ret;

# 
my $LOCATION = "sharedlist.cgi";

# 
if (dhcp_init(\%conf, $linkflag, $ref, \@errmsg) != 0) {
    syserr($errmsg[$main::L_DISP]);
    errlog($errmsg[$main::L_LOG], $conf{'facility'});
    exit 1;
}

##########################################################
# ᥤ
##########################################################

my $errmsg;
my @dirlist;
my @otherlist;
my $dir;
my $dispdir;
my $other;
my $dispother;
my $displeft;
my $dispright;
my $count = 0;
my $postdata = "REF=" . $ENV{SCRIPT_NAME};
my $oldname;
my $oldpath;
my $networkname;
my $path;
my @selectleft;
my @selectright;
my $otherpath = $main::WORKDIR . "/" . $main::OTHERDIR;
my $message;

# ܥ ޤ ܥ󤬲
if (defined($q->param('mod')) || defined($q->param('del'))) {

    # Ϥ줿Ƥ
    $oldname = $q->param('oldname');
    $oldpath = $q->param('oldpath');
    $networkname = $q->param('networkname');
    @selectleft = $q->param('selectleft');
    @selectright = $q->param('selectright');

    # °륵֥ͥåȤɽ
    $displeft = "";
    foreach $dir (sort @selectleft) {
        $dir = $q->escapeHTML($dir);
        $dispdir = $dir;
        $dispdir =~ s/-/\//;
        $displeft .= "<option value=\"" . $dir . "\">" . $dispdir . "</option>\n";
    }
    $dispright = "";
    foreach $other (sort @selectright) {
        $other = $q->escapeHTML($other);
        $dispother = $other;
        $dispother =~ s/-/\//;
        $dispright .= "<option value=\"" . $other . "\">" . $dispother . "</option>\n";
    }

# ܥ󲡲
} elsif (defined($q->param('back'))) {

    # Shared-network̤
    if (location_display($LOCATION, $postdata, \@errmsg) == -1) {
        syserr($errmsg[$main::L_DISP]);
        errlog($errmsg[$main::L_LOG], $conf{'facility'});
        exit 1;
    }

} else {
    # ɽ

    # å
    $errmsg[$main::L_DISP] = $main::LANG{$ENV{$main::DISPLANG}}{'INFO_SHARED_MOD'};

    # Shared-network̤Υǡ
    $networkname = $q->param('modshname');
    $oldname = $q->param('modshname');
    $path = $q->param('modpath');
    $oldpath = $q->param('modpath');

    # IEϥեEnter򲡤modpath錄äƤʤ
    if ($path eq "" && $networkname eq "") {
        $networkname = $q->param('oldname');
        $oldname = $q->param('oldname');
        $path = $q->param('oldpath');
        $oldpath = $q->param('oldpath');
    }

    # Shared-network¸ߤ뤫å
    if (! -d $path) {
        # ǥ쥯ȥ꤬¸ߤʤϥ顼
        $message = $main::LANG{$ENV{$main::DISPLANG}}{'ERR_SHARED_NOEXIST'};
        $errmsg[$main::L_LOG] = $main::LANG{$main::LOGLANG}{'ERR_SHARED_NOEXIST'};
        errlog($errmsg[$main::L_LOG], $conf{'facility'});
        $postdata .= "&dispmsg=" . $message;

        # Shared-network̤
        if (location_display($LOCATION, $postdata, \@errmsg) == -1) {
            syserr($errmsg[$main::L_DISP]);
            errlog($errmsg[$main::L_LOG], $conf{'facility'});
            exit 1;
        }
    }

    # °륵֥ͥåȤɤ߹
    if (read_dir($path, \@dirlist, $errmsg) < 0) {
        syserr($errmsg[$main::L_DISP]);
        errlog($errmsg[$main::L_LOG], $conf{'facility'});
        exit 1;
    }
    foreach $dir (sort @dirlist) {
        $dir = $q->escapeHTML(basename($dir));
        $dispdir = $dir;
        $dispdir =~ s/-/\//;
        $displeft .= "<option value=\"" . $dir . "\">" . $dispdir . "</option>\n";
    }

    # ̤°Υ֥ͥåȤɤ߹(_otherǥ쥯ȥ꤬¸ߤΤ)
    if (-d $otherpath) {
        if (read_dir($otherpath, \@otherlist, $errmsg) < 0) {
            syserr($errmsg[$main::L_DISP]);
            errlog($errmsg[$main::L_LOG], $conf{'facility'});
            exit 1;
        }
        foreach $other (sort @otherlist) {
            $other = $q->escapeHTML(basename($other));
            $dispother = $other;
            $dispother =~ s/-/\//;
            $dispright .= "<option value=\"" . $other . "\">" . $dispother . "</option>\n";
        }
    }
}

# ܥ󲡲
if (defined($q->param('mod'))) {

    # Shared-networkѹ
    $ret = mod_sharednetwork($oldname, $networkname, \@selectleft, 
                             \@selectright, \@errmsg);
    if ($ret == 0) {
        # 
        $message = $main::LANG{$ENV{$main::DISPLANG}}{'INFO_SHARED_MODOK'};

        $errmsg[$main::L_LOG] = $main::LANG{$main::LOGLANG}{'INFO_SHARED_MODOK'};

        # Shared-network̾ѹƤΤߥåɲ
        if ($oldname ne $networkname) {
            $message .= "(" . $oldname . " -> " . $networkname . ")";
            $errmsg[$main::L_LOG] .= "(" . $oldname . " -> " . $networkname . ")";
        } else {
            $message .= "(" . $networkname . ")";
            $errmsg[$main::L_LOG] .= "(" . $networkname . ")";
        }

        errlog($errmsg[$main::L_LOG], $conf{'facility'});
        $postdata .= "&dispmsg=" . $message;

        # Shared-network̤
        if (location_display($LOCATION, $postdata, \@errmsg) == -1) {
            syserr($errmsg[$main::L_DISP]);
            errlog($errmsg[$main::L_LOG], $conf{'facility'});
            exit 1;
        }
    } else {
        # ԡ̺ɽ
        errlog($errmsg[$main::L_LOG], $conf{'facility'});
    }
}

# ܥ󲡲
if (defined($q->param('del'))) {

    # Shared-networkκ
    $ret = del_sharednetwork($networkname, \@selectleft, \@selectright,
                             \@errmsg);
    if ($ret == 0) {
        # 
        $message = $main::LANG{$ENV{$main::DISPLANG}}{'INFO_SHARED_DELOK'} .
                   "(" . $networkname . ")";
        $errmsg[$main::L_LOG] = $main::LANG{$main::LOGLANG}{'INFO_SHARED_DELOK'}                                . "(" . $networkname . ")";
        errlog($errmsg[$main::L_LOG], $conf{'facility'});
        $postdata .= "&dispmsg=" . $message;

        # Shared-network̤
        if (location_display($LOCATION, $postdata, \@errmsg) == -1) {
            syserr($errmsg[$main::L_DISP]);
            errlog($errmsg[$main::L_LOG], $conf{'facility'});
            exit 1;
        }
    } else {
        # ԡ̺ɽ
        errlog($errmsg[$main::L_LOG], $conf{'facility'});
    }
}

##########################################################
# ƥץ졼֤
##########################################################

my $id = "sharedmod"; 	# ɽѥڡID

# 
$inputdata{'OLDNAME'} = $q->escapeHTML($oldname);
$inputdata{'OLDPATH'} = $q->escapeHTML($oldpath);
$inputdata{'SHNAME'} = $q->escapeHTML($networkname);
$inputdata{'SUBNETLEFT'} = $displeft;
$inputdata{'SUBNETRIGHT'} = $dispright;

# ƥץ졼֤
if (page::replace_template($id, \$bodyhtml, \%inputdata, \@errmsg) != 0) {
    syserr($errmsg[$main::L_DISP]);
    errlog($errmsg[$main::L_LOG], $conf{'facility'});
    exit 1;
}

##########################################################
# ڡɽ
##########################################################

my $tabId = "nw";
my $obj;
my $syserr = 0;
$obj = new mypage;

# ɽʸ<br>ؤѴ
main::conv_br(\$errmsg[$main::L_DISP]);

if ($obj->display($id, \$syserr, $tabId, \@errmsg) == -1) {
    syserr($errmsg[$main::L_DISP]);
    errlog($errmsg[$main::L_LOG], $conf{'facility'});
    exit 1;
}

exit 0;
