#!/usr/bin/perl

#
# dhcpadmin
#
# Copyright (C) 2008 DesigNET, INC.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
#

##########################################################
#
# ֥ͥåϿ
#
# $RCSfile: subnetadd.cgi,v $
# $Revision: 1.12 $
# $Date: 2013/01/12 00:40:18 $
#
##########################################################

# 饤֥ɲ
use lib "../lib";

use strict;
use CGI;
use Net::IPv4Addr;
use Net::IP;

# 饤֥ɤ߹
require "libcommon.pl";
require "libpage.pl";
require "libpost.pl";
require "libhost.pl";
require "subnetadd.pl";

##########################################################
# ڡѥå
##########################################################
package mypage;

my $bodyhtml;

use vars qw(@ISA);

#
# pageλҥ饹
#
@ISA = qw(page);
sub new
{
    bless {};
}

#
# ɽ
#
sub display_body
{
    print $bodyhtml;
}

##########################################################
# ᥤѥå
##########################################################
package main;

##########################################################
# 
##########################################################

my $q = new CGI;
my %conf;
my @errmsg;
my %inputdata;
my $linkflag = 1;
my $ref = $q->param('REF');
my $ret;

# 
my $LOCATION = "subnetlist.cgi";

# 
if (dhcp_init(\%conf, $linkflag, $ref, \@errmsg) != 0) {
    syserr($errmsg[$main::L_DISP]);
    errlog($errmsg[$main::L_LOG], $conf{'facility'});
    exit 1;
}

%inputdata = ('SUBNETDATA' => $q->param('subnetlist'),
              'ADDDATA' => $q->param('adddata'),
              'ROUTER' => $q->param('router'),
              'DOMAINNAME' => $q->param('domainname'),
              'LEASETIME' => $q->param('leasetime'),
              'MAXLEASETIME' => $q->param('maxleasetime'),
              'DNSSERVER' => $q->param('dnsserver'),
              'EXOPTION' => $q->param('exoption'));

##########################################################
# ᥤ
##########################################################

my $subnetdir;
my $subnetdata;
my $subnetaddhtml;
my $hiddenhtml;
my %chgdata;
my $postresult;
my %subnetinfo;
my %serverlist;
my $mainflg;
my $postdata = "REF=" . $ENV{SCRIPT_NAME};
my $subnet = $q->param('subnet');
my $netmask = $q->param('netmask');
my %hiddendata;
my $shared;

# å
$errmsg[$main::L_DISP] = $main::LANG{$ENV{$main::DISPLANG}}{'INFO_SUBNETADD'};

# ɽѥǡ
$subnetdata = $q->param('subnetlist');
$shared = $q->param('shared');

# Ͽorξͤǥ
if ((defined($q->param('addition')) == 1) || (defined($q->param('back')) == 1)) {
    %hiddendata = ('SELECTNETWORK' => $subnetdata,
                   'SUBNET' => $subnet,
                   'NETMASK' => $netmask,
                   'SHARED' => $shared);


    if (hidden_decrypt(\%hiddendata, \%conf, \@errmsg) != 0) {
    # ǧ۾
        syserr($errmsg[$main::L_DISP]);
        errlog($errmsg[$main::L_LOG], $conf{'facility'});
        exit 1;
    }

    $subnetdata = $hiddendata{'SELECTNETWORK'};
    $subnet = $hiddendata{'SUBNET'};
    $netmask = $hiddendata{'NETMASK'};
    $shared = $hiddendata{'SHARED'};
}

# ѹܤƤȤ
if ($q->param('dest') eq "mod") {
    # ǡ
    if (make_subnetdata($subnetdata, \%inputdata, \$shared, \@errmsg) != 0) {
        syserr($errmsg[$main::L_DISP]);
        errlog($errmsg[$main::L_LOG], $conf{'facility'});
        exit 1;
    } 
}

# ϿܤƤȤ
if ($q->param('status') eq "subnetadd") {

    $shared = $main::OTHERDIR;
    
    # ֥ͥåȥǡ(subnetdataˤϥ쥯ȤΤϤäƤ)
    $inputdata{'SUBNETDATA'} = $subnet . "/" . $netmask;

    # ǡ
    make_firstdata(\%inputdata, \%conf);
}

# Ͽܥ󲡲
if (defined($q->param('addition'))) {

    # ʣ粽
    %hiddendata = ('SUBNETDATA' => $inputdata{'SUBNETDATA'},
                   'ADDDATA' => $q->param('adddata'));

    if (hidden_decrypt(\%hiddendata, \%conf, \@errmsg) != 0) {
    # ǧ۾
        syserr($errmsg[$main::L_DISP]);
        errlog($errmsg[$main::L_LOG], $conf{'facility'});
        exit 1;
    }

    $inputdata{'SUBNETDATA'} = $hiddendata{'SUBNETDATA'};
    $inputdata{'ADDDATA'} = $hiddendata{'ADDDATA'};
   
    # å
    $ret = check_alldata(\%inputdata, \@errmsg);

    if ($ret == -1) {
        syserr($errmsg[$main::L_DISP]);
        errlog($errmsg[$main::L_LOG], $conf{'facility'});
        exit 1;
    }

    if ($ret == 0) {

        # ɲý
        if (modify_subnet(\%inputdata, $shared, \@errmsg) != 0) {
            syserr($errmsg[$main::L_DISP]);
            errlog($errmsg[$main::L_LOG], $conf{'facility'});
            exit 1;
        }
        # ɲ
        # ݥȥǡȤΩ
        $postdata .= "&dispmsg=" . $main::LANG{$ENV{$main::DISPLANG}}{'INFO_SUBNET_ADD'} . "(" . $inputdata{'ADDDATA'} . ")";

        # ǡΥݥ
        if (location_display($LOCATION, $postdata, \@errmsg) == -1) {
            syserr($errmsg[$main::L_DISP]);
            errlog($errmsg[$main::L_LOG], $conf{'facility'});
            exit 1;
        }
    }
    $inputdata{'SUBNETDATA'} = $inputdata{'ADDDATA'};
}

# 
if (defined($q->param('back')) == 1) {

    # POSTǡȤΩ
    $postdata .= "&subnetlist=" . $subnetdata . "&subnet=" . $subnet . 
                 "&netmask=" . $netmask;

    # ǡΥݥ
    if (location_display($LOCATION, $postdata, \@errmsg) == -1) {
        syserr($errmsg[$main::L_DISP]);
        errlog($errmsg[$main::L_LOG], $conf{'facility'});
        exit 1;
    }
}

##########################################################
# ƥץ졼֤
##########################################################

my $id = "subnetadd"; 	# ɽѥڡID

# ǡŹ沽
$hiddendata{'SELECTNETWORK'} = $subnetdata;
$hiddendata{'ADDDATA'} = $inputdata{'SUBNETDATA'};
$hiddendata{'ADDSUBNET'} = $subnet;
$hiddendata{'ADDNETMASK'} = $netmask;
$hiddendata{'SHARED'} = $shared;

if (hidden_crypt(\%hiddendata, \%conf, \@errmsg) == -1) {
    # ǧ۾
    syserr($errmsg[$main::L_DISP]);
    errlog($errmsg[$main::L_LOG], $conf{'facility'});
    exit 1;
}

# ִǡϿ
$inputdata{'SELECTNETWORK'} = $q->escapeHTML($hiddendata{'SELECTNETWORK'});
$inputdata{'ADDDATA'} = $q->escapeHTML($hiddendata{'ADDDATA'});
$inputdata{'ADDSUBNET'} = $q->escapeHTML($hiddendata{'ADDSUBNET'});
$inputdata{'ADDNETMASK'} = $q->escapeHTML($hiddendata{'ADDNETMASK'});
$inputdata{'SHARED'} = $q->escapeHTML($hiddendata{'SHARED'});

# 
$inputdata{'ROUTER'} = $q->escapeHTML($inputdata{'ROUTER'});
$inputdata{'DOMAINNAME'} = $q->escapeHTML($inputdata{'DOMAINNAME'});
$inputdata{'LEASETIME'} = $q->escapeHTML($inputdata{'LEASETIME'});
$inputdata{'DNSSERVER'} = $q->escapeHTML($inputdata{'DNSSERVER'});
$inputdata{'EXOPTION'} = $q->escapeHTML($inputdata{'EXOPTION'});

# ƥץ졼֤
if (page::replace_template($id, \$bodyhtml, \%inputdata, \@errmsg) != 0) {
    syserr($errmsg[$main::L_DISP]);
    errlog($errmsg[$main::L_LOG], $conf{'facility'});
    exit 1;
}

##########################################################
# ڡɽ
##########################################################

my $tabId = "nw";
my $obj;
my $syserr = 0;
$obj = new mypage;

# ɽʸ<br>ؤѴ
main::conv_br(\$errmsg[$main::L_DISP]);

if ($obj->display($id, \$syserr, $tabId, \@errmsg) == -1) {
    syserr($errmsg[$main::L_DISP]);
    errlog($errmsg[$main::L_LOG], $conf{'facility'});
    exit 1;
}

exit 0;
