#
# dhcpadmin
#
# Copyright (C) 2008 DesigNET, INC.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
#

##########################################################
#
# host_search.cgi
#
# $RCSfile: host_search.pl,v $
# $Revision: 1.19 $
# $Date: 2013/01/17 00:31:51 $
#
##########################################################

use strict;
use Jcode;

# ؿ⥰Хѿ

my $HOSTNAME = 0;
my $MACADDRESS = 1;
my $IPADDRESS = 2;
my $BOOTING_FLAG = 3;

my $DELSUBNRT = 0;
my $DELMACADDRESS = 1;
my $DELHOSTNAME = 2;

# IP߽
my $ALLOW_DENY_BOOTING = "noselect";
my $ALLOW_STR = "allow";
my $DENY_STR = "deny";
my $ALLOW_JP_STR = "";
my $DENY_JP_STR = "";

# ֤ʸκ
my $REPLACESTR = $WORKDIR . "\/";

#
# 饤ȸ
#
# []
#	arg0	subnet̾(Ϣ)
#	arg1	ۥ̾
#	arg2	ѴMACɥ쥹̾
#	arg3	IPɥ쥹
#	arg4	IP߽ե饰
#	arg5	ϥե饰(0:web, 1:csv)
#	arg6	å饤
#	arg7	
#	arg8	
#	arg9	顼å
#
# [֤]
#	0       OK
#	-1      ƥ२顼
#
#

sub search_client
{
    my ($subnet, $hostname, $convmacaddr, $ipaddr, $ipflag, $outputflag, $checkdata, $hostsearch, $macsearch, 
        $errmsg) = @_;
    my @subnetdirlist;
    my @tmpdirlist;
    my @tmpshdirlist;
    my $subnetdirline;
    my $subnetdir;
    my $tmpdir;
    my $tmpsubnetdir;
    my %dirlist;
    my $line;
    my $resultnum = 0;
    my $shared;
    my $subnetlist_key;
    my $subnetlist;
    my @tmpitem;
    my %tmpline;
    my $dirpath;

    # ʤξ
    if ($#$subnet == -1) {
        # ֥ͥåɤ߽Ф
        if (read_dir($WORKDIR, \@tmpdirlist, $errmsg) < 0 ) {
            return -1;
        }

        # shared-networkǥ쥯ȥʬΥꥹȤ
        foreach $shared (@tmpdirlist) {

            # ǥ쥯ȥǤС۲Υեɤ߹
            if(-d $shared) {
                if (read_dir($shared, \@tmpshdirlist, $errmsg) < 0 ) {
                    return -1;
                }
                # ǥ쥯ȥ̾Υ
                # 
                %dirlist = ();
                
                # ֥ͥåȤ򥽡ѤbitѴ
                conv_bit_subnet(\@tmpshdirlist, \%dirlist, $errmsg);

                # shrared̾ǥȤ
                foreach $subnetlist_key (sort keys %dirlist) {
                    $subnetlist = $dirlist{$subnetlist_key};

                    # ֥ͥåȤǥȤ
                    foreach $line (sort {$subnetlist -> {$a} cmp $subnetlist -> {$b}} keys %$subnetlist) {

                        # ˥ǥ쥯ȥѥ
                        $tmpline{$line} = $$subnetlist{$line};
                    }
                }
            } 
        }

        # Υ֥ͥåȤǤȤ
        foreach $line (sort {$a cmp $b} keys %tmpline) {
            push(@subnetdirlist, $tmpline{$line});
        }

    # ֥ͥåȤ򤵤Ƥ
    } else {
        foreach $tmpsubnetdir (@$subnet) {

            # sharedsubnetʬ
            @tmpitem = split(/\//, $tmpsubnetdir);

            # ֥ͥåȤΥѥ̾
            $subnetdirline = $WORKDIR . "/" . $tmpitem[0] . "/" .
                             $tmpitem[1] . "-" . $tmpitem[2];
            push(@subnetdirlist, $subnetdirline);
        }
    }

    # subnetɤ߽Ф
    foreach $subnetdir (@subnetdirlist) {

        # ֥ͥåȤȤ˸
        if (search_client_subnet($subnetdir, $hostname, $convmacaddr,
                                 $ipaddr, $ipflag, $outputflag, $checkdata,
                                 \$resultnum, $hostsearch, $macsearch,
                                 $errmsg) == -1) { 
            return -1;
        }
    }
 
    # csvϤǡפ븡̤ʤ
    if ($outputflag == 1 && $resultnum == 0) {
        print Jcode->new($LANG{$ENV{$DISPLANG}}{'INFO_SEARCH_NORESULT'}, 
                         "euc")->sjis . "\r\n";
    }

    return 0;
}

#
# 饤ȸ(subnet)
#
# []
#	arg0	subnet̾
#	arg1	ۥ̾
#	arg2	ѴMACɥ쥹̾
#	arg3	IP߽ե饰
#	arg4	줿饤ȿ()
#	arg5	ϥե饰(0:web, 1:csv)
#	arg6	򤵤줿ǡ(ݻ)
#	arg7	
#	arg8	顼å
#
# [֤]
#	0       OK
#	1       subnetη顼(Ф)
#	-1      ƥ२顼
#
#

sub search_client_subnet
{
    my ($subnet, $hostname, $convmacaddr, $ipaddr, $ipflag, $outputflg,
        $checkdata, $resultnum, $hostsearch, $macsearch,  $errmsg) = @_;
    my $hostfilepath;
    my $line;
    my @hostvalue;
    my $output;
    my $inputstr;
    my $ipflagstr;
    my $subnetdata;
    my $shsubnetdata;
    my $bootingstr;
    my $checkstr;
    my $check;
    my $linkstr;
    my $delcheckstr;
    my $escape;
    my $convhost;
    my $lchostname;
    my $searchhostname;
    my $lcmacaddr;
    my $nocolonmacaddr;
    my $sharedname;

    $escape = new CGI;

    # ʸ(subnet)
    if (conv_outputsubnet($subnet, \$subnetdata, \$sharedname, $errmsg)) {
        # 
        return 1;
    }

    # ɤ߹߲ǽ
    if (! -r $subnet) {
        $$errmsg[$L_DISP] = $LANG{$ENV{$DISPLANG}}{'ERR_TMP_DIR1'} . "(" . 
                            $subnet .  ")";
        $$errmsg[$L_LOG] = $LANG{$LOGLANG}{'ERR_TMP_DIR1'} . "(" . 
                           $subnet . ")";
        return -1;
    }
    
    # hostեΥѥ
    $hostfilepath = $subnet . "/host";

    # ե뤬¸ߤ뤫
    if (!-e $hostfilepath) {
        # subnetľξ
        return 0;
    }

    # hostեɤ߹
    if (open(IN, $hostfilepath) == 0) {
        $$errmsg[$L_DISP] = $LANG{$ENV{$DISPLANG}}{'ERR_TMP_FILE1'} . "(" . 
                            $hostfilepath .  ")";
        $$errmsg[$L_LOG] = $LANG{$LOGLANG}{'ERR_TMP_FILE1'} . "(" . 
                           $hostfilepath . ")";
        return -1;
    }

    while (<IN>) {

        $line = $_;

        # Ԥ
        chop($line);

        # ,ʬ
        @hostvalue = split(/\,/, $line);

        # ۥ̾Ǹ(ʸʸ̤ʤ)
        # ɤ߽Фۥ̾ʸѴ
        $lchostname = lc($hostvalue[$HOSTNAME]);

        # ۥ̾ʸѴ
        $searchhostname = lc($hostname);

        # ׸ξ
        if ($hostsearch == 0) {
            if ($hostname ne "" && $searchhostname ne $lchostname) {
                next;
            }
        # ʬ׸ξ
        } else {
            if ($hostname ne "" && $lchostname !~ /$searchhostname/) {
                next;
            }
        }

        # MACɥ쥹Ǹ(ʸʸ̤ʤ)
        $lcmacaddr = lc($hostvalue[$MACADDRESS]);
        # ׸ξ
        if ($macsearch == 0) {
            if ($convmacaddr ne "" && $convmacaddr ne $lcmacaddr) {
                next;
            }
        # ʬ׸ξ
        } else {

            # äƤ硢դΥۥ̾Ӥ
            if ($convmacaddr =~ /\:/) {
                if ($convmacaddr ne "" && $lcmacaddr !~ /$convmacaddr/) {
                    next;
                }
            # äƤʤä硢ʤΥۥ̾Ӥ򤹤
            } else { 
                # ɤ߹MACɥ쥹
                $nocolonmacaddr = $lcmacaddr;
                $nocolonmacaddr =~ s/\://g;

                if ($convmacaddr ne "" && $nocolonmacaddr !~ /$convmacaddr/) {
                    next;
                }
            }
        }

        # IPɥ쥹Ǹ;
        if ($ipaddr ne "" && $ipaddr ne $hostvalue[$IPADDRESS]) {
            next;
        }

        # IP߽Ǹ
        if ($ipflag ne $ALLOW_DENY_BOOTING) {

            # IP߽Ǹ
            if ($ipflag ne $hostvalue[$BOOTING_FLAG]) {
                next;
            }
        }

        # ʸѴ(ġ)
        if ($hostvalue[$BOOTING_FLAG] eq $ALLOW_STR) {
            $bootingstr = $ALLOW_JP_STR;
        } else {
            $bootingstr = $DENY_JP_STR;
        }

        # ׿Υ
        $$resultnum++;

        # ϹԺ
        if ($outputflg == 0) {
            # åѤκƸ
            $check = "";
            foreach $checkstr (@$checkdata) {
                $delcheckstr = $subnetdata . "," . $hostvalue[$MACADDRESS] .
                               "," . $hostvalue[$HOSTNAME];
                if ($checkstr eq $delcheckstr) {
                    $check = "checked";
                    last;
                }
            }
            #             
            $convhost = "";

            # ۥ̾Ѵ
            conv_host_br($escape->escapeHTML($hostvalue[$HOSTNAME]), \$convhost);

            
            # valueϤǡ롣shared̾/֥ͥå[XXXX/XXXX]
            $shsubnetdata = $sharedname . "/" . $subnetdata;

            # webʸ
            $inputstr = '<input type=checkbox name=deldata value="' . 
                        $shsubnetdata . "," . $hostvalue[$MACADDRESS] . ","  
                        . $hostvalue[$HOSTNAME] . "\" " . $check . '>';
            $linkstr = '<a href="#" onClick="modlinkSubmit(\'' . $shsubnetdata .
                       "', '" . $escape->escapeHTML($hostvalue[$HOSTNAME]) . 
                       "', '" .  $hostvalue[$MACADDRESS] . "'" . 
                       ", '" .  $hostvalue[$IPADDRESS] . "', '" . 
                       $hostvalue[$BOOTING_FLAG] . '\')">';
            $output = "<tr>\n" . 
                      '<td class="resultitem">' . $inputstr . "</td>\n" . 
                      '<td class="resultitem">' . $subnetdata . "</td>\n" . 
                      '<td class="resultitem">' . $linkstr . $convhost . "</td>\n" . 
                      '<td class="resultitem">' .
                                $escape->escapeHTML($hostvalue[$MACADDRESS]) . "</td>\n" . 
                      '<td class="resultitem">' .
                                $escape->escapeHTML($hostvalue[$IPADDRESS]) . "</td>\n" . 
                      '<td class="resultitem">' . $bootingstr . "</td>\n" . 
                      "</tr>\n";
        } else {
            # csvʸ(euc)
            $output = $subnetdata . "," . $hostvalue[$HOSTNAME] . "," 
                      . $hostvalue[$MACADDRESS] . "," . $hostvalue[$IPADDRESS] . ","
                      .  Jcode->new($bootingstr, "euc")->sjis . "\r\n";
        }
    

        # 
        print $output;
    }

    # 
    close(IN);

    return 0;
}

#
# ۥ̾ɽhtmlκ
#
# 
#	arg0	ɽhtml(Ϥ)
#	arg1	򤵤줿μ(Ϥ)
#	arg2	顼å
#
# ֤
#	0	   
#
sub make_hostsearchhtml
{
    my ($hostsearchhtml, $hostsearch, $errmsg) = @_;
    my $allmatch = "";
    my $partmatch = "";
    my $tmpline = "";
    
    # פä
    if ($hostsearch == 0) {
        $allmatch = "selected";

    # ʬפä
    } elsif ($hostsearch == 1) {
        $partmatch = "selected";
    }

    # HTML
    $tmpline = "<option value=\"allmatch\" " . $allmatch . ">Ȱפ\n" .
               "<option value=\"partmatch\" " . $partmatch .">ޤ\n";

    # Ϥѿ
    $$hostsearchhtml = $tmpline;
  
    return 0;
}


#
# MACɥ쥹ɽhtmlκ
#
# 
#	arg0	ɽhtml(Ϥ)
#	arg1	򤵤줿μ(Ϥ)
#	arg3	顼å
#
# ֤
#	0	   
#
sub make_macsearchhtml
{
    my ($macsearchhtml, $macsearch, $errmsg) = @_;
    my $allmatch = "";
    my $partmatch = "";
    my $tmpline = "";
    
    # פä
    if ($macsearch == 0) {
        $allmatch = "selected";

    # ʬפä
    } elsif ($macsearch == 1) {
        $partmatch = "selected";
    }

    # HTML
    $tmpline = "<option value=\"allmatch\" " . $allmatch . ">Ȱפ\n" .
               "<option value=\"partmatch\" " . $partmatch .">ޤ\n";

    # Ϥѿ
    $$macsearchhtml = $tmpline;
  
    return 0;
}

#
# hostκ
#
# 
#	arg0	Ϥ줿(Ϥ)
#	arg1	å(Ϥ)
#	arg2	顼å
#
# ֤
#	0	
#	-1	ƥ२顼
#

sub del_host
{
    my ($deldata, $infomsg, $errmsg) = @_;
    my $subnetdir;
    my $subnetdirpath;
    my @value;
    my $delhost;
    my %data;
    my $subnet;
    my $bitsubnet;
    my @dellist;
    my $macaddr;
    my $bitsubnetdir;
    my @arr;
    
    foreach $delhost (@$deldata) {

        # subnet̾host̾ʬ
        @value = split(/,/, $delhost); 
        @arr = split(/\//, $value[$DELSUBNRT]); 

        # bitѴѿǼ
        $bitsubnetdir = $arr[1];

        # ϢǼ
        push(@{$data{add2bin($bitsubnetdir)}}, $delhost);
    }

    # 륵֥ͥåȤɤ߽Ф
    foreach my $bitsubnet (sort {$a cmp $b} keys %data) {

        # 
        @dellist = ();

        # ֥ͥåȤȤ˺
        if (del_host_subnet(\@{$data{$bitsubnet}}, $infomsg, $errmsg) < 0) {
            return -1;
        }
    }

    return 0;
}

#
# hostκ(subnet)
#
# 
#	arg0	MACɥ쥹,subnet()
#	arg1	å(Ϥ)
#	arg2	顼å
#
# ֤
#	0	
#	-1	ƥ२顼
#

sub del_host_subnet
{
    my ($delinfo, $infomsg, $errmsg) = @_;
    my $oldhostpath;
    my $tmphostpath;
    my %deldata;
    my $line;
    my @value;
    my @arr;
    my $checkflag;
    my $delmsg = "";
    my $writeline;
    my $delhost;
    my $subnetdir;
    my @delhostname;
    my $tmphostname;
    my @tmpshared;

    foreach $delhost (@$delinfo) {

        @arr = split(/,/, $delhost); 
        
        # ϢؤγǼ
        $deldata{$arr[$DELMACADDRESS]} = $arr[$DELSUBNRT];
        
        # 륵֥ͥå̾μФ
        $subnetdir = $arr[$DELSUBNRT];

        # ۥ̾μФ
        push(@delhostname, $arr[$DELHOSTNAME]);
    }

    # sharedȥ֥ͥåȤʬ
    @tmpshared = split(/\//, $subnetdir);

    # ¸Υե̾κ
    $oldhostpath = $WORKDIR . "/" . $tmpshared[0] . "/" . $tmpshared[1] . 
                   "-" . $tmpshared[2] . "/host";

    # ե̾κ
    $tmphostpath = $WORKDIR . "/" . $tmpshared[0] . "/" . $tmpshared[1] . 
                   "-" . $tmpshared[2] . "/host.tmp";

    # ΰե
    if (write_file($tmphostpath, "", $errmsg)) {
        return -1;
    }

    # եΥץ
    if (open(IN, $oldhostpath) == 0) {
        $$errmsg[$L_DISP] = $$infomsg . $LANG{$ENV{$DISPLANG}}{'ERR_TMP_FILE1'} . "(" 
                           . $oldhostpath .  ")";
        $$errmsg[$L_LOG] = $LANG{$LOGLANG}{'ERR_TMP_FILE1'} .  "(" .  
                           $oldhostpath . ")";
        return -1;
    }

    while (<IN>) {

        # 
        $checkflag = 0;

        $line = $_;

        # ʬ
        @value = split(/,/, $line);


        # MACɥ쥹ɤ
        if (defined($deldata{$value[$MACADDRESS]}) == 1) {
             next;
        }

        # 񤭹ʸɵ
        $writeline .= $line;
    }

    # 
    close(IN);

    # åå
    foreach $tmphostname (@delhostname) {

        $delmsg .= $LANG{$ENV{$DISPLANG}}{'INFO_DEL_HOST'} .
                  "(" . $tmphostname . ")\n";
    }

    # եκ
    if (write_file($tmphostpath, $writeline, $errmsg) < 0) {

        # եκ
        unlink($tmphostpath);
        return -1;
    }

    # եΥ͡
    if (rename($tmphostpath, $oldhostpath) == 0) {

        # եκ
        unlink($tmphostpath);
        $$errmsg[$L_DISP] = $$infomsg . $LANG{$ENV{$DISPLANG}}{'ERR_RENAME_FILE'} . 
                            "(" . $tmphostpath . "<br>->" . $oldhostpath .  ")";
        $$errmsg[$L_LOG] = $LANG{$LOGLANG}{'ERR_RENAME_FILE'} .  "(" .  
                           $tmphostpath . "->" . $oldhostpath . ")";
        return -1;
    }

    $$infomsg .= $delmsg; 

    return 0;
}

1;
