#
# dhcpadmin
#
# Copyright (C) 2008 DesigNET, INC.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
#

##########################################################
#
# ̥饤֥
#
# $RCSfile: libcommon.pl,v $
# $Revision: 1.145 $
# $Date: 2013/02/08 01:00:56 $
#
##########################################################

use strict;
use vars qw/%LANG $L_LOG $L_DISP $LOGLANG/;
use vars qw/$DHCPDDIR $ETCDIR $WORKDIR $WORKDIR $DHCPDCONFTMP $DHCPADMINCONF $LOCKFILE/;
use vars qw/$DHCPDCONF $TEMPDIR $TABFILE $TITLEFILE $IMAGEDIR $SERVERLISTFILE/;
use vars qw/$USERLISTFILE/;
use vars qw/$DISPLANG $LOGLANG $L_DISP $L_LOG $OTHERDIR/;

#############ե롦ǥ쥯ȥ#############

$DHCPDDIR = "/usr/local/DhcpAdmin";
$ETCDIR = $DHCPDDIR . "/etc";
$WORKDIR = $DHCPDDIR . "/work";
$DHCPDCONFTMP = $WORKDIR . "/dhcpd_conf.tmp";
$DHCPDCONF = $ETCDIR . "/dhcpd.conf";
$DHCPADMINCONF = $ETCDIR .  "/dhcpadmin.conf";
$TEMPDIR = $DHCPDDIR ."/template";
$TABFILE = $ETCDIR . "/tab";
$LOCKFILE = $WORKDIR . "/.lock";
$TITLEFILE = $TEMPDIR . "/title";
$IMAGEDIR = $DHCPDDIR . "/cgi/image";
$SERVERLISTFILE = $ETCDIR . "/serverlist";
$USERLISTFILE = $ETCDIR . "/usertable";
$OTHERDIR = "_other";

##################ؿ⥰Х##################

my @USELANG = ("en_US", "ja_JP.eucJP");
$DISPLANG = "DHCPADMIN_LANG";
#$LOGLANG = "en_US";
$LOGLANG = "ja_JP.eucJP";
$L_DISP = 0;
$L_LOG = 1;
my $DIRMODE = 0755;
my $KEYFILE = $ETCDIR . "/admin.key";
my $TOUCH="/usr/bin/touch";

# ɤ߹ܤȥåؿ
my %entry_info = ("syslogfacility" => \&check_facility,
                  "locktime" => \&check_num,
                  "defdomain" => \&check_domain,
                  "defleasetime" => \&check_num,
                  "defmaxleasetime" => \&check_num,
                  "restartcom" => \&check_com,
                  "checkcom" => \&check_com,
                  "dhcplease" => \&check_filename,
                  "leaseslistnum" => \&check_num,
                  "openssl" => \&check_com,
                  "touch" => \&check_com,
                  "tac" => \&check_com,
                  "optionname" => \&no_check);

# ǥե
my %entry_def = ("syslogfacility" => "local0",
                 "locktime" => "600",
                 "restartcom" => "/opt/dhcpadmin/bin/dhcprestart -r",
                 "checkcom" => "/opt/dhcpadmin/bin/dhcprestart -c",
                 "dhcplease" => "/var/db/dhcp/dhcpd.leases",
                 "leaseslistnum" => "20",
                 "openssl" => "/usr/bin/openssl",
                 "touch" => "/usr/bin/touch",
                 "tac" => "/usr/bin/tac");

#
# 顼
#
# []
#	arg0	顼å
#	arg1	եƥ̾
#
# [֤]
#	0	OK
#
#

sub errlog
{
    use Sys::Syslog qw(:DEFAULT setlogsock);
    my ($message, $facility) = @_;
    my $pgname = "dhcpadmin";
    my @lines;
    my $line;

    my %facilitynames =( "auth", "LOG_AUTH", "cron", "LOG_CRON",
			 "daemon", "LOG_DAEMON", "kern", "LOG_KERN",
			 "lpr", "LOG_LPR", "mail", "LOG_MAIL",
			 "news", "LOG_NEWS", "syslog", "LOG_SYSLOG",
			 "user", "LOG_USER", "uucp", "LOG_UUCP",
			 "local0", "LOG_LOCAL0", "local1", "LOG_LOCAL1",
			 "local2", "LOG_LOCAL2", "local3", "LOG_LOCAL3",
			 "local4", "LOG_LOCAL4", "local5", "LOG_LOCAL5",
			 "local6", "LOG_LOCAL6", "local7", "LOG_LOCAL7",
			 "authpriv", "LOG_AUTHPRIV");

    openlog($pgname, 'pid', $facilitynames{$facility});

    # Ԥʬ䤷1ñ̤ǽ
    @lines = split(/\n/, $message);
    foreach $line(@lines) {
	syslog("LOG_ERR", $ENV{'REMOTE_USER'} . " " . $line);
    }

    closelog();
    return 0;
}

#
# ååѥ桼ǧ
#
# []
#       arg1    ⡼IP
#       arg0    顼å
#
# [֤]
#       0       桼פ
#       1       桼פʤ
#      -1       åե륪ץ󥨥顼
#
#

sub check_lock_user
{

    my ($rip, $errmsg) = @_;
    my $cuser;
    my $crip;

    # åեɹ
    if (open(LOCK, $LOCKFILE) == 0) {
        $$errmsg[$L_DISP] = $LANG{$ENV{$DISPLANG}}{'ERR_LOCK_FILE1'} . "(" . $LOCKFILE . ")";
        $$errmsg[$L_LOG] = $LANG{$LOGLANG}{'ERR_LOCK_FILE1'} . "(" . $LOCKFILE . ")";
        return -1;
    }

    # ǡФ
    $cuser = <LOCK>;
    $crip = <LOCK>;
    close(LOCK);

    # Ժ
    chomp($cuser);
    chomp($crip);

    # 桼å
    if ($ENV{'REMOTE_USER'} ne $cuser) {
        $$errmsg[$L_DISP] = $LANG{$ENV{$DISPLANG}}{'ERR_LOCK_USER'} . "(" . $cuser . ")";
        $$errmsg[$L_LOG] = $LANG{$LOGLANG}{'ERR_LOCK_USER'} . "(" . $cuser . ")";
        #桼פʤ
        return 1;
    }

    # ⡼IPå
    if ($rip ne "") {
        if ($rip ne $crip) {
            $$errmsg[$L_DISP] = $LANG{$ENV{$DISPLANG}}{'ERR_LOCK_USER'} . "(" . $cuser . ")";
            $$errmsg[$L_LOG] = $LANG{$LOGLANG}{'ERR_LOCK_USER'} . "(" . $cuser . ")";
            return 1;
        }
    }

    # 桼IPɥ쥹
    return 0;

}

#
# ååmtimeå
#
# []
#       arg0    åͭ
#
# [֤]
#       0       ϰϤʤ
#       1       ϰϳ
#       2       OK:եʤ
#

sub check_lock_time
{

    my ($ltime) = @_;
    my @fstat;
    my $nowtime;
    my $etime;

    # ե뤬̵ϰϳ
    if ( ! -f $LOCKFILE ) {
        # ֳͭ
        return 2;
    }

    # ơ
    @fstat = stat($LOCKFILE);

    # åͭ¤­
    $etime = $fstat[9] + $ltime;

    # ߻
    $nowtime = time();

    # ֥ͭå
    if ( $nowtime > $etime ) {
        # ֳͭ
        return 1;
    }

    # ͭ
    return 0;
}

#
# å
#
# []
#       arg0    顼å
#
# [֤]
#       0       ϰϳ
#       1       ϰϤʤ
#

sub create_lock
{

    my ($rip, $errmsg) = @_;

    # åեν
    if (open(LOCK, "> $LOCKFILE") == 0) {
        $$errmsg[$L_DISP] = $LANG{$ENV{$DISPLANG}}{'ERR_LOCK_FILE1'} . "(" . $LOCKFILE . ")";
        $$errmsg[$L_LOG] = $LANG{$LOGLANG}{'ERR_LOCK_FILE1'} . "(" . $LOCKFILE . ")";
        return -1;
    }

    # 桼̾
    printf LOCK $ENV{'REMOTE_USER'} . "\n";
    printf LOCK $rip . "\n";

    close(LOCK);

    return 0;
}

#
# åγǧȳ
#
# []
#       arg0    åͭ
#       arg1    顼å
#
# [֤]
#       0       ͭʥåޤϥåγ
#       1       ̤Υ桼
#      -1       ƥ२顼
#

sub login_session
{

    my ($conf, $rip, $topflg, $errmsg) = @_;
    my $lret;
    my $uret;

    # ͭ¥å
    $lret = check_lock_time($$conf{'locktime'});

    # Ǥꡢե뤬ʤڤ
    if ( ($topflg == 1) && ($lret == 2) || ($topflg == 1) && ($lret == 1) ) {
        # åե
        if (create_lock($rip, $errmsg) == -1 ) {
            # ƥ२顼
            return -1;
        }
        return 0;
    }

    # ̾ǥåե뤬ʤ
    if ( ($topflg == 0) && ($lret == 2) || ($topflg == 0) && ($lret == 1) ) {
        $$errmsg[$L_DISP] = $LANG{$ENV{$DISPLANG}}{'ERR_SESS_TIMEOUT'};
        $$errmsg[$L_LOG] = $LANG{$LOGLANG}{'ERR_SESS_TIMEOUT'};
        return 1;
    }

    # 桼γǧ
    $uret = check_lock_user($rip, $errmsg);

    # ƥ२顼
    if ($uret == -1) {
        return -1;
    }

    # åδ˥桼פʤ̥桼
    if (($lret == 0) && ($uret == 1)) {
        return 1;
    }

    # ͭ³&桼:å󥿥ॢ
    if (($lret == 1) && ($uret == 0)) {
        $$errmsg[$L_DISP] = $LANG{$ENV{$DISPLANG}}{'ERR_SESS_TIMEOUT'};
        $$errmsg[$L_LOG] = $LANG{$LOGLANG}{'ERR_SESS_TIMEOUT'};
        return 1;
    }

    # ڤ&̤Υ桼
    if (($lret == 1) && ($uret == 1)) {
        # åե
        if (create_lock($rip, $errmsg) == -1 ) {
            # ƥ२顼
            return -1;
        }
        undef($$errmsg[$L_DISP]);
        undef($$errmsg[$L_LOG]);
        return 0;
    }

    # ͭ¤αĹ
    `$$conf{'touch'} $LOCKFILE`;

    return 0;
}

#
# 
#
# []
#       arg0    åͭ
#       arg1    顼å
#
# [֤]
#       0       ͭʥåޤϥåγ
#       1       ̤Υ桼
#      -1       ƥ२顼
#

sub logout_session
{

    my ($ltime, $errmsg) = @_;
    my $ret;
    my $rip;

    # ͭ¥å
    if (check_lock_time($ltime, $errmsg) == 0 ) {
        # åե뤬ͭǤХ桼γǧԤ
        $ret = check_lock_user($rip, $errmsg);

        if ($ret != 0) {
            return $ret;
        }
    }

    # åե뤬̵Ͻλ
    if ( !-e $LOCKFILE ) {
        return 0;
    }

    # å
    if (unlink($LOCKFILE) != 1) {
        # åե
        $$errmsg[$L_DISP] = $LANG{$ENV{$DISPLANG}}{'ERR_LOCK_FILE2'} . "(" . $LOCKFILE . ")";
        $$errmsg[$L_LOG] = $LANG{$LOGLANG}{'ERR_LOCK_FILE2'} . "(" . $LOCKFILE . ")";
        return -1;
    }

    return 0;
}

#
# եν񤭹
#
# 
#	arg0	񤭹ե̾
#	arg1	񤭹ʸ
#	arg2	顼å
#
# ֤
#	0	
#	-1	顼
#
sub write_file
{
    my ($filename, $writeline, $errmsg) = @_;

    # ե񤭹ߥ⡼ɤǥץ
    if (open(OUT, ">" . $filename) == 0) {
        $$errmsg[$L_DISP] .= $LANG{$ENV{$DISPLANG}}{'ERR_TMP_FILE2'} . "("
                            . $filename . ")";
        $$errmsg[$L_LOG] .= $LANG{$LOGLANG}{'ERR_TMP_FILE2'} . "("
                            . $filename . ")";
        return -1;
    }

    # 񤭹
    print OUT $writeline;

    # 
    close(OUT);

    return 0;
}

#
# ǥ쥯ȥɤ߹
#
# 
#	arg0	ɤ߹ǥ쥯ȥ̾
#	arg1	ǥ쥯ȥ۲Υե̾(Ϥ)
#	arg2	顼å
#
# ֤
#	0	
#	-1	顼
#
sub read_dir
{
    my ($dirname, $filelist, $errmsg) = @_;
    my $filename;
    my $filepath;

    # 
    undef(@$filelist);

    # ǥ쥯ȥ򥪡ץ
    if (opendir(DIR, $dirname) != 1) {
        $$errmsg[$L_DISP] = $LANG{$ENV{$DISPLANG}}{'ERR_TMP_DIR1'} . "("
                            . $dirname . ")";
        $$errmsg[$L_LOG] = $LANG{$LOGLANG}{'ERR_TMP_DIR1'} . "("
                            . $dirname . ")";
        return -1;
    }

    # եǼǥ쥯ȥ۲Υǥ쥯ȥ̾
    while ($filename = readdir(DIR)) {
        if (($filename eq "..") || ($filename eq ".")) {
            next;
        }
        $filepath = $dirname . "/" . $filename;
        push(@$filelist, $filepath);
    }

    # 
    closedir(DIR);

    return 0;
}

#
# ǥ쥯ȥκ
#
# 
#	arg0	ǥ쥯ȥ̾
#	arg1	顼å
#
# ֤
#	0	
#	-1	顼
#
sub make_dir
{
    my ($dirname, $errmsg) = @_;

    # ǥ쥯ȥ
    mkdir($dirname, $DIRMODE);
    if (! -d $dirname) {
        $$errmsg[$L_DISP] .= $LANG{$ENV{$DISPLANG}}{'ERR_TMP_DIR3'} . "("
                            . $dirname . ")";
        $$errmsg[$L_LOG] .= $LANG{$LOGLANG}{'ERR_TMP_DIR3'} . "("
                            . $dirname . ")";
        return -1;
    }

    return 0;
}

#
# եɤ߹سǼ
#
# []
#	arg0	ǡǼ
#	arg1	顼å
#
# [֤]
#	0	OK
#	-1	եɤ߹ߥ顼
#	1	顼
#

sub read_conf 
{
    my ($adminconf, $errmsg) = @_;
    my $entry;
    my $value;
    my $name;
    my @entry_names = keys(%entry_info);
    my @def_names = keys(%entry_def);
    my $count = 0;

    # եɤ߹
    if (open(IN, $DHCPADMINCONF) == 0) {
        $$errmsg[$L_DISP] = $LANG{$ENV{$DISPLANG}}{'ERR_CONF_FILE'} . 
                            " (" . $DHCPADMINCONF . ")";
        $$errmsg[$L_LOG] =$LANG{$LOGLANG}{'ERR_CONF_FILE'} . 
                            " (" . $DHCPADMINCONF . ")";
        return -1;
    }

    while (<IN>) {
        # ǸΥեɤ\n򤱤
        chomp;

        # Կ
        $count++;

        # ȡԤ̵
        if (($_ =~ /^#/) || ($_=~ /^$/)) {
            next;
        }

        # "="ڤ
        ($entry, $value) = split("=", $_, 2);

        # ܤʸѴ
        $entry = lc($entry);

        # ܤꤵƤ뤫å
        if (defined($entry_info{$entry})) {

            # ܤ¸ߥå
            if (defined($$adminconf{$entry})) {
                $$errmsg[$L_DISP] = $LANG{$ENV{$DISPLANG}}{'ERR_CONF_FORM'} . 
                                    " (line:" . $count . ")";
                $$errmsg[$L_LOG] =$LANG{$LOGLANG}{'ERR_CONF_FORM'} . 
                                  " (line:" . $count . ")";
                return 1;
            }

            # ͤΥå
            if ($value eq "" || &{$entry_info{$entry}}($value) != 0 ) {
                $$errmsg[$L_DISP] = $LANG{$ENV{$DISPLANG}}{'ERR_CONF_FORM'} . 
                                    " (line:" . $count . ")";
                $$errmsg[$L_LOG] =$LANG{$LOGLANG}{'ERR_CONF_FORM'} . 
                                  " (line:" . $count . ")";
                return 1;
            }
            $$adminconf{$entry} = $value;

        # ꤵƤʤܤ¸ߤ
        } else {
            $$errmsg[$L_DISP] = $LANG{$ENV{$DISPLANG}}{'ERR_CONF_FORM'} . 
                                " (line:" . $count . ")";
            $$errmsg[$L_LOG] =$LANG{$LOGLANG}{'ERR_CONF_FORM'} . 
                              " (line:" . $count . ")";
            return 1;
        }
    }

    close(IN);

    # ͤꤵƤʤϥǥեͤ򥻥å
    foreach $name (@def_names) {
        if (!defined($$adminconf{$name})) {
            $$adminconf{$name} = $entry_def{$name};
        }
    }

    return 0;

}

#
# Υեƥå
#
# []
#	arg0	եƥ
#
# [֤]
#	0	OK
#	1	NG
#

sub check_facility
{
    my ($facility) = @_;
    my @list;
    my $fac;

    @list = ("auth", "cron", "daemon", "kern", "lpr", "mail", "news", 
             "syslog", "user", "uucp", "local0", "local1", "local2", "local3",
             "local4", "local5", "local6", "local7", "authpriv");

    foreach $fac (@list) {
        if ($facility eq $fac) {
            return 0;
        }
    }
    return 1;
}

#
# ͥå
#
# []
#	arg0	
#
# [֤]
#	0	OK
#	1	NG
#

sub check_num
{
    my ($num) = @_;

    if (($num !~ /^[0-9]+$/) || ($num < 0) || ($num > 2147483647)){
        return 1;
    }

    return 0;
}
        
#
# åʤ
#
# []
#
# [֤]
#       0       OK
#

sub no_check
{
    return 0;
}

#
# ɥᥤ̾å
#
# []
#	arg0	ɥᥤ̾	
#
# [֤]
#	0	OK
#	1	ʸ泌顼
#	2	ʸ顼
#

sub check_domain
{
    my ($domain) = @_;
    my $pattern;
    
    # ʸå
    if (length($domain) > 128) {
        return 2;
    }

    # ʸå
    $pattern ='^[A-Za-z0-9\-.,]*$';
    if ($domain !~ /$pattern/) {
        return 1;
    }
   
    return 0;
}

#
# ޥɥå
#
# []
#	arg0	ޥ
#
# [֤]
#	0	OK
#	1	NG
#

sub check_com
{
    my ($command) = @_;
    my $pattern;
    my @arr;
    my $comname = 0;

    $pattern = '^[A-Za-z0-9 \./_-]*$';
    if ($command !~ /$pattern/) {
        return 1;
    }

    # ե̾ʬ
    @arr = split(/ /, $command);

    # ¸ߥå
    if (!-f $arr[$comname]) {
        return 1;
    }

    return 0;
}

#
# եΥѥ̾å
#
# []
#	arg0	ե̾
#
# [֤]
#	0	OK
#	1	NG
#

sub check_filename
{
    my ($filename) = @_;
    my $pattern;

    $pattern = '^[A-Za-z0-9/_\-\.]*$';
    if ($filename !~ /$pattern/) {
        return 1;
    }

    return 0;
}

#
# 顼åƥץ졼ɹ
#
# []
#       arg0    åǼΰ
#       arg1    
#       arg2    顼å
#
# [֤]
#       0       OK
#      -1      ƥ२顼
#

sub read_msgtmpl
{
    my ($local, $errmsg) = @_;

    my @onemsg;
    my $templfile = "$TEMPDIR/$local/errmsg";

    # ƥץ졼ȥե륪ץ
    if (open(IN, $templfile) == 0) {
        # 顼å
        $$errmsg = "Cannot open msgtemplate file. :(" . $templfile . ")";
        return -1;
    }

    # 顼åɤ߽Ф
    while (<IN>) {
        # Ժ
        chomp($_);

        @onemsg = split(/=/, $_);

        # ֥륯ơ
        $onemsg[1] =~ s/^\"//;
        $onemsg[1] =~ s/\"$//;

        # ǡǼ
        $LANG{$local}{$onemsg[0]} = $onemsg[1];
    }

    return 0;
}

#
# 顼ƥץ졼ɹ
#
# []
#       arg0    顼å
#
# [֤]
#       0       OK
#      -1      ƥ२顼
#

sub init_msgtmpl
{

    my ($errmsg) = @_;
    my @tmp;

    # enåФ
    if (read_msgtmpl($LOGLANG, $errmsg) == -1 ) {
        return -1;
    }

    # 줬enξˤɤ߹߽λ
    if ($ENV{$DISPLANG} eq $LOGLANG ) {
       return 0;
    }

    @tmp = grep (/^$ENV{$DISPLANG}$/, @USELANG) ;

    # ǧ
    if (!defined($tmp[0])) {
        # 줬ƤʤenƤ򥳥ԡ
        $LANG{$ENV{$DISPLANG}} = $LANG{$LOGLANG};
        return 0;
    } 

    # ѤΥåФ
    if (read_msgtmpl($ENV{$DISPLANG}, $errmsg) == -1 ) {
        return -1;
    }

    return 0;
}

#
# 
#
# []
#       conf            (Ϥ)
#       linkflg         󥯥åե饰
#       ref             $q->param('REF')
#       errmsg          顼å
#
# [֤]
#       0       OK
#      -1       ƥ२顼
#

sub dhcp_top_init
{
    my ($conf, $linkflg, $ref, $rip, $errmsg) = @_;
    my $ret;
    my %decrypt;
    my $setrip;
    my $topflg = 1;

    # ե롢顼åեν
    if (pre_dhcp_init($conf, $linkflg, $ref, $errmsg) == -1 ) {
        return -1;
    }

    # ⡼IPγǼ
    $decrypt{'rip'} = $rip;

    # hidden(桼̾)ΰŹ沽
    if (hidden_decrypt(\%decrypt, $conf, $errmsg) == -1) {
        return -1;
    }

    $setrip = $decrypt{'rip'};

    # ⡼IPȽ
    if ($setrip eq "") {
        $setrip = $ENV{REMOTE_ADDR};
    }

    # å󳫻
    $ret = login_session($conf, $setrip, $topflg, $errmsg);
    if ($ret != 0) {
        return -1;
    }

    return 0;
}

#
# 
#
# []
#	conf		(Ϥ)
#       linkflg		󥯥åե饰
#       ref		$q->param('REF')
#	errmsg		顼å
#
# [֤]
#       0       OK
#      -1       ƥ२顼
#

sub dhcp_init
{
    my ($conf, $linkflg, $ref, $errmsg) = @_;
    my $rip = "";
    my $ret;
    my $otherflg = 0;

    # ե롢顼åեν
    if (pre_dhcp_init($conf, $linkflg, $ref, $errmsg) == -1 ) {
        return -1;
    }

    # å󳫻
    $ret = login_session($conf, $rip, $otherflg, $errmsg);
    if ($ret != 0) {
        return -1;
    }

    return 0;
}

#
# ե뤪ӥեå
#
# []
#       conf            (Ϥ)
#       linkflg         󥯥åե饰
#       ref             $q->param('REF')
#       rip             ⡼IP
#       errmsg          顼å
#
# [֤]
#       0       OK
#      -1       ƥ२顼
#

sub pre_dhcp_init
{
    my ($conf, $linkflg, $ref, $errmsg) = @_;
    my $ret;

    # 顼ƥץ졼Ȥɹ
    $ret = init_msgtmpl(\$$errmsg[0]);
    if ($ret != 0) {
	return -1;
    }

    # ǥեȤΥեƥ򥻥å
    $$conf{'facility'} = "local0";

    # եɹ
    $ret = read_conf($conf, $errmsg);
    if ($ret != 0) {
	return -1;
    }

    # ե顼å
    if ($linkflg == 1) {
        if (check_referer($ref, $errmsg) == -1) {
           return -1;
        }
    }

    return 0;
}

#
# ƥ२顼ɽ
#
# []
#	arg0	顼å
#
# [֤]
#	0	OK
#

sub syserr
{
    my ($errmsg) = @_;
    my $converrmsg;

    $converrmsg = $errmsg;
    $converrmsg =~ s/\n/<br>\n/g;

    page::output_header();
    print $converrmsg;

    return 0;
}

#
# WORLDIR۲Υǥ쥯ȥ
#
# []
#       arg1    ǥ쥯ȥ̾
#       arg0    顼å
#
# [֤]
#       0       OK
#      -1       ƥ२顼
#

sub del_dir
{
    my ($deldirpath, $errmsg) = @_;
    my @tmpdirlist;
    my @tmpfilelist;
    my $delfilename;
    my $filepath;
    my $ret;
 
    # ǥ쥯ȥ۲Υե
    if (read_dir($deldirpath, \@tmpdirlist, $errmsg) < 0 ) {
        return -1;
    }

    foreach $filepath (@tmpdirlist) {
    
        if(read_dir($filepath, \@tmpfilelist, $errmsg) < 0) {
            return -1;
        }

        # եκ
        foreach $delfilename (@tmpfilelist) {
            $ret = unlink($delfilename);

            # ˼Ԥ
            if ($ret == 0) {
                $$errmsg[$L_DISP] = $LANG{$ENV{$DISPLANG}}{'ERR_TMP_FILE3'}
                                    . "(" . $delfilename . ")";
                $$errmsg[$L_LOG] = $LANG{$LOGLANG}{'ERR_TMP_FILE3'}
                                    . "(" . $delfilename . ")";
                return -1;
            }
        }

        # ǥ쥯ȥκ
        if (rmdir($filepath) ==  0) {
            $$errmsg[$L_DISP] = $LANG{$ENV{$DISPLANG}}{'ERR_TMP_DIR2'}
                           . "(" . $filepath . ")";
            $$errmsg[$L_LOG] = $LANG{$LOGLANG}{'ERR_TMP_DIR2'}
                          . "(" . $filepath . ")";
            return -1;
        }
    }

    # Υǥ쥯ȥκ
    if (rmdir($deldirpath) ==  0) {
         $$errmsg[$L_DISP] = $LANG{$ENV{$DISPLANG}}{'ERR_TMP_DIR2'}
                            . "(" . $deldirpath . ")";
         $$errmsg[$L_LOG] = $LANG{$LOGLANG}{'ERR_TMP_DIR2'}
                            . "(" . $deldirpath . ")";
         return -1;
    }

    return 0;
}

#
# ۥȤΥǧ
#
# []
#       arg0    ֥ͥå
#       arg1    Shared-network
#
# [֤]
#       0       ե뤬¸ߤʤޤϥХ
#       1       ե뤬¸ߤ0ХȤǤϤʤ
#

sub check_hostsize
{
    my ($subnet, $shared) = @_;
    my $host = $WORKDIR . "/" . $shared . "/" . $subnet . "/host";

    # ۥȤ¸ߥå
    if (( -e $host ) && ( !-z $host)) {
        # ۥȥե뤬0ХȤǤϤʤ
        return 1;
    }

    return 0;
}

#
# (POST)
#
# []
#       arg0    о(Ϥ)
#       arg1    ե̾
#       arg2    (POSTϤ)
#       arg3    顼å
#
# [֤]
#       0       OK
#      -1       ƥ२顼
#

sub location_post_method
{
    my ($serverlist, $desturl, $arg, $errmsg) = @_;
    my $url = "";
    my $key;
    my $pattern;
    my $html;
    my $findflg = 0;

    $pattern = '^http://' . $ENV{SERVER_NAME} . '/*';

    foreach $key (keys %{$serverlist}) {

	# URL
	if ($$serverlist{$key} =~ /$pattern/) {
	    $url = $$serverlist{$key};
	    $findflg = 1;
	    last;
	}
    }

    # а˼Ф꤬ʤ
    if ($findflg == 0) {
        $$errmsg[$L_DISP] = $LANG{$ENV{$DISPLANG}}{'ERR_SERVERLIST_OWN'} . 
                            "(" . $SERVERLISTFILE . ")";
        $$errmsg[$L_LOG] = $LANG{$LOGLANG}{'ERR_ERR_SERVERLIST_OWN'} . 
                           "(" . $SERVERLISTFILE . ")";
	return -1;
    }

    # URL
    $url .= "/" . $desturl;

    # POST
    if (send_post_method($url, $arg, \$html, $errmsg) != 0) {
	return -1;
    }

    # ̽
    page::output_header();
    print $html;

    exit 0;

}

#
# ХꥹȾ
#
# 
#	arg0    ꥹȳǼϢ(Ϥ)
#	arg1    祵Хե饰(Ϥ)
#	arg2    ꥹȳǼ(Ϥ)
#	arg3    顼å
#
# ֤
#	0	
#	-1	ƥ२顼
#

sub get_serverlist
{
    my ($listdata, $mainflg, $serverlist, $errmsg) = @_;
    my $count = 0;
    my @filedata;
    my $pattern;

    # 
    $$mainflg = 0;

    # Сեɤ߹
    if (open(IN, $SERVERLISTFILE) == 0) {
        $$errmsg[$L_DISP] = $LANG{$ENV{$DISPLANG}}{'ERR_SERVERLIST_FILE'} . 
                            "(" . $SERVERLISTFILE . ")";
        $$errmsg[$L_LOG] = $LANG{$LOGLANG}{'ERR_SERVERLIST_FILE'} . 
                           "(" . $SERVERLISTFILE . ")";
        return -1;
    }

    # URL
    $pattern = '^http://' . $ENV{SERVER_NAME} . '/*';

    while (<IN>) {

        # Կ
        $count++;

        # ǸΥեɤ\n
        chomp;

        # ȡԤ̵
        if (($_ =~ /^#/) || ($_=~ /^$/)) {
            next;
        }

        # " "(ڡor)ڤ
        @filedata = split(/\s+/, $_);

        # å
        if (@filedata != 2) {
            $$errmsg[$L_DISP] = $LANG{$ENV{$DISPLANG}}{'ERR_SERVERLIST_FORM'} . 
                                "(line:" . $count . ")";
            $$errmsg[$L_LOG] = $LANG{$LOGLANG}{'ERR_SERVERLIST_FORM'} . 
                               "(line:" . $count . ")";
            return -1;
        }

        # ʣå
        if (defined($$listdata{$filedata[0]}) == 1) {
            $$errmsg[$L_DISP] = $LANG{$ENV{$DISPLANG}}{'ERR_SERVERLIST_DATA'} .
                                "(line:" . $count . ")";
            $$errmsg[$L_LOG] = $LANG{$LOGLANG}{'ERR_SERVERLIST_DATA'} .
                               "(line:" . $count . ")";
            return -1;
        }

	# URL(1)
	if ($filedata[1] =~ /$pattern/ && $count == 1) {
	    $$mainflg = 1;
	}

        # ǡǼ
        $$listdata{$filedata[0]} = $filedata[1];
        push (@$serverlist, {$filedata[0] => $filedata[1]});
    }

    close (IN);

    return 0;
}

#
# ХꥹȾɤ߹
#
# 
#	arg0    ꥹȳǼϢ(Ϥ)
#	arg1    祵Хե饰(Ϥ)
#	arg2    顼å
#
# ֤
#	0	
#	-1	ƥ२顼
#

sub read_serverlist
{
    my ($listdata, $mainflg, $errmsg) = @_;
    my @dummy;
    
    if (get_serverlist($listdata, $mainflg, \@dummy, $errmsg) != 0) {
        return -1;
    }

    return 0;
    
}
#
# IPɥ쥹ηå
#
# 
#       arg0    IPɥ쥹
#       arg1    顼å
#
# ֤
#       0       OK
#       1       顼
#

sub check_ipaddr {
    my ($ipaddr, $errmsg) = @_;
    my @spval;

    #  ʸå
    if ($ipaddr =~ /[^0-9\.]/) {
        $$errmsg[$L_DISP] = $LANG{$ENV{$DISPLANG}}{'INFO_IP_FORMAT'};
        return 1;
    }

    # ɥåȤʬ
    @spval = split(/\./, $ipaddr);

    # եɥå
    if ($#spval != 3) {
        $$errmsg[$L_DISP] = $LANG{$ENV{$DISPLANG}}{'INFO_IP_FORMAT'};
        return 1;
    }

    # å
    if ($ipaddr !~ /^[0-9]*\.[0-9]*\.[0-9]*\.[0-9]*$/) {
        $$errmsg[$L_DISP] = $LANG{$ENV{$DISPLANG}}{'INFO_IP_FORMAT'};
        return 1;
    }

    # ऴȤΥå
    foreach (@spval) {

        # å
        if ($_ eq "") {
            $$errmsg[$L_DISP] = $LANG{$ENV{$DISPLANG}}{'INFO_IP_FORMAT'};
            return 1;
        }

        # ʸĹå
        if (length($_) > 3 ) {
            $$errmsg[$L_DISP] = $LANG{$ENV{$DISPLANG}}{'INFO_IP_FORMAT'};
            return 1;
        }

        # ͤϰϥå
        if (($_ < 0) || ($_ > 255)) {
            $$errmsg[$L_DISP] = $LANG{$ENV{$DISPLANG}}{'INFO_IP_FORMAT'};
            return 1;
        }
    }

    return 0;
}

#
# ե󥹥å
#
# 
#	arg0	URLꥹ()
#	arg1	顼å
#
# ֤
#	0	
#	1	顼
#

sub check_referer
{
    my ($ref, $errmsg) = @_;
    my $checkflag = 0;
    my $link;

    # ץ̾Ǽ
    my @linklist = ("top.cgi",
                    "network.cgi",
                    "sharedlist.cgi",
                    "serverlist.cgi",
                    "serverlist_dhcp.cgi",
                    "serverlist_user.cgi",
                    "sharedlist.cgi",
                    "sharedmod.cgi",
                    "subnetlist.cgi",
                    "subnetadd.cgi",
                    "range.cgi",
                    "rangemod.cgi",
                    "host_search.cgi",
                    "host_add.cgi",
                    "upload.cgi",
                    "lease_search.cgi",
                    "restart.cgi",
                    "userlist.cgi",
                    "useradd.cgi",
                    "usermod.cgi");

    # ե顼ѿγǧ
    if (defined($ENV{'HTTP_REFERER'}) == 0) {
        # ե顼ѿγǼ
        $ENV{'HTTP_REFERER'} = $ref;
    }

    foreach $link (@linklist) {

        # Ĥä
        if (rindex($ENV{'HTTP_REFERER'}, $link) != -1) {
            $checkflag = 1;
        }
    }

    if ($checkflag == 0) {
        $$errmsg[$L_DISP] = $LANG{$ENV{$DISPLANG}}{'ERR_REFERER'};
        $$errmsg[$L_LOG] = $LANG{$LOGLANG}{'ERR_REFERER'};
        return -1;
    }

    return 0;
}

#
# եɵ
#
# 
#	arg0	񤭹ե̾
#	arg1	񤭹ʸ
#	arg2	顼å
#
# ֤
#	0	
#	-1	顼
#
sub append_file
{
    my ($filename, $writeline, $errmsg) = @_;

    # ե񤭹ߥ⡼ɤǥץ
    if (open(OUT, ">>" . $filename) == 0) {
        $$errmsg[$L_DISP] .= $LANG{$ENV{$DISPLANG}}{'ERR_TMP_FILE2'} . "("
                            . $filename . ")";
        $$errmsg[$L_LOG] .= $LANG{$LOGLANG}{'ERR_TMP_FILE2'} . "("
                            . $filename . ")";
        return -1;
    }

    # 񤭹
    print OUT $writeline;

    # 
    close(OUT);

    return 0;
}

#
# Ԥ<br>Ѵ
#
# 
#	arg0	Ѵå(Ϥ)
#
# ֤
#	0	
#

sub conv_br
{
    my ($convmsg) = @_;

    $$convmsg =~ s/\n/<br>\n/g;

    return 0;
}

#
# 
#
# []
#       arg0    о(Ϥ)
#       arg1    ե̾
#       arg2    (POSTϤ)
#       arg3    顼å
#
# [֤]
#       0       OK
#      -1       ƥ२顼
#

sub location_display
{
    my ($desturl, $postdata, $errmsg) = @_;
    my $dummy;
    my %serverlist;
    my $key;
    my $value;
    my $ret;

    # а
    if (read_serverlist(\%serverlist, \$dummy, $errmsg) == -1) {
        return -1;
    }

    # subnetϿ̤ν
    if (location_post_method(\%serverlist, $desturl, $postdata, $errmsg) == -1){
        return -1;
    }

    return 0;
}

#
# MACɥ쥹ηåȳǼ
#
# []
#	arg0	åMACɥ쥹̾
#	arg1	ѴMACɥ쥹̾
#
# [֤]
#	0	OK
#	1	顼
#
#

sub check_macaddr
{
    my ($macaddr, $convmacaddr, $errmsg) = @_;
    my $checkstr;
    my @value;

    # ʤ
    if ($macaddr eq "") {
        return 0;
    }

    # ѿ.:ʳʸ󤬤
    if ($macaddr =~ /[^0-9a-fA-F\.\:]/) {
        $$errmsg[$L_DISP] = $LANG{$ENV{$DISPLANG}}{'ERR_MACADDR_FORMAT'};
        $$errmsg[$L_LOG] = $LANG{$ENV{$LOGLANG}}{'ERR_MACADDR_FORMAT'};
        return 1;
    }

    # ѿϤޤ꽪äƤ뤫
    if ($macaddr !~ /^[0-9a-fA-F]/ || $macaddr !~ /[0-9a-fA-F]$/) {
        $$errmsg[$L_DISP] = $LANG{$ENV{$DISPLANG}}{'ERR_MACADDR_FORMAT'};
        $$errmsg[$L_LOG] = $LANG{$ENV{$LOGLANG}}{'ERR_MACADDR_FORMAT'};
        return 1;
    }

    # ڤʸ.(ɥå):()ߤƤ
    if ($macaddr =~ /\./ && $macaddr =~ /\:/) {
        $$errmsg[$L_DISP] = $LANG{$ENV{$DISPLANG}}{'ERR_MACADDR_FORMAT'};
        $$errmsg[$L_LOG] = $LANG{$ENV{$LOGLANG}}{'ERR_MACADDR_FORMAT'};
        return 1;
    }

    # Ѵ
    if (check_conv_macaddr($macaddr, $convmacaddr)) {
        $$errmsg[$L_DISP] = $LANG{$ENV{$DISPLANG}}{'ERR_MACADDR_FORMAT'};
        $$errmsg[$L_LOG] = $LANG{$ENV{$LOGLANG}}{'ERR_MACADDR_FORMAT'};
        return 1;
    }

    return 0;
}

#
# MACɥ쥹ѴȳǼ
#
# []
#       arg0    åMACɥ쥹̾
#       arg1    ѴMACɥ쥹̾
#
# [֤]
#       0       OK
#       1       顼
#
#

sub check_conv_macaddr
{
    my ($defmacaddr, $convmacaddr) = @_;
    my $macaddr;
    my @value;

    # 
    $$convmacaddr = "";

    # ʸѴ
    $macaddr = lc($defmacaddr);

    # .ξ
    if ($macaddr =~ /\./) {
        @value = split(/\./, $macaddr);
        # ʬå
        if ($#value != 2) {
            return 1;
        } else {
            foreach (@value) {
                # å
                if (length($_) != 4) {
                    return 1;
                }

                # Ѵ
                $$convmacaddr .= substr($_, 0, 2) . ":";
                $$convmacaddr .= substr($_, 2, 2) . ":";

            }

            # Ǹ:
            chop($$convmacaddr);
        }
        return 0;
    }

    # :ξ
    if ($macaddr =~ /\:/) {
        @value = split(/\:/, $macaddr);
        # ʬå
        if ($#value != 5) {
            return 1;
        } else {
            foreach (@value) {
                # å
                if (length($_) != 2) {
                    return 1;
                }
            }
        }

        # Ѵѿ˳Ǽ
        $$convmacaddr = $macaddr;
        return 0;
    }

    # ڤʸʤ
    # å
    if (length($macaddr) != 12) {
        return 1;
    }

    # Ѵ
    $$convmacaddr = sprintf("%s:%s:%s:%s:%s:%s",substr($macaddr, 0, 2),
                                             substr($macaddr, 2, 2),
                                             substr($macaddr, 4, 2),
                                             substr($macaddr, 6, 2),
                                             substr($macaddr, 8, 2),
                                             substr($macaddr, 10, 2),
                                             substr($macaddr, 12, 2));

    return 0;
}

#
# ֥ͥåȾμ
#
# []
#       arg0    ֥ͥå
#       arg1    ֥ͥåȾǼ(Ϥ)
#       arg2    Shared-network̾
#       arg3    顼å
#
# [֤]
#       0       OK
#       1       顼
#       -1      ƥ२顼
#

sub get_subnetinformation
{
    my ($subnet, $subnetdata, $shared, $errmsg) = @_;
    my $subnetfile;

    # "/""-"ִ
    $subnet =~ s/\//-/;

    # ֥ͥåȥե
    $subnetfile = $WORKDIR . "/" . $shared . "/" . $subnet . "/subnet";

    # ե륪ץ
    if (open(IN, $subnetfile) == 0) {
        $$errmsg[$L_DISP] = $LANG{$ENV{$DISPLANG}}{'ERR_SUBNET_FILE1'} . "(" . $subnetfile . ")";
        $$errmsg[$L_LOG] = $LANG{$LOGLANG}{'ERR_SUBNET_FILE1'} . "(" . $subnetfile . ")";
        return -1;
    }

    while (<IN>) {
        chomp;

        # سǼ
        push(@$subnetdata, $_);
    }

    return 0;

}

#
# ʸΰŹ沽(CBC)
#
# []
#       arg0    Ź沽оʸ
#       arg1    ե
#       arg2    顼å
#
# [֤]
#       0       OK
#       -1      ƥ२顼
#

sub crypt_cbc
{
    my ($key, $decrypt, $crypt, $conf, $errmsg) = @_;

    my $BUFSZ = 128;
    my $buffer;
    my $bytesread;

    # 
    $$crypt = "";

    # å󥭡
    # DES3
    my $pid = open(PIPE, "-|");
    if ($pid < 0) {
        $$errmsg[$L_DISP] = $LANG{$ENV{$DISPLANG}}{'ERR_CRYPT_FORK'};
        $$errmsg[$L_LOG] = $LANG{$LOGLANG}{'ERR_CRYPT_FORK'};
        return -1;
    }

    # ҥץν:cbcŹ沽
    unless ($pid) {
        open(CMD, "| $$conf{'openssl'} enc -e -aes-128-cbc -base64  -pass file:$KEYFILE 2> /dev/null");
        print CMD "$key $decrypt\n";
        close(CMD);
        # ¹ԸϽλ
        exit;
    }

    waitpid($pid, 0);

    # Ǹޤɤ
    while($bytesread = read(PIPE, $buffer, $BUFSZ)){
        $$crypt .= $buffer;
    }

    close(PIPE);

    return 0;
}

#
# ʸʣ粽(CBC)
#
# []
#       arg0    Ź沽ʸ
#       arg1    ե
#       arg2    顼å
#
# [֤]
#       0       OK
#       -1      ƥ२顼
#

sub decrypt_cbc
{
    my ($key, $crypt, $decrypt, $conf, $errmsg) = @_;

    my $BUFSZ = 128;
    my $buffer;
    my $bytesread;

    # 
    $$decrypt = "";

    # ҥץư
    my $pid = open(PIPE, "-|");
    if ($pid < 0) {
        $$errmsg[$L_DISP] = $LANG{$ENV{$DISPLANG}}{'ERR_CRYPT_FORK'};
        $$errmsg[$L_LOG] = $LANG{$LOGLANG}{'ERR_CRYPT_FORK'};
        return -1;
    }

    # ҥץν:cbcʣ粽
    unless ($pid) {
        open(CMD, "| $$conf{'openssl'} enc -d -aes-128-cbc -base64  -pass file:$KEYFILE 2> /dev/null ");
        print CMD "$crypt\n";
        close(CMD);
        exit;
    }

    waitpid($pid, 0);

    # Ǹޤɤ
    while($bytesread = read(PIPE, $buffer, $BUFSZ)){
        $$decrypt .= $buffer;
    }

    close(PIPE);

    return 0;
}

#
# ʸΰŹ沽
#
# []
#       arg0    Ź沽Ϣ
#       arg1    ե
#       arg2    顼å
#
# [֤]
#       0       OK
#       -1      ƥ२顼
#

sub hidden_crypt
{
    my ($decrypt, $conf, $errmsg) = @_;    
    my $ret;
    my $key;
    my $crypt;

    # եɤ߹
    if (open(IN, $KEYFILE) == 0) {
        $$errmsg[$L_DISP] = $LANG{$ENV{$DISPLANG}}{'ERR_KEY_FILE'} .
                            " (" . $KEYFILE . ")";
        $$errmsg[$L_LOG] =$LANG{$LOGLANG}{'ERR_KEY_FILE'} .
                            " (" . $KEYFILE . ")";
        return -1;
    }

    # եɹ
    $key = <IN>;
    close(IN);

    # Ժ
    chomp($key);

    # ٤ͤ˰Ź沽
    foreach (keys %$decrypt) {
        # Ź沽¹
        if (crypt_cbc($key, $$decrypt{$_}, \$crypt, $conf, $errmsg) == -1) {
            return -1;
        }

        chomp($crypt);

        # ǡκƳǼ
        $$decrypt{$_} = $crypt; 
    }

    return 0;
}

#
# ʸʣ粽
#
# []
#       arg0    Ź沽Ϣ
#       arg1    ե
#       arg2    顼å
#
# [֤]
#       0       OK
#       -1      ƥ२顼
#       1       ʣ粽
#

sub hidden_decrypt
{
    my ($crypt, $conf, $errmsg) = @_;
    my $ret;
    my $key;
    my $decrypt;

    # եɤ߹
    if (open(IN, $KEYFILE) == 0) {
        $$errmsg[$L_DISP] = $LANG{$ENV{$DISPLANG}}{'ERR_KEY_FILE'} .
                            " (" . $KEYFILE . ")";
        $$errmsg[$L_LOG] =$LANG{$LOGLANG}{'ERR_KEY_FILE'} .
                            " (" . $KEYFILE . ")";
        return -1;
    }

    # եɹ
    $key = <IN>;
    close(IN);

    # Ժ
    chomp($key);

    # ٤ͤ˰Ź沽
    foreach (keys %$crypt) {

        # ͤξˤϽ򤷤ʤ
        if ($$crypt{$_} eq "") {
            next;
        }

        # Ź沽¹
        if (decrypt_cbc($key, $$crypt{$_}, \$decrypt, $conf, $errmsg) == -1 ) {
            return -1;
        }

        # ʣ粽åפʤȥ顼
        if ($decrypt !~ /^$key /) {
            $$errmsg[$L_DISP] = $LANG{$ENV{$DISPLANG}}{'ERR_POST_DATA'} .
                                " (" . $_ . "/" . $$crypt{$_} .")";
            $$errmsg[$L_LOG] =$LANG{$LOGLANG}{'ERR_POST_DATA'} .
                                " (" . $_ . ")";
            return 1;
        }

        # 
        $decrypt =~ s/^$key //;

        # Ժ
        chomp($decrypt);

        # ǡκƳǼ
        $$crypt{$_} = $decrypt;
    }

    return 0;
}

#
# 
#
# []
#       conf    (Ϥ)
#       linkflg 󥯥åե饰
#       ref     $q->param('REF')
#       errmsg  顼å
#
# [֤]
#       0       OK
#      -1       ƥ२顼
#

sub dhcp_init_nosession
{

    my ($conf, $linkflg, $ref, $errmsg) = @_;
    my $ret;
    my %hiddendata;

    $hiddendata{'CRYPT_USER'} = $ENV{'REMOTE_USER'};

    # 顼ƥץ졼Ȥɹ
    $ret = init_msgtmpl(\$$errmsg[0]);
    if ($ret != 0) {
        return -1;
    }

    # ǥեȤΥեƥ򥻥å
    $$conf{'facility'} = "local0";

    # եɹ
    $ret = read_conf($conf, $errmsg);
    if ($ret != 0) {
        return -1;
    }

    # hidden(桼̾)ΰŹ沽
    if (hidden_crypt(\%hiddendata, $conf, $errmsg) == -1) {
        return -1;
    }

    $ENV{'CRYPT_USER'} = $hiddendata{'CRYPT_USER'};

    # ե顼å
    if ($linkflg == 1) {
        if (check_referer($ref, $errmsg) == -1) {
           return -1;
        }
    }

    return 0;
}

#
# 2ʿѴ
#
# []
#       arg0    IP
#
# [֤]
#       2ʿǡ
#

sub add2bin
{
    my ($ip) = @_;
    my @tmp;

    @tmp = split(/\./, $ip);

    return sprintf("%08b%08b%08b%08b", $tmp[0], $tmp[1], $tmp[2], $tmp[3]);
}

#
# ʬפξΡclientηåMACɥ쥹Ѵ
#
# []
#       arg0    åhost̾
#       arg1    åMACɥ쥹
#       arg2    ѴMACɥ쥹(Ϥ)
#       arg3    IPɥ쥹
#       arg4    顼å
#
# [֤]
#       0       OK
#       1       顼
#
#

sub check_client_part
{
    my ($hostname, $macaddr, $convmacaddr, $ipaddr, $errmsg) = @_;

    # ۥ̾Υå
    if (main::check_hostname($hostname) == 1) {
        $$errmsg[$main::L_DISP] = $main::LANG{$main::ENV{$main::DISPLANG}}{'ERR_HOST_FORMAT'};
        $$errmsg[$main::L_LOG] = $main::LANG{$main::LOGLANG}{'ERR_HOST_FORMAT'};
        return 1;
    }

    # MACɥ쥹ΥåѴ
    if (main::check_macaddr_part($macaddr, $convmacaddr, $errmsg) == 1) {
        return 1;
    }
    
    if ($ipaddr eq "") {
        return 0;
    }
 
    # IPɥ쥹Υå
    if (main::check_ipaddr($ipaddr, $errmsg) == 1) {
         return 1;
    }

    return 0;
}

# MACɥ쥹ηåȳǼ
#
# []
#       arg0    åMACɥ쥹̾
#       arg1    ѴMACɥ쥹̾
#
# [֤]
#       0       OK
#       1       顼
#

sub check_macaddr_part
{
    my ($macaddr, $convmacaddr, $errmsg) = @_;
    my $checkstr;
    my @value;

    # ʤ
    if ($macaddr eq "") {
        return 0;
    }
    # ѿ.:ʳʸ󤬤
    if ($macaddr =~ /[^0-9a-fA-F\.\:]/) {
        $$errmsg[$main::L_DISP] = $main::LANG{$main::ENV{$main::DISPLANG}}{'ERR_MACADDR_FORMAT'};
        $$errmsg[$main::L_LOG] = $main::LANG{$main::ENV{$main::LOGLANG}}{'ERR_MACADDR_FORMAT'};
        return 1;
    }

    # ʸ3İʾϢ³Ƥ硢ߤƤʤ
    if ($macaddr =~ /[0-9a-fA-F]{3,}/ && $macaddr =~ /\:/) {
        $$errmsg[$main::L_DISP] = $main::LANG{$main::ENV{$main::DISPLANG}}{'ERR_MACADDR_FORMAT'};
        $$errmsg[$main::L_LOG] = $main::LANG{$main::ENV{$main::LOGLANG}}{'ERR_MACADDR_FORMAT'};
        return 1;
    }

    # Ѵ
    # ʸѴ
    $$convmacaddr = lc($macaddr);

    return 0;
}

# ꤷǥ쥯ȥΤߺ
#
# []
#       arg1    ǥ쥯ȥ̾
#       arg0    顼å
#
# [֤]
#       0       OK
#      -1       ƥ२顼
#
sub del_onedir
{
    my ($deldirpath, $errmsg) = @_;
    my @tmpfilelist;
    my $delfilename;
    my $ret;
 
    # ǥ쥯ȥ۲Υե
    if (read_dir($deldirpath, \@tmpfilelist, $errmsg) < 0 ) {
        return -1;
    }

    # եκ
    foreach $delfilename (@tmpfilelist) {
        $ret = unlink($delfilename);

        # եκ
        if ($ret == 0) {
            $$errmsg[$L_DISP] = $LANG{$ENV{$DISPLANG}}{'ERR_TMP_FILE3'}
                                . "(" . $delfilename . ")";
            $$errmsg[$L_LOG] = $LANG{$LOGLANG}{'ERR_TMP_FILE3'}
                                . "(" . $delfilename . ")";
            return -1;
        }
    }

    # ǥ쥯ȥκ
    if (rmdir($deldirpath) == 0) { 
        $$errmsg[$L_DISP] = $LANG{$ENV{$DISPLANG}}{'ERR_TMP_DIR2'}
                            . "(" . $deldirpath . ")";
        $$errmsg[$L_LOG] = $LANG{$LOGLANG}{'ERR_TMP_DIR2'}
                           . "(" . $deldirpath . ")";
        return -1;
    }
    return 0;
}

#
# subnetɽhtmlκ
#
# 
#       arg0    ɽhtml(Ϥ)
#       arg1    򤵤줿subnet(Ϥ)
#       arg3    顼å
#
# ֤
#       0          
#       -1        顼
#

sub make_subnethtml
{
    my ($subnethtml, $selectsubnet, $errmsg) = @_;
    my %dirlist;
    my @shareddirlist;
    my @tmpdirlist;
    my @value;
    my %tmpline;
    my $subnet;
    my $line;
    my $selectstr;
    my $select;
    my $valueline;
    my $shared;
    my $workdir;
    my $subnetlist_key;
    my $subnetlist;


    # shared-networkǥ쥯ȥ
    if (read_dir($WORKDIR, \@shareddirlist, $errmsg) < 0 ) {
        return -1;
    }

    # shared-networkǥ쥯ȥʬdirlist
    foreach $shared (@shareddirlist) {

        # ǥ쥯ȥɤ߽Ф
        if (-d $shared) {
            if (read_dir($shared, \@tmpdirlist, $errmsg) < 0 ) {
                return -1;
            }

            # ¤ؤbitѴ
            conv_bit_subnet(\@tmpdirlist, \%dirlist, $errmsg);
        }
    }

    # 
    %tmpline = ();

    # ǥ쥯ȥ̾Υ
    foreach $subnetlist_key (sort keys %dirlist) {
        $subnetlist = $dirlist{$subnetlist_key};
        foreach $line (sort {$subnetlist -> {$a} cmp $subnetlist -> {$b}} keys %$subnetlist) {

            # valueʸ
            $valueline = $$subnetlist{$line};

            # ɽʸ
            if (conv_outputsubnet($valueline, \$subnet, \$shared, $errmsg) > 0) {
                next;
            }

            # 
            $selectstr = "";

            foreach $select (@$selectsubnet) {
                # 򤵤Ƥ
                if ($shared . "/" . $subnet eq $select) {
                    $selectstr = "selected";
                    last;
                }
            }

            $tmpline{$line} =  "<option value=" . $shared . "/" . $subnet . " " .  $selectstr . ">" .
                          $subnet . " </option>\n";
        }
    }

    # 
    $$subnethtml = "";
    foreach $line (sort {$a cmp $b} keys %tmpline) {
        # htmlʸκ
        $$subnethtml .= $tmpline{$line};
    }

    return 0;
}
1;
