#
# dhcpadmin
#
# Copyright (C) 2008 DesigNET, INC.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
#

##########################################################
#
# ̥饤֥
#
# $RCSfile: libhost.pl,v $
# $Revision: 1.32 $
# $Date: 2013/01/17 05:09:57 $
#
##########################################################

use strict;
use Jcode;
use File::Basename;

# ؿ⥰Хѿ

my $HOSTNAME = 0;
my $MACADDRESS = 1;
my $IPADDR = 2;
my $BOOTING_FLAG = 3;

my $DELSUBNRT = 0;
my $DELMACADDRESS = 1;
my $DELHOSTNAME = 2;

# IP߽
my $ALLOW_DENY_BOOTING = "noselect";
my $ALLOW_STR = "allow";
my $DENY_STR = "deny";
my $ALLOW_JP_STR = "";
my $DENY_JP_STR = "";

# ֤ʸκ
my $REPLACESTR = $WORKDIR . "\/";

# ۥȤζڤ
my $HOSTSTRNUM = 15;

#
# clientηåMACɥ쥹Ѵ
#
# []
#	arg0	åhost̾
#	arg1	åMACɥ쥹
#	arg2	ѴMACɥ쥹(Ϥ)
#	arg3	IPɥ쥹
#	arg4	顼å
#
# [֤]
#	0       OK
#	1       顼
#
#

sub check_client
{
    my ($hostname, $macaddr, $convmacaddr, $ipaddr, $errmsg) = @_;

    # ۥ̾Υå
    if (check_hostname($hostname) == 1) {
        $$errmsg[$L_DISP] = $LANG{$ENV{$DISPLANG}}{'ERR_HOST_FORMAT'}; 
        $$errmsg[$L_LOG] = $LANG{$LOGLANG}{'ERR_HOST_FORMAT'};
        return 1;
    }

    # MACɥ쥹ΥåѴ
    if (check_macaddr($macaddr, $convmacaddr, $errmsg) == 1) {
        return 1;
    }

    if ($ipaddr eq "") {
        return 0;
    }

    # IPɥ쥹Υå
    if (check_ipaddr($ipaddr, $errmsg) == 1) {
        return 1;
    }

    return 0;
}

#
# subnet,rangeΥå
#
# []
#	arg0	åsubnet
#	arg1	IPɥ쥹
#	arg2	顼å
#
# [֤]
#	0       OK
#	1       顼
#
#

sub check_subnet
{
    my ($subnet, $ipaddr, $errmsg) = @_;
    my $subnetdirpath;
    my @tmp;

    @tmp = split(/\//, $subnet);
    $subnet = $tmp[0] . "/" . $tmp[1] . "-" . $tmp[2];

    $subnetdirpath = $WORKDIR . "/" . $subnet;

    # ¸ߥå
    if (!-d $subnetdirpath) {
        $$errmsg[$L_DISP] = $LANG{$ENV{$DISPLANG}}{'ERR_RESTART3'} . "(" . 
                            $subnetdirpath . ")";
        $$errmsg[$L_LOG] = $LANG{$LOGLANG}{'ERR_RESTART3'} . "(" . 
                           $subnetdirpath . ")";
        return 1;
    }

    return 0;
}

#
# hostname̾å
#
# []
#	arg0	åhost̾
#
# [֤]
#	0       OK
#	1       顼
#
#

sub check_hostname
{
    my ($hostname) = @_;

    # ʸå
    if (length($hostname) > 128) {
        return 1;
    }

    # ʸå
    my $pattern ='^[A-Za-z0-9\-._]*$';
    if ($hostname !~ /$pattern/) {
        return 1;
    }

    return 0;
}

#
# subnetʸ
#
# []
#	arg0	subnet̾(եѥ)
#	arg1	subnet̾(Ϥ)
#	arg1	shared̾(Ϥ)
#	arg2	顼å
#
# [֤]
#	0       OK
#	1       subnetηǤʤ
#
#

sub conv_outputsubnet
{
    my ($shared, $outputsubnet, $outputshared, $errmsg) = @_;
    my @sharedvalue;
    my @value;

    # ǥ쥯ȥʬ֤
    $shared =~ s/$REPLACESTR//g;

    # /ʬ
    @sharedvalue = split(/\//, $shared);

    # -ʬ
    @value = split(/-/, $sharedvalue[1]);

    # ʤ
    if ($#value != 1) {
        return 1;
    }

    # ɽʸ
    $$outputsubnet = $value[0] . "/" . $value[1];
    $$outputshared = $sharedvalue[0];

    return 0;
}

#
# hostɤ߽Ф
#
# 
#	arg0	Shared-network
#	arg1	оsubnet̾
#	arg2	ۥȾ(Ϥ)
#	arg3	FIXIP
#	arg4	顼å
#
# ֤
#	0	
#	-1	ƥ२顼
#

sub read_host
{
    my ($shared, $subnet, $hostlist, $fixiplist, $errmsg) = @_;
    my $host;
    my @value;
    my $convmac;

    # ۥȥեΥѥ̾
    $host = $WORKDIR . "/" .  $shared . "/" . $subnet . "/host";

    # ۥȥե뤬ʤ
    if (! -e $host) {
        return 0;
    }

    # ۥȥեΥץ
    if (open(IN, "$host") == 0) {
        $$errmsg[$L_DISP] = $LANG{$ENV{$DISPLANG}}{'ERR_TMP_FILE2'} . "("
                            . $host . ")";
        $$errmsg[$L_LOG] = $LANG{$LOGLANG}{'ERR_TMP_FILE2'} . "("
                            . $host . ")";
        return -1;
    }

    while (<IN>) {

        # Ժ 
        chomp($_);

        # ,ʬ
        @value = split(/,/, $_);

        # ʸѴ
        $convmac = lc($value[$MACADDRESS]);

        # Ϣ˳Ǽ
        $$hostlist{$subnet}{$convmac}{$value[$HOSTNAME]}{$value[$IPADDR]} = $value[$BOOTING_FLAG];

        # IPɥ쥹ǤʤгǼ
        if ($value[$IPADDR] ne "") {
            $$fixiplist{$subnet}{$value[$IPADDR]} = "";
        }
    }

    close(IN);

    return 0;
}

#
# bitѴؿ
#
# 
#	arg0	֥ͥåȥѥ
#	arg1	bitѴ+֥ͥåȥѥ(Ϣ)
#	arg2	顼å
#
# ֤
#	0	
#

sub conv_bit_subnet
{
    my ($subnetdirlist, $bitsubnetdirlist, $errmsg) = @_;
    my $line;
    my @value;
    my $shared;
    my $subnet;
    
    foreach $line (@$subnetdirlist) {
        my $subnet = $line;

        # ǥ쥯ȥʬ֤
        $subnet =~ s/$REPLACESTR//g;
        @value = split(/\//, $subnet);
        $value[1] =~ s/-//g;

        $$bitsubnetdirlist{$value[1]}{add2bin($value[1])} = $line;
    }

     return 0;
}

#
# ۥȾ
#
# 
#	arg0	ۥȾ(Ϥ)
#	arg1	顼å
#
# ֤
#	0	
#	-1	ƥ२顼
#

sub read_allhost
{
    my ($allhostlist, $fixiplist, $errmsg) = @_;
    my $subnetdir;
    my $subnet;
    my $line;
    my @tmpdirlist;
    my @dirlist;
    my $filepath;
    my $shared;

    # ǥ쥯ȥɤ߽Ф
    if (read_dir($WORKDIR, \@tmpdirlist, $errmsg) < 0 ) {
        return -1;
    }

    foreach $filepath (@tmpdirlist) {
        # 켡ե(.lock)commonեФ
        if ($filepath =~ /\/.lock$/ || $filepath =~ /\/common$/) {
            next;
        }

        if (read_dir($filepath, \@dirlist, $errmsg) < 0 ) {
            return -1;
        }

        foreach $line (@dirlist) {

            # ǥ쥯ȥ֥̾ͥåȤη
            if (conv_outputsubnet($line, \$subnet, \$shared, $errmsg) > 0) {
                next;
            }

            # subnetηѴ
            $subnetdir = $subnet;
            $subnetdir =~ s/\//-/g;

            # ۥȾɤ߽Ф
            if (read_host($shared, $subnetdir, $allhostlist, $fixiplist,
                          $errmsg) < 0) {
                return -1;
            }
        }
    }
    return 0;
}

#
# ۥ̾β
#
# 
#	arg0	Ѵۥ̾
#	arg1	Ѵۥ̾(Ϥ)
#
# ֤
#	0	
#

sub conv_host_br
{
    my ($hostdata, $convhostdata) = @_;
    my $startlen = 0;
    my $len;

    # 30ʸʾʤ
    $len = length($hostdata);
    if ($len < 30) {
        $$convhostdata = $hostdata;
        return 0;
    }

    # 30ʸʾξ硢
    for ($startlen = 0; $len >= $startlen;) {
        $$convhostdata .= substr($hostdata, $startlen, $HOSTSTRNUM) . "<br>";
        $startlen = $startlen + $HOSTSTRNUM;
    }

    # Ǹ<br>
    $$convhostdata =~ s/<br>$//g;

    return 0;
}

#
# []
#       arg0    ϰϥե
#       arg1    IPɥ쥹
#       arg2    顼å
#
# [֤]
#       0       OK
#       1       оݤΥǡϰ¸
#

sub check_range
{
    my ($range, $ipaddr, $errmsg) = @_;
    my $line;
    my $start = 0;
    my $end = 1;
    my $rangelist;
    my @arr;

    # IPɥ쥹ꤵƤʤХåʤ
    if ($range eq "") {
        return 0;
    }

    # 󥸥եΥץ
    if (open(IN, "$range") == 0) {
        $$errmsg[$L_DISP] = $LANG{$ENV{$DISPLANG}}{'ERR_TMP_FILE1'} . "(" . $range .
                            ")";
        $$errmsg[$L_LOG] = $LANG{$LOGLANG}{'ERR_TMP_FILE1'} . "(" . $range . ")";
        return -1;
    }

    # ɤ߹˳Ǽ
    while (<IN>) {
        $line = $_;
        chomp($line);
        @arr = split(/,/, $line);
        if (check_inrange(add2bin($arr[$start]),
                          add2bin($arr[$end]), add2bin($ipaddr), $errmsg) == 1) {
            return 1;
        }
    }

    return 0;
}

#
# []
#       arg0    ϰϳ
#       arg1    ϰϽλ
#       arg2    IPɥ쥹
#       arg3    顼å
#
# [֤]
#       0       OK
#       1       оݤΥǡϰ¸
#

sub check_inrange
{
    my ($rangest, $rangeend, $ipaddr, $errmsg) = @_;

    # ϰϤȥå
    if ($ipaddr ge $rangest && $ipaddr le $rangeend) {
        $$errmsg[$L_DISP] = $LANG{$ENV{$DISPLANG}}{'INFO_IP_ERR5'};
        return 1;
    }

    return 0;
}

#
# IPɥ쥹Υեޥåȥå
#
# 
#       arg0    Shared-network
#       arg1    ֥ͥå
#       arg2    åIPɥ쥹
#       arg3    ɲѤΥå
#       arg4    顼å
#
# ֤
#       0       
#       1       ʣ顼
#      -1       ƥ२顼
#

sub check_ipformat
{
    my ($shared, $subnet, $checkipaddr, $addmsg, $errmsg) = @_;
    my $network = 0;
    my $netmask = 1;
    my $gwip = 0;
    my $broadcast;
    my @subnetdata;
    my @tmp;
    my %hostlist;
    my $rangepath;
    my $ret;

    # ֥ͥåʬ
    @tmp = split(/-|\//, $subnet);

    # ϰϥå
    if (Net::IPv4Addr::ipv4_in_network($tmp[$network],
                                       $tmp[$netmask], $checkipaddr) != 1) {
        $$errmsg[$L_DISP] = $LANG{$ENV{$DISPLANG}}{'INFO_IP_ERR1'};
        $$errmsg[$L_DISP] .= $addmsg;
        return 1;
    }

    if ($tmp[$network] eq $checkipaddr) {
        $$errmsg[$L_DISP] = $LANG{$ENV{$DISPLANG}}{'INFO_IP_ERR4'};
        $$errmsg[$L_DISP] .= $addmsg;
        return 1;
    }

    $broadcast = Net::IPv4Addr::ipv4_broadcast($tmp[$network] . "/" . $tmp[$netmask]);

    if ($broadcast eq $checkipaddr) {
        $$errmsg[$L_DISP] = $LANG{$ENV{$DISPLANG}}{'INFO_IP_ERR3'};
        $$errmsg[$L_DISP] .= $addmsg;
        return 1;
    }

    # ֥ͥåȤɤ߹ߥ롼
    if (get_subnetinformation($subnet, \@subnetdata, $shared, $errmsg) == -1) {
        return -1;
    }

    # ȥȤΥå
    if ($subnetdata[$gwip] eq $checkipaddr) {
        $$errmsg[$L_DISP] = $LANG{$ENV{$DISPLANG}}{'INFO_IP_ERR2'};
        $$errmsg[$L_DISP] .= $addmsg;
        return 1;
    }

    # rangeΥեѥ
    $rangepath = $WORKDIR . "/" . $shared . "/" . $tmp[$network] . "-" . 
                 $tmp[$netmask] . "/range";

    # ϰϤΥå
    $ret = check_range($rangepath, $checkipaddr, $errmsg);

    return $ret;
}

1;
