#
# dhcpadmin
#
# Copyright (C) 2008 DesigNET, INC.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
#

##########################################################
#
# Shared-network饤֥
#
# $RCSfile: libsharedlist.pl,v $
# $Revision: 1.7 $
# $Date: 2013/01/13 06:05:38 $
#
##########################################################

use strict;
use Jcode;
use CGI;

# ǥ쥯ȥȽѿ
my $DHCPTMP = "dhcpd_conf.tmp";
my $COMMON = "common";

#
# sharedname̾å
#
# []
#	arg0	åsharedname̾
#	arg1	顼å
#
# [֤]
#	0       OK
#	1       顼
#

sub check_sharedname
{
    my ($sharedname, $errmsg) = @_;
    my $dirpath;

    # ä
    if ($sharedname eq "") {
        $$errmsg[$L_DISP] = $LANG{$ENV{$DISPLANG}}{'ERR_NULL_SHNAME'};
        $$errmsg[$L_LOG] = $LANG{$LOGLANG}{'ERR_NULL_SHNAME'};
        return 1;
    }

    # ʸå
    if (length($sharedname) > 255) {
        $$errmsg[$L_DISP] = $LANG{$ENV{$DISPLANG}}{'ERR_SHNAME'};
        $$errmsg[$L_LOG] = $LANG{$LOGLANG}{'ERR_SHNAME'} . "(" .
                           $sharedname . ")";
        return 1;
    }

    # ʸå
    my $pattern ='^[A-Za-z0-9]*$';
    if ($sharedname !~ /$pattern/) {
        $$errmsg[$L_DISP] = $LANG{$ENV{$DISPLANG}}{'ERR_SHNAME'};
        $$errmsg[$L_LOG] = $LANG{$LOGLANG}{'ERR_SHNAME'} . "(" .
                           $sharedname . ")";
        return 1;
    }

    # ʣå
    $dirpath = $WORKDIR . "/" . $sharedname;
    if (-d $dirpath) {
        $$errmsg[$L_DISP] = $LANG{$ENV{$DISPLANG}}{'ERR_DUPLICATE_SHNAME'};
        $$errmsg[$L_LOG] = $LANG{$LOGLANG}{'ERR_DUPLICATE_SHNAME'} . "(" .
                           $sharedname . ")";
        return 1;
    }

    return 0;
}

#
# Shared-networklistɽhtmlκ
#
# 
#	arg0	ɽhtml(Ϥ)
#	arg1	顼å
#
# ֤
#	0	   
#	-1	  顼
#

sub make_sharedhtml
{
    my ($errmsg) = @_;
    my %dirlist;
    my @tmpdirlist;
    my @value;
    my $tmpline;
    my $subnet;
    my $line;
    my $escline;
    my $selectstr;
    my $select;
    my $valueline;
    my $filepath;
    my $sharedname;
    my $escsharedname;
    my @sortdirlist;
    my @tmpname;

    my $escape = new CGI;

    # ǥ쥯ȥɤ߽Ф
    if (read_dir($WORKDIR, \@tmpdirlist, $errmsg) < 0 ) {
        return -1;
    }

    # 
    $tmpline = "";

    # ǥ쥯ȥ̾Υ
    @sortdirlist = sort @tmpdirlist;

    foreach $line (@sortdirlist) {
        
        # åʬ䤹
        @tmpname = split(/\//, $line);
        $sharedname = pop @tmpname;

        # ;ʬʥǥ쥯ȥФ
        if ($sharedname =~ /$COMMON/ || $sharedname =~ /$OTHERDIR/ || 
            $sharedname =~ /$DHCPTMP/ || $sharedname =~ /\./) {
            next;
        }

        # եäФ
        $filepath = $WORKDIR . "/" . $sharedname;
        if (-f $filepath) {
            next;
        }

        $escsharedname =  $escape->escapeHTML($sharedname);
        $escline =  $escape->escapeHTML($line);

        $tmpline .=  '<tr><td class="item4"><a href="#" onClick="modlinkSubmit(\'' . 
                      $escline . "\', \'" . $escsharedname . '\')">' .
                      $escsharedname . '</a></td></tr>' . "\n";
    }

    # htmlʸκ
    print $tmpline;

    return 0;
}

1;
