#
# dhcpadmin
#
# Copyright (C) 2008 DesigNET, INC.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
#

##########################################################
#
# Shared-network饤֥
#
# $RCSfile: libsharedmod.pl,v $
# $Revision: 1.6 $
# $Date: 2013/01/13 07:23:02 $
#
##########################################################

use strict;
use File::Basename;

#
# Shared-networkѹ
#
# 
#       arg0    ѹShared-network̾
#	arg1	Shared-network̾
#	arg2	°륵֥ͥå
#	arg3	̤°Υ֥ͥå
#	arg4	顼å
#
# ֤
#	 0	  
#	-1	  顼
#
sub mod_sharednetwork
{
    my ($oldname, $networkname, $selectleft, $selectright, $errmsg) = @_;
    my $ret;
    my $oldpath = $main::WORKDIR . "/" . $oldname;
    my $newpath = $main::WORKDIR . "/" . $networkname;
    my $otherpath = $main::WORKDIR . "/" . $main::OTHERDIR;
    my $subnet;
    my $othersubnet;
    my $dirname;
    my $dir;
    my $other;
    my $nomodify;
    my @dirlist;
    my @otherlist;
    my $oldsubnetpath;
    my $newsubnetpath;

    # Shared-networkѹƤǥ쥯ȥѹ
    if ($oldname ne $networkname) {
        # Shared-networkηå
        $ret = check_sharedname($networkname, $errmsg);
        if ($ret == 1) {
            # 顼 ޤ ʣ
            return -1;
        }

        # Shared-network̾ι
        # ѹΥǥ쥯ȥ¸߳ǧ
        if (! -d $oldpath) {
            # ѹΥǥ쥯ȥ꤬¸ߤʤ
            $$errmsg[$main::L_DISP] = $main::LANG{$ENV{$main::DISPLANG}}{'ERR_OLDSHARED_NOEXIST'}
                                      . "(" . $oldpath . ")";
            $$errmsg[$main::L_LOG] = $main::LANG{$main::LOGLANG}{'ERR_OLDSHARED_NOEXIST'}
                                     . "(" . $oldpath . ")";
            return -1;
        }

        # Shared-networkΥǥ쥯ȥ͡
        if (!rename($oldpath, $newpath)) {
            # ǥ쥯ȥΥ͡˼
            $$errmsg[$main::L_DISP] = $main::LANG{$ENV{$main::DISPLANG}}{'ERR_SHARED_MODNG'}
                                      . "(" . $oldpath . " -> " . $newpath . ")";
            $$errmsg[$main::L_LOG] = $main::LANG{$main::LOGLANG}{'ERR_SHARED_MODNG'}
                                     . "(" . $oldpath . " -> " . $newpath . ")";
            return -1;
        }
    }

    # °륵֥ͥåȤɤ߹
    if (read_dir($newpath, \@dirlist, $errmsg) < 0) {
        return -1;
    }

    # ̤°Υ֥ͥåȤɤ߹
    if (-d $otherpath) {
        if (read_dir($otherpath, \@otherlist, $errmsg) < 0) {
            return -1;
        }
    }

    # °륵֥ͥåȤѹ
    foreach $subnet (@$selectleft) {
        $nomodify = 0;
 
        foreach $dir (@dirlist) {
            $dir = basename($dir);
            if ($subnet eq $dir) {
                # ֥ͥåȤĤä => ǥ쥯ȥѹʤ
                $nomodify = 1;
            }
        }

        # Shared-networkΥǥ쥯ȥ۲ˤʤ => _otherѹ
        if ($nomodify == 0) {
            $oldsubnetpath = $otherpath . "/" . $subnet;
            $newsubnetpath = $newpath . "/" . $subnet;

            if (-d $oldsubnetpath) {
                # ǥ쥯ȥ͡
                if (!rename($oldsubnetpath, $newsubnetpath)) {
                    # ǥ쥯ȥΥ͡˼
                    $$errmsg[$main::L_DISP] = $main::LANG{$ENV{$main::DISPLANG}}{'ERR_SUBNET_MODNG'}
                                              . "(" . $oldsubnetpath . " -> " . $newsubnetpath . ")";
                    $$errmsg[$main::L_LOG] = $main::LANG{$main::LOGLANG}{'ERR_SUBNET_MODNG'}
                                             . "(" . $oldsubnetpath . " -> " . $newsubnetpath . ")";
                    return -1;
                }
            } else {
                # ѹΥǥ쥯ȥ꤬ɤΥǥ쥯ȥˤ¸ߤʤ
                $$errmsg[$main::L_DISP] = $main::LANG{$ENV{$main::DISPLANG}}{'ERR_OLDSHARED_NOEXIST'};
                $$errmsg[$main::L_LOG] = $main::LANG{$main::LOGLANG}{'ERR_OLDSHARED_NOEXIST'};
                return -1;
            }
        }
    }

    # ̤°Υ֥ͥåȤѹ
    foreach $othersubnet (@$selectright) {
        $nomodify = 0;

        foreach $other (@otherlist) {
            $other = basename($other);
            if ($othersubnet eq $other) {
                # ֥ͥåȤĤä => ǥ쥯ȥѹʤ
                $nomodify = 1;
            }
        }

        # _otherΥǥ쥯ȥ۲ˤʤ => Shared-networkѹ
        if ($nomodify == 0) {
            $oldsubnetpath = $newpath . "/" . $othersubnet;
            $newsubnetpath = $otherpath . "/" . $othersubnet;

            # _otherǥ쥯ȥ꤬¸ߤʤϺ
            if (! -d $otherpath) {
                if (make_dir($otherpath, $errmsg)) {
                    return -1;
                }
            }

            if (-d $oldsubnetpath) {
                # ǥ쥯ȥ͡
                if (!rename($oldsubnetpath, $newsubnetpath)) {
                    # ǥ쥯ȥΥ͡˼
                    $$errmsg[$main::L_DISP] = $main::LANG{$ENV{$main::DISPLANG}}{'ERR_SUBNET_MODNG'}
                                              . "(" . $oldsubnetpath . " -> " . $newsubnetpath . ")";
                    $$errmsg[$main::L_LOG] = $main::LANG{$main::LOGLANG}{'ERR_SUBNET_MODNG'}
                                             . "(" . $oldsubnetpath . " -> " . $newsubnetpath . ")";
                    return -1;
                }
            } else {
                # ѹΥǥ쥯ȥ꤬ɤΥǥ쥯ȥˤ¸ߤʤ
                $$errmsg[$main::L_DISP] = $main::LANG{$ENV{$main::DISPLANG}}{'ERR_OLDSHARED_NOEXIST'};
                $$errmsg[$main::L_LOG] = $main::LANG{$main::LOGLANG}{'ERR_OLDSHARED_NOEXIST'};
                return -1;
            }
        }
    }

    return 0;
}

#
# Shared-networkκ
#
# 
#	arg0	Shared-network̾
#	arg1	°륵֥ͥå
#	arg2	̤°Υ֥ͥå
#	arg3	顼å
#
# ֤
#	 0	  
#	-1	  顼
#	-2	  ƥ२顼
#
sub del_sharednetwork
{
    my ($networkname, $selectleft, $selectright, $errmsg) = @_;
    my $ret;
    my $path = $main::WORKDIR . "/" . $networkname;
    my @dirlist;
    my $count = 0;

    # Shared-networkϤƤʤ
    if ($networkname eq "") {
        $$errmsg[$main::L_DISP] = $LANG{$ENV{$main::DISPLANG}}{'ERR_NULL_SHNAME'};
        $$errmsg[$main::L_LOG] = $LANG{$LOGLANG}{'ERR_NULL_SHNAME'};
        return -1;
    }

    # Shared-networkΥǥ쥯ȥ¸߳ǧ
    if (! -d $path) {
        $$errmsg[$main::L_DISP] = $main::LANG{$ENV{$main::DISPLANG}}{'ERR_SHARED_NOEXIST'}
                                  . "(" . $networkname . ")";
        $$errmsg[$main::L_LOG] = $main::LANG{$main::LOGLANG}{'ERR_SHARED_NOEXIST'}
                                 . "(" . $networkname . ")";
        return -1;
    }

    # °륵֥ͥåȤɤ߹
    if (read_dir($path, \@dirlist, $errmsg) < 0) {
        return -1;
    }

    $count = @dirlist;
    if ($count != 0) {
        # ֥ͥåȤ¸ߤ뤿Բ
        $$errmsg[$main::L_DISP] = $main::LANG{$ENV{$main::DISPLANG}}{'ERR_SUBNET_EXIST'};
        $$errmsg[$main::L_LOG] = $main::LANG{$main::LOGLANG}{'ERR_SUBNET_EXIST'};
        return -1;
    }

    # Shared-networkΥǥ쥯ȥ
    if (!rmdir($path)) {
        # 
        $$errmsg[$main::L_DISP] = $main::LANG{$ENV{$main::DISPLANG}}{'ERR_SHARED_DELNG'}
                                  . "(" . $path . ")";
        $$errmsg[$main::L_LOG] = $main::LANG{$main::LOGLANG}{'ERR_SHARED_DELNG'}
                                 . "(" . $path . ")";
        return -1;
    }

    return 0;
}

1;
