#
# dhcpadmin
#
# Copyright (C) 2008 DesigNET, INC.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
#

##########################################################
#
# rangemod.cgiѥ饤֥
#
# $RCSfile: rangemod.pl,v $
# $Revision: 1.7 $
# $Date: 2013/01/16 23:44:27 $
#
##########################################################

#
# ϰϥǡ¸
#
# []
#       arg0    ֥ͥå
#       arg1    ϰϳ
#       arg2    ϰϽλ
#       arg3    򤷤ϰ
#       arg4    Shared-network
#       arg5    顼å
#
# [֤]
#       0       OK
#      -1       ƥ२顼
#

sub save_range
{
    my ($subnet, $chkranst, $chkranend, $selrange, $shared, $errmsg) = @_;
    my %rangelist;
    my $rangedata;
    my $range = $WORKDIR . "/" . $shared . "/" . $subnet . "/range";
    my @subnetdata;
    my $gwip = 0;

    # ϰɤ߹
    if (read_range($subnet, \%rangelist, $shared, $errmsg) == -1) {
        return -1;
    }

    # ֥ͥåȤɤ߹ߥ롼
    if (get_subnetinformation($subnet, \@subnetdata, $shared, $errmsg) == -1) {
        return -1;
    }

    # ϰϥǡ
    if (make_rangedata($chkranst, $chkranend, $subnetdata[$gwip], \%rangelist,
                                             \$rangedata, $selrange, $errmsg) == 1 ) {
        return 1;
    }

    # ϰϤη
    $rangedata .= $chkranst . "," . $chkranend . "\n";

    # ϰϤν
    if (write_file($range , $rangedata, $errmsg) == -2) {
        return -1;
    }

    return 0;
}

#
# ϥǡ֥ͥåȤϰ⤫å
#
# []
#       arg0    ֥ͥå
#       arg1    ϰϳ
#       arg2    ϰϽλ
#       arg3    顼å
#
# [֤]
#       0       OK
#       1       ϰϤγϤȽλƱ
#      -1       ƥ२顼
#

sub is_insubnet
{
    my ($subnet, $chkranst, $chkranend, $errmsg) = @_;
    my $network = 0;
    my $netmask = 1;
    my @tmp;
    my $broadcast;

    @tmp = split(/-/, $subnet);

    # ֥ͥåȤϰå
    if (Net::IPv4Addr::ipv4_in_network($tmp[$network], $tmp[$netmask], $chkranst) != 1) {
        $$errmsg[$L_DISP] = $LANG{$ENV{$DISPLANG}}{'INFO_RANGE_DATA5'};
        return 1;
    }

    # ֥ͥåȤϰåλ
    if (Net::IPv4Addr::ipv4_in_network($tmp[$network], $tmp[$netmask], $chkranend) != 1) {
        $$errmsg[$L_DISP] = $LANG{$ENV{$DISPLANG}}{'INFO_RANGE_DATA5'};
        return 1;
    }

    $broadcast = Net::IPv4Addr::ipv4_broadcast($tmp[$network] . "/" . $tmp[$netmask]);

    if ($tmp[$network] eq $chkranst) {
        $$errmsg[$L_DISP] = $LANG{$ENV{$DISPLANG}}{'INFO_RANGE_DATA9'};
        return 1;
    }

    if ($broadcast eq $chkranend) {
        $$errmsg[$L_DISP] = $LANG{$ENV{$DISPLANG}}{'INFO_RANGE_DATA10'};
        return 1;
    }

    return 0;
}

#
# ϥǡϰ⤫å
#
# []
#       arg0    åоϰϳ
#       arg1    åоϰϽλ
#       arg2    ϰϳ
#       arg3    ϰϳ
#
# [֤]
#       0       OK
#       1       оݤΥǡϰ¸
#      -1       ƥ२顼
#

sub is_inrange
{
    my ($targetst, $targetend, $chkst, $chkend, $errmsg) = @_;

    # ϰϥå
    if ($targetst ge $chkst && $targetst le $chkend) {
        $$errmsg[$L_DISP] = $LANG{$ENV{$DISPLANG}}{'INFO_RANGE_DATA8'};
        return 1;
    }

    # λϰϥå
    if ($targetend ge $chkst && $targetend le $chkend) {
        $$errmsg[$L_DISP] = $LANG{$ENV{$DISPLANG}}{'INFO_RANGE_DATA8'};
        return 1;
    }

    return 0;
}

#
# rangeѤΥǡ
#
# []
#       arg0    ϰϳ
#       arg1    ϰϽλ
#       arg2    롼ɥ쥹(gw)
#       arg3	ϰϰ
#       arg4	ϰϤΥǡ
#       arg5	򤷤ϰ
#       arg6	顼å
#
# [֤]
#       0       OK
#      -1       ƥ२顼
#

sub make_rangedata 
{
    my ($chkranst, $chkranend, $gwip, $rangelist, $rangedata, $selrange, $errmsg) = @_;
    my @tmp;
    my $binranst;
    my $binranend;
    my $range;
    my $binchkranst = add2bin($chkranst);     # 2ʿѴ
    my $binchkranend = add2bin($chkranend);   # 2ʿѴ
    my $bingwip = add2bin($gwip);             # 2ʿѴ

    # ϰϳϤϰϽλͤå
    if ($binchkranst ge $binchkranend) {
        $$errmsg[$L_DISP] = $LANG{$ENV{$DISPLANG}}{'INFO_RANGE_DATA1'};
        return 1;
    }

    # ȥɥ쥹Ȥνʣå
    if ($bingwip ge $binchkranst && $bingwip le $binchkranend) {
        $$errmsg[$L_DISP] = $LANG{$ENV{$DISPLANG}}{'INFO_RANGE_DATA2'};
        return 1;
    }

    # ϿѤϰϰȤνʣå
    foreach $range (keys %$rangelist) {
        @tmp = split(/,/, $$rangelist{$range});

        # ξϥǡ
        if ($$rangelist{$range} eq $selrange) {
            next;
        }

        # 2Ѵ
        $binranst = add2bin($tmp[0]);
        $binranend= add2bin($tmp[1]);

        # ϰϤΥå
        if (is_inrange($binchkranst, $binchkranend,
                                     $binranst, $binranend, $errmsg) == 1) {
            return 1;
        }

        # λϰϤΥå
        if (is_inrange($binranst, $binranend,
                                  $binchkranst, $binchkranend, $errmsg) == 1) {
            return 1;
        }

        # ǡ¸
        $$rangedata .= $$rangelist{$range} . "\n";
    }

    return 0;
}

sub check_range_ipaddr
{
    my ($subnet, $startrange, $endrange, $shared, $errmsg) = @_;
    my %allhostlist;
    my %fixiplist;

    # ϥɥ쥹å
    if (check_ipaddr($startrange, $errmsg) == 1) {
        $$errmsg[$L_DISP] = $LANG{$ENV{$DISPLANG}}{'INFO_IP_STRANGE'} .
                                  $$errmsg[$L_DISP];
        return 1;
    }

    # λɥ쥹å
    if (check_ipaddr($endrange, $errmsg) == 1) {
        $$errmsg[$L_DISP] = $LANG{$ENV{$DISPLANG}}{'INFO_IP_ENDRANGE'} .
                                  $$errmsg[$L_DISP];
        return 1;
    }

    # ϰϤγϤȽλƱå
    if ($startrange eq $endrange) {
        # ͤƱʤὪλ
        $$errmsg[$L_DISP] = $LANG{$ENV{$DISPLANG}}{'INFO_RANGE_DATA4'};
        return 1;
    }

    # ֥ͥåȤϰ⤫å
    if (is_insubnet($subnet, $startrange, $endrange, $errmsg) == 1) {
        # ֥ͥåȤϰϳΤὪλ
        return 1;
    }

    # ۥȾȤνʣå
    if (read_host($shared, $subnet, \%allhostlist, \%fixiplist, $errmsg) < 0) {
        return -1;
    }

    # ¹
    foreach  (sort {add2bin($a) cmp add2bin($b)} keys %{$fixiplist{$subnet}}) {
        if (add2bin($_) ge add2bin($startrange) && add2bin($_) le add2bin($endrange)) {
            $$errmsg[$L_DISP] = $LANG{$ENV{$DISPLANG}}{'INFO_RANGE_DATA11'} . "(" . $_ . ")";
            return 1;
        }
    }

    return 0;
}

1;
