#
# dhcpadmin
#
# Copyright (C) 2008 DesigNET, INC.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
#

##########################################################
#
# ֥ͥḁ̊饤֥
#
# $RCSfile: subnetlist.pl,v $
# $Revision: 1.7 $
# $Date: 2013/01/11 00:45:42 $
#
##########################################################

use strict;

#
# ֥ͥå/ͥåȥޥå
#
# []
#       arg0    ֥ͥå
#       arg1    ͥåȥޥ
#       arg2    顼å
#
# [֤]
#       0       OK
#       1       顼
#

sub check_networkform
{
    my ($subnet, $netmask, $errmsg) = @_;
    my @subnetparts;
    my @netmaskparts;
    my $subnetint;
    my $netmaskint;
    my $i;
    my $bit = 0;
    my @netmaskcheck = (128, 64, 32, 16, 8, 4, 2, 1);
    my $checkint;
    my $status;

    # ֥ͥå̤
    if ($subnet eq "") {
        $$errmsg[$L_DISP] = $LANG{$ENV{$DISPLANG}}{'ERR_SUBNET_DATA4'};
        return 1;
    } 

    # ͥåȥޥ̤
    if ($netmask eq "") {
        $$errmsg[$L_DISP] = $LANG{$ENV{$DISPLANG}}{'ERR_SUBNET_DATA5'};
        return 1;
    }

    # ֥ͥåIPå
    if (check_ipaddr($subnet, $errmsg) != 0) {
        $$errmsg[$L_DISP] = $LANG{$ENV{$DISPLANG}}{'INFO_IP_SUBNET1'} .
                                 $LANG{$ENV{$DISPLANG}}{'INFO_IP_FORMAT'};
        return 1;
    } 

    # ֥ͥåIP0.0.0.0ϥ顼
    if ($subnet eq "0.0.0.0") {
        $$errmsg[$L_DISP] = $LANG{$ENV{$DISPLANG}}{'INFO_IP_SUBNET2'} .
                                 $LANG{$ENV{$DISPLANG}}{'ERR_IP_DATA'};
        return 1;
    }

    # ͥåȥޥIPå
    if (check_ipaddr($netmask, $errmsg) != 0) {
        $$errmsg[$L_DISP] = $LANG{$ENV{$DISPLANG}}{'INFO_IP_NETMASK1'} .
                            $LANG{$ENV{$DISPLANG}}{'INFO_IP_FORMAT'};
        return 1;
    }

    # ͥåȥޥIP0.0.0.0ϥ顼
    if ($netmask eq "0.0.0.0") {
        $$errmsg[$L_DISP] = $LANG{$ENV{$DISPLANG}}{'INFO_IP_NETMASK2'} .
                                 $LANG{$ENV{$DISPLANG}}{'ERR_IP_DATA'};
        return 1;
    }

    # ɥ쥹1Ĥϥ顼
    if ($netmask eq "255.255.255.255") {
        $$errmsg[$L_DISP] = $LANG{$ENV{$DISPLANG}}{'INFO_IP_NETMASK2'} .
                            $LANG{$ENV{$DISPLANG}}{'ERR_IP_DATA'};
        return 1;
    }

    # ͥåȥΥå
    @subnetparts = split(/\./, $subnet, 4);
    @netmaskparts = split(/\./, $netmask, 4);

    for ($i = 0; $i < 4; $i++) {
        $status = 0;
        $subnetint = int($subnetparts[$i]);
        $netmaskint = int($netmaskparts[$i]);

        # ֥ͥåȤȥͥåȥޥORη̤ͥåȥޥʤХ顼
        $bit = ($subnetint | $netmaskint);
        if ($bit ne $netmaskint) {
            $$errmsg[$L_DISP] = $LANG{$ENV{$DISPLANG}}{'ERR_NETWORK_FORMAT'};
            return 1;
        }

        # ͭʥͥåȥޥå
        foreach $checkint (@netmaskcheck) {

            # 12864ƥޥʥʤե饰ΩƤ
            if ($netmaskint - $checkint < 0) {
                $status = 1;
                next;
            }

            # 12864Ƥե饰ΩäƤ饨顼
            if ($status == 1) {
                $$errmsg[$L_DISP] = $LANG{$ENV{$DISPLANG}}{'ERR_NETWORK_FORMAT'};
                return 1;
            }
            $netmaskint -= $checkint;
        }
    }

    # ʣå
    if (check_duplicatesubnet($subnet, $netmask, $errmsg) != 0) {
        return 1;
    }

    return 0;
}

#
# ֥ͥåȽʣå
#
# []
#       arg0    ֥ͥå
#       arg1    顼å
#
# [֤]
#       0       OK
#       1       顼
#

sub check_duplicatesubnet
{
    my ($addsubnet, $addnetmask, $errmsg) = @_;
    my @tmpdirlist;
    my @dirlist;
    my $dirname;
    my $subnet;
    my $netmask;
    my $filepath;

    # ֥ͥåȥǥ쥯ȥ
    if (read_dir($WORKDIR, \@tmpdirlist, $errmsg) != 0 ) {
        return -1;
    }

    foreach $filepath (@tmpdirlist) {

        # ֥ͥåȥǥ쥯ȥ
        if (-d $filepath) {
            if (read_dir($filepath, \@dirlist, $errmsg) != 0 ) {
                return -1;
            }

            foreach $dirname (@dirlist) {
                if (!-d $dirname) {
                    next;
                }

                $dirname =~ s/$WORKDIR\///g;
                ($subnet, $netmask) = split(/-/, $dirname);
        
                # ¸ߤƤ륵֥ͥåȤΥͥåȥä饨顼
                if (Net::IPv4Addr::ipv4_in_network($subnet, $netmask, $addsubnet) == 1) {
                    $$errmsg[$L_DISP] = $LANG{$ENV{$DISPLANG}}{'ERR_SUBNET_DATA7'} .
                                         "(" . $addsubnet . "/" . $addnetmask . ")";
                    return 1;
                }

                # ¸ߤƤ륵֥ͥåȤɲä֥ͥåä饨顼
                if (Net::IPv4Addr::ipv4_in_network($addsubnet, $addnetmask, $subnet) == 1) {
                    $$errmsg[$L_DISP] = $LANG{$ENV{$DISPLANG}}{'ERR_SUBNET_DATA7'} .
                                         "(" . $addsubnet . "/" . $addnetmask . ")";
                    return 1;
                }
            
            }
        }
    }
    return 0;

}

1;
