<?php

/*
 * postLDAPadmin
 *
 * Copyright (C) 2006,2014 DesigNET, INC.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

/***********************************************************
 * 饤ȰϿ
 *
 * $RCSfile: index.php,v $
 * $Revision: 1.0 $
 * $Date: 2014 $
 **********************************************************/

include_once("../initial");
include_once("lib/dglibpostldapadmin");
include_once("lib/dglibcommon");
include_once("lib/dglibpage");
include_once("lib/dglibsess");
include_once("lib/dglibdhcpadmin");

/********************************************************
 * ƥڡ
 ********************************************************/

define("TMPLFILE_UPLOAD",   "admin_client_upload.tmpl");
define("UPLOAD_CLIENT",     "Upload client");
define("MAX_SUBNET_LENGTH", "31");


/*********************************************************
 * check_file_duplication()
 *
 * եȤνʣå
 *
 * []
 *      $file_data   եȤä
 * [֤]
 *      0            
 *      1            ۥ̾顼
 *      2            MACɥ쥹顼
 *      3            IPɥ쥹顼
 **********************************************************/
function check_file_duplication($file_data, &$error_line)
{
    $i = 0;
    /* 1ԤĤ줾$checkֹĤľ */
    foreach ($file_data as $data) {
        $data = rtrim($data);
        list($subnet, $hostname, $mac, $ip, $select) = explode(",", $data);

        $check[$i]["subnet"] = $subnet;
        $check[$i]["mac"] = $mac;
        $check[$i]["ip"] = $ip;
        $check[$i]["hostname"] = $hostname;
        $i++;
    }
    $count = $i;
    /* եǽʣ̵å */
    for ($i = 0; $i < $count; $i++) {
        /* ƤԤμιԤȽ֤ӤƤ */
        for ($j = $i + 1; $j < $count; $j++) {
            /* ֥ͥåȤƱξΤ߽ʣå */
            if ($check[$i]["subnet"] == $check[$j]["subnet"]) {
                if ($check[$i]["hostname"] == $check[$j]["hostname"]) {
                    $error_line = $j;
                    return 1;
                }
                if ($check[$i]["mac"] == $check[$j]["mac"]) {
                    $error_line = $j;
                    return 2;
                }
                if ($check[$i]["ip"] == $check[$j]["ip"]) {
                    $error_line = $j;
                    return 3;
                }
            }
        }
    }
    return 0;
}


/*********************************************************
 * check_update_in()
 *
 * 饤ȰϿͥå
 *
 * []
 *      $file_data   եȤä
 * [֤]
 *      0            
 *      1            ֥ͥå̤
 *      2            ۥ̤̾
 *      3            MACɥ쥹̤
 *      4            IP߽̤
 *      5            ֥ͥåȥ顼
 *      6            ۥ̾顼
 *      7            MACɥ쥹顼
 *      8            IPɥ쥹顼
 *      9            IP߽ꥨ顼
 *     10            ֥ͥåȤ¸ߤʤ
 *     11            IP֥ͥåϰϳ
 **********************************************************/

function check_update_in($file_data, &$line)
{
    foreach ($file_data as $data) {
        $data = rtrim($data);
        /* ޤǶڤ */
        list($subnet, $hostname, $mac, $ip, $select) = explode(",", $data);

        $line++;
        /* ɬܹܥå */
        $must = check_in_must($subnet, $hostname, $mac, $select);
        if ($must != 0) {
            /* ϥ顼 */
            return $must;
        }
        /* ֥ͥåȤϤ顼 */
        $ret = check_subnet($subnet);
        if ($ret == FALSE) {
            return 5;
        }
        /* ۥ̾Ϥ顼 */
        $ret = check_hostname($hostname);
        if ($ret == FALSE) {
            return 6;
        }
        /* MACɥ쥹Ϥ顼 */
        $ret = check_add_mac($mac);
        if ($ret == FALSE) {
            return 7;
        }
        /* IPɥ쥹Ϥ顼 */
        $ret = check_ip($ip);
        if ($ret == FALSE) {
            return 8;
        }
        /* IP߽Ϥ顼 */
        $ret = check_select($select);
        if ($ret == FALSE) {
            return 9;
        }
        /* åƱ֥ͥåȤ뤫 */
        $judge = judge_sn($subnet);
        if ($judge == "") {
            return 10;
        }
        /* IPϰϤ顼 */
        if (isset($ip) && $ip != "") {
            $ret = in_range_ipv4($subnet, $ip);
            if ($ret == FALSE) {
                return 11;
            }
        }
    }
    return 0;
}

/*********************************************************
 * check_in_must()
 *
 * ɬܹܤϤƤ뤫å
 *
 * []
 *      $subnet      1ԤȤΥ֥ͥå
 *      $hostname    1ԤȤΥۥ̾
 *      $mac         1ԤȤmacɥ쥹
 *      $select      1ԤȤIP߽
 * [֤]
 *      0            
 *      1            ֥ͥåȥ顼
 *      2            ۥ̾顼
 *      3            MACɥ쥹顼
 *      4            IPɥ쥹顼
 **********************************************************/
function check_in_must($subnet, $hostname, $mac, $select)
{
    /* ֥ͥåȤϤ뤫 */
    if ($subnet == "") {
        return 1;
    } 
    /* ۥ̾Ϥ뤫 */
    if ($hostname == "") {
        return 2;
    } 
    /* MACɥ쥹Ϥ뤫 */
    if ($mac == "") {
        return 3;
    }
    /* IP߽꤬򤵤Ƥ뤫 */
    if ($select == "") {
        return 4;
    }
    return 0;
}

/*********************************************************
 * check_subnet()
 *
 * ֥ͥåȤͥå
 *
 * []
 *      $subnet      ֥ͥåȤ
 * [֤]
 *      TRUE         
 *      FALSE        ۾
 **********************************************************/
function check_subnet($subnet)
{
    /* ʸå */
    /* subnetͤ뤫Ĵ٤ */
    $length = strlen($subnet);
    if ($length > MAX_SUBNET_LENGTH) {
        return FALSE;
    }
    /* /ʬ */
    $piece = explode("/", $subnet);
    if (count($piece) != 2) {
        return FALSE;
    }
    /* /򤽤줾å */
    $ret = check_ip($piece[0]);
    if ($ret == FALSE) {
        return FALSE;
    }
    $ret = check_ip($piece[1]);
    if ($ret == FALSE) {
        return FALSE;
    }
    return TRUE;
}

/*********************************************************
 * check_select()
 *
 * IP߽å 
 *
 * []
 *      $select      IP߽
 * [֤]
 *      TRUE         
 *      FALSE        ۾
 **********************************************************/
function check_select($select)
{
    /*Ϥ줿ͤallow⤷deny*/
    $select = mb_convert_encoding($select, "EUC-JP", "SJIS");
    if ($select == "" || $select == "") {
        return TRUE;
    }
    return FALSE;
}


/*********************************************************
 * add_host_session()
 *
 * Ͽؿ 
 *
 * []
 *      $file_data    ե 
 * [֤]
 *      TRUE         
 *      FALSE        ۾
 **********************************************************/
function add_host_session($file_data)
{
    foreach ($file_data as $data) {
        $data = rtrim($data);
        /* dataȤʤcontinue */
        if ($data == "") {
            continue;
        }
        /* ޤǶڤ */
        list($subnet, $hostname, $mac, $ip, $select) = explode(",", $data);
        /* MACɥ쥹2· */
        $mac = check_macaddr($mac);
        /* IP߽Ѵ */
        $select = mb_convert_encoding($select, "EUC-JP", "SJIS");
        if ($select == "") {
            $select = "allow";
        } else {
            $select = "deny";
        }

        /* SESSIONʸ¤٤ */
        $line = $hostname . "," . $mac . "," . $ip . "," . "\"$hostname\"" . "," . $select;
        /* Shared-networkĴ٤ */
        $sn = judge_sn($subnet);
        if ($sn == "") {
            return FALSE;
        }
        if (isset($_SESSION[STR_IP]["$sn"]["$subnet"]["host"])) {
            /* hostȤФĤʤ */
            $hostline = $_SESSION[STR_IP]["$sn"]["$subnet"]["host"];
            $hostline = $hostline . $line . "\n";
        } else {
            /* hostȤʤ */
            $hostline = $line . "\n";
        }
        /* SESSIONϿ */
        $_SESSION[STR_IP]["$sn"]["$subnet"]["host"] = $hostline;
    }
    return TRUE;
}
/*********************************************************
 * check_column()
 *
 * åؿ 
 *
 * []
 *      $file_data    եȤä
 * [֤]
 *      $line         顼ι 
 **********************************************************/
/*å*/
function check_column($file_data) 
{
    $line = 0;
    foreach ($file_data as $data) {
        $line++;
        $data = rtrim($data);
        /* ޤǶڤ */
        $column = explode(",", $data);
        /*å*/
        if (count($column) != 5) {
            /* 顼ιԿ֤ */
            return $line;
        }
    }
    /* 0֤ */
    return 0;
}

/***********************************************************
 * 
 **********************************************************/

$template = TMPLFILE_UPLOAD;

/*  */
$tag["<<TITLE>>"]        = "";
$tag["<<JAVASCRIPT>>"]   = "";
$tag["<<SK>>"]           = "";
$tag["<<SN>>"]           = "";
$tag["<<TOPIC>>"]        = "";
$tag["<<MESSAGE>>"]      = "";
$tag["<<TAB>>"]          = "";
$tag["<<MENU>>"]         = "";
$newhostline             = "";
$addhostline             = "";

/* ե䥿ִեɹåΥå */
$ret = init();
if ($ret === FALSE) {
    syserr_display();
    exit(1);
}

/* dhcpd.confβ */
$ret = analyze_dhcpd_conf($web_conf["dhcpadmin"]["dhcpdconfpath"], "IPv4");
/* dhcpd.confɤ߹ߥ顼 */
if ($ret == FALSE) {
    $err_msg = $msgarr['27004'][SCREEN_MSG];
    $log_msg = $msgarr['27004'][LOG_MSG];
    result_log($log_msg, LOG_ERR);
    syserr_display();
    exit(1);
}

/* ťΥå */
$ret = dhcpadmin_login_check($lock_file);
if ($ret === FUNC_FALSE) {
    $err_msg = sprintf($msgarr['27006'][SCREEN_MSG], $lock_file);
    $log_msg = sprintf($msgarr['27006'][LOG_MSG], $lock_file);
    result_log($log_msg, LOG_ERR);
    syserr_display();
    exit(1);
} elseif ($ret === LOCK_FALSE) {
    $err_msg = $msgarr['27005'][SCREEN_MSG];
    $log_msg = sprintf($msgarr['27005'][LOG_MSG], $_SERVER["REMOTE_ADDR"]);
    result_log($log_msg, LOG_ERR);
    syserr_display();
    exit(1);
}

/***********************************************************
 * main
 **********************************************************/

if (isset($_POST["csvupload"])) {
    /* $_FILESѿ tmp_name ˥оΥե̾ */
    $csv_file = $_FILES["csv_upload"]["tmp_name"];

    /* UPLOAD줿ե뤫å򤹤 */
    if (is_uploaded_file($csv_file) === FALSE) {
        $err_msg = sprintf($msgarr['34008'][SCREEN_MSG]);
        $log_msg = $msgarr['34008'][LOG_MSG];
        result_log(UPLOAD_CLIENT . ":NG:" . $log_msg, LOG_ERR);
    } else {
        $file_data = file($csv_file);
        /* եȤʤ饨顼 */
        if (empty($file_data)) {
            $err_msg = sprintf($msgarr['34013'][SCREEN_MSG]);
            $log_msg = $msgarr['34013'][LOG_MSG];
            result_log(UPLOAD_CLIENT . ":NG:" . $log_msg, LOG_ERR);
        } else {
            /*å*/
            $line = check_column($file_data);
            if ($line != 0) {
                /*  */
                $err_msg = sprintf($msgarr['34001'][SCREEN_MSG], $line);
                $log_msg = sprintf($msgarr['34001'][LOG_MSG], $line);
                result_log(UPLOAD_CLIENT . ":NG:" . $log_msg, LOG_ERR);
            } else {
                /*ϥå*/
                $line = 0;
                $ret = check_update_in($file_data, $line);
                switch ($ret) {
                case 1:
                    /* ֥ͥåȤϤʤ */
                    $err_msg = sprintf($msgarr['34002'][SCREEN_MSG], $line);
                    $log_msg = sprintf($msgarr['34002'][LOG_MSG], $line);
                    result_log(UPLOAD_CLIENT . ":NG:" . $log_msg, LOG_ERR);
                    break;
                case 2:
                    /* ۥ̾Ϥʤ */
                    $err_msg = sprintf($msgarr['34003'][SCREEN_MSG], $line);
                    $log_msg = sprintf($msgarr['34003'][LOG_MSG], $line);
                    result_log(UPLOAD_CLIENT . ":NG:" . $log_msg, LOG_ERR);
                    break;
                case 3:
                /* MACɥ쥹Ϥʤ */
                    $err_msg = sprintf($msgarr['34005'][SCREEN_MSG], $line);
                    $log_msg = sprintf($msgarr['34005'][LOG_MSG], $line);
                    result_log(UPLOAD_CLIENT . ":NG:" . $log_msg, LOG_ERR);
                    break;
                case 4:
                /* IP߽꤬򤵤Ƥ뤫 */
                    $err_msg = sprintf($msgarr['34010'][SCREEN_MSG], $line);
                    $log_msg = sprintf($msgarr['34010'][LOG_MSG], $line);
                    result_log(UPLOAD_CLIENT . ":NG:" . $log_msg, LOG_ERR);
                    break;
                /* ֥ͥåȤϥå顼 */
                case 5:
                    $err_msg = sprintf($msgarr['34009'][SCREEN_MSG], $line);
                    $log_msg = sprintf($msgarr['34009'][LOG_MSG], $line);
                    result_log(UPLOAD_CLIENT . ":NG:" . $log_msg, LOG_ERR);
                    break;
                /* ۥ̾ϥå顼 */
                case 6:
                    $err_msg = sprintf($msgarr['34004'][SCREEN_MSG], $line);
                    $log_msg = sprintf($msgarr['34004'][LOG_MSG], $line);
                    result_log(UPLOAD_CLIENT . ":NG:" . $log_msg, LOG_ERR);
                    break;
                /* MACɥ쥹ϥå顼 */
                case 7:
                    $err_msg = sprintf($msgarr['34006'][SCREEN_MSG], $line);
                    $log_msg = sprintf($msgarr['34006'][LOG_MSG], $line);
                    result_log(UPLOAD_CLIENT . ":NG:" . $log_msg, LOG_ERR);
                    break;
                /* IPɥ쥹ϥå顼 */
                case 8:
                    $err_msg = sprintf($msgarr['34007'][SCREEN_MSG], $line);
                    $log_msg = sprintf($msgarr['34007'][LOG_MSG], $line);
                    result_log(UPLOAD_CLIENT . ":NG:" . $log_msg, LOG_ERR);
                    break;
                /* IP߽ϥå顼 */
                case 9:
                    $err_msg = sprintf($msgarr['34012'][SCREEN_MSG], $line);
                    $log_msg = sprintf($msgarr['34012'][LOG_MSG], $line);
                    result_log(UPLOAD_CLIENT . ":NG:" . $log_msg, LOG_ERR);
                    break;
                /* ֥ͥå¸ߥ顼 */
                case 10:
                    $err_msg = sprintf($msgarr['34011'][SCREEN_MSG], $line);
                    $log_msg = sprintf($msgarr['34011'][LOG_MSG], $line);
                    result_log(UPLOAD_CLIENT . ":NG:" . $log_msg, LOG_ERR);
                    break;
                /* IPɥ쥹ϰϥ顼 */
                case 11:
                    $err_msg = sprintf($msgarr['33020'][SCREEN_MSG], $line);
                    $log_msg = sprintf($msgarr['33020'][LOG_MSG], $line);
                    result_log(UPLOAD_CLIENT . ":NG:" . $log_msg, LOG_ERR);
                    break;
                /* ξ */
                case 0:
                    /* եȽʣå */
                    $ret = check_file_duplication($file_data, $line);
                    switch ($ret) {
                    /* ۥ̾ʣ */
                    case 1:
                        $err_msg = sprintf($msgarr['34018'][SCREEN_MSG], $line + 1);
                        $log_msg = sprintf($msgarr['34018'][LOG_MSG], $line + 1);
                        result_log(UPLOAD_CLIENT . ":NG:" . $log_msg, LOG_ERR);
                        break;
                    /* MACɥ쥹ʣ */
                    case 2:
                        $err_msg = sprintf($msgarr['34019'][SCREEN_MSG], $line + 1);
                        $log_msg = sprintf($msgarr['34019'][LOG_MSG], $line + 1);
                        result_log(UPLOAD_CLIENT . ":NG:" . $log_msg, LOG_ERR);
                        break;
                    /* IPɥ쥹ʣ */
                    case 3:
                        $err_msg = sprintf($msgarr['34020'][SCREEN_MSG], $line + 1);
                        $log_msg = sprintf($msgarr['34020'][LOG_MSG], $line + 1);
                        result_log(UPLOAD_CLIENT . ":NG:" . $log_msg, LOG_ERR);
                        break;
                    /* ξ */
                    case 0:
                        /* ʣå */
                        $line = 0;
                        $dup_flag = 0;
                        foreach ($file_data as $data) {
                            $line++;
                            $ret = check_duplication_data($data);
                            switch ($ret) {
                            /* ۥ̾ʣ */
                            case 1:
                                $err_msg = sprintf($msgarr['34015'][SCREEN_MSG], $line);
                                $log_msg = sprintf($msgarr['34015'][LOG_MSG], $line);
                                result_log(UPLOAD_CLIENT . ":NG:" . $log_msg, LOG_ERR);
                                $dup_flag = 1;
                                break 2;
                            /* MACɥ쥹ʣ */
                            case 2:
                                $err_msg = sprintf($msgarr['34016'][SCREEN_MSG], $line);
                                $log_msg = sprintf($msgarr['34016'][LOG_MSG], $line);
                                result_log(UPLOAD_CLIENT . ":NG:" . $log_msg, LOG_ERR);
                                $dup_flag = 1;
                                break 2;
                            /* IPɥ쥹ʣ */
                            case 3:
                                $err_msg = sprintf($msgarr['34017'][SCREEN_MSG], $line);
                                $log_msg = sprintf($msgarr['34017'][LOG_MSG], $line);
                                result_log(UPLOAD_CLIENT . ":NG:" . $log_msg, LOG_ERR);
                                $dup_flag = 1;
                                break 2;
                            /* Shared-network¸ߤʤ */
                            case 4:
                                $err_msg = sprintf($msgarr['34022'][SCREEN_MSG], $line);
                                $log_msg = sprintf($msgarr['34022'][LOG_MSG], $line);
                                result_log(UPLOAD_CLIENT . ":NG:" . $log_msg, LOG_ERR);
                                $dup_flag = 1;
                                break 2;
                            /* ξ */
                            case 0:
                                break;
                            }
                        }
                        /* ξ */
                        if ($dup_flag == 0) {
                            /* Ͽ */
                            $ret = add_host_session($file_data);
                            if ($ret == FALSE) {
                                /* Shared-network¸ߤʤ */
                                $err_msg = sprintf($msgarr['34022'][SCREEN_MSG], $line);
                                $log_msg = sprintf($msgarr['34022'][LOG_MSG], $line);
                                result_log(UPLOAD_CLIENT . ":NG:" . $log_msg, LOG_ERR);
                            } else {
                                /* Ͽ */
                                $err_msg = sprintf($msgarr['34021'][SCREEN_MSG], $line);
                                $log_msg = sprintf($msgarr['34021'][LOG_MSG], $line);
                                result_log(UPLOAD_CLIENT . ":OK:" . $log_msg, LOG_ERR);
                            }
                        }
                    }
                }
            }
        }
    }
/* ܥ󤬲줿 */
} else if (isset($_POST["back"])) {
    /*  */
    dgp_location("index.php");
    exit(0);
}

/***********************************************************
 * ɽ
 **********************************************************/
/*   */
set_tag_common($tag);

/* ڡν */
$ret = display($template, $tag, array(), "", "");
if ($ret === FALSE) {
    result_log($log_msg, LOG_ERR);
    syserr_display();
    exit(1);
}
?>
