#ifndef __BROWSER_H__
#define __BROWSER_H__

#include <sys/types.h>
#include <gdk/gdk.h>
#include <gtk/gtk.h>
#include "url.h"       /* for DilloUrl */
#include "dw_style.h"  /* for DwStyle */

typedef struct _BrowserWindow BrowserWindow;
typedef struct _DilloMenuPopup DilloMenuPopup;
typedef struct _DilloDoc DilloDoc;

typedef struct {
    DilloUrl *Url;   /* URL-key for this cache connection */
    gint Flags;      /* {WEB_RootUrl, WEB_Image, WEB_Download} */
} DdUrls;

/* The popup menus so that we can call them. */
struct _DilloMenuPopup
{
   GtkWidget *over_page;
   GtkWidget *over_link;
   GtkWidget *over_image;
   GtkWidget *over_back;
   GtkWidget *over_forw;
#ifndef XHTML_DTD_STRICT
   GtkWidget *over_frame;
#endif /* !XHTML_DTD_STRICT */
#ifndef DISABLE_TABS
   GtkWidget *over_tab;
#endif /* !DISABLE_TABS */
   DilloUrl *url;
};

/* browser_window contains everything related to a window */
struct _BrowserWindow
{
   /* Control-Panel handleboxes --used for hiding */
   GSList *PanelHandles;
   /* Flag: TRUE when control-panel is hidden */
   gboolean fullwindow;

   /* The tag for the idle function that sets button sensitivity. */
   guint sens_idle_tag;

   /* widgets for the main window */
   GtkWidget *main_window;
   GtkWidget *back_button;
   GtkWidget *forw_button;
   GtkWidget *home_button;
   GtkWidget *reload_button;
   GtkWidget *save_button;
   GtkWidget *stop_button;
   GtkWidget *bookmarks_button;
   GtkWidget *menubar;
   GtkWidget *clear_url_button;
   GtkWidget *location;
   GtkWidget *progress_box;
   GtkWidget *status_box;
   GtkWidget *status;
#ifdef ENABLE_USER_AGENT
   GtkWidget *useragent_box;
#endif
   gint status_is_link;
   GtkWidget *imgprogress;
   GtkWidget *progress;

   /* popup menu navigation widgets */
   GtkWidget *back_op_menu_button;
   GtkWidget *forw_op_menu_button;
   GtkWidget *stop_op_menu_button;

   /* the keyboard accelerator table */
   GtkAccelGroup *accel_group;

   /* the tooltips group */
   GtkTooltips *tooltips;

   /* Popup menu for this BrowserWindow */
   DilloMenuPopup menu_popup;

   /* The bookmarks menu so that we can add things to it. */
   GtkWidget *bookmarks_menu;

   /* The Pagemark menu_item (points to individual document's pagemark menus */
   GtkWidget *pagemarks_menuitem;

#ifndef XHTML_DTD_STRICT
   /* The Frame menu_item (points to individual frame menus */
   GtkWidget *frame_menuitem;

   /* The Frameset menu_item (points to nested frameset menus */
   GtkWidget *frameset_menuitem;

#endif /* !XHTML_DTD_STRICT */
   /* widgets for dialog boxes off main window */
   GtkWidget *open_dialog_window;
   GtkWidget *open_dialog_entry;
   GtkWidget *openfile_dialog_window;
   GtkWidget *quit_dialog_window;
   GtkWidget *save_dialog_window;
   GtkWidget *save_link_dialog_window;
   GtkWidget *findtext_dialog_window;
   GtkWidget *findtext_dialog_check;
   GtkWidget *findtext_dialog_entry;
   GtkWidget *question_dialog_window;
   gpointer  question_dialog_data;
   GtkWidget *passwd_dialog_window;
   GtkWidget *passwd_dialog_uentry;
   GtkWidget *passwd_dialog_pentry;
   GtkWidget *viewsource_window;
   GtkWidget *full_screen_off_button;

   /* the container widget, this contains either the tabbrowser
    * or the docwin
    */
   GtkContainer *container;

   /* tab width adjustment magic. Yes, it is magic. In essence,
    * this contains the average width of a character in a string
    * in the current display context and with the current language.
    * This is used to calculate the expected width of tab labels
    *
    * the value is calculated when the tabbrowser is loaded
    */
   gfloat tab_label_average_character_width;

   /* the currently displayed document */
   DilloDoc *dd;

   /* the findtext state (TRUE if search string has been found
    * in the document or any of its children
    */
   gboolean found;

   /* the list of documents to search through in findtext */
   GList *dd_list;
   /* the current index for dd_list */
   gint dd_list_index;
};

/* dillo_doc contains all data pertaining to a single document */
struct _DilloDoc
{
   /* the BrowserWindow this document is currently part of */
   BrowserWindow *bw;

   /* This is the main document widget. (HTML rendering or whatever) */
   GtkWidget *docwin;

   /* The initial style for the widget */
   DwStyle *style;

   /* for nested documents, points to parent document */
   DilloDoc *parent;

#ifdef XHTML_DTD_FRAMESET
   /* This is the frameset widget. */
   GtkWidget *frameset;

#endif /* XHTML_DTD_FRAMESET */
#ifndef XHTML_DTD_STRICT
   /* document name (as used in 'target=window_or_frame_name' attribute */
   gchar *name;

#endif /* !XHTML_DTD_STRICT */
   /* The "Headings" and "Anchors" menus */
   GtkWidget *pagemarks_menu;
   GtkWidget *pagemarks_last;

   /* Current cursor type */
   GdkCursorType CursorType;

   /* A list of active cache clients in the window (The primary Key) */
   gint *RootClients;
   gint NumRootClients;
   gint MaxRootClients;

   /* Image Keys for all active connections in the window */
   gint *ImageClients;
   gint NumImageClients;
   gint MaxImageClients;
   /* Number of different images in the page */
   gint NumImages;
   /* Number of different images already loaded */
   gint NumImagesGot;
   /* the current document progress */
   gfloat progress;
   /* 'ready' is true when the root document has finished loading */
   gboolean ready;

   /* List of all Urls requested by this page (and its types) */
   DdUrls *PageUrls;
   gint NumPageUrls;
   gint MaxPageUrls;

   /* Dillo navigation stack (holds indexes to history list) */
   gint *nav_stack;
   gint nav_stack_size;       /* [1 based] */
   gint nav_stack_size_max;
   /* 'nav_stack_ptr' refers to what's being displayed */
   gint nav_stack_ptr;        /* [0 based] */
   /* When the user clicks a link, the URL isn't pushed directly to history;
    * nav_expect_url holds it until the first answer-bytes are got. Only then
    * it is sent to history and referenced in 'nav_stack[++nav_stack_ptr]' */
   DilloUrl *nav_expect_url;
   /* 'nav_expecting' is true if the last URL is being loaded for
    * the first time and has not gotten the dw yet. */
   gboolean nav_expecting;
   DilloUrl *auth_await_url;
};

#endif /* __BROWSER_H__ */

