#ifndef __DEBUG_H__
#define __DEBUG_H__

/*
 * Simple debug messages. Add:
 *
 *    #define DEBUG_LEVEL <n>
 *    #include "debug.h"
 *
 * to the file you are working on, or let DEBUG_LEVEL undefined to
 * disable all messages. A higher level denotes a greater importance
 * of the message.
 */

#include <glib.h>

# ifdef DEBUG_LEVEL
#    define DEBUG_MSG(level, fmt...) \
        ( (DEBUG_LEVEL) && ((level) >= DEBUG_LEVEL) ) ? \
        g_print(fmt) : (level)
# else
#    define DEBUG_MSG(level, fmt...)
# endif /* DEBUG_LEVEL */


//#define DEBUG_HTML_WARN 1

# ifdef DEBUG_HTML_WARN
#    define DEBUG_HTML_MSG(fmt...) {g_print("HTML warning: ");g_print(fmt);}
# else
#    define DEBUG_HTML_MSG(fmt...)
# endif /* DEBUG_HTML_WARN */

//#define DEBUG_HTTP_WARN 1

# ifdef DEBUG_HTTP_WARN
#    define DEBUG_HTTP_MSG(fmt...) {g_print("HTTP warning: ");g_print(fmt);}
# else
#    define DEBUG_HTTP_MSG(fmt...)
# endif /* DEBUG_HTTP_WARN */


/*
 * Following is experimental, and will be explained soon.
 */

#ifdef DBG_RTFL

#include <unistd.h>
#include <stdio.h>

#define DBG_CREATE(obj, klass) \
   do { \
      printf ("[rtfl]%s:%d:%p:%d:::create:%s\n", \
              __FILE__, __LINE__, obj, getpid(), klass); \
      fflush (stdout); \
   } while(0);

#define DBG_MSG(obj, aspect, prio, msg) \
   do { \
      printf ("[rtfl]%s:%d:%p:%d:%s:%d:msg:%s\n", \
              __FILE__, __LINE__, obj, getpid(), aspect, prio, msg); \
      fflush (stdout); \
   } while(0);

#define DBG_MSGF(obj, aspect, prio, fmt, arg...) \
   do { \
      printf ("[rtfl]%s:%d:%p:%d:%s:%d:msg:" fmt "\n", \
              __FILE__, __LINE__, obj, getpid(), aspect, prio, arg); \
      fflush (stdout); \
   } while(0);

#define DBG_START(obj) \
   do { \
      printf ("[rtfl]%s:%d:%p:%d:::start:\n", \
              __FILE__, __LINE__, obj, getpid()); \
      fflush (stdout); \
   } while(0);

#define DBG_END(obj) \
   do { \
      printf ("[rtfl]%s:%d:%p:%d:::end:\n", \
              __FILE__, __LINE__, obj, getpid()); \
      fflush (stdout); \
   } while(0);

#define DBG_ASSOC(child, parent) \
   do { \
      printf ("[rtfl]%s:%d:%p:%d:::assoc:%p\n", \
              __FILE__, __LINE__, child, getpid(), parent); \
      fflush (stdout); \
   } while(0);

#define DBG_SET_NUM(obj, var, val) \
   do { \
      printf ("[rtfl]%s:%d:%p:%d:::set:%s=%d\n", \
              __FILE__, __LINE__, obj, getpid(), var, val); \
      fflush (stdout); \
   } while(0);

#define DBG_ARRSET_NUM(obj, var, ind, val) \
   do { \
      printf ("[rtfl]%s:%d:%p:%d:::set:%s[%d]=%d\n", \
              __FILE__, __LINE__, obj, getpid(), var, ind, val); \
      fflush (stdout); \
   } while(0);

#else /* DBG_RTFL */

#define DBG_CREATE(obj, klass)
#define DBG_MSG(obj, aspect, prio, msg)
#define DBG_MSGF(obj, aspect, prio, fmt, arg...)
#define DBG_START(obj)
#define DBG_END(obj)
#define DBG_ASSOC(child, parent)
#define DBG_SET_NUM(obj, var, val)
#define DBG_ARRSET_NUM(obj, var, ind, val)

#endif /* DBG_RTFL */

#endif /* __DEBUG_H__ */


