-- <pre>
-- $ createdb -U skelton_user books_manager
-- $ psql -U skelton_user books_manager < books_manager.sql
--
-- sql file for "books_manager"

CREATE TABLE auth_user (
	username text not null,
	password text not null, -- to be stored md5 hashed password
	auth_level int not null default 0, -- level of access granted
	auth_perm text default null, --  ',' seperated 
	primary key (username)
);

-- logging class for Dino_DB
CREATE TABLE __logging_sql (
	logging_time timestamp not null default current_timestamp,
	func_name text not null,
	query text not null,
	result_option text
);
CREATE INDEX idx___logging_sql_logging_time
on __logging_sql (logging_time);


-- ڡ
CREATE TABLE page (
	"key" text, -- key
	parent_key text default '', -- ƥڡ
	ctime text default '', -- 
	mtime text default '', -- ǽ
	contents text, -- ƥ
	contents_type text not null default 'wiki', -- ƥĥ
	visible boolean not null default 'f', -- Ļ
	enable boolean not null default 't', -- Ѳǽ
	template text default 'default', -- ƥץ졼

	primary key ("key")
);

-- insert into page("key",visible,template) values('default','t','default');


-- Ǽҥꥹ

CREATE TABLE publisher_list (

	id serial, -- ǼID
	name text not null, -- ̾
	address text not null, -- 
	tel text not null, -- ֹ
	fax text, -- faxֹ
	note text, -- 
	last_update timestamp not null default current_timestamp, -- ǽ


	primary key (id)
);



-- ʬ

CREATE TABLE classification (

	id serial, -- ʬID
	name text not null, -- ʬ̾
	note text, -- 
	last_update timestamp default current_timestamp, -- ǽ

	unique(name),

	primary key (id)
);



-- ߽Х桼

CREATE TABLE user_list (

	id serial, -- 桼ID
	name text not null, -- ̾
	birth_date timestamp, -- ǯ
	sex text not null, -- 
	address text not null, -- 
	note text, -- 
	create_date date not null, -- Ͽ
	last_update timestamp default current_timestamp, -- ǽ


	primary key (id)
);



-- ԥꥹ

CREATE TABLE manage_member (

	username text not null primary key,
	name text not null, -- ̾
	office_id text not null, -- ID
	create_date timestamp default current_timestamp, -- Ͽ


	dummy_field_of_auth_user int default null -- dummy 
) inherits (auth_user);



-- ԥꥹ

CREATE TABLE writer_list (

	id serial, -- ID
	name text not null, -- ̾
	pronunciation text, -- ɤߤ
	note text, -- 
	create_date timestamp not null, -- Ͽ


	primary key (id)
);



-- £ȿ

CREATE TABLE present_org (

	id serial, -- £ȿID
	org_name text not null, -- ȿ̾
	note text, -- 


	primary key (id)
);



-- ʬ

CREATE TABLE detailed_class (

	id serial, -- ʬID
	class_id__classification_id integer not null, -- ʬ
	name text not null, -- ʬ̾
	note text, -- 
	last_update timestamp default current_timestamp, -- ǽ

	foreign key (class_id__classification_id) references classification(id)
	on update cascade on delete set null,

	primary key (id)
);

create index detailed_class_class_id__classification_id_idx on detailed_class using btree(class_id__classification_id);


-- ҥꥹ

CREATE TABLE book_list (

	id serial, -- ID
	name text not null, -- ̾
	special_level text, -- ޽٥
	status text not null, -- 
	detailclass__detailed_class_id integer not null, -- ʬ
	publisher__publisher_list_id integer not null, -- Ǽ
	writer__writer_list_id integer not null, -- 
	org__present_org_id_ integer, -- £ȿ
	note text, -- 
	create_date timestamp default current_timestamp, -- Ͽ

	foreign key (detailclass__detailed_class_id) references detailed_class(id)
	on update cascade on delete set null,
	foreign key (publisher__publisher_list_id) references publisher_list(id)
	on update cascade on delete set null,
	foreign key (writer__writer_list_id) references writer_list(id)
	on update cascade on delete set null,
	foreign key (org__present_org_id_) references present_org(id)
	on update cascade on delete set null,

	primary key (id)
);

create index book_list_detailclass__detailed_class_id_idx on book_list using btree(detailclass__detailed_class_id);
create index book_list_publisher__publisher_list_id_idx on book_list using btree(publisher__publisher_list_id);
create index book_list_writer__writer_list_id_idx on book_list using btree(writer__writer_list_id);
create index book_list_org__present_org_id__idx on book_list using btree(org__present_org_id_);


-- ߽ɽ

CREATE TABLE lending_list (

	id serial, -- ߤФID
	book_id__book_list_id integer not null, -- ̾
	status text, -- 
	user_name__user_list_id integer, -- ߽桼
	manage__manage_member_username text not null, -- 
	lend_date timestamp not null default current_timestamp, -- ߽
	yotei_date date not null default current_date + interval '14 day', -- ֵͽ
	back_date timestamp, -- ֵ

	foreign key (book_id__book_list_id) references book_list(id)
	on update cascade on delete set null,
	foreign key (user_name__user_list_id) references user_list(id)
	on update cascade on delete set null,

	primary key (id)
);

create index lending_list_book_id__book_list_id_idx on lending_list using btree(book_id__book_list_id);
create index lending_list_user_name__user_list_id_idx on lending_list using btree(user_name__user_list_id);


-- </pre>
