<?php {
  /*
   * $Id: dino_db.php,v 1.21 2003/03/07 09:12:21 noriko Exp $
   * Copyright (c) 2002-2003 Dino Co.,Ltd.
   */

  /**
   * PEAR DB饹Υåѡ
   *
   *
   *@access public
   *@package Dino_DB 
   */ 
  require_once('db/dino_db_error.php');
  require_once('db/dino_db_result.php');

  class Dino_DB {

    /**
    * 󥹥ȥ饯
    *
    *@access public
    *@param string  $dsn     dsnʸ
    *@param boolean $logging 뤫ݤ
    */
    function Dino_DB($dsn = '', $logging = false) {
      if($dsn) {
	$this->connect($dsn);
	$this->setFetchMode(DB_FETCHMODE_ASSOC);
      }
      $this->logging = $logging;
    }

    /**
    * ǥХå󥰤ͭˤ
    *
    *@access public
    *@param object Template $t ƥץ졼ȥ֥
    */
    function enable_debug(&$t) {
      if(is_object($t)) {
	$this->t =& $t;
      } else {
	unset($this->t);
      }
    }

    /**
    * DB³
    *
    *@access public
    *@param string $dsn dsnʸ
    */
    function connect($dsn) {
      check_db_error($this->db =& DB::connect($dsn));
    }
    /**
    * DBؤ³
    *
    *@access public
    */
    function disconnect() {
      check_db_error($this->db->disconnect());
    }
      
    /**
    * DB˥ȯԤ
    *
    *@access public
    *@param string $sql SQLʸ
    *@return object Dino_Result ¹Է̤¸Dino_Result֥
    */
    function &query($sql) {
      if($this->t) $this->t->append('__sql', $sql);
      if($this->logging) { 
	if($affected = $this->affectedRows()) {
	  $this->logging_sql('query()', $sql, $affected);
	} else {
	  $rs =& new Dino_Result(check_db_error($this->db->query($sql)));
	  $this->logging_sql('query()', $sql, $rs->numRows());
	  return $rs;
	}
      }
      return new Dino_Result(check_db_error($this->db->query($sql)));
    }
    /**
    * DBդȯԤ
    *
    *@access public
    *@param string  $sql   SQLʸ
    *@param integer $from  OFFSET
    *@param integer $count LIMIT
    *@return object Dino_Result ¹Է̤¸Dino_Result֥
    */
    function &limitQuery($sql, $from, $count) {
      if($this->t) $this->t->append('__sql', $sql);
      if($this->logging) { 
	if($affected = $this->affectedRows()) {
	  $this->logging_sql('limitQuery()', $sql, $affected);
	} else {
	  $rs =& new Dino_Result(check_db_error($this->db->limitQuery($sql, $from, $count)));
	  $this->logging_sql('limitQuery()', $sql, $rs->numRows());
	  return $rs;
	}
      }
      return new Dino_Result(check_db_error($this->db->limitQuery($sql, $from, $count)));
    }


    //=====================================================
    // getXXX functions

    /**
    * ꤫֤줿쥳ɤƼ
    *
    * $modeϡ
    * DB_FETCHMODE_DEFAULT (ǥե = DB_FETCHMODE_ASSOC)
    * DB_FETCHMODE_ORDERED (ź)
    * DB_FETCHMODE_ASSOC   (Ϣ)
    * DB_FETCHMODE_OBJECT  (֥)
    * Τ줫 (ܺ٤ϡPEAR DBΥޥ˥奢򻲾)
    *
    *@access public
    *@param string  $sql  SQLʸ
    *@param integer $mode Ǽ⡼
    *@return array        ̹ԤǼ
    */
    function &getAll($sql, $mode = DB_FETCHMODE_DEFAULT) {
      if($this->t) $this->t->append('__sql', $sql);
      if($this->logging) {
	$data =& check_db_error($this->db->getAll($sql, $mode));
	$this->logging_sql('getAll()', $sql, count($data));
	return $data;
      } else {
	return check_db_error($this->db->getAll($sql, $mode));
      }
    }
    /**
    * ꤫ǽιԤ
    *
    * $modeϡ
    * DB_FETCHMODE_DEFAULT (ǥե = DB_FETCHMODE_ASSOC)
    * DB_FETCHMODE_ORDERED (ź)
    * DB_FETCHMODE_ASSOC   (Ϣ)
    * DB_FETCHMODE_OBJECT  (֥)
    * Τ줫 (ܺ٤ϡPEAR DBΥޥ˥奢򻲾)
    *
    *@access public
    *@param string  $sql  SQLʸ
    *@param integer $mode Ǽ⡼
    *@return array        ̹ԤǼ
    */
    function &getRow($sql, $mode = DB_FETCHMODE_DEFAULT) {
      if($this->t) $this->t->append('__sql', $sql);
      if($this->logging) {
	$data =& check_db_error($this->db->getRow($sql, $mode));
	if(!$data) $this->logging_sql('getRow()', $sql, 0);
	else $this->logging_sql('getRow()', $sql, 1);
	return $data;
      } else {
	return check_db_error($this->db->getRow($sql, $mode));
      }
    }
    /**
    * ꤫1ʬΥǡ
    *
    *@access public
    *@param string  $sql  SQLʸ
    *@param mixed   $col  λ (0١ź⤷ϡ̾)
    *@return array        1ʬΥǡ
    */
    function &getCol($sql, $col = null) {
      if($this->t) $this->t->append('__sql', $sql);
      if($this->logging) {
	$data =& check_db_error($this->db->getCol($sql, $col));
	$this->logging_sql('getCol()', $sql, count($data));
	return $data;
      } else {
	return check_db_error($this->db->getCol($sql, $col));
      }
    }
    /**
    * ꤫ǽιԤκǽΥ
    *
    *@access public
    *@param string $sql SQLʸ
    *@return string     
    */
    function &getOne($sql) {
      if($this->t) $this->t->append('__sql', $sql);
      if($this->logging) {
        $data =& check_db_error($this->db->getOne($sql));
	if($data) $this->logging_sql('getOne()', $sql, $data);
	else $this->logging_sql('getOne()', $sql, 0);
	return $data;
      } else {
	return check_db_error($this->db->getOne($sql));
      }
    }
    /**
    * ȤƺǽΥѤϢȤƷ̥åȤ
    *
    *@access public
    *@param string $sql SQLʸ
    *@return array      ̥å
    */
    function &getAssoc($sql) {
      if($this->t) $this->t->append('__sql', $sql);
      if($this->logging) {
	$data =& check_db_error($this->db->getAssoc($sql));
	$this->logging_sql('getAssoc()', $sql, count($data));
	return $data;
      } else {
	return check_db_error($this->db->getAssoc($sql));
      }
    }

    //=====================================================
    // misc functions

    /**
    * ꤷ³ΥˤƥǥեȤ˻Ѥ⡼ɤ ꤹ
    *
    *@access public
    *@param integer $mode ⡼
    *@return mixed ֤ʤ$mode̤Τͤޤޤ PEAR_ERROR 
    */
    function setFetchMode($mode) {
      return $this->db->setFetchMode($mode);
    }

    /**
    * Ǳƶ쥳ɿ֤
    *
    *@access public
    *@return integer 쥳ɿ
    */
    function affectedRows() {
      $rows = $this->db->affectedRows();
      return check_db_error($rows);
    }

    /**
    * ǰ˻Ѳǽʤ褦ʸ򥯥Ȥ
    *
    *@access public
    *@param string $str Ȥʸ
    *@return string Ȥ줿ʸ
    */
    function &quote($str) {
      return $this->db->quote($str);
    }

    /**
    * DBꥹȤ
    *
    *@access public
    *@param string $type ηǡ$typeǻ ǽͤϥǡ١˰¸¿ξ硢 "databases", "users", "view", "functions"Ǥ 
    *@return mixed ꤵ줿ǡ
    */
    function getListOf($type) {
      return check_db_error($this->db->getListOf($type));
    }

    /**
    * logging function
    *
    *@access private
    *@param string $func function name
    *@param string $sql  SQL query
    *@param integer $result result option
    */
    function logging_sql($func, $sql, $result = null) {
      $func = $this->db->quote($func);
      $sql = $this->db->quote($sql);
      if(is_null($result)) $result = 'null';
      check_db_error($this->db->query("
	insert into __logging_sql
	  (func_name, query, result_option)
	values
	  ($func, $sql, $result)
      "));
    }

    /**
    * DB object
    *@access private
    */
    var $db;
    /**
    * Smarty object for logging
    *@access private
    */
    var $t;
    /**
    * logging boolean
    *@access private
    */
    var $logging = false;
  }

} ?>
